import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Translate extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a Parallel Data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_CreateParallelData.html
     */
    toCreateParallelData(): this;
    /**
     * Grants permission to delete a Parallel Data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteParallelData.html
     */
    toDeleteParallelData(): this;
    /**
     * Grants permission to delete a terminology
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     */
    toDeleteTerminology(): this;
    /**
     * Grants permission to get the properties associated with an asynchronous batch translation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     */
    toDescribeTextTranslationJob(): this;
    /**
     * Grants permission to get a Parallel Data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetParallelData.html
     */
    toGetParallelData(): this;
    /**
     * Grants permission to retrieve a terminology
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     */
    toGetTerminology(): this;
    /**
     * Grants permission to create or update a terminology, depending on whether or not one already exists for the given terminology name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     */
    toImportTerminology(): this;
    /**
     * Grants permission to list supported languages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListLanguages.html
     */
    toListLanguages(): this;
    /**
     * Grants permission to list Parallel Data associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListParallelData.html
     */
    toListParallelData(): this;
    /**
     * Grants permission to list terminologies associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     */
    toListTerminologies(): this;
    /**
     * Grants permission to list batch translation jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     */
    toListTextTranslationJobs(): this;
    /**
     * Grants permission to start an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     */
    toStartTextTranslationJob(): this;
    /**
     * Grants permission to stop an asynchronous batch translation job that is in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     */
    toStopTextTranslationJob(): this;
    /**
     * Grants permission to translate text from a source language to a target language
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     */
    toTranslateText(): this;
    /**
     * Grants permission to update an existing Parallel Data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_UpdateParallelData.html
     */
    toUpdateParallelData(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type terminology to the statement
     *
     * https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTerminology(resourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type parallel-data to the statement
     *
     * https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onParallelData(resourceName: string, account?: string, region?: string, partition?: string): this;
}
