# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['wildq', 'wildq.filetypes']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.3.1,<6.0.0',
 'Pygments>=2.7.2,<3.0.0',
 'click>=7.1.2,<8.0.0',
 'jq>=1.1.1,<2.0.0',
 'pyhcl>=0.4.4,<0.5.0',
 'toml>=0.10.1,<0.11.0',
 'xmltodict>=0.12.0,<0.13.0']

entry_points = \
{'console_scripts': ['wildq = wildq.__main__:main', 'wq = wildq.__main__:main']}

setup_kwargs = {
    'name': 'wildq',
    'version': '1.1.6',
    'description': 'Command-line TOML/JSON/INI/YAML/XML processor using jq c bindings.',
    'long_description': '\n\n# wildq - Command-line TOML/JSON/INI/YAML/XML/HCL processor using jq c bindings\n\n![GitHub](https://img.shields.io/github/license/ahmet2mir/wildq.svg)\n[![image](https://img.shields.io/pypi/pyversions/wildq.svg)](https://python.org/pypi/wildq)\n[![Build Status](https://github.com/ahmet2mir/wildq/workflows/Unit%20Tests/badge.svg)](https://github.com/ahmet2mir/wildq/actions)\n\nPurpose of this package is to provide a simple wrapper arround jq for different formats.\nI\'m tired of searching a package doing yaml jq, toml jq, ini jq etc. mainly used for scripting.\n\nThis script uses:\n* @mwilliamson [Python bindings](https://github.com/mwilliamson/jq.py) on top of @stedolan famous [jq](https://github.com/stedolan/jq/) lib\n* swiss knife for coloration [pygments](https://github.com/pygments/pygments)\n* binary built with [pyinstaller](https://github.com/pyinstaller/pyinstaller)\n* easy CLI with [click](https://github.com/pallets/click)\n* for supported types sources, check table `Supported file types`\n\n# Installation\n\n## Pip\n\n```sh\npip install wildq\n```\n\nA binary is also available for different platform, pick one (both of `wildq` and `wq` will be in the archive)\n\n## MacOS\n\n```\nbrew install ahmet2mir/tap/wildq\nbrew install ahmet2mir/tap/wq\n```\n\n## GNU/Linux Binary\n\nCompiled using glibc 2.17, it should work on lot of stable/LTS distros.\n\n```\nmkdir -p ~/bin/\ncurl -sL https://github.com/ahmet2mir/wildq/releases/download/v1.1.5/wildq-1.1.5-linux-x86_64.tar.gz -o wildq-1.1.5-linux-x86_64.tar.gz\ntar xvfz wildq-1.1.5-linux-x86_64.tar.gz -C ~/bin\nexport PATH="~/bin:$PATH"\n\nwq --help\nwildq --help\n```\n\n## Debian (no gpg signature) >= 10\n\n```\ncurl -sL https://github.com/ahmet2mir/wildq/releases/download/v1.1.5/wildq_1.1.5-1_amd64.deb -o wildq_1.1.5-1_amd64.deb\nsudo dpkg -i wildq_1.1.5-1_amd64.deb\n\nwq --help\nwildq --help\n```\n\n## Centos (no gpg singature) >= 7\n\n```\ncurl -sL https://github.com/ahmet2mir/wildq/releases/download/v1.1.5/wildq-1.1.5-1.x86_64.rpm -o wildq-1.1.5-1.x86_64.rpm\nsudo yum install -y ./wildq-1.1.5-1.x86_64.rpm\n\nwq --help\nwildq --help\n```\n\n\n## Windows\n\nWildq use [jq.py](https://github.com/mwilliamson/jq.py) and it\'s not yet available on windows platforms.\nI tried to compile it without windows machine and I failed, and I don\'t had the time to try to understand how Windows / C binding / Python works.\nIf anybody would contribute, there is an [open issue](https://github.com/mwilliamson/jq.py/issues/20) (jq and onigurama are \'compilable\' on Windows so I think that someone confortable with that OS could make it);\n\n\n# Supported file types\n\n| type | color | ordering | output | source                                                              |\n|------|-------|----------|--------|---------------------------------------------------------------------|\n| hcl  |  json |    no    |  json  | [pyhcl](https://github.com/virtuald/pyhcl) by @virtuald             |\n| ini  |  yes  |    no    |  yes   | [ConfigParser](https://docs.python.org/3/library/configparser.html) |\n| json |  yes  |    yes   |  yes   | [json](https://docs.python.org/3/library/json.html)                 |\n| toml |  yes  |    no    |  yes   | [toml](https://github.com/uiri/toml) by @uiri                       |\n| xml  |  yes  |    no    |  yes   | [xmldict](https://github.com/martinblech/xmltodict) by @martinblech |\n| yaml |  yes  |    yes   |  yes   | [pyyaml](https://github.com/yaml/pyyaml)                            |\n\n# Usage\n\n```\n$ wildq -i help\nUsage: wildq [OPTIONS] JQ_FILTER [FILE]\n\nOptions:\n  -c, --compact-output            compact instead of pretty-printed output\n  -r, --raw                       output raw strings, not content texts\n  -C, --color-output              colorize content (default), mutally\n                                  exclusive with --monochrome-output\n\n  -M, --monochrome-output         monochrome (don\'t colorize content), mutally\n                                  exclusive with --color-output\n\n  --hcl                           Combine --input hcl --output json, mutally\n                                  exclusive with other Combined options\n\n  --ini                           Combine --input ini --output json, mutally\n                                  exclusive with other Combined options\n\n  --json                          Combine --input json --output json, mutally\n                                  exclusive with other Combined options\n\n  --toml                          Combine --input toml --output json, mutally\n                                  exclusive with other Combined options\n\n  --xml                           Combine --input xml --output json, mutally\n                                  exclusive with other Combined options\n\n  --yaml                          Combine --input yaml --output json, mutally\n                                  exclusive with other Combined options\n\n  -i, --input [hcl|ini|json|toml|xml|yaml]\n                                  Define the content type of file, mutally\n                                  exclusive with Combined option\n\n  -o, --output [hcl|ini|json|toml|xml|yaml]\n                                  Define the content type of printed output,\n                                  mutally exclusive with Combined option\n                                  (default input format)\n\n  --help                          Show this message and exit.\n```\n\nFor backward compatibility in previous version only `--[yaml|json|toml|ini|xml|hcl]` was possible with default to json output.\nWe still keep Monochrome, raw and json output with thoses options.\nOutput was similar to `jq -MCr` (no color, no compact and no quote on single value)\n\nBut now, by default it\'s colorized, not raw and if you specify input using `-i` or `--input` output will be the same format.\n\nThere is also a shorter command `wq` comming with the package.\n\nLike `jq cli`, wildq supports both of stdin and file to the function\n\nSee examples to get some example.\n\nContent of `examples/json.json`\n\n```\n{\n    "general": {\n        "user": "admin"\n    },\n    "keys": [\n        {"key": "value1"},\n        {"key": "value2"},\n        "alone"\n    ]\n}\n```\n\n```sh\ncat examples/json.json | wildq -i json ".keys[]"\n{\n    "key": "value1"\n}\n{\n    "key": "value2"\n}\nalone\n```\n\nor\n\n```sh\nwildq -i json ".keys[]" examples/json.json\n{\n    "key": "value1"\n}\n{\n    "key": "value2"\n}\nalone\n```\nor\n\n```sh\nwq -i json ".keys[]" examples/json.json\n{\n    "key": "value1"\n}\n{\n    "key": "value2"\n}\nalone\n```\n\nFor TOML\n```sh\ncat examples/toml.toml | wildq -i toml ".keys[]"\n{\n    "key": "value1"\n}\n{\n    "key": "value2"\n}\nalone\n```\n\nFor INI (no array)\n```sh\ncat examples/ini.ini | wildq -i ini ".keys"\n{\n    "key1": "value1",\n    "key2": "value2"\n}\n```\n\nFor XML\n```sh\ncat examples/xml.xml | wildq -i xml "."\n{\n    "root": {\n        "general": {\n            "user": "admin"\n        },\n        "keys": {\n            "element": [\n                {\n                    "key": "value1"\n                },\n                {\n                    "key": "value2"\n                },\n                "alone"\n            ]\n        }\n    }\n}\n```\n\nFor YAML\n```sh\ncat examples/yaml.yaml  | wildq -i yaml ".keys[]"\n{\n    "key1": "value1"\n}\n{\n    "key2": "value2"\n}\nalone\n```\n\nFor HCL\n```sh\ncat examples/hcl.hcl  | wildq -i hcl ".keys[]"\n{\n    "key": "value1"\n}\n{\n    "key": "value2"\n}\n```\n\n## Tips and tricks\n\nLoop on keys in bash without creating a subshell\n\n```sh\nwildq -i toml "keys[]" examples/toml.toml | while read -r key \ndo\n    echo "Getting key ${key}"\ndone\n```\n\n## TODO\n\n- [x] add tests...\n- [x] add more control over filters and files\n- [x] use click for the CLI\n- [x] support different output\n- [ ] detect automagically filetype\n- [ ] support all jq types\n- [ ] ordering\n\n## Contributing\n\nMerge requests are welcome :)\n\n\n## License\n\nLicensed under the terms of the [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0).\n\n\n## Repository URL\n\nhttps://github.com/ahmet2mir/wildq\n',
    'author': 'Ahmet Demir',
    'author_email': 'me@ahmet2mir.eu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ahmet2mir/wildq',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
