"""Error handling module for the application.

This module provides a comprehensive set of custom exceptions for handling various
error scenarios in the application, organized by category.
"""

from archipy.models.errors.auth_errors import (
    AccountDisabledError,
    AccountLockedError,
    InvalidCredentialsError,
    InvalidTokenError,
    InvalidVerificationCodeError,
    PermissionDeniedError,
    SessionExpiredError,
    TokenExpiredError,
    UnauthenticatedError,
)
from archipy.models.errors.base_error import BaseError
from archipy.models.errors.business_errors import (
    BusinessRuleViolationError,
    FailedPreconditionError,
    InsufficientBalanceError,
    InsufficientFundsError,
    InvalidOperationError,
    InvalidStateError,
    MaintenanceModeError,
)
from archipy.models.errors.database_errors import (
    CacheError,
    CacheMissError,
    DatabaseConfigurationError,
    DatabaseConnectionError,
    DatabaseConstraintError,
    DatabaseDeadlockError,
    DatabaseError,
    DatabaseIntegrityError,
    DatabaseQueryError,
    DatabaseSerializationError,
    DatabaseTimeoutError,
    DatabaseTransactionError,
)
from archipy.models.errors.keycloak_errors import (
    ClientAlreadyExistsError,
    InsufficientPermissionsError,
    InvalidCredentialsError as KeycloakInvalidCredentialsError,
    KeycloakConnectionTimeoutError,
    KeycloakServiceUnavailableError,
    PasswordPolicyError,
    RealmAlreadyExistsError,
    ResourceNotFoundError,
    RoleAlreadyExistsError,
    UserAlreadyExistsError,
    ValidationError,
)
from archipy.models.errors.network_errors import (
    BadGatewayError,
    ConnectionTimeoutError,
    GatewayTimeoutError,
    NetworkError,
    RateLimitExceededError,
    ServiceUnavailableError,
)
from archipy.models.errors.resource_errors import (
    AlreadyExistsError,
    ConflictError,
    DataLossError,
    FileTooLargeError,
    InvalidEntityTypeError,
    InvalidFileTypeError,
    NotFoundError,
    QuotaExceededError,
    ResourceBusyError,
    ResourceExhaustedError,
    ResourceLockedError,
    StorageError,
)
from archipy.models.errors.system_errors import (
    AbortedError,
    ConfigurationError,
    DeadlineExceededError,
    DeadlockDetectedError,
    DeprecationError,
    InternalError,
    UnavailableError,
    UnknownError,
)
from archipy.models.errors.validation_errors import (
    InvalidArgumentError,
    InvalidDateError,
    InvalidEmailError,
    InvalidFormatError,
    InvalidIpError,
    InvalidJsonError,
    InvalidLandlineNumberError,
    InvalidNationalCodeError,
    InvalidPasswordError,
    InvalidPhoneNumberError,
    InvalidTimestampError,
    InvalidUrlError,
    OutOfRangeError,
)

__all__ = [
    "AbortedError",
    "AccountDisabledError",
    "AccountLockedError",
    "AlreadyExistsError",
    "BadGatewayError",
    "BaseError",
    "BusinessRuleViolationError",
    "CacheError",
    "CacheMissError",
    "ClientAlreadyExistsError",
    "ConfigurationError",
    "ConflictError",
    "ConnectionTimeoutError",
    "DataLossError",
    "DatabaseConfigurationError",
    "DatabaseConnectionError",
    "DatabaseConstraintError",
    "DatabaseDeadlockError",
    # Database Errors
    "DatabaseError",
    "DatabaseIntegrityError",
    "DatabaseQueryError",
    "DatabaseSerializationError",
    "DatabaseTimeoutError",
    "DatabaseTransactionError",
    "DeadlineExceededError",
    "DeadlockDetectedError",
    "DeprecationError",
    "FailedPreconditionError",
    "FileTooLargeError",
    "GatewayTimeoutError",
    "InsufficientBalanceError",
    "InsufficientFundsError",
    "InsufficientPermissionsError",
    # System Errors
    "InternalError",
    # Validation Errors
    "InvalidArgumentError",
    "InvalidCredentialsError",
    "InvalidDateError",
    "InvalidEmailError",
    "InvalidEntityTypeError",
    "InvalidFileTypeError",
    "InvalidFormatError",
    "InvalidIpError",
    "InvalidJsonError",
    "InvalidLandlineNumberError",
    "InvalidNationalCodeError",
    "InvalidOperationError",
    "InvalidPasswordError",
    "InvalidPhoneNumberError",
    # Business Errors
    "InvalidStateError",
    "InvalidTimestampError",
    "InvalidTokenError",
    "InvalidUrlError",
    "InvalidVerificationCodeError",
    "KeycloakConnectionTimeoutError",
    "KeycloakInvalidCredentialsError",
    "KeycloakServiceUnavailableError",
    "MaintenanceModeError",
    # Network Errors
    "NetworkError",
    # Resource Errors
    "NotFoundError",
    "OutOfRangeError",
    "PasswordPolicyError",
    "PermissionDeniedError",
    "QuotaExceededError",
    "RateLimitExceededError",
    # Keycloak Errors
    "RealmAlreadyExistsError",
    "ResourceBusyError",
    "ResourceExhaustedError",
    "ResourceLockedError",
    "ResourceNotFoundError",
    "RoleAlreadyExistsError",
    "ServiceUnavailableError",
    "SessionExpiredError",
    "StorageError",
    "TokenExpiredError",
    # Auth Errors
    "UnauthenticatedError",
    "UnavailableError",
    "UnknownError",
    "UserAlreadyExistsError",
    "ValidationError",
]
