# ArchiPy Documentation

![ArchiPy Logo](assets/logo.jpg)

ArchiPy is a Python framework designed to provide a standardized, scalable, and maintainable architecture for modern
applications. Built with Python 3.13+, it offers a suite of tools, utilities, and best practices to streamline
development workflows while adhering to clean architecture principles and modern Python practices.

## Goals

ArchiPy is built with the following objectives in mind:

1. **Database Integration** - Provide robust, type-safe database adapters for PostgreSQL, SQLite, and StarRocks
2. **Configuration Management** - Simplify and standardize configuration handling with validation
3. **Service Integration** - Offer ready-to-use adapters for common services (Redis, Email, Keycloak, MinIO, Kafka)
4. **Data Standardization** - Enforce consistency in data modeling with modern type hints
5. **Development Efficiency** - Provide comprehensive utilities and helpers for common tasks
6. **Quality Assurance** - Enable robust testing and code quality enforcement

## Features

- **Database Integration**: Dedicated adapters for PostgreSQL, SQLite, and StarRocks with SQLAlchemy integration
- **Configuration Management**: Type-safe configuration with environment variable support
- **Service Adapters**: Pre-built adapters for Redis, Email, Keycloak, MinIO, and Kafka
- **Payment Processing**: Payment gateway adapters for online transaction processing
- **Data Standardization**: Base entities, DTOs, and modern type hints
- **Helper Utilities**: Decorators, interceptors, and security utilities
- **Testing & Quality**: BDD testing and automated code quality tools
- **Performance & Scalability**: Connection pooling, caching, and async support

## Quick Links

- [Installation Guide](installation.md)
- [Architecture Overview](architecture.md)
- [API Reference](api_reference/index.md)
- [Examples](examples/index.md)
- [Contributing](contributing.md)
