# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.resource_requirements import ResourceRequirements  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelDeploymentSpec(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, annotations: Dict[str, str]=None, image: str=None, image_pull_conn_id: str=None, liveness_probe_initial_delay: int=None, max_replicas: int=None, min_replicas: int=None, node_selector: Dict[str, str]=None, predictor: str=None, readiness_probe_initial_delay: int=None, resources: ResourceRequirements=None, role_name: str=None):  # noqa: E501
        """ModelDeploymentSpec - a model defined in Swagger

        :param annotations: The annotations of this ModelDeploymentSpec.  # noqa: E501
        :type annotations: Dict[str, str]
        :param image: The image of this ModelDeploymentSpec.  # noqa: E501
        :type image: str
        :param image_pull_conn_id: The image_pull_conn_id of this ModelDeploymentSpec.  # noqa: E501
        :type image_pull_conn_id: str
        :param liveness_probe_initial_delay: The liveness_probe_initial_delay of this ModelDeploymentSpec.  # noqa: E501
        :type liveness_probe_initial_delay: int
        :param max_replicas: The max_replicas of this ModelDeploymentSpec.  # noqa: E501
        :type max_replicas: int
        :param min_replicas: The min_replicas of this ModelDeploymentSpec.  # noqa: E501
        :type min_replicas: int
        :param node_selector: The node_selector of this ModelDeploymentSpec.  # noqa: E501
        :type node_selector: Dict[str, str]
        :param predictor: The predictor of this ModelDeploymentSpec.  # noqa: E501
        :type predictor: str
        :param readiness_probe_initial_delay: The readiness_probe_initial_delay of this ModelDeploymentSpec.  # noqa: E501
        :type readiness_probe_initial_delay: int
        :param resources: The resources of this ModelDeploymentSpec.  # noqa: E501
        :type resources: ResourceRequirements
        :param role_name: The role_name of this ModelDeploymentSpec.  # noqa: E501
        :type role_name: str
        """
        self.swagger_types = {
            'annotations': Dict[str, str],
            'image': str,
            'image_pull_conn_id': str,
            'liveness_probe_initial_delay': int,
            'max_replicas': int,
            'min_replicas': int,
            'node_selector': Dict[str, str],
            'predictor': str,
            'readiness_probe_initial_delay': int,
            'resources': ResourceRequirements,
            'role_name': str
        }

        self.attribute_map = {
            'annotations': 'annotations',
            'image': 'image',
            'image_pull_conn_id': 'imagePullConnID',
            'liveness_probe_initial_delay': 'livenessProbeInitialDelay',
            'max_replicas': 'maxReplicas',
            'min_replicas': 'minReplicas',
            'node_selector': 'nodeSelector',
            'predictor': 'predictor',
            'readiness_probe_initial_delay': 'readinessProbeInitialDelay',
            'resources': 'resources',
            'role_name': 'roleName'
        }

        self._annotations = annotations
        self._image = image
        self._image_pull_conn_id = image_pull_conn_id
        self._liveness_probe_initial_delay = liveness_probe_initial_delay
        self._max_replicas = max_replicas
        self._min_replicas = min_replicas
        self._node_selector = node_selector
        self._predictor = predictor
        self._readiness_probe_initial_delay = readiness_probe_initial_delay
        self._resources = resources
        self._role_name = role_name

    @classmethod
    def from_dict(cls, dikt) -> 'ModelDeploymentSpec':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelDeploymentSpec of this ModelDeploymentSpec.  # noqa: E501
        :rtype: ModelDeploymentSpec
        """
        return util.deserialize_model(dikt, cls)

    @property
    def annotations(self) -> Dict[str, str]:
        """Gets the annotations of this ModelDeploymentSpec.

        Annotations for model pods.  # noqa: E501

        :return: The annotations of this ModelDeploymentSpec.
        :rtype: Dict[str, str]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations: Dict[str, str]):
        """Sets the annotations of this ModelDeploymentSpec.

        Annotations for model pods.  # noqa: E501

        :param annotations: The annotations of this ModelDeploymentSpec.
        :type annotations: Dict[str, str]
        """

        self._annotations = annotations

    @property
    def image(self) -> str:
        """Gets the image of this ModelDeploymentSpec.

        Model Docker image  # noqa: E501

        :return: The image of this ModelDeploymentSpec.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image: str):
        """Sets the image of this ModelDeploymentSpec.

        Model Docker image  # noqa: E501

        :param image: The image of this ModelDeploymentSpec.
        :type image: str
        """

        self._image = image

    @property
    def image_pull_conn_id(self) -> str:
        """Gets the image_pull_conn_id of this ModelDeploymentSpec.

        If pulling of your image requires authorization, then you should specify the connection id  # noqa: E501

        :return: The image_pull_conn_id of this ModelDeploymentSpec.
        :rtype: str
        """
        return self._image_pull_conn_id

    @image_pull_conn_id.setter
    def image_pull_conn_id(self, image_pull_conn_id: str):
        """Sets the image_pull_conn_id of this ModelDeploymentSpec.

        If pulling of your image requires authorization, then you should specify the connection id  # noqa: E501

        :param image_pull_conn_id: The image_pull_conn_id of this ModelDeploymentSpec.
        :type image_pull_conn_id: str
        """

        self._image_pull_conn_id = image_pull_conn_id

    @property
    def liveness_probe_initial_delay(self) -> int:
        """Gets the liveness_probe_initial_delay of this ModelDeploymentSpec.

        Initial delay for liveness probe of model pod  # noqa: E501

        :return: The liveness_probe_initial_delay of this ModelDeploymentSpec.
        :rtype: int
        """
        return self._liveness_probe_initial_delay

    @liveness_probe_initial_delay.setter
    def liveness_probe_initial_delay(self, liveness_probe_initial_delay: int):
        """Sets the liveness_probe_initial_delay of this ModelDeploymentSpec.

        Initial delay for liveness probe of model pod  # noqa: E501

        :param liveness_probe_initial_delay: The liveness_probe_initial_delay of this ModelDeploymentSpec.
        :type liveness_probe_initial_delay: int
        """

        self._liveness_probe_initial_delay = liveness_probe_initial_delay

    @property
    def max_replicas(self) -> int:
        """Gets the max_replicas of this ModelDeploymentSpec.

        Maximum number of pods for model. By default the max replicas parameter equals 1.  # noqa: E501

        :return: The max_replicas of this ModelDeploymentSpec.
        :rtype: int
        """
        return self._max_replicas

    @max_replicas.setter
    def max_replicas(self, max_replicas: int):
        """Sets the max_replicas of this ModelDeploymentSpec.

        Maximum number of pods for model. By default the max replicas parameter equals 1.  # noqa: E501

        :param max_replicas: The max_replicas of this ModelDeploymentSpec.
        :type max_replicas: int
        """

        self._max_replicas = max_replicas

    @property
    def min_replicas(self) -> int:
        """Gets the min_replicas of this ModelDeploymentSpec.

        Minimum number of pods for model. By default the min replicas parameter equals 0.  # noqa: E501

        :return: The min_replicas of this ModelDeploymentSpec.
        :rtype: int
        """
        return self._min_replicas

    @min_replicas.setter
    def min_replicas(self, min_replicas: int):
        """Sets the min_replicas of this ModelDeploymentSpec.

        Minimum number of pods for model. By default the min replicas parameter equals 0.  # noqa: E501

        :param min_replicas: The min_replicas of this ModelDeploymentSpec.
        :type min_replicas: int
        """

        self._min_replicas = min_replicas

    @property
    def node_selector(self) -> Dict[str, str]:
        """Gets the node_selector of this ModelDeploymentSpec.

        Node selector for specifying a node pool  # noqa: E501

        :return: The node_selector of this ModelDeploymentSpec.
        :rtype: Dict[str, str]
        """
        return self._node_selector

    @node_selector.setter
    def node_selector(self, node_selector: Dict[str, str]):
        """Sets the node_selector of this ModelDeploymentSpec.

        Node selector for specifying a node pool  # noqa: E501

        :param node_selector: The node_selector of this ModelDeploymentSpec.
        :type node_selector: Dict[str, str]
        """

        self._node_selector = node_selector

    @property
    def predictor(self) -> str:
        """Gets the predictor of this ModelDeploymentSpec.

        ID of Predictor to use  # noqa: E501

        :return: The predictor of this ModelDeploymentSpec.
        :rtype: str
        """
        return self._predictor

    @predictor.setter
    def predictor(self, predictor: str):
        """Sets the predictor of this ModelDeploymentSpec.

        ID of Predictor to use  # noqa: E501

        :param predictor: The predictor of this ModelDeploymentSpec.
        :type predictor: str
        """

        self._predictor = predictor

    @property
    def readiness_probe_initial_delay(self) -> int:
        """Gets the readiness_probe_initial_delay of this ModelDeploymentSpec.

        Initial delay for readiness probe of model pod  # noqa: E501

        :return: The readiness_probe_initial_delay of this ModelDeploymentSpec.
        :rtype: int
        """
        return self._readiness_probe_initial_delay

    @readiness_probe_initial_delay.setter
    def readiness_probe_initial_delay(self, readiness_probe_initial_delay: int):
        """Sets the readiness_probe_initial_delay of this ModelDeploymentSpec.

        Initial delay for readiness probe of model pod  # noqa: E501

        :param readiness_probe_initial_delay: The readiness_probe_initial_delay of this ModelDeploymentSpec.
        :type readiness_probe_initial_delay: int
        """

        self._readiness_probe_initial_delay = readiness_probe_initial_delay

    @property
    def resources(self) -> ResourceRequirements:
        """Gets the resources of this ModelDeploymentSpec.

        Resources for model deployment The same format like k8s uses for pod resources.  # noqa: E501

        :return: The resources of this ModelDeploymentSpec.
        :rtype: ResourceRequirements
        """
        return self._resources

    @resources.setter
    def resources(self, resources: ResourceRequirements):
        """Sets the resources of this ModelDeploymentSpec.

        Resources for model deployment The same format like k8s uses for pod resources.  # noqa: E501

        :param resources: The resources of this ModelDeploymentSpec.
        :type resources: ResourceRequirements
        """

        self._resources = resources

    @property
    def role_name(self) -> str:
        """Gets the role_name of this ModelDeploymentSpec.

        Initial delay for readiness probe of model pod  # noqa: E501

        :return: The role_name of this ModelDeploymentSpec.
        :rtype: str
        """
        return self._role_name

    @role_name.setter
    def role_name(self, role_name: str):
        """Sets the role_name of this ModelDeploymentSpec.

        Initial delay for readiness probe of model pod  # noqa: E501

        :param role_name: The role_name of this ModelDeploymentSpec.
        :type role_name: str
        """

        self._role_name = role_name
