# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.training_result import TrainingResult  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelTrainingStatus(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, artifacts: List[TrainingResult]=None, created_at: str=None, exit_code: int=None, message: str=None, pod_name: str=None, reason: str=None, state: str=None, updated_at: str=None):  # noqa: E501
        """ModelTrainingStatus - a model defined in Swagger

        :param artifacts: The artifacts of this ModelTrainingStatus.  # noqa: E501
        :type artifacts: List[TrainingResult]
        :param created_at: The created_at of this ModelTrainingStatus.  # noqa: E501
        :type created_at: str
        :param exit_code: The exit_code of this ModelTrainingStatus.  # noqa: E501
        :type exit_code: int
        :param message: The message of this ModelTrainingStatus.  # noqa: E501
        :type message: str
        :param pod_name: The pod_name of this ModelTrainingStatus.  # noqa: E501
        :type pod_name: str
        :param reason: The reason of this ModelTrainingStatus.  # noqa: E501
        :type reason: str
        :param state: The state of this ModelTrainingStatus.  # noqa: E501
        :type state: str
        :param updated_at: The updated_at of this ModelTrainingStatus.  # noqa: E501
        :type updated_at: str
        """
        self.swagger_types = {
            'artifacts': List[TrainingResult],
            'created_at': str,
            'exit_code': int,
            'message': str,
            'pod_name': str,
            'reason': str,
            'state': str,
            'updated_at': str
        }

        self.attribute_map = {
            'artifacts': 'artifacts',
            'created_at': 'createdAt',
            'exit_code': 'exitCode',
            'message': 'message',
            'pod_name': 'podName',
            'reason': 'reason',
            'state': 'state',
            'updated_at': 'updatedAt'
        }

        self._artifacts = artifacts
        self._created_at = created_at
        self._exit_code = exit_code
        self._message = message
        self._pod_name = pod_name
        self._reason = reason
        self._state = state
        self._updated_at = updated_at

    @classmethod
    def from_dict(cls, dikt) -> 'ModelTrainingStatus':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelTrainingStatus of this ModelTrainingStatus.  # noqa: E501
        :rtype: ModelTrainingStatus
        """
        return util.deserialize_model(dikt, cls)

    @property
    def artifacts(self) -> List[TrainingResult]:
        """Gets the artifacts of this ModelTrainingStatus.

        List of training results  # noqa: E501

        :return: The artifacts of this ModelTrainingStatus.
        :rtype: List[TrainingResult]
        """
        return self._artifacts

    @artifacts.setter
    def artifacts(self, artifacts: List[TrainingResult]):
        """Sets the artifacts of this ModelTrainingStatus.

        List of training results  # noqa: E501

        :param artifacts: The artifacts of this ModelTrainingStatus.
        :type artifacts: List[TrainingResult]
        """

        self._artifacts = artifacts

    @property
    def created_at(self) -> str:
        """Gets the created_at of this ModelTrainingStatus.


        :return: The created_at of this ModelTrainingStatus.
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at: str):
        """Sets the created_at of this ModelTrainingStatus.


        :param created_at: The created_at of this ModelTrainingStatus.
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def exit_code(self) -> int:
        """Gets the exit_code of this ModelTrainingStatus.

        Pod exit code  # noqa: E501

        :return: The exit_code of this ModelTrainingStatus.
        :rtype: int
        """
        return self._exit_code

    @exit_code.setter
    def exit_code(self, exit_code: int):
        """Sets the exit_code of this ModelTrainingStatus.

        Pod exit code  # noqa: E501

        :param exit_code: The exit_code of this ModelTrainingStatus.
        :type exit_code: int
        """

        self._exit_code = exit_code

    @property
    def message(self) -> str:
        """Gets the message of this ModelTrainingStatus.

        Pod last log  # noqa: E501

        :return: The message of this ModelTrainingStatus.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str):
        """Sets the message of this ModelTrainingStatus.

        Pod last log  # noqa: E501

        :param message: The message of this ModelTrainingStatus.
        :type message: str
        """

        self._message = message

    @property
    def pod_name(self) -> str:
        """Gets the pod_name of this ModelTrainingStatus.

        Pod package for name  # noqa: E501

        :return: The pod_name of this ModelTrainingStatus.
        :rtype: str
        """
        return self._pod_name

    @pod_name.setter
    def pod_name(self, pod_name: str):
        """Sets the pod_name of this ModelTrainingStatus.

        Pod package for name  # noqa: E501

        :param pod_name: The pod_name of this ModelTrainingStatus.
        :type pod_name: str
        """

        self._pod_name = pod_name

    @property
    def reason(self) -> str:
        """Gets the reason of this ModelTrainingStatus.

        Pod reason  # noqa: E501

        :return: The reason of this ModelTrainingStatus.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason: str):
        """Sets the reason of this ModelTrainingStatus.

        Pod reason  # noqa: E501

        :param reason: The reason of this ModelTrainingStatus.
        :type reason: str
        """

        self._reason = reason

    @property
    def state(self) -> str:
        """Gets the state of this ModelTrainingStatus.

        Model Packaging State  # noqa: E501

        :return: The state of this ModelTrainingStatus.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str):
        """Sets the state of this ModelTrainingStatus.

        Model Packaging State  # noqa: E501

        :param state: The state of this ModelTrainingStatus.
        :type state: str
        """

        self._state = state

    @property
    def updated_at(self) -> str:
        """Gets the updated_at of this ModelTrainingStatus.


        :return: The updated_at of this ModelTrainingStatus.
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at: str):
        """Sets the updated_at of this ModelTrainingStatus.


        :param updated_at: The updated_at of this ModelTrainingStatus.
        :type updated_at: str
        """

        self._updated_at = updated_at
