/*
 * Decompiled with CFR 0.152.
 */
package src.eidreader;

import java.applet.Applet;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardPermission;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import src.eidreader.BelgianReader;
import src.eidreader.PersonalFile;

public class EIDReader
extends Applet {
    public static void main(String[] stringArray) {
        System.out.println("EIDReader main()");
    }

    @Override
    public void init() {
        System.err.println("EIDReader version 20140213 initialized");
    }

    public void unused2_init() {
        System.err.println("Gonna set the security manager...");
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                if (permission instanceof CardPermission) {
                    return;
                }
                AccessController.checkPermission(permission);
            }
        });
        System.err.println("Initialized");
    }

    public String readCard() {
        return this.readCard(true);
    }

    public String readCard(final Boolean bl) {
        System.err.println("EIDReader.readCard()");
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    TerminalFactory terminalFactory = TerminalFactory.getDefault();
                    List<CardTerminal> list = terminalFactory.terminals().list();
                    if (list.size() == 0) {
                        return "Error: No card reader found";
                    }
                    CardTerminal cardTerminal = list.get(0);
                    if (!cardTerminal.isCardPresent()) {
                        return "Error: No card found on terminal";
                    }
                    Card card = cardTerminal.connect("T=0");
                    System.err.println("Protocol: " + card.getProtocol());
                    ATR aTR = card.getATR();
                    CardChannel cardChannel = card.getBasicChannel();
                    if (BelgianReader.matchesEidAtr(aTR)) {
                        System.err.println("It's a Belgian card");
                        BelgianReader belgianReader = new BelgianReader(cardChannel);
                        return belgianReader.resultAsString(bl);
                    }
                    System.err.println("It's an Estonian card");
                    PersonalFile personalFile = new PersonalFile(cardChannel);
                    return personalFile.resultAsString(bl);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return "Error: " + throwable.toString();
                }
            }
        });
    }
}

