# -*- coding: UTF-8 -*-
# Copyright 2014 Luc Saffre
# License: GNU Affero General Public License v3 (see file COPYING for details)

"""
DEPRECATED : use eesti.py instead!

This fixture contains all Estonian places.

It is a proof of concept for my idea of using :ref:`dpy` as data
format for maintaining large knowledge bases like the list of places
of a country.

"""

from __future__ import unicode_literals
from lino_xl.lib.countries.utils import PlaceGenerator


def objects():

    ig = PlaceGenerator()

    # Harju (county)
    ig.county("Harju", "")
    ig.town("Tallinn", "")
    ig.town("Loksa", "")
    ig.municipality("Vasalemma", "")
    ig.smallborough("Rummu", "")
    ig.village("Veskiküla", "")
    ig.smallborough("Ämari", "")
    ig.village("Lemmaru", "76107")

    ig.municipality("Nissi", "")
    ig.smallborough("Turba", "")
    ig.village("Lehetu", "")
    ig.village("Madila", "")
    ig.smallborough("Riisipere", "")
    ig.village("Kivitammi", "76207")
    ig.village("Mustu", "76216")
    ig.village("Lepaste", "76217")
    ig.village("Tabara", "")
    ig.village("Viruküla", "76206")
    ig.village("Odulemma", "76210")
    ig.village("Ellamaa", "76203")
    ig.village("Jaanika", "76211")
    ig.village("Aude", "76209")
    ig.village("Rehemäe", "76218")
    ig.village("Ürjaste", "76214")
    ig.village("Siimika", "76208")
    ig.village("Nurme", "76215")
    ig.village("Vilumäe", "76212")
    ig.village("Munalaskme", "76318")

    ig.municipality("Saku", "")
    ig.village("Tänassilma", "")
    ig.village("Üksnurme", "")
    ig.village("Rahula", "")
    ig.village("Roobuka", "")
    ig.village("Jälgimäe", "")
    ig.village("Kirdalu", "")
    ig.village("Kasemetsa", "")
    ig.village("Männiku", "")
    ig.village("Tagadi", "")
    ig.village("Kurtna", "")
    ig.village("Metsanurme", "")
    ig.smallborough("Kiisa", "")
    ig.village("Juuliku", "")
    ig.village("Tammejärve", "")
    ig.village("Kanama", "")
    ig.village("Saustinõmme", "")
    ig.village("Tõdva", "")
    ig.village("Lokuti", "")
    ig.village("Tammemäe", "75509")
    ig.village("Kajamaa", "75504")
    ig.village("Sookaera-Metsanurga", "75515")

    ig.town("Saue", "")
    ig.smallborough("Laagri", "")
    ig.village("Aila", "")
    ig.village("Alliku", "")
    ig.village("Ääsmäe", "")
    ig.village("Vatsla", "")
    ig.village("Hüüru", "")
    ig.village("Vanamõisa", "")
    ig.village("Jõgisoo", "")
    ig.village("Püha", "")
    ig.village("Maidla", "")
    ig.village("Valingu", "")
    ig.village("Koppelmaa", "")
    ig.village("Tuula", "")
    ig.village("Pällu", "")
    ig.village("Kiia", "")
    ig.village("Tagametsa", "76409")
    ig.village("Pärinurme", "76408")
    ig.village("Koidu", "76418")

    ig.municipality("Viimsi", "")
    ig.village("Püünsi", "")
    ig.village("Pringi", "")
    ig.village("Muuga", "")
    ig.smallborough("Haabneeme", "")
    ig.village("Laiaküla", "")
    ig.village("Lubja", "")
    ig.village("Rohuneeme", "")
    ig.village("Pärnamäe", "")
    ig.village("Tammneeme", "")
    ig.village("Leppneeme", "")
    ig.village("Metsakasti", "")
    ig.village("Randvere", "")
    ig.village("Miiduranna", "")
    ig.village("Kelvingi", "")
    ig.village("Äigrumäe", "")
    ig.village("Kelnase", "")
    ig.village("Lõunaküla/Storbyn", "74022")
    ig.village("Tagaküla/Bakbyn", "74023")
    ig.village("Lääneotsa", "74007")
    ig.village("Väikeheinamaa/Lillängin", "74024")
    ig.village("Idaotsa", "74005")

    ig.municipality("Raasiku", "")
    ig.smallborough("Aruküla", "")
    ig.village("Kurgla", "")
    ig.village("Kalesi", "")
    ig.village("Kiviloo", "")
    ig.village("Perila", "")
    ig.village("Peningi", "")
    ig.village("Igavere", "")
    ig.village("Kulli", "")
    ig.village("Rätla", "75216")
    ig.village("Järsi", "75204")
    ig.village("Pikavere", "75202")
    ig.village("Härma", "75214")
    ig.village("Tõhelgi", "75223")
    ig.village("Mallavere", "75210")

    ig.municipality("Jõelähtme", "")
    ig.smallborough("Loo", "")
    ig.village("Jägala", "")
    ig.village("Kaberneeme", "")
    ig.village("Liivamäe", "")
    ig.village("Neeme", "")
    ig.village("Manniva", "")
    ig.village("Uusküla", "")
    ig.village("Ülgase", "")
    ig.village("Ihasalu", "")
    ig.village("Kallavere", "")
    ig.smallborough("Kostivere", "")
    ig.village("Iru", "")
    ig.village("Haljava", "")
    ig.village("Koogi", "")
    ig.village("Saviranna", "")
    ig.village("Saha", "")
    ig.village("Rebala", "")
    ig.village("Ruu", "")
    ig.village("Koipsi", "74215")
    ig.village("Rammu", "74227")
    ig.village("Aruaru", "75225")
    ig.village("Võerdla", "74221")
    ig.village("Vandjala", "74229")
    ig.village("Sambu", "75222")
    ig.village("Rohusi", "74219")
    ig.village("Kullamäe", "74218")
    ig.village("Kostiranna", "74225")
    ig.village("Parasmäe", "74230")
    ig.village("Nehatu", "74208")
    ig.village("Koila", "74214")

    ig.town("Maardu", "")
    ig.municipality("Rae", "")
    ig.smallborough("Vaida", "")
    ig.smallborough("Jüri", "")
    ig.village("Patika", "")
    ig.village("Lehmja", "")
    ig.village("Vaskjala", "")
    ig.village("Järveküla", "")
    ig.village("Aaviku", "")
    ig.village("Pajupea", "")
    ig.village("Tuulevälja", "")
    ig.smallborough("Peetri", "")
    ig.smallborough("Lagedi", "")
    ig.village("Karla", "")
    ig.village("Pildiküla", "")
    ig.village("Soodevahe", "")
    ig.village("Kadaka", "")
    ig.village("Ülejõe", "")
    ig.village("Suuresta", "")
    ig.smallborough("Assaku", "")
    ig.village("Veskitaguse", "")
    ig.village("Suursoo", "")
    ig.village("Veneküla", "")
    ig.village("Kurna", "")
    ig.village("Kopli", "")
    ig.village("Urvaste", "")
    ig.village("Salu", "")
    ig.village("Limu", "")
    ig.village("Vaidasoo", "")
    ig.village("Seli", "75311")
    ig.village("Kautjala", "75315")
    ig.village("Aruvalla", "75320")

    ig.municipality("Harku", "")
    ig.smallborough("Tabasalu", "")
    ig.village("Adra", "")
    ig.village("Liikva", "")
    ig.village("Tiskre", "")
    ig.village("Naage", "")
    ig.village("Ilmandu", "")
    ig.village("Muraste", "")
    ig.village("Suurupi", "")
    ig.village("Harkujärve", "")
    ig.village("Rannamõisa", "")
    ig.village("Viti", "")
    ig.village("Türisalu", "")
    ig.village("Kumna", "")
    ig.village("Laabi", "")
    ig.village("Tutermaa", "")
    ig.village("Sõrve", "")
    ig.village("Kütke", "")
    ig.village("Vaila", "")
    ig.village("Vääna", "")
    ig.village("Vääna-Jõesuu", "")
    ig.village("Vahi", "")
    ig.village("Humala", "76707")

    ig.municipality("Keila", "")
    ig.village("Kloogaranna", "")
    ig.smallborough("Klooga", "")
    ig.village("Lehola", "")
    ig.village("Maeru", "")
    ig.village("Laulasmaa", "")
    ig.village("Ohtu", "")
    ig.village("Kulna", "")
    ig.village("Illurma", "")
    ig.village("Tuulna", "")
    ig.village("Meremõisa", "")
    ig.village("Valkse", "")
    ig.smallborough("Keila-Joa", "")
    ig.smallborough("Karjaküla", "")
    ig.village("Lohusalu", "")
    ig.village("Käesalu", "")
    ig.village("Niitvälja", "")
    ig.village("Tõmmiku", "76619")
    ig.village("Laoküla", "76714")
    ig.village("Nahkjala", "76104")
    ig.village("Põllküla", "76712")
    ig.village("Keelva", "76622")

    ig.municipality("Anija", "")
    ig.town("Kehra", "")
    ig.village("Lükati", "")
    ig.village("Alavere", "")
    ig.village("Mustjõe", "")
    ig.village("Pillapalu", "")
    ig.village("Lehtmetsa", "")
    ig.village("Kuusemäe", "")
    ig.village("Soodla", "")
    ig.village("Parila", "75221")
    ig.village("Aavere", "74417")
    ig.village("Paasiku", "74314")
    ig.village("Salumetsa", "74312")
    ig.village("Kihmla", "75219")
    ig.village("Looküla", "74311")
    ig.village("Rasivere", "74403")
    ig.village("Voose", "74410")
    ig.village("Linnakse", "75220")
    ig.village("Arava", "74405")
    ig.village("Partsaare", "74415")
    ig.village("Uuearu", "74407")
    ig.village("Salumäe", "75226")
    ig.village("Kaunissaare", "74309")
    ig.village("Vetla", "74408")
    ig.village("Pikva", "")
    ig.village("Raudoja", "74416")
    ig.village("Rooküla", "74404")
    ig.village("Härmakosu", "74412")
    ig.village("Lilli", "74414")

    ig.municipality("Kiili", "")
    ig.smallborough("Luige", "")
    ig.village("Sausti", "")
    ig.smallborough("Kangru", "")
    ig.village("Nabala", "")
    ig.village("Sookaera", "")
    ig.village("Vaela", "")
    ig.village("Lähtse", "")
    ig.village("Mõisaküla", "")
    ig.village("Sõgula", "75410")
    ig.village("Kurevere", "75405")
    ig.village("Paekna", "75408")
    ig.village("Arusta", "75402")
    ig.village("Piissoo", "75414")

    ig.town("Paldiski", "")
    ig.municipality("Kose", "")
    ig.smallborough("Kose-Uuemõisa", "")
    ig.village("Oru", "")
    ig.village("Tade", "")
    ig.village("Liiva", "")
    ig.smallborough("Ravila", "")
    ig.village("Tuhala", "")
    ig.village("Saula", "")
    ig.village("Ahisilla", "")
    ig.village("Krei", "")
    ig.village("Palvere", "")
    ig.village("Vardja", "")
    ig.village("Nõmbra", "")
    ig.village("Viskla", "")
    ig.village("Sõmeru", "")
    ig.village("Tammiku", "75119")
    ig.village("Nõrava", "75116")
    ig.village("Raveliku", "75112")
    ig.village("Vilama", "75110")
    ig.village("Kata", "75120")
    ig.village("Kolu", "75121")
    ig.village("Kuivajõe", "75123")
    ig.village("Võlle", "75109")
    ig.village("Kanavere", "75105")

    ig.municipality("Padise", "")
    ig.village("Madise", "")
    ig.village("Kurkse", "")
    ig.village("Harju-Risti", "")
    ig.village("Kõmmaste", "76016")
    ig.village("Keibu", "76019")
    ig.village("Vintse", "76021")
    ig.village("Alliklepa", "76018")
    ig.village("Määra", "76010")
    ig.village("Vihterpalu", "76003")
    ig.village("Audevälja", "76005")
    ig.village("Altküla", "76012")
    ig.village("Vilivalla", "76020")
    ig.village("Pae", "76015")
    ig.village("Hatu", "76013")
    ig.village("Metslõugu", "76009")
    ig.village("Langa", "76711")
    ig.village("Laane", "")
    ig.village("Kasepere", "76007")
    ig.village("Pedase", "76014")
    ig.village("Änglema", "76022")
    ig.village("Karilepa", "76006")
    ig.village("Suurküla", "76011")
    ig.village("Kobru", "76004")

    ig.municipality("Kõue", "")
    ig.smallborough("Ardu", "")
    ig.smallborough("Habaja", "")
    ig.village("Harmi", "75034")
    ig.village("Virla", "75021")
    ig.village("Paunaste", "75025")
    ig.village("Aela", "75004")
    ig.village("Katsina", "75005")
    ig.village("Rõõsa", "75015")
    ig.village("Kadja", "75003")
    ig.village("Saarnakõrve", "75023")
    ig.village("Kantküla", "75027")
    ig.village("Vahetüki", "75020")
    ig.village("Uueveski", "75037")
    ig.village("Sae", "75016")
    ig.village("Kukepala", "75010")
    ig.village("Puusepa", "75017")
    ig.village("Kõrvenurga", "75008")
    ig.village("Kiruvere", "75006")
    ig.village("Nutu", "75012")
    ig.village("Alansi", "75035")
    ig.village("Lutsu", "75030")
    ig.village("Kirivalla", "75036")
    ig.village("Paunküla", "75011")
    ig.village("Riidamäe", "75032")
    ig.village("Äksi", "75038")
    ig.village("Silmsi", "75024")
    ig.village("Ojasoo", "75031")
    ig.village("Rava", "75014")
    ig.village("Sääsküla", "75033")
    ig.village("Lööra", "75028")
    ig.village("Leistu", "75026")
    ig.village("Marguse", "75029")
    ig.village("Triigi", "75019")
    ig.village("Nõmmeri", "75013")

    ig.municipality("Kuusalu", "")
    ig.smallborough("Kolga", "")
    ig.smallborough("Kiiu", "")
    ig.village("Valkla", "")
    ig.village("Viinistu", "")
    ig.village("Kaberla", "")
    ig.village("Mäepea", "")
    ig.village("Sõitme", "")
    ig.village("Uuri", "")
    ig.village("Mustametsa", "")
    ig.village("Kolga-Aabla", "")
    ig.village("Salmistu", "")
    ig.village("Kiiu-Aabla", "")
    ig.village("Vihasoo", "")
    ig.village("Kõnnu", "")
    ig.village("Allika", "")
    ig.village("Leesi", "")
    ig.village("Suurpea", "74812")
    ig.village("Saunja", "74636")
    ig.village("Valgejõe", "74712")
    ig.village("Haavakannu", "74628")
    ig.village("Nõmmeveski", "74815")
    ig.village("Tapurla", "74721")
    ig.village("Kemba", "74708")
    ig.village("Kodasoo", "74632")
    ig.village("Virve", "74814")
    ig.village("Hirvli", "74607")
    ig.village("Parksi", "74710")
    ig.village("Tsitre", "74616")
    ig.village("Tõreska", "74617")
    ig.village("Koitjärve", "74622")
    ig.village("Tammispea", "74715")
    ig.village("Põhja", "74635")
    ig.village("Muuksi", "74612")
    ig.village("Suru", "74615")
    ig.village("Kalme", "74714")
    ig.village("Juminda", "74716")
    ig.village("Pala", "")
    ig.village("Kolgaküla", "74808")
    ig.village("Tammistu", "74719")
    ig.village("Hara", "74810")
    ig.village("Pärispea", "74706")
    ig.village("Liiapeksi", "74709")
    ig.village("Pudisoo", "74626")
    ig.village("Murksi", "74713")
    ig.village("Joaveski", "74813")
    ig.village("Kahala", "74621")
    ig.village("Aru", "74606")
    ig.village("Turbuneeme", "74707")
    ig.village("Kursi", "74611")
    ig.village("Pedaspea", "74718")
    ig.village("Kolgu", "74618")
    ig.village("Kasispea", "74811")
    ig.village("Rehatse", "74624")
    ig.village("Kosu", "74608")
    ig.village("Vanaküla", "74711")
    ig.village("Ilmastalu", "74619")
    ig.village("Sigula", "74625")
    ig.village("Kotka", "74809")
    ig.village("Soorinna", "74614")
    ig.village("Külmaallika", "74634")
    ig.village("Kupu", "74610")

    ig.municipality("Kernu", "")
    ig.village("Laitse", "")
    ig.village("Haiba", "")
    ig.village("Ruila", "")
    ig.village("Kustja", "")
    ig.village("Mõnuste", "76310")
    ig.village("Kirikla", "76306")
    ig.village("Kabila", "")
    ig.village("Metsanurga", "")
    ig.village("Hingu", "76312")
    ig.village("Kohatu", "76304")
    ig.village("Muusika", "76309")

    ig.municipality("Aegviidu", "")
    ig.municipality("Kaasiku", "")
    ig.municipality("Kibuna", "")
    ig.municipality("Vahastu", "")
    ig.municipality("Vansi", "")
    ig.municipality("Vikipalu", "")
    ig.municipality("Jägala-Joa", "")
    ig.municipality("Kersalu", "")
    ig.municipality("Haapse", "")
    ig.municipality("Jõesuu", "")
    ig.municipality("Pohla", "")
    ig.municipality("Andineeme", "")

    # Hiiu (county)
    ig.county("Hiiu", "")
    ig.town("Kärdla", "")
    ig.municipality("Käina", "")
    ig.village("Nõmme", "")
    ig.village("Selja", "")
    ig.village("Putkaste", "")
    ig.village("Lelu", "")
    ig.village("Ligema", "")
    ig.village("Ühtri", "")
    ig.village("Niidiküla", "92131")
    ig.village("Kaigutsi", "92164")
    ig.village("Ristivälja", "92135")
    ig.village("Nasva", "92130")
    ig.village("Mäeküla", "92116")
    ig.village("Vaemla", "92137")
    ig.village("Mäeltse", "92129")
    ig.village("Orjaku", "")
    ig.village("Kolga", "92126")
    ig.village("Taterma", "92174")
    ig.village("Kogri", "92125")
    ig.village("Moka", "92128")
    ig.village("Aadma", "92161")
    ig.village("Taguküla", "92112")
    ig.village("Jõeküla", "92118")
    ig.village("Kuriste", "92171")
    ig.village("Utu", "92136")
    ig.village("Kaasiku", "92123")
    ig.village("Esiküla", "92113")
    ig.village("Laheküla", "92115")
    ig.village("Luguse", "92127")
    ig.village("Kleemu", "92124")
    ig.village("Kassari", "92111")
    ig.village("Villemi", "92138")
    ig.village("Männamaa", "92102")
    ig.village("Pärnselja", "92162")
    ig.village("Nõmmerga", "92133")
    ig.village("Allika", "92122")

    ig.municipality("Kõrgessaare", "")
    ig.village("Tahkuna", "")
    ig.village("Lauka", "")
    ig.village("Ülendi", "92229")
    ig.village("Risti", "92224")
    ig.village("Metsaküla", "92249")
    ig.village("Kidaste", "92216")
    ig.village("Kiduspe", "92234")
    ig.village("Hüti", "92243")
    ig.village("Heigi", "92241")
    ig.village("Kopa", "92255")
    ig.village("Laasi", "92231")
    ig.village("Poama", "92259")
    ig.village("Kodeste", "92217")
    ig.village("Mangu", "92220")
    ig.village("Mudaste", "92222")
    ig.village("Hirmuste", "92228")
    ig.village("Kalana", "92230")
    ig.village("Mardihansu", "92256")
    ig.village("Ogandi", "92223")
    ig.village("Vilima", "92237")
    ig.village("Sülluste", "92252")
    ig.village("Puski", "92260")
    ig.village("Lilbi", "92248")
    ig.village("Koidma", "92218")
    ig.village("Kurisu", "")
    ig.village("Pihla", "92264")
    ig.village("Kaleste", "92232")
    ig.village("Kiivera", "92254")
    ig.village("Heistesoo", "92270")
    ig.village("Kauste", "92215")
    ig.village("Reigi", "92265")
    ig.village("Sigala", "92213")
    ig.village("Tiharu", "92269")
    ig.village("Palli", "92258")
    ig.village("Lehtma", "92219")
    ig.village("Isabella", "92244")
    ig.village("Napi", "92250")
    ig.village("Mägipe", "92233")
    ig.village("Villamaa", "92261")
    ig.village("Meelste", "92221")
    ig.village("Viita", "92227")
    ig.village("Ojaküla", "92235")
    ig.village("Viitasoo", "92238")
    ig.village("Malvaste", "92211")
    ig.village("Suurepsi", "92236")
    ig.village("Heiste", "92242")
    ig.village("Suureranna", "92225")
    ig.village("Leigri", "92247")
    ig.village("Luidja", "92202")
    ig.village("Rootsi", "92266")
    ig.village("Jõeranna", "92263")
    ig.village("Paope", "92267")
    ig.village("Kõpu", "92212")
    ig.village("Jõesuu", "92253")
    ig.village("Kanapeeksi", "92214")
    ig.village("Otste", "92251")
    ig.village("Tammistu", "92268")

    ig.municipality("Pühalepa", "")
    ig.village("Hausma", "")
    ig.village("Suuremõisa", "")
    ig.village("Kuri", "")
    ig.village("Loja", "")
    ig.village("Tareste", "")
    ig.village("Hiiessaare", "")
    ig.village("Salinõmme", "92317")
    ig.village("Sarve", "92322")
    ig.village("Lõbembe", "92340")
    ig.village("Reikama", "92344")
    ig.village("Harju", "")
    ig.village("Hagaste", "92332")
    ig.village("Kerema", "92315")
    ig.village("Lõpe", "92341")
    ig.village("Määvli", "92362")
    ig.village("Suuresadama", "92346")
    ig.village("Partsi", "92342")
    ig.village("Soonlepa", "92323")
    ig.village("Tubala", "92311")
    ig.village("Viilupi", "92320")
    ig.village("Valipe", "92319")
    ig.village("Värssu", "92349")
    ig.village("Kalgi", "92314")
    ig.village("Leerimetsa", "92361")
    ig.village("Pilpaküla", "92368")
    ig.village("Ala", "92331")
    ig.village("Prählamäe", "92364")
    ig.village("Vilivalla", "92367")
    ig.village("Linnumäe", "92422")
    ig.village("Sakla", "92345")
    ig.village("Vahtrepa", "92318")
    ig.village("Undama", "92366")
    ig.village("Kõlunõmme", "92338")
    ig.village("Aruküla", "92321")
    ig.village("Sääre", "92347")
    ig.village("Hilleste", "92313")
    ig.village("Nõmba", "92363")
    ig.village("Hellamaa", "92334")
    ig.village("Paluküla", "92420")
    ig.village("Palade", "92301")
    ig.village("Kukka", "92336")
    ig.village("Puliste", "92343")
    ig.village("Tempa", "92348")
    ig.village("Heltermaa", "92312")
    ig.village("Tammela", "92365")

    ig.municipality("Emmaste", "")
    ig.village("Kaderna", "92045")
    ig.village("Reheselja", "92019")
    ig.village("Lepiku", "92014")
    ig.village("Lassi", "92051")
    ig.village("Hindu", "92012")
    ig.village("Jausa", "92003")
    ig.village("Õngu", "92059")
    ig.village("Valgu", "92011")
    ig.village("Muda", "92029")
    ig.village("Haldreka", "92043")
    ig.village("Kabuna", "92041")
    ig.village("Metsapere", "92053")
    ig.village("Külaküla", "92049")
    ig.village("Tilga", "92024")
    ig.village("Tärkma", "92026")
    ig.village("Sõru", "92023")
    ig.village("Külama", "92021")
    ig.village("Sinima", "92058")
    ig.village("Pärna", "92017")
    ig.village("Prassi", "92016")
    ig.village("Nurste", "92002")
    ig.village("Prähnu", "92056")
    ig.village("Kuusiku", "92048")
    ig.village("Mänspe", "92054")
    ig.village("Viiri", "92027")
    ig.village("Kitsa", "92046")
    ig.village("Leisu", "92052")
    ig.village("Tohvri", "92025")
    ig.village("Rannaküla", "92018")
    ig.village("Metsalauka", "92015")
    ig.village("Ole", "92055")
    ig.village("Ulja", "92030")
    ig.village("Laartsa", "92050")
    ig.village("Härma", "92044")
    ig.village("Kõmmusselja", "92013")
    ig.village("Riidaküla", "92020")
    ig.village("Haldi", "92042")
    ig.village("Sepaste", "92022")
    ig.village("Vanamõisa", "92060")


    # Ida-Viru (county)
    ig.county("Ida-Viru", "")
    ig.municipality("Lohusuu", "")
    ig.village("Kalmaküla", "")
    ig.village("Ninasi", "42003")
    ig.village("Tammispää", "42006")
    ig.village("Raadna", "42004")
    ig.village("Kärasi", "42119")
    ig.village("Piilsi", "42120")
    ig.village("Jõemetsa", "42118")
    ig.village("Separa", "42005")
    ig.village("Vilusi", "42007")

    ig.municipality("Sonda", "")
    ig.smallborough("Erra", "")
    ig.village("Erra-Liiva", "")
    ig.village("Varinurme", "")
    ig.village("Vana-Sonda", "43006")
    ig.village("Uljaste", "43005")
    ig.village("Koljala", "43135")
    ig.village("Vainu", "43136")
    ig.village("Ilmaste", "43138")
    ig.village("Nüri", "43003")
    ig.village("Satsu", "43004")

    ig.municipality("Toila", "")
    ig.smallborough("Voka", "")
    ig.village("Pühajõe", "")
    ig.village("Altküla", "")
    ig.village("Konju", "41714")
    ig.village("Uikala", "41717")
    ig.village("Martsa", "41715")
    ig.village("Päite", "40104")
    ig.village("Metsamägara", "41712")
    ig.village("Vaivina", "40105")

    ig.municipality("Tudulinna", "")
    ig.village("Sahargu", "")
    ig.village("Pikati", "42207")
    ig.village("Rannapungerja", "42208")
    ig.village("Roostoja", "42209")
    ig.village("Peressaare", "42121")
    ig.village("Oonurme", "42206")
    ig.village("Tagajõe", "42211")
    ig.village("Lemmaku", "42205")
    ig.village("Kellassaare", "42204")

    ig.town("Sillamäe", "")
    ig.town("Püssi", "")
    ig.municipality("Lüganuse", "")
    ig.village("Purtse", "")
    ig.village("Matka", "")
    ig.village("Moldova", "43307")
    ig.village("Irvala", "43132")
    ig.village("Mustmätta", "43308")
    ig.village("Aa", "43311")
    ig.village("Jabara", "43304")
    ig.village("Kopli", "43305")
    ig.village("Liimala", "43306")
    ig.village("Varja", "43309")
    ig.village("Voorepera", "43310")
    ig.village("Lohkuse", "43225")

    ig.municipality("Vaivara", "")
    ig.smallborough("Sinimäe", "")
    ig.smallborough("Olgina", "")
    ig.village("Tõrvajõe", "")
    ig.village("Sõtke", "")
    ig.village("Hiiemetsa", "40108")
    ig.village("Udria", "40118")
    ig.village("Soldina", "40115")
    ig.village("Vodava", "40119")
    ig.village("Perjatsi", "40241")
    ig.village("Pimestiku", "40113")
    ig.village("Hundinurga", "40109")
    ig.village("Auvere", "40107")
    ig.village("Arumäe", "40106")
    ig.village("Kudruküla", "29024")
    ig.village("Mustanina", "40111")
    ig.village("Laagna", "40110")
    ig.village("Puhkova", "40114")
    ig.village("Meriküla", "29025")
    ig.village("Peeterristi", "40112")

    ig.town("Narva", "")
    ig.municipality("Avinurme", "")
    ig.village("Paadenurme", "42113")
    ig.village("Laekannu", "42110")
    ig.village("Tammessaare", "42115")
    ig.village("Adraku", "42103")
    ig.village("Vadi", "42116")
    ig.village("Kiissa", "42106")
    ig.village("Kõrve", "42107")
    ig.village("Sälliksaare", "42114")
    ig.village("Kaevussaare", "42122")
    ig.village("Kõrvemetsa", "42108")
    ig.village("Maetsma", "42112")
    ig.village("Kõveriku", "42109")
    ig.village("Alekere", "42104")
    ig.village("Lepiksaare", "42111")
    ig.village("Änniksaare", "42117")
    ig.village("Ulvi", "42102")

    ig.town("Narva-Jõesuu", "")
    ig.town("Kohtla-Järve", "")
    ig.township("Sirgala (Viivikonna linnaosa)", "")
    ig.municipality("Aseri", "")
    ig.village("Rannu", "")
    ig.village("Kestla", "43303")
    ig.village("Kõrkküla", "43405")
    ig.village("Kõrtsialuse", "43406")
    ig.village("Kalvi", "43403")
    ig.village("Oru", "43407")
    ig.village("Koogu", "43404")
    ig.village("Aseriaru", "43402")

    ig.town("Jõhvi", "")
    ig.village("Puru", "")
    ig.village("Linna", "")
    ig.smallborough("Tammiku", "")
    ig.village("Edise", "")
    ig.village("Kotinuka", "")
    ig.village("Sompa", "")
    ig.village("Pauliku", "")
    ig.village("Kahula", "")
    ig.village("Pajualuse", "")
    ig.village("Pargitaguse", "")
    ig.village("Kose", "")

    ig.municipality("Iisaku", "")
    ig.village("Kuru", "")
    ig.village("Tammetaguse", "41112")
    ig.village("Sõrumäe", "41111")
    ig.village("Jõuga", "41104")
    ig.village("Alliku", "41102")
    ig.village("Lõpe", "42213")
    ig.village("Koldamäe", "41106")
    ig.village("Taga-Roostoja", "42203")
    ig.village("Kauksi", "41008")
    ig.village("Pootsiku", "41109")
    ig.village("Kasevälja", "41105")
    ig.village("Sälliku", "41110")
    ig.village("Varesmetsa", "41115")
    ig.village("Lipniku", "41107")
    ig.village("Vaikla", "41114")
    ig.village("Tärivere", "41113")
    ig.village("Imatu", "41103")

    ig.town("Kiviõli", "")
    ig.municipality("Alajõe", "")
    ig.village("Smolnitsa", "")
    ig.village("Remniku", "")
    ig.village("Vasknarva", "")
    ig.village("Katase", "")
    ig.village("Karjamaa", "41002")
    ig.village("Uusküla", "41006")

    ig.municipality("Kohtla-Nõmme", "")
    ig.municipality("Maidla", "")
    ig.village("Savala", "")
    ig.village("Uniküla", "")
    ig.village("Soonurme", "")
    ig.village("Aidu-Liiva", "")
    ig.village("Kulja", "42311")
    ig.village("Mehide", "42313")
    ig.village("Virunurme", "42324")
    ig.village("Rebu", "42317")
    ig.village("Tarumaa", "41305")
    ig.village("Lümatu", "42312")
    ig.village("Aidu", "42302")
    ig.village("Aidu-Nõmme", "42304")
    ig.village("Koolma", "42310")
    ig.village("Arupäälse", "42307")
    ig.village("Aidu-Sooküla", "42305")
    ig.village("Lipu", "41304")
    ig.village("Rääsa", "42318")
    ig.village("Salaküla", "43133")
    ig.village("Aruküla", "")
    ig.village("Sirtsi", "42320")
    ig.village("Piilse", "42316")
    ig.village("Hirmuse", "42309")
    ig.village("Ojamaa", "42315")
    ig.village("Veneoja", "42323")
    ig.village("Aruvälja", "42308")
    ig.village("Oandu", "42314")

    ig.municipality("Mäetaguse", "")
    ig.village("Kiikla", "")
    ig.village("Rajaküla", "")
    ig.village("Liivakünka", "41314")
    ig.village("Uhe", "41320")
    ig.village("Apandiku", "41306")
    ig.village("Väike-Pungerja", "41324")
    ig.village("Atsalama", "41309")
    ig.village("Võhma", "41321")
    ig.village("Ratva", "41318")
    ig.village("Kalina", "41312")
    ig.village("Ereda", "41310")
    ig.village("Tarakuse", "41319")
    ig.village("Võide", "41322")
    ig.village("Metsküla", "41315")
    ig.village("Arvila", "41308")
    ig.village("Pagari", "41303")
    ig.village("Jõetaguse", "41311")
    ig.village("Võrnu", "41323")

    ig.municipality("Kohtla", "")
    ig.village("Roodu", "")
    ig.village("Servaääre", "30506")
    ig.village("Paate", "30625")
    ig.village("Kabelimetsa", "30624")
    ig.village("Järve", "30331")
    ig.village("Täkumetsa", "30626")
    ig.village("Vitsiku", "30507")
    ig.village("Ontika", "41556")
    ig.village("Saka", "30103")
    ig.village("Mõisamaa", "30332")
    ig.village("Kukruse", "30623")
    ig.village("Amula", "41553")
    ig.village("Kaasikaia", "41554")
    ig.village("Kaasikvälja", "41555")
    ig.village("Peeri", "30333")
    ig.village("Valaste", "41557")

    ig.municipality("Illuka", "")
    ig.village("Kurtna", "")
    ig.village("Kuremäe", "")
    ig.village("Konsu", "41209")
    ig.village("Kivinõmme", "41208")
    ig.village("Rausvere", "41214")
    ig.village("Karoli", "41011")
    ig.village("Permisküla", "41013")
    ig.village("Agusalu", "41211")
    ig.village("Ohakvere", "41210")
    ig.village("Kaatermu", "41205")
    ig.village("Puhatu", "41213")
    ig.village("Kamarna", "41207")
    ig.village("Jaama", "41010")
    ig.village("Edivere", "41203")
    ig.village("Vasavere", "41215")
    ig.village("Kuningaküla", "41012")
    ig.village("Kaidma", "41206")
    ig.village("Ongassaare", "41212")


    # Jõgeva (county)
    ig.county("Jõgeva", "")
    ig.municipality("Torma", "")
    ig.smallborough("Sadala", "")
    ig.village("Ookatku", "48512")
    ig.village("Rääbise", "48516")
    ig.village("Kodismaa", "48505")
    ig.village("Sätsuvere", "48517")
    ig.village("Võtikvere", "48525")
    ig.village("Kantküla", "48526")
    ig.village("Rassiku", "48514")
    ig.village("Leedi", "48508")
    ig.village("Tuimõisa", "48519")
    ig.village("Tähkvere", "48521")
    ig.village("Võidivere", "48524")
    ig.village("Vaiatu", "48522")
    ig.village("Iravere", "48503")
    ig.village("Kõnnu", "48507")
    ig.village("Tealama", "48518")
    ig.village("Tõikvere", "48520")
    ig.village("Vanamõisa", "48523")
    ig.village("Näduvere", "48511")
    ig.village("Reastvere", "48515")
    ig.village("Oti", "48513")
    ig.village("Liikatku", "48509")
    ig.village("Lilastvere", "48510")
    ig.village("Koimula", "48506")

    ig.town("Põltsamaa", "")
    ig.smallborough("Adavere", "")
    ig.village("Esku", "")
    ig.village("Kuningamäe", "")
    ig.village("Mõhküla", "")
    ig.village("Lustivere", "")
    ig.village("Kaavere", "48006")
    ig.village("Tõrenurme", "48025")
    ig.village("Väike-Kamari", "48030")
    ig.village("Pilu", "48018")
    ig.village("Annikvere", "48004")
    ig.village("Kablaküla", "48007")
    ig.village("Lebavere", "48012")
    ig.village("Võhmanõmme", "48028")
    ig.village("Vitsjärve", "48027")
    ig.village("Rõstla", "48022")
    ig.village("Kaliküla", "48008")
    ig.village("Kalme", "48031")
    ig.village("Umbusi", "48026")
    ig.village("Neanurme", "48015")
    ig.village("Mällikvere", "48014")
    ig.village("Pauastvere", "48017")
    ig.village("Pudivere", "48019")
    ig.village("Puduküla", "48020")
    ig.village("Nõmavere", "48016")
    ig.village("Sulustvere", "48024")
    ig.village("Puiatu", "48021")
    ig.village("Võisiku", "48029")
    ig.smallborough("Kamari", "48003")
    ig.village("Alastvere", "48010")
    ig.village("Räsna", "48023")

    ig.municipality("Tabivere", "")
    ig.village("Voldi", "")
    ig.village("Kõduküla", "")
    ig.village("Lilu", "49113")
    ig.village("Sortsi", "49119")
    ig.village("Kaitsemõisa", "49106")
    ig.village("Kõnnujõe", "49110")
    ig.village("Elistvere", "49103")
    ig.village("Reinu", "49117")
    ig.village("Valgma", "49123")
    ig.village("Tormi", "49120")
    ig.village("Õvanurme", "49125")
    ig.village("Pataste", "49115")
    ig.village("Otslava", "49114")
    ig.village("Maarja-Magdaleena", "49126")
    ig.village("Vahi", "49122")
    ig.village("Kassema", "49107")
    ig.village("Juula", "49104")
    ig.village("Kärksi", "49112")
    ig.village("Uhmardu", "49121")
    ig.village("Sepa", "49118")
    ig.village("Koogi", "49108")
    ig.village("Kaiavere", "")
    ig.village("Raigastvere", "49116")
    ig.village("Kõrenduse", "49111")

    ig.town("Mustvee", "")
    ig.town("Jõgeva", "")
    ig.smallborough("Kuremaa", "")
    ig.village("Õuna", "")
    ig.village("Mooritsa", "")
    ig.smallborough("Laiuse", "")
    ig.smallborough("Siimusti", "")
    ig.village("Vana-Jõgeva", "")
    ig.village("Lemuvere", "48417")
    ig.village("Liivoja", "48418")
    ig.village("Alavere", "48405")
    ig.village("Kõola", "48414")
    ig.village("Rohe", "48428")
    ig.village("Viruvere", "48435")
    ig.village("Painküla", "48422")
    ig.village("Lõpe", "48440")
    ig.village("Kaude", "48411")
    ig.village("Ellakvere", "48406")
    ig.village("Selli", "48429")
    ig.village("Endla", "48407")
    ig.village("Kaera", "48409")
    ig.village("Raaduvere", "48427")
    ig.village("Pedja", "48426")
    ig.village("Vilina", "48434")
    ig.village("Väljaotsa", "48441")
    ig.village("Pakaste", "48423")
    ig.village("Kurista", "48413")
    ig.village("Paduvere", "48421")
    ig.village("Patjala", "48425")
    ig.village("Laiusevälja", "48416")
    ig.village("Soomevere", "48430")
    ig.village("Võduvere", "48436")
    ig.village("Vaimastvere", "48446")
    ig.village("Võikvere", "48437")
    ig.village("Palupere", "48424")
    ig.village("Kivijärve", "48412")
    ig.village("Teilma", "48431")
    ig.village("Tooma", "48432")
    ig.village("Kassinurme", "48410")
    ig.village("Kärde", "48415")
    ig.village("Mõisamaa", "48420")

    ig.municipality("Palamuse", "")
    ig.village("Ehavere", "49205")
    ig.village("Süvalepa", "49219")
    ig.village("Eerikvere", "49204")
    ig.village("Imukvere", "49206")
    ig.village("Sudiste", "49218")
    ig.village("Pikkjärve", "49213")
    ig.village("Kudina", "49210")
    ig.village("Järvepera", "49207")
    ig.village("Visusti", "49224")
    ig.village("Mullavere", "49211")
    ig.village("Ronivere", "49217")
    ig.village("Vanavälja", "49222")
    ig.village("Praaklima", "49227")
    ig.village("Varbevere", "49223")
    ig.village("Änkküla", "49225")
    ig.village("Kaarepere", "49201")
    ig.village("Vaidavere", "49221")
    ig.village("Luua", "49203")
    ig.village("Rahivere", "49216")
    ig.village("Toovere", "49220")
    ig.village("Nava", "49212")
    ig.village("Kivimäe", "49209")
    ig.village("Kassivere", "49208")
    ig.village("Raadivere", "49228")

    ig.municipality("Puurmani", "")
    ig.village("Tammiku", "49012")
    ig.village("Härjanurme", "49003")
    ig.village("Pikknurme", "49009")
    ig.village("Jõune", "49004")
    ig.village("Jüriküla", "49005")
    ig.village("Kirikuvalla", "49006")
    ig.village("Altnurga", "49002")
    ig.village("Tõrve", "49013")
    ig.village("Saduküla", "49011")
    ig.village("Kursi", "49007")
    ig.village("Laasme", "49008")
    ig.village("Pööra", "49010")

    ig.municipality("Saare", "")
    ig.village("Voore", "")
    ig.village("Koseveski", "")
    ig.village("Sirguvere", "49317")
    ig.village("Vassevere", "49321")
    ig.village("Putu", "49313")
    ig.village("Pedassaare", "49312")
    ig.village("Odivere", "49311")
    ig.village("Vanassaare", "49320")
    ig.village("Ruskavere", "49315")
    ig.village("Saarjärve", "49316")
    ig.village("Nautrasi", "49310")
    ig.village("Kiisli", "49306")
    ig.village("Kallivere", "49305")
    ig.village("Halliku", "49303")
    ig.village("Maardla", "49309")
    ig.village("Veia", "49322")
    ig.village("Tarakvere", "49318")
    ig.village("Pällu", "49314")
    ig.village("Levala", "49308")
    ig.village("Jaama", "49304")
    ig.village("Kääpa", "49323")
    ig.village("Tuulavere", "49319")

    ig.municipality("Kasepää", "")
    ig.village("Tiheda", "")
    ig.village("Raja", "")
    ig.village("Kükita", "")
    ig.village("Metsaküla", "49505")
    ig.village("Omedu", "49507")
    ig.village("Nõmme", "49506")
    ig.village("Kaasiku", "49502")

    ig.municipality("Pajusi", "")
    ig.village("Vägari", "")
    ig.village("Pisisaare", "")
    ig.village("Kalana", "")
    ig.village("Lahavere", "")
    ig.village("Tapiku", "48218")
    ig.village("Kõpu", "48208")
    ig.village("Loopre", "48211")
    ig.village("Uuevälja", "48220")
    ig.village("Tõivere", "48219")
    ig.village("Kauru", "48206")
    ig.village("Nurga", "48215")
    ig.village("Aidu", "48202")
    ig.village("Mõisaküla", "48213")
    ig.village("Kõrkküla", "48209")
    ig.village("Väljataguse", "48223")
    ig.village("Kose", "48207")
    ig.village("Arisvere", "48203")
    ig.village("Kaave", "48204")
    ig.village("Vorsti", "48221")
    ig.village("Luige", "48212")
    ig.village("Mõrtsi", "48214")
    ig.village("Sopimetsa", "48217")

    ig.municipality("Pala", "")
    ig.village("Kodavere", "49407")
    ig.village("Haavakivi", "49404")
    ig.village("Lümati", "49425")
    ig.village("Kokanurga", "49408")
    ig.village("Nõva", "49411")
    ig.village("Sassukvere", "49418")
    ig.village("Kadrina", "49405")
    ig.village("Sõõru", "49419")
    ig.village("Sääritsa", "49420")
    ig.village("Vea", "49422")
    ig.village("Ranna", "49417")
    ig.village("Perametsa", "49412")
    ig.village("Raatvere", "49416")
    ig.village("Äteniidi", "49423")
    ig.village("Tagumaa", "49421")
    ig.village("Kirtsi", "49406")
    ig.village("Piibumäe", "49413")
    ig.village("Piirivarbe", "49414")
    ig.village("Moku", "49410")
    ig.village("Assikvere", "49403")
    ig.village("Metsanurga", "49409")
    ig.village("Punikvere", "49415")

    ig.municipality("Vägeva", "")

    # Järva (county)
    ig.county("Järva", "")
    ig.municipality("Türi", "")
    ig.smallborough("Särevere", "")
    ig.smallborough("Oisu", "")
    ig.village("Lokuta", "")
    ig.village("Jändja", "")
    ig.village("Kabala", "")
    ig.village("Türi-Alliku", "")
    ig.village("Poaka", "")
    ig.village("Karjaküla", "72242")
    ig.village("Rikassaare", "72307")
    ig.village("Väljaotsa", "72311")
    ig.village("Villevere", "72006")
    ig.village("Kirna", "72231")
    ig.village("Rassi", "72007")
    ig.village("Raukla", "72305")
    ig.village("Laupa", "72102")
    ig.village("Saareotsa", "72308")
    ig.village("Tännassilma", "72310")
    ig.village("Pibari", "72005")
    ig.village("Pala", "72234")
    ig.village("Kurla", "72009")
    ig.village("Ollepa", "72002")
    ig.village("Äiamaa", "72312")
    ig.village("Vilita", "72245")
    ig.village("Retla", "72306")
    ig.village("Sagevere", "72003")
    ig.village("Arkma", "72011")
    ig.village("Änari", "72241")
    ig.village("Metsaküla", "72303")
    ig.village("Põikva", "72244")
    ig.village("Kärevere", "72302")
    ig.village("Tori", "72230")
    ig.village("Taikse", "72309")
    ig.village("Meossaare", "72010")
    ig.village("Näsuvere", "72246")

    ig.municipality("Roosna-Alliku", "")
    ig.village("Viisu", "")
    ig.village("Valasti", "73210")
    ig.village("Kihme", "73206")
    ig.village("Koordi", "73212")
    ig.village("Oeti", "73208")
    ig.village("Kodasema", "73207")
    ig.village("Kirisaare", "73211")
    ig.village("Kaaruka", "73205")
    ig.village("Tännapere", "73209")
    ig.village("Allikjärve", "73203")
    ig.village("Vedruka", "73213")

    ig.town("Paide", "")
    ig.village("Tarbja", "")
    ig.village("Kriilevälja", "")
    ig.village("Sargvere", "")
    ig.village("Sillaotsa", "")
    ig.village("Sõmeru", "72614")
    ig.village("Viraksaare", "")
    ig.village("Veskiaru", "72760")
    ig.village("Mustla", "72607")
    ig.village("Ojaküla", "72610")
    ig.village("Mustla-Nõmme", "72608")
    ig.village("Eivere", "72757")
    ig.village("Mäeküla", "")
    ig.village("Korba", "72753")
    ig.village("Valgma", "72606")
    ig.village("Võõbu", "72615")
    ig.village("Kirila", "72755")
    ig.village("Mündi", "72762")
    ig.village("Seinapalu", "72761")
    ig.village("Otiku", "72611")
    ig.village("Nurme", "72609")
    ig.village("Prääma", "72763")
    ig.village("Nurmsi", "72603")
    ig.village("Purdi", "72613")
    ig.village("Mäo", "72751")
    ig.village("Suurpalu", "72605")
    ig.village("Anna", "72601")
    ig.village("Pikaküla", "72756")

    ig.municipality("Väätsa", "")
    ig.village("Aasuvälja", "")
    ig.village("Reopalu", "")
    ig.village("Ülejõe", "")
    ig.village("Lõõla", "72814")
    ig.village("Roovere", "72805")
    ig.village("Vissuvere", "72812")
    ig.village("Väljataguse", "72802")
    ig.village("Saueaugu", "72813")
    ig.village("Röa", "72806")
    ig.village("Piiumetsa", "72804")

    ig.municipality("Ambla", "")
    ig.smallborough("Aravete", "")
    ig.smallborough("Käravete", "")
    ig.village("Raka", "")
    ig.village("Kurisoo", "")
    ig.village("Jõgisoo", "")
    ig.village("Roosna", "")
    ig.village("Märjandi", "73513")
    ig.village("Sääsküla", "73511")
    ig.village("Kukevere", "73512")
    ig.village("Mägise", "73510")
    ig.village("Reinevere", "73507")
    ig.village("Rava", "73506")

    ig.municipality("Järva-Jaani", "")
    ig.village("Karinu", "")
    ig.village("Metsla", "73307")
    ig.village("Kuksema", "73306")
    ig.village("Jalalõpe", "73303")
    ig.village("Jalgsema", "73304")
    ig.village("Kagavere", "73305")
    ig.village("Seliküla", "73310")
    ig.village("Metstaguse", "73308")
    ig.village("Ramma", "73309")

    ig.municipality("Koeru", "")
    ig.village("Ervita", "")
    ig.village("Vao", "")
    ig.village("Rõhu", "73018")
    ig.village("Udeva", "73019")
    ig.village("Tammiku", "73023")
    ig.village("Preedi", "73017")
    ig.village("Norra", "73016")
    ig.village("Kuusna", "73008")
    ig.village("Visusti", "73012")
    ig.village("Valila", "73024")
    ig.village("Tudre", "73010")
    ig.village("Väinjärve", "73021")
    ig.village("Santovi", "73005")
    ig.village("Koidu-Ellavere", "73027")
    ig.village("Vahuküla", "73020")
    ig.village("Aruküla", "73004")
    ig.village("Jõeküla", "73014")
    ig.village("Kalitsa", "73022")
    ig.village("Liusvere", "73015")
    ig.village("Kapu", "73007")
    ig.village("Puhmu", "73006")
    ig.village("Laaneotsa", "73013")
    ig.village("Salutaguse", "73009")
    ig.village("Vuti", "73011")
    ig.village("Merja", "73026")
    ig.village("Abaja", "73025")

    ig.municipality("Kareda", "")
    ig.village("Esna", "")
    ig.smallborough("Peetri", "")
    ig.village("Õle", "73108")
    ig.village("Köisi", "73104")
    ig.village("Ataste", "73103")
    ig.village("Müüsleri", "73105")
    ig.village("Vodja", "73111")
    ig.village("Küti", "73106")
    ig.village("Ämbra", "73110")
    ig.village("Ammuta", "73107")
    ig.village("Öötla", "73112")

    ig.municipality("Albu", "")
    ig.village("Pullevere", "")
    ig.village("Järva-Madise", "")
    ig.village("Ahula", "")
    ig.village("Seidla", "73407")
    ig.village("Vetepere", "73416")
    ig.village("Ageri", "73408")
    ig.village("Soosalu", "73414")
    ig.village("Mägede", "73412")
    ig.village("Orgmetsa", "73405")
    ig.village("Sugalepa", "73415")
    ig.village("Kaalepi", "73403")
    ig.village("Lehtmetsa", "73410")
    ig.village("Mõnuvere", "73411")
    ig.village("Neitla", "73404")
    ig.village("Peedu", "73413")

    ig.municipality("Imavere", "")
    ig.village("Käsukonna", "")
    ig.village("Taadikvere", "")
    ig.village("Jalametsa", "72403")
    ig.village("Võrevere", "72409")
    ig.village("Eistvere", "72402")
    ig.village("Laimetsa", "72410")
    ig.village("Kiigevere", "72405")
    ig.village("Pällastvere", "72412")
    ig.village("Puiatu", "")
    ig.village("Järavere", "72404")
    ig.village("Tammeküla", "72411")

    ig.municipality("Koigi", "")
    ig.village("Päinurme", "")
    ig.village("Huuksi", "72503")
    ig.village("Vaali", "72513")
    ig.village("Tamsi", "72509")
    ig.village("Lähevere", "72511")
    ig.village("Silmsi", "72507")
    ig.village("Sõrandu", "72508")
    ig.village("Keri", "72505")
    ig.village("Väike-Kareda", "72510")
    ig.village("Prandi", "72506")
    ig.village("Kahala", "")
    ig.village("Rutikvere", "72512")

    ig.municipality("Kolu", "")

    # Lääne (county)
    ig.county("Lääne", "")
    ig.town("Lihula", "")
    ig.village("Hälvati", "")
    ig.village("Tuudi", "")
    ig.village("Kirbla", "")
    ig.village("Penijõe", "90305")
    ig.village("Seira", "90214")
    ig.village("Kloostri", "90206")
    ig.village("Parivere", "90228")
    ig.village("Lautna", "90212")
    ig.village("Võhma", "90215")
    ig.village("Matsalu", "90230")
    ig.village("Petaaluse", "90223")
    ig.village("Rumba", "90213")
    ig.village("Vagivere", "90226")
    ig.village("Metsküla", "90232")
    ig.village("Tuhu", "90225")
    ig.village("Valuste", "90227")
    ig.village("Kirikuküla", "90221")
    ig.village("Poanse", "90224")
    ig.village("Meelva", "90231")
    ig.village("Kelu", "90205")
    ig.village("Alaküla", "90219")
    ig.village("Kunila", "90222")
    ig.village("Pagasi", "90207")
    ig.village("Saastna", "90233")
    ig.village("Järise", "90220")

    ig.municipality("Risti", "")
    ig.village("Jaakna", "90911")
    ig.village("Kuijõe", "90903")
    ig.village("Piirsalu", "90902")
    ig.village("Rõuma", "90904")

    ig.municipality("Ridala", "")
    ig.smallborough("Uuemõisa", "")
    ig.smallborough("Paralepa", "")
    ig.village("Valgevälja", "")
    ig.village("Herjava", "")
    ig.village("Tanska", "")
    ig.village("Vilkla", "")
    ig.village("Rohuküla", "")
    ig.village("Nõmme", "")
    ig.village("Mäeküla", "")
    ig.village("Pusku", "")
    ig.village("Kiltsi", "")
    ig.village("Sinalepa", "")
    ig.village("Saardu", "90424")
    ig.village("Lannuste", "90414")
    ig.village("Liivaküla", "")
    ig.village("Metsaküla", "90436")
    ig.village("Allika", "90405")
    ig.village("Üsse", "90461")
    ig.village("Tuuru", "90426")
    ig.village("Põgari-Sassi", "90421")
    ig.village("Kiideva", "90409")
    ig.village("Rohense", "90457")
    ig.village("Tammiku", "")
    ig.village("Jõõdre", "90412")
    ig.village("Hobulaiu", "90432")
    ig.village("Vätse", "90481")
    ig.village("Parila", "90418")
    ig.village("Emmuvere", "90431")
    ig.village("Kadaka", "90455")
    ig.village("Väike-Ahli", "90446")
    ig.village("Koheri", "90434")
    ig.village("Koidu", "90410")
    ig.village("Rummu", "90458")
    ig.village("Haeska", "90407")
    ig.village("Kolila", "90411")
    ig.village("Kaevere", "90408")
    ig.village("Mägari", "90438")
    ig.village("Suure-Ahli", "90443")
    ig.village("Aamse", "90450")
    ig.village("Käpla", "90413")
    ig.village("Erja", "90451")
    ig.village("Litu", "90416")
    ig.village("Kolu", "90435")
    ig.village("Varni", "90445")
    ig.village("Puise", "90420")
    ig.village("Espre", "90452")
    ig.village("Ammuta", "90406")
    ig.village("Laheva", "90456")
    ig.village("Uneste", "90427")
    ig.village("Lõbe", "90417")
    ig.village("Sepaküla", "90442")
    ig.village("Puiatu", "90419")
    ig.village("Kabrametsa", "90454")
    ig.village("Saanika", "90423")
    ig.village("Võnnu", "90460")
    ig.village("Kiviküla", "90433")
    ig.village("Panga", "90402")

    ig.town("Haapsalu", "")
    ig.municipality("Hanila", "")
    ig.smallborough("Virtsu", "")
    ig.village("Voose", "")
    ig.village("Kõmsi", "")
    ig.village("Rame", "90127")
    ig.village("Rannaküla", "")
    ig.village("Massu", "90111")
    ig.village("Ullaste", "90117")
    ig.village("Pajumaa", "90125")
    ig.village("Kokuta", "90108")
    ig.village("Vatla", "90103")
    ig.village("Karuse", "90112")
    ig.village("Mäense", "90113")
    ig.village("Linnuse", "90121")
    ig.village("Kõera", "90110")
    ig.village("Kaseküla", "90106")
    ig.village("Esivere", "90104")
    ig.village("Ridase", "90131")
    ig.village("Äila", "90128")
    ig.village("Pivarootsi", "90126")
    ig.village("Lõo", "90122")
    ig.village("Nehatu", "90123")
    ig.village("Kiska", "90120")
    ig.village("Kuke", "90109")
    ig.village("Kause", "90107")
    ig.village("Nurmsi", "90124")
    ig.village("Kinksi", "90130")
    ig.village("Salevere", "90116")

    ig.municipality("Taebla", "")
    ig.smallborough("Palivere", "")
    ig.village("Luigu", "")
    ig.village("Vidruka", "")
    ig.village("Nigula", "")
    ig.village("Pälli", "")
    ig.village("Väänla", "90819")
    ig.village("Võntküla", "90820")
    ig.village("Allikmaa", "90811")
    ig.village("Nihka", "90808")
    ig.village("Koela", "90806")
    ig.village("Leediküla", "90813")
    ig.village("Kedre", "90812")
    ig.village("Kadarpiku", "90804")
    ig.village("Kirimäe", "90805")
    ig.village("Tagavere", "90816")
    ig.village("Turvalepa", "90817")

    ig.municipality("Oru", "")
    ig.village("Linnamäe", "")
    ig.village("Saunja", "")
    ig.village("Niibi", "91015")
    ig.village("Jalukse", "91004")
    ig.village("Ingküla", "91003")
    ig.village("Soolu", "91012")
    ig.village("Auaste", "91002")
    ig.village("Seljaküla", "91011")
    ig.village("Mõisaküla", "")
    ig.village("Kärbla", "91006")
    ig.village("Keedika", "91005")
    ig.village("Uugla", "91013")
    ig.village("Salajõe", "91016")
    ig.village("Vedra", "91014")

    ig.municipality("Vormsi", "")
    ig.village("Hullo", "")
    ig.village("Sviby", "91313")
    ig.village("Söderby", "91314")
    ig.village("Rälby", "91310")
    ig.village("Saxby", "91311")
    ig.village("Norrby", "91308")
    ig.village("Rumpo", "91309")
    ig.village("Kersleti", "91307")
    ig.village("Förby", "91305")
    ig.village("Borrby", "91302")
    ig.village("Suuremõisa", "91312")
    ig.village("Fällarna", "91304")
    ig.village("Diby", "91303")

    ig.municipality("Martna", "")
    ig.village("Rõude", "")
    ig.village("Kaasiku", "")
    ig.village("Niinja", "90628")
    ig.village("Oonga", "90616")
    ig.village("Ehmja", "90620")
    ig.village("Uusküla", "90634")
    ig.village("Väike-Lähtru", "90636")
    ig.village("Soo-otsa", "90646")
    ig.village("Enivere", "90621")
    ig.village("Keskküla", "90606")
    ig.village("Kokre", "90626")
    ig.village("Kirna", "90625")
    ig.village("Keskvere", "90642")
    ig.village("Ohtla", "90630")
    ig.village("Tuka", "90617")
    ig.village("Kaare", "90640")
    ig.village("Putkaste", "90631")
    ig.village("Kabeli", "90641")
    ig.village("Jõesse", "90622")
    ig.village("Laiküla", "90612")
    ig.village("Kasari", "90605")
    ig.village("Keravere", "90614")
    ig.village("Kurevere", "90643")
    ig.village("Kuluse", "90627")
    ig.village("Suure-Lähtru", "90632")
    ig.village("Männiku", "90644")
    ig.village("Allikotsa", "90613")
    ig.village("Rannajõe", "90645")
    ig.village("Kesu", "90624")

    ig.municipality("Noarootsi", "")
    ig.village("Spithami", "")
    ig.village("Pürksi", "")
    ig.village("Suur-Nõmmküla", "91232")
    ig.village("Saare", "91205")
    ig.village("Rooslepa", "91219")
    ig.village("Einbi", "91203")
    ig.village("Väike-Nõmmküla", "91233")
    ig.village("Telise/Tällnäs", "91208")
    ig.village("Elbiku", "91202")
    ig.village("Paslepa/Pasklepi", "91204")
    ig.village("Sutlepa", "91230")
    ig.village("Dirhami", "91214")
    ig.village("Hosby", "")
    ig.village("Vanaküla", "")
    ig.village("Aulepa", "91231")
    ig.village("Tahu", "91206")
    ig.village("Kudani/Gutanäsi", "91216")
    ig.village("Hara", "91211")
    ig.village("Höbringi", "91213")
    ig.village("Tuksi", "91221")
    ig.village("Riguldi", "91218")
    ig.village("Osmussaare", "91217")
    ig.village("Österby", "91207")

    ig.municipality("Nõva", "")
    ig.village("Hindaste", "91102")
    ig.village("Peraküla", "91114")
    ig.village("Variku", "91106")
    ig.village("Vaisi", "91105")
    ig.village("Tusari", "91112")
    ig.village("Nõmmemaa", "91103")

    ig.municipality("Kullamaa", "")
    ig.village("Koluvere", "")
    ig.village("Lemmikküla", "90714")
    ig.village("Jõgisoo", "90710")
    ig.village("Ubasalu", "90719")
    ig.village("Kullametsa", "90713")
    ig.village("Üdruma", "90720")
    ig.village("Silla", "90718")
    ig.village("Päri", "90717")
    ig.village("Kalju", "90703")
    ig.village("Kastja", "90715")
    ig.village("Mõrdu", "90716")
    ig.village("Leila", "90704")
    ig.village("Liivi", "90711")


    # Lääne-Viru (county)
    ig.county("Lääne-Viru", "")
    ig.municipality("Tapa", "")
    ig.smallborough("Lehtse", "")
    ig.village("Kuru", "")
    ig.village("Jäneda", "")
    ig.village("Imastu", "45001")
    ig.village("Nõmmküla", "")
    ig.village("Karkuse", "")
    ig.village("Näo", "45007")
    ig.village("Linnape", "73606")
    ig.village("Läpi", "73607")
    ig.village("Läste", "73608")
    ig.village("Vahakulmu", "45011")
    ig.village("Raudla", "73612")
    ig.village("Rabasaare", "73611")
    ig.village("Kõrveküla", "")
    ig.village("Räsna", "73614")
    ig.village("Lokuta", "45004")
    ig.village("Patika", "73609")
    ig.village("Tõõrakõrve", "73615")
    ig.village("Pruuna", "73610")
    ig.village("Jootme", "73603")
    ig.village("Saiakopli", "45009")
    ig.village("Piilu", "45008")
    ig.village("Saksi", "45010")
    ig.village("Loksu", "45003")
    ig.village("Moe", "45005")

    ig.municipality("Rakvere", "")
    ig.smallborough("Lepna", "")
    ig.village("Päide", "")
    ig.village("Tõrremäe", "")
    ig.village("Veltsi", "")
    ig.village("Lasila", "")
    ig.village("Taaravainu", "")
    ig.village("Kõrgemäe", "")
    ig.village("Arkna", "")
    ig.village("Tõrma", "44406")
    ig.village("Eesküla", "44405")
    ig.village("Paatna", "44411")
    ig.village("Mädapea", "44409")
    ig.village("Karunga", "44404")
    ig.village("Levala", "")
    ig.village("Kullaaru", "44410")
    ig.village("Tobia", "44416")
    ig.village("Kloodi", "44413")
    ig.village("Järni", "44407")
    ig.village("Karivärava", "44412")
    ig.village("Karitsa", "44403")

    ig.municipality("Vinni", "")
    ig.smallborough("Tudu", "")
    ig.village("Piira", "")
    ig.village("Mõdriku", "")
    ig.smallborough("Roela", "")
    ig.village("Lähtse", "")
    ig.village("Vetiku", "")
    ig.village("Kakumäe", "")
    ig.village("Küti", "")
    ig.smallborough("Pajusti", "")
    ig.village("Kadila", "")
    ig.smallborough("Viru-Jaagupi", "")
    ig.village("Veadla", "")
    ig.village("Allika", "46612")
    ig.village("Obja", "46629")
    ig.village("Anguse", "46615")
    ig.village("Kannastiku", "46622")
    ig.village("Suigu", "46637")
    ig.village("Lepiku", "46627")
    ig.village("Koeravere", "46613")
    ig.village("Rünga", "46634")
    ig.village("Rasivere", "46632")
    ig.village("Aravuse", "46616")
    ig.village("Kaukvere", "46623")
    ig.village("Soonuka", "46636")
    ig.village("Palasi", "46630")
    ig.village("Nurmetu", "46628")
    ig.village("Võhu", "46620")
    ig.village("Mäetaguse", "46639")
    ig.village("Ristiküla", "46633")
    ig.village("Voore", "46642")
    ig.village("Puka", "46631")
    ig.village("Kulina", "46625")
    ig.village("Aruküla", "46617")
    ig.village("Alavere", "46611")
    ig.village("Inju", "46619")
    ig.village("Vana-Vinni", "46640")
    ig.village("Saara", "46635")
    ig.village("Kehala", "46624")
    ig.village("Aruvälja", "46618")

    ig.town("Tamsalu", "")
    ig.smallborough("Sääse", "")
    ig.village("Vajangu", "")
    ig.village("Porkuni", "")
    ig.village("Assamalla", "")
    ig.village("Sauvälja", "46023")
    ig.village("Järsi", "46007")
    ig.village("Savalduma", "46024")
    ig.village("Järvajõe", "46008")
    ig.village("Araski", "46005")
    ig.village("Uudeküla", "46026")
    ig.village("Koplitaguse", "46013")
    ig.village("Naistevälja", "46020")
    ig.village("Lemmküla", "46017")
    ig.village("Vadiküla", "46027")
    ig.village("Kerguta", "46011")
    ig.village("Vistla", "46028")
    ig.village("Kuie", "46014")
    ig.village("Kaeva", "46010")
    ig.village("Loksa", "46018")
    ig.village("Alupere", "46004")
    ig.village("Võhmetu", "46029")
    ig.village("Kursi", "46016")
    ig.village("Võhmuta", "46030")
    ig.village("Koiduküla", "46012")
    ig.village("Kullenga", "46015")
    ig.village("Metskaevu", "46019")
    ig.village("Põdrangu", "46022")
    ig.village("Piisupi", "46021")
    ig.village("Türje", "46025")

    ig.municipality("Rakke", "")
    ig.village("Suure-Rakke", "")
    ig.village("Mõisamaa", "")
    ig.village("Edru", "46304")
    ig.village("Mäiste", "46320")
    ig.village("Kõpsta", "46314")
    ig.village("Padaküla", "46323")
    ig.village("Tammiku", "")
    ig.village("Ao", "46303")
    ig.village("Kadiküla", "46308")
    ig.village("Väike-Rakke", "46331")
    ig.village("Väike-Tammiku", "46332")
    ig.village("Emumäe", "46305")
    ig.village("Sootaguse", "")
    ig.village("Piibe", "46324")
    ig.village("Liigvalla", "46318")
    ig.village("Olju", "46322")
    ig.village("Kellamäe", "46310")
    ig.village("Kamariku", "46309")
    ig.village("Koluvere", "46313")
    ig.village("Kitsemetsa", "46311")
    ig.village("Kaavere", "46307")
    ig.village("Lahu", "46315")
    ig.village("Salla", "46302")
    ig.village("Villakvere", "46330")
    ig.village("Koila", "")
    ig.village("Räitsvere", "46325")
    ig.village("Lasinurme", "46317")
    ig.village("Lammasküla", "46316")

    ig.municipality("Väike-Maarja", "")
    ig.smallborough("Simuna", "")
    ig.smallborough("Kiltsi", "")
    ig.village("Triigi", "")
    ig.village("Vao", "")
    ig.village("Ebavere", "")
    ig.village("Nadalama", "46221")
    ig.village("Raigu", "46227")
    ig.village("Aburi", "46206")
    ig.village("Eipri", "46210")
    ig.village("Pikevere", "46204")
    ig.village("Käru", "46217")
    ig.village("Orguse", "46223")
    ig.village("Imukvere", "46212")
    ig.village("Koonu", "46213")
    ig.village("Pudivere", "46225")
    ig.village("Avanduse", "46207")
    ig.village("Pandivere", "46224")
    ig.village("Rastla", "46228")
    ig.village("Varangu", "")
    ig.village("Uuemõisa", "46229")
    ig.village("Kännuküla", "46215")
    ig.village("Raeküla", "46226")
    ig.village("Vorsti", "46232")
    ig.village("Äntu", "46234")
    ig.village("Ärina", "46235")
    ig.village("Määri", "46219")
    ig.village("Nõmme", "46222")
    ig.village("Kurtna", "46214")
    ig.village("Aavere", "")
    ig.village("Liivaküla", "46218")
    ig.village("Võivere", "46233")
    ig.village("Avispea", "46208")
    ig.village("Hirla", "46211")
    ig.village("Kärsa", "46216")
    ig.village("Müüriku", "46220")

    ig.municipality("Sõmeru", "")
    ig.smallborough("Uhtna", "")
    ig.village("Ubja", "")
    ig.village("Toomla", "")
    ig.village("Ussimäe", "")
    ig.smallborough("Näpi", "")
    ig.village("Roodevälja", "")
    ig.village("Vaeküla", "")
    ig.village("Kohala", "")
    ig.village("Rägavere", "")
    ig.village("Põlula", "")
    ig.village("Nõmmise", "46710")
    ig.village("Viru-Kabala", "46714")
    ig.village("Miila", "46706")
    ig.village("Sae", "46712")
    ig.village("Kantküla", "46703")
    ig.village("Kõrma", "46704")
    ig.village("Nurkse", "46709")
    ig.village("Lavi", "46705")
    ig.village("Mõedaka", "46708")
    ig.village("Ulvi", "46701")
    ig.village("Aasuvälja", "46702")
    ig.village("Uljaste", "46713")
    ig.village("Männikvälja", "46707")

    ig.village("Katku", "44214")
    ig.village("Sämi-Tagaküla", "44225")
    ig.village("Sooaluse", "44223")
    ig.village("Jäätma", "")
    ig.village("Kohala-Eesküla", "44216")
    ig.village("Koovälja", "44217")
    ig.village("Katela", "44213")
    ig.village("Raudlepa", "44221")
    ig.village("Sämi", "44224")
    ig.village("Aluvere", "44208")
    ig.village("Aresi", "44210")
    ig.village("Kaarli", "44212")
    ig.village("Nurme", "44219")
    ig.village("Rahkla", "")
    ig.village("Raudvere", "44222")
    ig.village("Varudi-Altküla", "44228")
    ig.village("Varudi-Vanaküla", "44229")
    ig.village("Muru", "44218")
    ig.village("Andja", "44209")
    ig.village("Papiaru", "44206")

    ig.municipality("Vihula", "")
    ig.smallborough("Võsu", "")
    ig.village("Käsmu", "")
    ig.village("Sagadi", "")
    ig.village("Võsupere", "")
    ig.village("Palmse", "")
    ig.village("Oandu", "")
    ig.village("Metsiku", "45427")
    ig.village("Annikvere", "45410")
    ig.village("Ilumäe", "45414")
    ig.village("Adaka", "45407")
    ig.village("Kakuvälja", "45416")
    ig.village("Villandi", "45449")
    ig.village("Koolimäe", "45420")
    ig.village("Natturi", "45430")
    ig.village("Lahe", "45423")
    ig.village("Joandu", "45415")
    ig.village("Vila", "45448")
    ig.village("Rutja", "45451")
    ig.village("Metsanurga", "45426")
    ig.village("Lauli", "45424")
    ig.village("Altja", "45408")
    ig.village("Pajuveski", "45434")
    ig.village("Võhma", "")
    ig.village("Karula", "45417")
    ig.village("Noonu", "45431")
    ig.village("Korjuse", "45421")
    ig.village("Haili", "45413")
    ig.village("Tepelvälja", "45440")
    ig.village("Mustoja", "45429")
    ig.village("Tõugu", "45444")
    ig.village("Muike", "45428")
    ig.village("Tidriku", "45441")
    ig.village("Toolse", "45443")
    ig.village("Eru", "45412")
    ig.village("Pihlaspea", "45437")
    ig.village("Salatse", "45439")
    ig.village("Paasi", "45433")
    ig.village("Tiigi", "45442")
    ig.village("Lobi", "45425")
    ig.village("Karepa", "45401")
    ig.village("Aasumetsa", "45406")
    ig.village("Andi", "45409")
    ig.village("Kosta", "45422")
    ig.village("Vainupea", "45446")
    ig.village("Pedassaare", "45436")
    ig.village("Koljaku", "45419")
    ig.village("Vatku", "45447")
    ig.village("Sakussaare", "45438")
    ig.village("Uusküla", "45445")
    ig.village("Kiva", "45418")
    ig.village("Vergi", "45404")

    ig.municipality("Haljala", "")
    ig.village("Essu", "")
    ig.village("Aaspere", "")
    ig.village("Vanamõisa", "45319")
    ig.village("Kandle", "45308")
    ig.village("Pehka", "45315")
    ig.village("Kärmu", "45311")
    ig.village("Põdruse", "45316")
    ig.village("Tatruse", "45318")
    ig.village("Auküla", "45306")
    ig.village("Kõldu", "45312")
    ig.village("Kisuvere", "45310")
    ig.village("Kavastu", "45309")
    ig.village("Aasu", "45304")
    ig.village("Lihulõpe", "45313")
    ig.village("Võle", "45321")
    ig.village("Idavere", "45307")
    ig.village("Aaviku", "45305")
    ig.village("Sauste", "45317")
    ig.village("Liiguste", "45314")

    ig.town("Kunda", "")
    ig.municipality("Kadrina", "")
    ig.village("Viitna", "")
    ig.smallborough("Hulja", "")
    ig.village("Tokolopi", "")
    ig.village("Kadapiku", "")
    ig.village("Tirbiku", "")
    ig.village("Mõndavere", "45222")
    ig.village("Võduvere", "45238")
    ig.village("Kihlevere", "45215")
    ig.village("Mäo", "45223")
    ig.village("Põima", "45228")
    ig.village("Vandu", "45237")
    ig.village("Uku", "45234")
    ig.village("Läsna", "45221")
    ig.village("Vohnja", "45204")
    ig.village("Ohepalu", "45225")
    ig.village("Arbavere", "45206")
    ig.village("Kiku", "45216")
    ig.village("Vaiatu", "45236")
    ig.village("Ama", "45205")
    ig.village("Loobu", "45220")
    ig.village("Udriku", "45233")
    ig.village("Hõbeda", "45207")
    ig.village("Rõmeda", "45230")
    ig.village("Kallukse", "45214")
    ig.village("Jõepere", "45209")
    ig.village("Undla", "45235")
    ig.village("Neeruti", "45224")
    ig.village("Ridaküla", "45229")
    ig.village("Lante", "45218")
    ig.village("Võipere", "45239")
    ig.village("Leikude", "45219")
    ig.village("Härjadi", "45208")
    ig.village("Orutaguse", "45226")
    ig.village("Jõetaguse", "45210")
    ig.village("Salda", "45231")
    ig.village("Saukse", "45232")
    ig.village("Pariisi", "45227")

    ig.municipality("Laekvere", "")
    ig.village("Muuga", "")
    ig.village("Vassivere", "46519")
    ig.village("Alekvere", "46505")
    ig.village("Rajaküla", "46513")
    ig.village("Kellavere", "46508")
    ig.village("Salutaguse", "46516")
    ig.village("Venevere", "46504")
    ig.village("Rohu", "46515")
    ig.village("Moora", "46510")
    ig.village("Arukse", "46514")
    ig.village("Kaasiksaare", "46507")
    ig.village("Sirevere", "46517")
    ig.village("Ilistvere", "46506")
    ig.village("Padu", "46512")
    ig.village("Luusika", "46509")
    ig.village("Paasvere", "46511")

    ig.municipality("Viru-Nigula", "")
    ig.village("Siberi", "44028")
    ig.village("Selja", "44027")
    ig.village("Vasta", "44034")
    ig.village("Kabeli", "44004")
    ig.village("Kuura", "44012")
    ig.village("Malla", "44016")
    ig.village("Võrkla", "44035")
    ig.village("Kaliküla", "44005")
    ig.village("Samma", "44026")
    ig.village("Ojaküla", "44020")
    ig.village("Letipea", "44013")
    ig.village("Nugeri", "44019")
    ig.village("Linnuse", "44014")
    ig.village("Pikaristi", "44024")
    ig.village("Iila", "44003")
    ig.village("Tüükri", "44031")
    ig.village("Toomika", "44030")
    ig.village("Kutsala", "44011")
    ig.village("Kurna", "44010")
    ig.village("Aasukalda", "44002")
    ig.village("Mahu", "44015")
    ig.village("Paasküla", "44021")
    ig.village("Varudi", "44033")
    ig.village("Pärna", "44025")
    ig.village("Simunamäe", "44029")
    ig.village("Pada", "44023")
    ig.village("Pada-Aruküla", "44022")
    ig.village("Villavere", "44037")
    ig.village("Kanguristi", "44006")
    ig.village("Marinu", "44017")
    ig.village("Metsavälja", "44018")
    ig.village("Kiviküla", "44007")
    ig.village("Unukse", "44032")

    ig.municipality("Eisma", "")

    # Põlva (county)
    ig.county("Põlva", "")
    ig.town("Räpina", "")
    ig.village("Ristipalo", "")
    ig.village("Ruusa", "")
    ig.village("Leevaku", "")
    ig.village("Linte", "")
    ig.village("Naha", "64411")
    ig.village("Kõnnu", "64407")
    ig.village("Võiardi", "64426")
    ig.village("Saareküla", "64419")
    ig.village("Tsirksi", "64425")
    ig.village("Sillapää", "64420")
    ig.village("Köstrimäe", "64408")
    ig.village("Toolamaa", "64423")
    ig.village("Võuküla", "64427")
    ig.village("Mägiotsa", "64410")
    ig.village("Nulga", "64412")
    ig.village("Pindi", "64413")
    ig.village("Kassilaane", "64406")
    ig.village("Raigla", "64417")
    ig.village("Tooste", "64424")
    ig.village("Meelva", "64409")
    ig.village("Jaanikeste", "64405")
    ig.village("Rahumäe", "64416")
    ig.village("Pääsna", "64414")
    ig.village("Sülgoja", "64422")
    ig.village("Raadama", "64415")
    ig.village("Suure-Veerksu", "64421")

    ig.town("Põlva", "")
    ig.village("Soesaare", "")
    ig.village("Rosma", "")
    ig.village("Himmaste", "")
    ig.village("Taevaskoja", "")
    ig.village("Mammaste", "")
    ig.village("Tromsi", "63223")
    ig.village("Adiste", "63204")
    ig.village("Valgesoo", "63226")
    ig.village("Vanaküla", "63227")
    ig.village("Metste", "63213")
    ig.village("Nooritsmetsa", "63215")
    ig.village("Peri", "63218")
    ig.village("Holvandi", "63207")
    ig.village("Puskaru", "63219")
    ig.village("Meemaste", "63212")
    ig.village("Eoste", "63206")
    ig.village("Puuri", "63220")
    ig.village("Kähri", "63209")
    ig.village("Orajõe", "63216")
    ig.village("Aarna", "63203")
    ig.village("Lutsu", "63210")
    ig.village("Tännassilma", "63224")
    ig.village("Kiuma", "")
    ig.village("Uibujärve", "63225")
    ig.village("Miiaste", "63214")
    ig.village("Partsi", "63217")
    ig.village("Andre", "63205")

    ig.municipality("Veriora", "")
    ig.village("Leevi", "")
    ig.village("Männisalu", "64215")
    ig.village("Viira", "64224")
    ig.village("Kullamäe", "64210")
    ig.village("Haavapää", "64203")
    ig.village("Nohipalo", "64216")
    ig.village("Koolmajärve", "64209")
    ig.village("Kunksilla", "64211")
    ig.village("Laho", "")
    ig.village("Süvahavva", "64220")
    ig.village("Soohara", "64219")
    ig.village("Timo", "64221")
    ig.village("Sarvemäe", "64218")
    ig.village("Vareste", "64222")
    ig.village("Kikka", "64206")
    ig.village("Lihtensteini", "64213")
    ig.village("Väike-Veerksu", "64228")
    ig.village("Kirmsi", "64207")
    ig.village("Vändra", "64229")
    ig.village("Võika", "64227")
    ig.village("Jõeveere", "64233")
    ig.village("Himmiste", "64204")
    ig.village("Viluste", "64225")
    ig.village("Mõtsavaara", "64214")
    ig.village("Koolma", "64208")
    ig.village("Vinso", "64226")
    ig.village("Pahtpää", "64217")
    ig.village("Jõevaara", "64205")
    ig.village("Verioramõisa", "64223")

    ig.municipality("Kanepi", "")
    ig.village("Põlgaste", "")
    ig.village("Magari", "")
    ig.village("Jõgehara", "63109")
    ig.village("Peetrimõisa", "63118")
    ig.village("Kooraste", "63114")
    ig.village("Sõreste", "63121")
    ig.village("Lauri", "63115")
    ig.village("Soodoma", "63124")
    ig.village("Jõksi", "63110")
    ig.village("Heisri", "63106")
    ig.village("Koigera", "63113")
    ig.village("Hino", "63107")
    ig.village("Rebaste", "63120")
    ig.village("Kaagvere", "63103")
    ig.village("Närapää", "63117")
    ig.village("Erastvere", "63105")
    ig.village("Piigandi", "63119")
    ig.village("Kaagna", "63111")
    ig.village("Hurmi", "63108")
    ig.village("Varbuse", "63122")
    ig.village("Karste", "63112")

    ig.municipality("Ahja", "")
    ig.village("Ibaste", "63703")
    ig.village("Akste", "63702")
    ig.village("Mõtsküla", "63708")
    ig.village("Vanamõisa", "63709")
    ig.village("Kosova", "63704")
    ig.village("Mustakurmu", "63707")
    ig.village("Loko", "63706")
    ig.village("Kärsa", "63705")

    ig.municipality("Kõlleste", "")
    ig.village("Krootuse", "")
    ig.village("Prangli", "")
    ig.village("Veski", "63511")
    ig.village("Häätaru", "63502")
    ig.village("Tõdu", "63510")
    ig.village("Karaski", "63504")
    ig.village("Voorepalu", "63512")
    ig.village("Piigaste", "63507")
    ig.village("Palutaja", "63506")
    ig.village("Tuulemäe", "63509")
    ig.village("Ihamaru", "63503")

    ig.municipality("Vastse-Kuuste", "")
    ig.village("Vooreküla", "")
    ig.village("Karilatsi", "")
    ig.village("Valgemetsa", "63610")
    ig.village("Kiidjärve", "63604")
    ig.village("Koorvere", "63605")
    ig.village("Logina", "63607")
    ig.village("Padari", "63609")
    ig.village("Lootvina", "63608")
    ig.village("Leevijõe", "63606")

    ig.municipality("Värska", "")
    ig.village("Lobotka", "")
    ig.village("Tonja", "64025")
    ig.village("Popovitsa", "64019")
    ig.village("Rääptsova", "64020")
    ig.village("Velna", "64030")
    ig.village("Õrsava", "64035")
    ig.village("Väike-Rõsna", "64034")
    ig.village("Podmotsa", "64018")
    ig.village("Verhulitsa", "64031")
    ig.village("Litvina", "64011")
    ig.village("Korela", "64007")
    ig.village("Vaartsi", "64028")
    ig.village("Saatse", "64037")
    ig.village("Matsuri", "64036")
    ig.village("Vedernika", "64029")
    ig.village("Ulitina", "64027")
    ig.village("Perdaku", "64017")
    ig.village("Kremessova", "64009")
    ig.village("Saabolda", "64021")
    ig.village("Sesniki", "64023")
    ig.village("Koidula", "64004")
    ig.village("Kolodavitsa", "64005")
    ig.village("Kolossova", "64006")
    ig.village("Lutepää", "64013")
    ig.village("Pattina", "64016")
    ig.village("Nedsaja", "64015")
    ig.village("Säpina", "64024")
    ig.village("Võpolsova", "64033")
    ig.village("Kundruse", "64010")
    ig.village("Voropi", "64032")
    ig.village("Määsovitsa", "64014")
    ig.village("Kostkova", "64008")
    ig.village("Samarina", "64022")
    ig.village("Treski", "64026")

    ig.municipality("Mikitamäe", "")
    ig.village("Võõpsu", "")
    ig.village("Lüübnitsa", "")
    ig.village("Beresje", "")
    ig.village("Niitsiku", "64319")
    ig.village("Puugnitsa", "64311")
    ig.village("Rõsna", "64312")
    ig.village("Igrise", "64304")
    ig.village("Audjassaare", "64302")
    ig.village("Järvepää", "64305")
    ig.village("Usinitsa", "64316")
    ig.village("Selise", "64314")
    ig.village("Rääsolaane", "64313")
    ig.village("Varesmäe", "64317")
    ig.village("Laossina", "64308")
    ig.village("Karisilla", "64307")
    ig.village("Toomasmäe", "64315")

    ig.municipality("Mooste", "")
    ig.village("Terepi", "64613")
    ig.village("Kastmekoja", "64608")
    ig.village("Rasina", "64618")
    ig.village("Jaanimõisa", "64604")
    ig.village("Säässaare", "64612")
    ig.village("Säkna", "64611")
    ig.village("Kauksi", "64617")
    ig.village("Viisli", "64614")
    ig.village("Savimäe", "64609")
    ig.village("Kanassaare", "64607")
    ig.village("Kaaru", "64605")
    ig.village("Kadaja", "64606")
    ig.village("Suurmetsa", "64610")

    ig.municipality("Orava", "")
    ig.village("Piusa", "")
    ig.village("Suuremetsa", "64105")
    ig.village("Kliima", "64110")
    ig.village("Tamme", "64106")
    ig.village("Hanikase", "64107")
    ig.village("Luuska", "64117")
    ig.village("Praakmani", "64104")
    ig.village("Kakusuu", "64109")
    ig.village("Madi", "64118")
    ig.village("Kõvera", "64115")
    ig.village("Liinamäe", "64116")
    ig.village("Korgõmõisa", "64112")
    ig.village("Vivva", "64131")
    ig.village("Päka", "64123")
    ig.village("Jantra", "64103")
    ig.village("Tuderna", "64130")
    ig.village("Kahkva", "")
    ig.village("Rõssa", "64127")
    ig.village("Kamnitsa", "64111")
    ig.village("Riihora", "64126")
    ig.village("Lepassaare", "64102")
    ig.village("Oro", "64121")
    ig.village("Pääväkese", "64124")
    ig.village("Marga", "64119")
    ig.village("Kõivsaare", "64113")
    ig.village("Soe", "64128")
    ig.village("Soena", "64129")
    ig.village("Rebasmäe", "64125")
    ig.village("Kõliküla", "64114")

    ig.municipality("Valgjärve", "")
    ig.village("Saverna", "")
    ig.village("Sirvaste", "63413")
    ig.village("Abissaare", "63404")
    ig.village("Hauka", "63406")
    ig.village("Krüüdneri", "63408")
    ig.village("Sulaoja", "63414")
    ig.village("Maaritsa", "63417")
    ig.village("Vissi", "63416")
    ig.village("Aiaste", "63405")
    ig.village("Puugi", "63412")
    ig.village("Tiido", "63415")
    ig.village("Pikajärve", "63410")
    ig.village("Mügra", "63409")
    ig.village("Kooli", "63407")
    ig.village("Pikareinu", "63411")

    ig.municipality("Laheda", "")
    ig.village("Tilsi", "")
    ig.village("Himma", "63002")
    ig.village("Pragi", "63007")
    ig.village("Lahe", "63004")
    ig.village("Vardja", "63011")
    ig.village("Mustajõe", "63005")
    ig.village("Vana-Koiola", "63010")
    ig.village("Roosi", "63008")
    ig.village("Naruski", "63006")
    ig.village("Joosu", "63003")
    ig.village("Suurküla", "63009")


    # Pärnu (county)
    ig.county("Pärnu", "")
    ig.municipality("Halinga", "")
    ig.village("Libatse", "")
    ig.borough("Pärnu-Jaagupi", "")
    ig.village("Tõrdu", "")
    ig.village("Pitsalu", "87230")
    ig.village("Rukkiküla", "87233")
    ig.village("Kodesmaa", "87217")
    ig.village("Salu", "87234")
    ig.village("Mäeküla", "87225")
    ig.village("Helenurme", "87213")
    ig.village("Altküla", "87204")
    ig.village("Anelema", "87205")
    ig.village("Kuninga", "87218")
    ig.village("Arase", "87206")
    ig.village("Tarva", "")
    ig.village("Kablima", "87214")
    ig.village("Oese", "87227")
    ig.village("Valistre", "87242")
    ig.village("Vakalepa", "87241")
    ig.village("Sepaküla", "87235")
    ig.village("Enge", "87210")
    ig.village("Vahenurme", "87101")
    ig.village("Pereküla", "87229")
    ig.village("Sõõrike", "87237")
    ig.village("Vee", "87243")
    ig.village("Ertsma", "87211")
    ig.village("Maima", "87223")
    ig.village("Mõisaküla", "87224")
    ig.village("Kaelase", "87215")
    ig.village("Roodi", "87232")
    ig.village("Pallika", "87228")
    ig.village("Loomse", "87222")
    ig.village("Lehtmetsa", "87220")
    ig.village("Langerma", "87219")
    ig.village("Lehu", "87221")
    ig.village("Kangru", "87216")
    ig.village("Tühjasma", "87240")
    ig.village("Eense", "87208")
    ig.village("Soosalu", "87236")
    ig.village("Aasa", "87203")
    ig.village("Eerma", "87209")
    ig.village("Pööravere", "87231")
    ig.village("Naartse", "87226")

    ig.municipality("Tootsi", "")
    ig.municipality("Vändra", "")
    ig.village("Vihtra", "")
    ig.village("Võidula", "")
    ig.village("Kergu", "")
    ig.village("Suurejõe", "")
    ig.village("Kaisma", "")
    ig.village("Viluvere", "87633")
    ig.village("Rahnoja", "87622")
    ig.village("Luuri", "87614")
    ig.village("Kullimaa", "87611")
    ig.village("Ünnaste", "87636")
    ig.village("Kobra", "87609")
    ig.village("Massu", "87616")
    ig.village("Rõusa", "87624")
    ig.village("Allikõnnu", "87604")
    ig.village("Oriküla", "87619")
    ig.village("Kalmaru", "87607")
    ig.village("Kirikumõisa", "87608")
    ig.village("Kurgja", "87612")
    ig.village("Metsavere", "87405")
    ig.village("Veskisoo", "87632")
    ig.village("Leetva", "87613")
    ig.village("Tagassaare", "87629")
    ig.village("Lüüste", "87615")
    ig.village("Rätsepa", "")
    ig.village("Aluste", "87601")
    ig.village("Rae", "87621")
    ig.village("Kose", "87610")
    ig.village("Pärnjõe", "87620")
    ig.village("Reinumurru", "87623")
    ig.village("Rahkama", "87406")
    ig.village("Sikana", "87627")
    ig.village("Kaansoo", "87605")
    ig.village("Võiera", "87635")
    ig.village("Kõnnu", "87403")
    ig.village("Venekuusiku", "87631")
    ig.village("Sohlu", "87407")
    ig.village("Säästla", "87628")
    ig.village("Samliku", "87626")
    ig.village("Kadjaste", "87606")
    ig.village("Vaki", "87630")
    ig.village("Mustaru", "87617")
    ig.village("Mädara", "87618")

    ig.municipality("Tori", "")
    ig.village("Jõesuu", "")
    ig.village("Piistaoja", "")
    ig.village("Kõrsa", "")
    ig.village("Selja", "")
    ig.village("Taali", "")
    ig.village("Urumarja", "")
    ig.village("Kildemaa", "86805")
    ig.village("Oore", "86812")
    ig.village("Elbi", "86804")
    ig.village("Aesoo", "86803")
    ig.village("Muti", "86811")
    ig.village("Riisa", "86815")
    ig.village("Levi", "86808")
    ig.village("Kuiaru", "86806")
    ig.village("Muraka", "86810")
    ig.village("Tohera", "86819")
    ig.village("Mannare", "86809")
    ig.village("Randivälja", "86814")
    ig.village("Võlli", "86821")

    ig.municipality("Tõstamaa", "")
    ig.village("Kiraste", "88108")
    ig.village("Lao", "88110")
    ig.village("Pootsi", "88115")
    ig.village("Tõlli", "88119")
    ig.village("Rammuka", "88117")
    ig.village("Ranniku", "88118")
    ig.village("Lõuka", "88111")
    ig.village("Tõhela", "88102")
    ig.village("Seliste", "88103")
    ig.village("Peerni", "88114")
    ig.village("Kastna", "88106")
    ig.village("Alu", "88104")
    ig.village("Ermistu", "88105")
    ig.village("Kavaru", "88107")
    ig.village("Värati", "88120")
    ig.village("Männikuste", "88113")
    ig.village("Päraküla", "88116")
    ig.village("Manija", "88112")
    ig.village("Kõpu", "88109")

    ig.municipality("Tahkuranna", "")
    ig.village("Reiu", "")
    ig.village("Uulu", "")
    ig.smallborough("Võiste", "")
    ig.village("Lepaküla", "")
    ig.village("Laadi", "")
    ig.village("Piirumi", "86507")
    ig.village("Metsaküla", "")
    ig.village("Leina", "86504")

    ig.municipality("Sauga", "")
    ig.village("Tammiste", "")
    ig.village("Kilksama", "")
    ig.village("Eametsa", "")
    ig.village("Nurme", "")
    ig.village("Urge", "")
    ig.village("Vainu", "")
    ig.village("Räägu", "85006")
    ig.village("Kiisa", "85002")
    ig.village("Rütavere", "85007")
    ig.village("Pulli", "85005")

    ig.municipality("Paikuse", "")
    ig.village("Silla", "")
    ig.village("Seljametsa", "")
    ig.village("Tammuru", "")
    ig.village("Põlendmaa", "86603")
    ig.village("Vaskrääma", "86606")

    ig.town("Pärnu", "")
    ig.town("Sindi", "")
    ig.municipality("Audru", "")
    ig.village("Kõima", "")
    ig.village("Papsaare", "")
    ig.village("Lemmetsa", "")
    ig.village("Liiva", "")
    ig.village("Malda", "")
    ig.village("Marksa", "")
    ig.village("Kihlepa", "")
    ig.village("Lindi", "")
    ig.village("Jõõpre", "")
    ig.village("Kabriste", "")
    ig.village("Põldeotsa", "")
    ig.village("Saulepa", "")
    ig.village("Valgeranna", "")
    ig.village("Ahaste", "")
    ig.village("Oara", "88316")
    ig.village("Soeva", "88323")
    ig.village("Tuuraste", "88325")
    ig.village("Saari", "88321")
    ig.village("Soomra", "")
    ig.village("Kärbu", "88310")
    ig.village("Põhara", "88318")
    ig.village("Liu", "88313")
    ig.village("Eassalu", "88307")
    ig.village("Ridalepa", "88320")

    ig.municipality("Häädemeeste", "")
    ig.village("Kabli", "")
    ig.village("Rannametsa", "86016")
    ig.village("Papisilla", "86013")
    ig.village("Penu", "86014")
    ig.village("Metsapoole", "86010")
    ig.village("Orajõe", "86012")
    ig.village("Urissaare", "86019")
    ig.village("Arumetsa", "86006")
    ig.village("Sooküla", "86017")
    ig.village("Massiaru", "86004")
    ig.village("Majaka", "")
    ig.village("Soometsa", "86018")
    ig.village("Krundiküla", "86008")
    ig.village("Võidu", "86021")
    ig.village("Uuemaa", "86020")
    ig.village("Pulgoja", "86015")
    ig.village("Jaagupi", "86007")
    ig.village("Ikla", "86005")
    ig.village("Nepste", "86011")
    ig.village("Treimani", "86003")

    ig.town("Kilingi-Nõmme", "")
    ig.municipality("Are", "")
    ig.village("Kurena", "")
    ig.village("Parisselja", "87308")
    ig.village("Suigu", "87302")
    ig.village("Elbu", "87304")
    ig.village("Niidu", "87307")
    ig.village("Pärivere", "87309")
    ig.village("Tabria", "87311")
    ig.village("Lepplaane", "87306")
    ig.village("Murru", "87310")
    ig.village("Eavere", "87303")
    ig.village("Võlla", "87312")

    ig.municipality("Lavassaare", "")
    ig.municipality("Varbla", "")
    ig.village("Käru", "88217")
    ig.village("Kidise", "88212")
    ig.village("Saare", "88231")
    ig.village("Paatsalu", "88204")
    ig.village("Sookalda", "88233")
    ig.village("Maade", "88218")
    ig.village("Kilgi", "88213")
    ig.village("Tiilima", "88235")
    ig.village("Matsi", "88219")
    ig.village("Koeri", "88214")
    ig.village("Ännikse", "88240")
    ig.village("Korju", "88215")
    ig.village("Õhu", "88239")
    ig.village("Tõusi", "88236")
    ig.village("Piha", "88225")
    ig.village("Täpsi", "88237")
    ig.village("Mõtsu", "88222")
    ig.village("Raheste", "88227")
    ig.village("Paadrema", "88202")
    ig.village("Kulli", "88216")
    ig.village("Mereäärse", "88220")
    ig.village("Raespa", "88226")
    ig.village("Aruküla", "88206")
    ig.village("Helmküla", "88208")
    ig.village("Hõbesalu", "88209")
    ig.village("Rauksi", "88229")
    ig.village("Muriste", "88221")
    ig.village("Mäliküla", "88223")
    ig.village("Kanamardi", "88211")
    ig.village("Saulepi", "88203")
    ig.village("Tamba", "88234")
    ig.village("Vaiste", "88238")
    ig.village("Haapsi", "88207")
    ig.village("Rädi", "88230")
    ig.village("Allika", "88205")
    ig.village("Rannaküla", "88228")
    ig.village("Kadaka", "88210")
    ig.village("Nõmme", "88224")

    ig.municipality("Saarde", "")
    ig.smallborough("Tihemetsa", "")
    ig.village("Veelikse", "")
    ig.village("Tõlla", "")
    ig.village("Tali", "")
    ig.village("Tuuliku", "86108")
    ig.village("Sigaste", "86214")
    ig.village("Reinu", "86107")
    ig.village("Leipste", "86209")
    ig.village("Kalita", "86206")
    ig.village("Marina", "86105")
    ig.village("Jäärja", "86205")
    ig.village("Laiksaare", "86103")
    ig.village("Väljaküla", "86215")
    ig.village("Mustla", "86212")
    ig.village("Viisireiu", "86109")
    ig.village("Pihke", "86106")
    ig.village("Kamali", "86207")
    ig.village("Lodja", "86210")
    ig.village("Lanksaare", "86104")
    ig.village("Marana", "86211")
    ig.village("Kanaküla", "86204")
    ig.village("Kärsu", "86208")
    ig.village("Oissaare", "86216")

    ig.municipality("Surju", "")
    ig.village("Kalda", "")
    ig.village("Ristiküla", "86410")
    ig.village("Jaamaküla", "86403")
    ig.village("Lähkma", "86407")
    ig.village("Kikepera", "86405")
    ig.village("Rabaküla", "86409")
    ig.village("Kõveri", "86406")
    ig.village("Saunametsa", "86411")
    ig.village("Ilvese", "86402")

    ig.municipality("Kihnu", "")
    ig.village("Linaküla", "")
    ig.village("Lemsi", "88002")
    ig.village("Sääre", "88005")
    ig.village("Rootsiküla", "88004")

    ig.municipality("Koonga", "")
    ig.village("Võrungi", "88441")
    ig.village("Tamme", "88434")
    ig.village("Ura", "88436")
    ig.village("Paimvere", "88425")
    ig.village("Irta", "88407")
    ig.village("Pikavere", "88430")
    ig.village("Peantse", "88428")
    ig.village("Kibura", "88415")
    ig.village("Vastaba", "88438")
    ig.village("Iska", "88408")
    ig.village("Kurese", "88418")
    ig.village("Nätsi", "88424")
    ig.village("Sookatse", "88433")
    ig.village("Jänistvere", "88410")
    ig.village("Järve", "88411")
    ig.village("Tõitse", "88435")
    ig.village("Joonuse", "88409")
    ig.village("Urita", "88437")
    ig.village("Õepa", "88442")
    ig.village("Karuba", "88414")
    ig.village("Võitra", "88440")
    ig.village("Kuhu", "88417")
    ig.village("Emmu", "88405")
    ig.village("Kiisamaa", "88416")
    ig.village("Rabavere", "88431")
    ig.village("Palatu", "88426")
    ig.village("Nedrema", "88423")
    ig.village("Oidrema", "88404")
    ig.village("Naissoo", "88422")
    ig.village("Kalli", "88412")
    ig.village("Veltsa", "88439")
    ig.village("Hõbeda", "88406")
    ig.village("Salevere", "88432")
    ig.village("Mihkli", "88421")
    ig.village("Maikse", "88420")
    ig.village("Piisu", "88429")
    ig.village("Karinõmme", "88413")
    ig.village("Parasmaa", "88427")
    ig.village("Lõpe", "88402")

    ig.municipality("Metsaääre", "")
    ig.municipality("Aruvälja", "")

    # Rapla (county)
    ig.county("Rapla", "")
    ig.municipality("Kehtna", "")
    ig.smallborough("Lelle", "")
    ig.smallborough("Eidapere", "")
    ig.smallborough("Kaerepere", "")
    ig.village("Saksa", "")
    ig.village("Ohekatku", "")
    ig.village("Rõue", "")
    ig.smallborough("Keava", "")
    ig.village("Käbiküla", "")
    ig.village("Metsaääre", "")
    ig.village("Kehtna-Nurme", "79051")
    ig.village("Laeste", "79064")
    ig.village("Koogimäe", "79052")
    ig.village("Palasi", "79018")
    ig.village("Kärpla", "79063")
    ig.village("Kastna", "79016")
    ig.village("Vastja", "79071")
    ig.village("Lau", "79008")
    ig.village("Linnaaluste", "79050")
    ig.village("Reonda", "79015")
    ig.village("Kõrbja", "79023")
    ig.village("Selja", "79110")
    ig.village("Ellamaa", "79011")
    ig.village("Sooaluste", "79070")
    ig.village("Ahekõnnu", "79111")
    ig.village("Kalbu", "79061")
    ig.village("Mukri", "79013")
    ig.village("Saarepõllu", "79014")
    ig.village("Lokuta", "")
    ig.village("Põrsaku", "79524")
    ig.village("Hertu", "79521")
    ig.village("Pae", "79009")
    ig.village("Nadalama", "79068")
    ig.village("Lellapere-Nurme", "79066")
    ig.village("Lalli", "79017")
    ig.village("Nõlva", "79112")
    ig.village("Hiie", "79060")
    ig.village("Kenni", "79012")
    ig.village("Haakla", "79021")
    ig.village("Paluküla", "79019")
    ig.village("Saunaküla", "79526")
    ig.village("Koogiste", "79022")
    ig.village("Lellapere", "79065")
    ig.village("Valtu-Nurme", "79527")
    ig.village("Kumma", "79523")
    ig.village("Ingliste", "79004")
    ig.village("Põllu", "79020")

    ig.municipality("Rapla", "")
    ig.village("Uusküla", "")
    ig.smallborough("Hagudi", "")
    ig.smallborough("Alu", "")
    ig.village("Sulupere", "")
    ig.village("Mahlamäe", "")
    ig.village("Tuti", "")
    ig.smallborough("Kuusiku", "")
    ig.village("Kalevi", "")
    ig.village("Kuku", "")
    ig.village("Purila", "")
    ig.village("Valtu", "")
    ig.village("Kodila", "")
    ig.village("Sikeldi", "")
    ig.village("Ülejõe", "")
    ig.village("Oola", "79643")
    ig.village("Kõrgu", "79615")
    ig.village("Alu-Metsküla", "79605")
    ig.village("Seli", "79604")
    ig.village("Tõrma", "79622")
    ig.village("Seli-Nurme", "79634")
    ig.village("Röa", "79614")
    ig.village("Aranküla", "79640")
    ig.village("Oela", "79617")
    ig.village("Ohulepa", "79618")
    ig.village("Kodila-Metsküla", "79613")
    ig.village("Äherdi", "79644")
    ig.village("Juula", "79540")
    ig.village("Mõisaaseme", "79632")
    ig.village("Tapupere", "79621")
    ig.village("Ridaküla", "79528")
    ig.village("Palamulla", "79619")
    ig.village("Väljataguse", "79543")
    ig.village("Lipstu", "79519")
    ig.village("Kelba", "79611")
    ig.village("Koigi", "79630")
    ig.village("Kuusiku-Nõmme", "79518")
    ig.village("Mällu", "79616")
    ig.village("Nõmme", "79642")
    ig.village("Raka", "79620")
    ig.village("Iira", "79517")

    ig.municipality("Märjamaa", "")
    ig.village("Sõtke", "")
    ig.village("Maidla", "")
    ig.village("Sipa", "")
    ig.village("Moka", "78236")
    ig.village("Kasti", "78221")
    ig.village("Vana-Nurtu", "78258")
    ig.village("Kangru", "78220")
    ig.village("Sõmeru", "78255")
    ig.village("Purga", "78249")
    ig.village("Velise-Nõlva", "78260")
    ig.village("Laukna", "")
    ig.village("Napanurga", "78240")
    ig.village("Inda", "78216")
    ig.village("Pajaka", "78248")
    ig.village("Risu-Suurküla", "78252")
    ig.village("Veski", "78261")
    ig.village("Urevere", "78120")
    ig.village("Mõraste", "78116")
    ig.village("Loodna", "78113")
    ig.village("Kiilaspere", "78223")
    ig.village("Paisumaa", "78247")
    ig.village("Aravere", "78213")
    ig.village("Valgu", "78204")
    ig.village("Vanamõisa", "")
    ig.village("Konuvere", "78227")
    ig.village("Altküla", "78212")
    ig.village("Nõmmeotsa", "78242")
    ig.village("Rassiotsa", "78251")
    ig.village("Varbola", "78203")
    ig.village("Nurme", "78241")
    ig.village("Ohukotsu", "78244")
    ig.village("Mäliste", "78238")
    ig.village("Kohtru", "78226")
    ig.village("Russalu", "78317")
    ig.village("Leevre", "78112")
    ig.village("Keskküla", "78222")
    ig.village("Kaguvere", "78219")
    ig.village("Alaküla", "78211")
    ig.village("Metsküla", "")
    ig.village("Velise", "78201")
    ig.village("Orgita", "78313")
    ig.village("Naistevalla", "78239")
    ig.village("Paaduotsa", "78246")
    ig.village("Nurtu-Nõlva", "78207")
    ig.village("Velisemõisa", "78259")
    ig.village("Kilgi", "78224")
    ig.village("Paeküla", "78206")
    ig.village("Sulu", "78253")
    ig.village("Vaimõisa", "78205")
    ig.village("Kunsu", "78228")
    ig.village("Kirna", "78225")
    ig.village("Aruküla", "78214")
    ig.village("Vilta", "78121")
    ig.village("Võeva", "78262")
    ig.village("Lestima", "78232")
    ig.village("Käriselja", "78231")
    ig.village("Päädeva", "78314")
    ig.village("Ojaäärse", "78245")
    ig.village("Teenuse", "78103")
    ig.village("Nääri", "78243")
    ig.village("Põlli", "78250")
    ig.village("Sooniste", "78118")
    ig.village("Kohatu", "78111")
    ig.village("Jõeääre", "78218")
    ig.village("Haimre", "78202")
    ig.village("Luiste", "78114")
    ig.village("Männiku", "78117")
    ig.village("Suurküla", "78254")
    ig.village("Soosalu", "78119")
    ig.village("Rangu", "78315")
    ig.village("Ringuta", "78316")
    ig.village("Koluta", "78311")
    ig.village("Hiietse", "78215")
    ig.village("Kõrtsuotsa", "78229")
    ig.village("Jaaniveski", "78217")
    ig.village("Tolli", "78256")
    ig.village("Mõisamaa", "78237")

    ig.municipality("Järvakandi", "")
    ig.municipality("Juuru", "")
    ig.village("Järlepa", "")
    ig.village("Pirgu", "")
    ig.village("Orguse", "")
    ig.village("Hõreda", "79010")
    ig.village("Härgla", "79404")
    ig.village("Atla", "79403")
    ig.village("Mahtra", "79407")
    ig.village("Vankse", "79406")
    ig.village("Helda", "79417")
    ig.village("Kalda", "79418")
    ig.village("Sadala", "79419")
    ig.village("Jaluse", "79410")
    ig.village("Lõiuse", "79405")

    ig.municipality("Kaiu", "")
    ig.village("Kuimetsa", "")
    ig.village("Oblu", "79312")
    ig.village("Karitsa", "79320")
    ig.village("Kasvandu", "79321")
    ig.village("Tolla", "79322")
    ig.village("Põlliku", "79325")
    ig.village("Vahastu", "79303")
    ig.village("Tamsi", "79313")
    ig.village("Vaopere", "79314")
    ig.village("Suurekivi", "79333")
    ig.village("Toomja", "79323")
    ig.village("Vana-Kaiu", "79324")

    ig.municipality("Käru", "")
    ig.village("Sonni", "")
    ig.village("Lauri", "79215")
    ig.village("Kõdu", "79212")
    ig.village("Kädva", "79213")
    ig.village("Lungu", "79216")
    ig.village("Kändliku", "79214")
    ig.village("Kullimaa", "79211")
    ig.village("Jõeküla", "79218")

    ig.municipality("Kohila", "")
    ig.smallborough("Prillimäe", "")
    ig.village("Lohu", "")
    ig.village("Urge", "")
    ig.smallborough("Hageri", "")
    ig.village("Salutaguse", "")
    ig.village("Vilivere", "")
    ig.village("Sutlema", "")
    ig.smallborough("Aespa", "")
    ig.village("Masti", "")
    ig.village("Pukamäe", "")
    ig.village("Angerja", "79741")
    ig.village("Lümandu", "")
    ig.village("Pihali", "79703")
    ig.village("Adila", "79704")
    ig.village("Loone", "79831")
    ig.village("Põikma", "79709")
    ig.village("Rootsi", "79815")
    ig.village("Kadaka", "79811")
    ig.village("Rabivere", "79610")
    ig.village("Aandu", "79810")
    ig.village("Mälivere", "79814")
    ig.village("Pahkla", "79742")
    ig.village("Vana-Aespa", "79748")

    ig.municipality("Vigala", "")
    ig.village("Vana-Vigala", "78003")
    ig.village("Kivi-Vigala", "")
    ig.village("Kojastu", "78016")
    ig.village("Palase", "78025")
    ig.village("Tiduvere", "78031")
    ig.village("Paljasmaa", "78026")
    ig.village("Rääski", "78029")
    ig.village("Naravere", "78022")
    ig.village("Oese", "78023")
    ig.village("Araste", "78011")
    ig.village("Kurevere", "78018")
    ig.village("Manni", "78021")
    ig.village("Vaguja", "78032")
    ig.village("Tõnumaa", "78004")
    ig.village("Ojapere", "78024")
    ig.village("Kausi", "78014")
    ig.village("Vängla", "78034")
    ig.village("Kesu", "78015")
    ig.village("Pallika", "78027")
    ig.village("Jädivere", "78013")
    ig.village("Sääla", "78030")
    ig.village("Läti", "78020")
    ig.village("Leibre", "78019")
    ig.village("Konnapere", "78017")
    ig.village("Päärdu", "78028")
    ig.village("Avaste", "78012")

    ig.municipality("Raikküla", "")
    ig.village("Tamme", "")
    ig.village("Loe", "")
    ig.village("Nõmmküla", "78408")
    ig.village("Jalase", "78415")
    ig.village("Purku", "78401")
    ig.village("Pühatu", "78421")
    ig.village("Keo", "78404")
    ig.village("Vahakõnnu", "78411")
    ig.village("Põlma", "78410")
    ig.village("Lipa", "78405")
    ig.village("Lipametsa", "78406")
    ig.village("Raela", "78409")
    ig.village("Kõrvetaguse", "78417")
    ig.village("Riidaku", "78422")
    ig.village("Koikse", "78416")
    ig.village("Valli", "78413")
    ig.village("Nõmmemetsa", "78420")
    ig.village("Kaigepere", "78412")
    ig.village("Ummaru", "78423")
    ig.village("Lõpemetsa", "78419")


    # Saare (county)
    ig.county("Saare", "")
    ig.municipality("Leisi", "")
    ig.village("Parasmetsa", "94241")
    ig.village("Hiievälja", "94231")
    ig.village("Triigi", "94243")
    ig.village("Lõpi", "94255")
    ig.village("Luulupe", "94251")
    ig.village("Metsküla", "94271")
    ig.village("Asuka", "94257")
    ig.village("Paaste", "94240")
    ig.village("Moosi", "94236")
    ig.village("Jõiste", "94232")
    ig.village("Angla", "94244")
    ig.village("Purtsa", "94264")
    ig.village("Mätja", "94214")
    ig.village("Laugu", "94233")
    ig.village("Kopli", "94249")
    ig.village("Tareste", "94216")
    ig.village("Linnaka", "94213")
    ig.village("Tõre", "94217")
    ig.village("Pöitse", "94259")
    ig.village("Poka", "94258")
    ig.village("Tiitsuotsa", "94265")
    ig.village("Veske", "94247")
    ig.village("Nihatu", "94215")
    ig.village("Ratla", "94223")
    ig.village("Nurme", "")
    ig.village("Õeste", "94219")
    ig.village("Külma", "94211")
    ig.village("Nava", "94252")
    ig.village("Metsaääre", "94222")
    ig.village("Roobaka", "94242")
    ig.village("Mujaste", "94237")
    ig.village("Räägi", "94225")
    ig.village("Aru", "94245")
    ig.village("Koiduvälja", "94261")
    ig.village("Oitme", "94239")
    ig.village("Murika", "94272")
    ig.village("Selja", "94256")
    ig.village("Koikla", "94221")
    ig.village("Meiuste", "94235")
    ig.village("Pammana", "94273")
    ig.village("Täätsi", "94224")
    ig.village("Aruste", "94212")
    ig.village("Tutku", "94250")
    ig.village("Peederga", "94246")
    ig.village("Soela", "94274")
    ig.village("Pärsama", "94201")
    ig.village("Pamma", "94263")
    ig.village("Karja", "94248")
    ig.village("Kaisa", "94254")

    ig.municipality("Salme", "")
    ig.village("Rahuste", "93235")
    ig.village("Lõu", "93234")
    ig.village("Kaimri", "93232")
    ig.village("Anseküla", "93211")
    ig.village("Üüdibe", "93224")
    ig.village("Imara", "93213")
    ig.village("Metsalõuka", "93218")
    ig.village("Hindu", "")
    ig.village("Järve", "93271")
    ig.village("Tiirimetsa", "93223")
    ig.village("Länga", "93215")
    ig.village("Tehumardi", "93222")
    ig.village("Kaugatoma", "93233")
    ig.village("Toomalõuka", "93261")
    ig.village("Lahetaguse", "93260")
    ig.village("Läätsa", "93216")
    ig.village("Möldri", "93220")
    ig.village("Lõmala", "93217")
    ig.village("Suurna", "93221")
    ig.village("Lassi", "93214")
    ig.village("Easte", "93212")
    ig.village("Vintri", "93237")

    ig.municipality("Kaarma", "")
    ig.smallborough("Aste", "")
    ig.smallborough("Nasva", "")
    ig.smallborough("Kudjape", "")
    ig.village("Mändjala", "")
    ig.village("Muratsi", "")
    ig.village("Praakli", "")
    ig.village("Laheküla", "")
    ig.village("Kirikuküla", "")
    ig.village("Sikassaare", "")
    ig.village("Upa", "")
    ig.village("Vaivere", "")
    ig.village("Randvere", "")
    ig.village("Abruka", "93826")
    ig.village("Kaisvere", "93733")
    ig.village("Kiratsi", "93741")
    ig.village("Tamsalu", "93840")
    ig.village("Hübja", "93715")
    ig.village("Õha", "93888")
    ig.village("Tõrise", "93886")
    ig.village("Parila", "93836")
    ig.village("Anijala", "93831")
    ig.village("Lilbi", "93853")
    ig.village("Kellamäe", "93723")
    ig.village("Asuküla", "93717")
    ig.village("Ansi", "93832")
    ig.village("Kungla", "")
    ig.village("Hakjala", "93714")
    ig.village("Paimala", "93855")
    ig.village("Jootme", "93722")
    ig.village("Vantri", "93716")
    ig.village("Pähkla", "93874")
    ig.village("Eikla", "93881")
    ig.village("Tõru", "93887")
    ig.village("Tõlli", "93841")
    ig.village("Endla", "93712")
    ig.village("Meedla", "93744")
    ig.village("Vestla", "93746")
    ig.village("Koidu", "93834")
    ig.village("Mullutu", "93835")
    ig.village("Piila", "93885")
    ig.village("Viira", "")
    ig.village("Aula-Vintri", "93711")
    ig.village("Kuke", "93734")
    ig.village("Käku", "93753")
    ig.village("Koidula", "93884")
    ig.village("Pärni", "93837")
    ig.village("Irase", "93721")
    ig.village("Maleva", "93743")
    ig.village("Tahula", "93856")
    ig.village("Uduvere", "93745")
    ig.village("Kasti", "93858")
    ig.village("Laadjala", "93742")
    ig.village("Kärdu", "")
    ig.village("Nõmme", "")
    ig.village("Kaarmise", "93833")
    ig.village("Haamse", "93713")
    ig.village("Laoküla", "93754")
    ig.village("Kaubi", "93882")
    ig.village("Unimäe", "93875")
    ig.village("Vatsküla", "93891")
    ig.village("Keskranna", "93890")
    ig.village("Saia", "93725")

    ig.municipality("Orissaare", "")
    ig.village("Pulli", "94612")
    ig.village("Tagavere", "94638")
    ig.village("Põripõllu", "94613")
    ig.village("Randküla", "94656")
    ig.village("Imavere", "94623")
    ig.village("Mäeküla", "94632")
    ig.village("Järveküla", "94654")
    ig.village("Maasi", "94630")
    ig.village("Ariste", "")
    ig.village("Võhma", "")
    ig.village("Taaliku", "94637")
    ig.village("Suur-Pahila", "94659")
    ig.village("Kalma", "94624")
    ig.village("Väljaküla", "")
    ig.village("Kõinastu", "94611")
    ig.village("Arju", "94622")
    ig.village("Kavandi", "94655")
    ig.village("Väike-Pahila", "94660")
    ig.village("Väike-Rahula", "94640")
    ig.village("Kareda", "94625")
    ig.village("Saikla", "94634")
    ig.village("Raugu", "94658")
    ig.village("Tumala", "94639")
    ig.village("Mehama", "94631")
    ig.village("Orinõmme", "94633")
    ig.village("Ööriku", "94642")
    ig.village("Salu", "94635")
    ig.village("Jaani", "94653")
    ig.village("Suur-Rahula", "94636")
    ig.village("Haapsu", "94651")
    ig.village("Liigalaskma", "94628")
    ig.village("Kuninguste", "94626")

    ig.municipality("Kärla", "")
    ig.village("Sõmera", "")
    ig.village("Paiküla", "93562")
    ig.village("Kulli", "")
    ig.village("Mõnnuste", "93512")
    ig.village("Nõmpa", "93846")
    ig.village("Vendise", "93848")
    ig.village("Kõrkküla", "93527")
    ig.village("Hirmuste", "93523")
    ig.village("Kogula", "")
    ig.village("Ulje", "93529")
    ig.village("Käesla", "93526")
    ig.village("Kuuse", "93551")
    ig.village("Arandi", "93521")
    ig.village("Jõempa", "93844")
    ig.village("Mätasselja", "93520")
    ig.village("Paevere", "93528")
    ig.village("Kandla", "93845")
    ig.village("Vennati", "93530")
    ig.village("Anepesa", "93843")
    ig.village("Karida", "93524")
    ig.village("Sauvere", "93847")

    ig.municipality("Kihelkonna", "")
    ig.village("Loona", "")
    ig.village("Viki", "")
    ig.village("Oju", "")
    ig.village("Rootsiküla", "")
    ig.village("Karujärve", "")
    ig.village("Kuralase", "")
    ig.village("Tammese", "93449")
    ig.village("Abula", "93461")
    ig.village("Virita", "93414")
    ig.village("Odalätsi", "93468")
    ig.village("Üru", "93471")
    ig.village("Kiirassaare", "93433")
    ig.village("Läägi", "93456")
    ig.village("Kurevere", "93439")
    ig.village("Kuusiku", "")
    ig.village("Neeme", "93444")
    ig.village("Kõõru", "93467")
    ig.village("Pidula", "93469")
    ig.village("Pajumõisa", "93412")
    ig.village("Kõruse", "93440")
    ig.village("Tagamõisa", "93448")
    ig.village("Vedruka", "93432")
    ig.village("Sepise", "93447")
    ig.village("Kalmu", "93436")
    ig.village("Kuremetsa", "93464")
    ig.village("Kuumi", "93465")
    ig.village("Vaigu", "93452")
    ig.village("Lätiniidi", "93441")
    ig.village("Vilsandi", "93421")
    ig.village("Undva", "93451")
    ig.village("Tohku", "93450")
    ig.village("Varkja", "93470")
    ig.village("Abaja", "93411")
    ig.village("Kehila", "93437")
    ig.village("Kotsma", "93434")

    ig.town("Kuressaare", "")
    ig.municipality("Valjala", "")
    ig.village("Põlluküla", "")
    ig.village("Oessaare", "94313")
    ig.village("Kõriska", "94338")
    ig.village("Tõnija", "94344")
    ig.village("Vanalõve", "94318")
    ig.village("Vilidu", "94347")
    ig.village("Jööri", "94332")
    ig.village("Võrsna", "94323")
    ig.village("Kalju", "94333")
    ig.village("Jursi", "94321")
    ig.village("Kuiste", "94336")
    ig.village("Kalli", "94322")
    ig.village("Veeriku", "94346")
    ig.village("Männiku", "94340")
    ig.village("Kallemäe", "94301")
    ig.village("Koksi", "94335")
    ig.village("Undimäe", "94345")
    ig.village("Röösa", "94343")
    ig.village("Siiksaare", "94316")
    ig.village("Jõelepa", "94331")
    ig.village("Rahu", "94342")
    ig.village("Turja", "94317")
    ig.village("Väkra", "94348")
    ig.village("Lööne", "94339")
    ig.village("Sakla", "94315")

    ig.municipality("Lümanda", "")
    ig.village("Himmiste", "93311")
    ig.village("Koki", "93327")
    ig.village("Koovi", "93314")
    ig.village("Atla", "93322")
    ig.village("Kipi", "93313")
    ig.village("Vahva", "93319")
    ig.village("Viidu", "93343")
    ig.village("Leedri", "93316")
    ig.village("Kotlandi", "93328")
    ig.village("Kuusnõmme", "93342")
    ig.village("Karala", "93325")
    ig.village("Austla", "93323")
    ig.village("Taritu", "93331")
    ig.village("Vana-Lahetaguse", "93320")
    ig.village("Varpe", "93321")
    ig.village("Riksu", "93330")
    ig.village("Jõgela", "93312")
    ig.village("Eeriksaare", "93324")
    ig.village("Metsapere", "93329")
    ig.village("Koimla", "93326")

    ig.municipality("Pöide", "")
    ig.village("Tornimäe", "")
    ig.village("Muraja", "")
    ig.village("Veere", "")
    ig.village("Kanissaare", "94533")
    ig.village("Unguma", "94545")
    ig.village("Reina", "94553")
    ig.village("Kübassaare", "94534")
    ig.village("Kakuna", "94532")
    ig.village("Sundimetsa", "94521")
    ig.village("Kõrkvere", "94535")
    ig.village("Mui", "94543")
    ig.village("Ula", "")
    ig.village("Ardla", "94531")
    ig.village("Are", "94511")
    ig.village("Metsara", "94551")
    ig.village("Oti", "94518")
    ig.village("Keskvere", "")
    ig.village("Välta", "94540")
    ig.village("Neemi", "94537")
    ig.village("Koigi", "94515")
    ig.village("Talila", "94538")
    ig.village("Uuemõisa", "94522")
    ig.village("Levala", "94517")
    ig.village("Nenu", "94552")
    ig.village("Kahutsi", "94513")
    ig.village("Kärneri", "94542")
    ig.village("Puka", "94519")
    ig.village("Iruste", "94512")

    ig.municipality("Pihtla", "")
    ig.village("Kaali", "")
    ig.village("Suure-Rootsi", "")
    ig.village("Kõljala", "")
    ig.village("Püha", "94117")
    ig.village("Reeküla", "94148")
    ig.village("Metsaküla", "")
    ig.village("Hämmelepa", "94111")
    ig.village("Kõnnu", "")
    ig.village("Tõlluste", "94124")
    ig.village("Nässuma", "94116")
    ig.village("Haeska", "94142")
    ig.village("Matsiranna", "94154")
    ig.village("Reo", "94171")
    ig.village("Räimaste", "94120")
    ig.village("Sepa", "")
    ig.village("Sutu", "94123")
    ig.village("Eiste", "94141")
    ig.village("Masa", "94146")
    ig.village("Kiritu", "94113")
    ig.village("Ennu", "94126")
    ig.village("Iilaste", "94112")
    ig.village("Sagariste", "94149")
    ig.village("Sauaru", "94122")
    ig.village("Saue-Putla", "94151")
    ig.village("Väike-Rootsi", "94131")
    ig.village("Salavere", "94150")
    ig.village("Rahniku", "94118")
    ig.village("Kangrusselja", "94153")
    ig.village("Kailuka", "94127")
    ig.village("Ilpla", "94161")
    ig.village("Leina", "94115")
    ig.village("Liiva-Putla", "94145")
    ig.village("Sandla", "94121")

    ig.municipality("Torgu", "")
    ig.village("Läbara", "")
    ig.village("Iide", "")
    ig.village("Kaavi", "93239")
    ig.village("Lindmetsa", "93243")
    ig.village("Mäebe", "")
    ig.village("Mõntu", "93122")
    ig.village("Lõupõllu", "93245")
    ig.village("Mässa", "93247")
    ig.village("Sääre", "93249")
    ig.village("Maantee", "93121")
    ig.village("Soodevahe", "93114")
    ig.village("Karuste", "93241")
    ig.village("Tammuna", "93250")
    ig.village("Jämaja", "93238")
    ig.village("Ohessaare", "93248")
    ig.village("Kaunispe", "93242")
    ig.village("Laadla", "93112")
    ig.village("Kargi", "93240")
    ig.village("Hänga", "93111")
    ig.village("Lülle", "93113")
    ig.village("Türju", "93251")

    ig.municipality("Mustjala", "")
    ig.village("Merise", "")
    ig.village("Silla", "")
    ig.village("Rahtla", "93614")
    ig.village("Kugalepa", "93611")
    ig.village("Küdema", "93622")
    ig.village("Selgase", "93642")
    ig.village("Jauni", "93641")
    ig.village("Ohtja", "93623")
    ig.village("Tuiu", "93645")
    ig.village("Tagaranna", "93616")
    ig.village("Kiruma", "93621")
    ig.village("Paatsa", "93644")
    ig.village("Vanakubja", "93617")
    ig.village("Panga", "93634")
    ig.village("Pahapilli", "93633")
    ig.village("Ninase", "93613")
    ig.village("Järise", "93643")
    ig.village("Liiküla", "93631")

    ig.municipality("Laimjala", "")
    ig.village("Rannaküla", "")
    ig.village("Aaviku", "94417")
    ig.village("Käo", "94434")
    ig.village("Mustla", "")
    ig.village("Asva", "94418")
    ig.village("Üüvere", "94425")
    ig.village("Paju-Kurdla", "94415")
    ig.village("Saaremetsa", "94443")
    ig.village("Audla", "94431")
    ig.village("Kapra", "94432")
    ig.village("Kõiguste", "94421")
    ig.village("Jõe", "")
    ig.village("Saareküla", "94442")
    ig.village("Mägi-Kurdla", "94412")
    ig.village("Ridala", "94416")
    ig.village("Pahavalla", "94414")
    ig.village("Kahtla", "94420")
    ig.village("Kingli", "94433")
    ig.village("Viltina", "94424")
    ig.village("Ruhve", "94423")

    ig.municipality("Muhu", "")
    ig.village("Liiva", "")
    ig.village("Rinsi", "94761")
    ig.village("Vanamõisa", "")
    ig.village("Tamse", "94763")
    ig.village("Igaküla", "94722")
    ig.village("Pallasmaa", "94754")
    ig.village("Päelda", "94755")
    ig.village("Koguva", "94724")
    ig.village("Kantsi", "94723")
    ig.village("Lehtmetsa", "94746")
    ig.village("Võiküla", "94713")
    ig.village("Simisti", "94719")
    ig.village("Nautse", "94728")
    ig.village("Levalõpme", "94748")
    ig.village("Linnuse", "")
    ig.village("Mõega", "94711")
    ig.village("Kapi", "94743")
    ig.village("Raugi", "94759")
    ig.village("Mõisaküla", "")
    ig.village("Kuivastu", "94702")
    ig.village("Külasema", "94744")
    ig.village("Leeskopa", "94726")
    ig.village("Vahtraste", "94765")
    ig.village("Rässa", "94718")
    ig.village("Raegma", "94717")
    ig.village("Lõetsa", "94749")
    ig.village("Pädaste", "94716")
    ig.village("Kallaste", "")
    ig.village("Kesse", "94720")
    ig.village("Pärase", "94756")
    ig.village("Lalli", "94745")
    ig.village("Oina", "94715")
    ig.village("Ridasi", "94731")
    ig.village("Soonda", "94762")
    ig.village("Tupenurme", "94764")
    ig.village("Piiri", "94730")
    ig.village("Mäla", "94750")
    ig.village("Paenase", "94753")
    ig.village("Suuremõisa", "94733")
    ig.village("Põitse", "94757")
    ig.village("Tusti", "94712")
    ig.village("Lepiku", "94747")
    ig.village("Hellamaa", "94741")
    ig.village("Rootsivere", "94732")
    ig.village("Võlla", "94714")
    ig.village("Rebaski", "94760")
    ig.village("Aljava", "94721")
    ig.village("Nõmmküla", "94752")

    ig.municipality("Ruhnu", "")

    # Tartu (county)
    ig.county("Tartu", "")
    ig.town("Tartu", "")
    ig.smallborough("Kõrveküla", "")
    ig.smallborough("Vahi", "")
    ig.village("Lombi", "")
    ig.smallborough("Lähte", "")
    ig.village("Maramaa", "")
    ig.village("Tila", "")
    ig.village("Haava", "")
    ig.village("Aovere", "")
    ig.village("Vasula", "")
    ig.village("Vesneri", "")
    ig.smallborough("Äksi", "")
    ig.village("Kastli", "60508")
    ig.village("Salu", "60525")
    ig.village("Soitsjärve", "60527")
    ig.village("Sojamaa", "60528")
    ig.village("Igavere", "60506")
    ig.village("Jõusa", "60507")
    ig.village("Võibla", "60540")
    ig.village("Pupastvere", "60523")
    ig.village("Kobratu", "60510")
    ig.village("Väägvere", "60541")
    ig.village("Kukulinna", "60511")
    ig.village("Tammistu", "60531")
    ig.village("Õvi", "60542")
    ig.village("Kükitaja", "60514")
    ig.village("Vedu", "60536")
    ig.village("Arupää", "60504")
    ig.village("Sootaga", "60529")
    ig.village("Erala", "60505")
    ig.village("Toolamaa", "60533")
    ig.village("Kikivere", "60509")
    ig.village("Viidike", "60538")
    ig.village("Nõela", "60521")
    ig.village("Lammiku", "60515")
    ig.village("Möllatsi", "60519")
    ig.village("Puhtaleiva", "60522")
    ig.village("Saadjärve", "60524")
    ig.village("Vilussaare", "60539")
    ig.village("Kärkna", "60513")
    ig.village("Soeküla", "60526")
    ig.village("Metsanuka", "60518")
    ig.village("Nigula", "60520")
    ig.village("Taabri", "60530")

    ig.municipality("Luunja", "")
    ig.village("Lohkva", "")
    ig.village("Veibri", "")
    ig.village("Kabina", "")
    ig.village("Rõõmu", "")
    ig.village("Kakumetsa", "")
    ig.village("Põvvatu", "")
    ig.village("Sava", "62214")
    ig.village("Pajukurmu", "62209")
    ig.village("Savikoja", "62215")
    ig.village("Pilka", "")
    ig.village("Poksi", "62211")
    ig.village("Sääsekõrva", "62218")
    ig.village("Kikaste", "62205")
    ig.village("Kõivu", "62206")
    ig.village("Sirgumetsa", "62217")
    ig.village("Viira", "62221")
    ig.village("Muri", "62208")
    ig.village("Kavastu", "62204")
    ig.village("Sääsküla", "62219")
    ig.village("Sirgu", "62216")

    ig.municipality("Ülenurme", "")
    ig.smallborough("Tõrvandi", "")
    ig.village("Soinaste", "")
    ig.village("Räni", "")
    ig.village("Laane", "")
    ig.village("Külitse", "")
    ig.village("Lemmatsi", "")
    ig.village("Uhti", "")
    ig.village("Õssu", "")
    ig.village("Reola", "")
    ig.village("Lepiku", "")
    ig.village("Soosilla", "61710")
    ig.village("Läti", "61706")
    ig.village("Täsvere", "61711")

    ig.municipality("Haaslava", "")
    ig.smallborough("Roiu", "")
    ig.village("Aardlapalu", "")
    ig.village("Tõõraste", "")
    ig.village("Aardla", "")
    ig.village("Mõra", "")
    ig.village("Lange", "")
    ig.village("Aadami", "")
    ig.village("Ignase", "")
    ig.village("Kõivuküla", "")
    ig.village("Koke", "62111")
    ig.village("Kurepalu", "")
    ig.village("Igevere", "62108")
    ig.village("Päkste", "62119")
    ig.village("Alaküla", "62106")
    ig.village("Kitseküla", "62110")
    ig.village("Paluküla", "62118")
    ig.village("Uniküla", "62121")
    ig.village("Metsanurga", "62116")

    ig.municipality("Rõngu", "")
    ig.smallborough("Käärdi", "")
    ig.village("Teedla", "")
    ig.village("Kalme", "")
    ig.village("Raigaste", "")
    ig.village("Valguta", "")
    ig.village("Uderna", "")
    ig.village("Lapetukme", "")
    ig.village("Rannaküla", "61012")
    ig.village("Kirepi", "61003")
    ig.village("Lossimäe", "61009")
    ig.village("Tammiste", "61013")
    ig.village("Koruste", "61004")
    ig.village("Piigandi", "61010")
    ig.village("Käo", "61006")
    ig.village("Tilga", "61015")
    ig.village("Kõduküla", "61005")

    ig.municipality("Kambja", "")
    ig.village("Sulu", "")
    ig.village("Pangodi", "")
    ig.village("Visnapuu", "")
    ig.village("Virulase", "")
    ig.village("Vana-Kuuste", "")
    ig.village("Madise", "")
    ig.village("Kullaga", "62009")
    ig.village("Kodijärve", "62008")
    ig.village("Sirvaku", "62025")
    ig.village("Kõrkküla", "62010")
    ig.village("Mäeküla", "62013")
    ig.village("Pühi", "62019")
    ig.village("Raanitsa", "62020")
    ig.village("Aakaru", "")
    ig.village("Oomiste", "")
    ig.village("Sipe", "62024")
    ig.village("Kavandu", "62032")
    ig.village("Reolasoo", "62022")
    ig.village("Ivaste", "62005")
    ig.village("Paali", "62015")
    ig.village("Tatra", "62029")
    ig.village("Pulli", "62018")
    ig.village("Talvikese", "62028")
    ig.village("Riiviku", "62023")
    ig.village("Kammeri", "62007")
    ig.village("Palumäe", "62016")
    ig.village("Rebase", "62021")
    ig.village("Lalli", "62011")
    ig.village("Suure-Kambja", "62027")
    ig.village("Kaatsi", "62006")

    ig.town("Elva", "")
    ig.municipality("Nõo", "")
    ig.smallborough("Tõravere", "")
    ig.village("Luke", "")
    ig.village("Meeri", "")
    ig.village("Tamsa", "")
    ig.village("Nõgiaru", "")
    ig.village("Etsaste", "")
    ig.village("Vissi", "")
    ig.village("Uuta", "61620")
    ig.village("Ketneri", "61610")
    ig.village("Altmäe", "61604")
    ig.village("Kääni", "61612")
    ig.village("Voika", "")
    ig.village("Aiamaa", "61603")
    ig.village("Laguja", "61613")
    ig.village("Kolga", "61611")
    ig.village("Enno", "61605")
    ig.village("Sassi", "61617")
    ig.village("Keeri", "61609")
    ig.village("Unipiha", "61619")
    ig.village("Järiste", "61608")

    ig.town("Kallaste", "")
    ig.municipality("Puhja", "")
    ig.smallborough("Ulila", "")
    ig.village("Võsivere", "")
    ig.village("Tännassilma", "")
    ig.village("Teilma", "")
    ig.village("Rämsi", "")
    ig.village("Võllinge", "61318")
    ig.village("Mõisanurme", "61307")
    ig.village("Saare", "")
    ig.village("Järvaküla", "61304")
    ig.village("Mäeselja", "61308")
    ig.village("Poriküla", "61311")
    ig.village("Vihavu", "61317")
    ig.village("Ridaküla", "61312")
    ig.village("Kaimi", "61305")
    ig.village("Nasja", "61309")
    ig.village("Palupõhja", "60547")
    ig.village("Härjanurme", "61303")

    ig.municipality("Alatskivi", "")
    ig.village("Savimetsa", "60226")
    ig.village("Linaleo", "60210")
    ig.village("Sudemäe", "60227")
    ig.village("Virtsu", "60231")
    ig.village("Rupsi", "60223")
    ig.village("Savastvere", "60225")
    ig.village("Tõruvere", "60230")
    ig.village("Orgemäe", "60213")
    ig.village("Lahe", "60208")
    ig.village("Rootsiküla", "60222")
    ig.village("Nina", "60212")
    ig.village("Pusi", "60217")
    ig.village("Kõdesi", "60207")
    ig.village("Ronisoo", "60221")
    ig.village("Lahepera", "60209")
    ig.village("Toruküla", "60229")
    ig.village("Päiksi", "60218")
    ig.village("Passi", "60215")
    ig.village("Padakõrve", "60214")
    ig.village("Kesklahe", "60204")
    ig.village("Naelavere", "60211")
    ig.village("Kokora", "60205")
    ig.village("Alasoo", "60202")
    ig.village("Pärsikivi", "60219")
    ig.village("Peatskivi", "60216")
    ig.village("Torila", "60228")
    ig.village("Haapsipea", "60203")
    ig.village("Saburi", "60224")
    ig.village("Väljaküla", "60232")
    ig.village("Riidma", "60220")
    ig.village("Kuningvere", "60206")

    ig.municipality("Mäksa", "")
    ig.village("Melliste", "")
    ig.village("Sudaste", "62310")
    ig.village("Võõpste", "62316")
    ig.village("Tigase", "62312")
    ig.village("Kastre", "62305")
    ig.village("Tammevaldma", "62311")
    ig.village("Veskimäe", "62314")
    ig.village("Sarakuste", "62309")
    ig.village("Aruaia", "62303")
    ig.village("Mäletjärve", "62307")
    ig.village("Vana-Kastre", "62313")
    ig.village("Kaagvere", "62317")
    ig.village("Kaarlimõisa", "62304")
    ig.village("Poka", "62308")
    ig.village("Võruküla", "62315")

    ig.municipality("Tähtvere", "")
    ig.smallborough("Märja", "")
    ig.village("Pihva", "")
    ig.village("Kandiküla", "")
    ig.village("Rahinge", "")
    ig.village("Tüki", "")
    ig.village("Ilmatsalu", "")
    ig.village("Rõhu", "")
    ig.village("Vorbuse", "")
    ig.village("Haage", "")
    ig.village("Kardla", "")

    ig.municipality("Konguta", "")
    ig.village("Annikoru", "")
    ig.village("Metsalaane", "")
    ig.village("Pööritsa", "61214")
    ig.village("Kurelaane", "61206")
    ig.village("Külaaseme", "61207")
    ig.village("Poole", "61213")
    ig.village("Mäeotsa", "61211")
    ig.village("Kapsta", "61203")
    ig.village("Vahessaare", "61215")
    ig.village("Lembevere", "61208")
    ig.village("Mälgi", "61212")
    ig.village("Karijärve", "61204")
    ig.village("Majala", "61209")
    ig.village("Vellavere", "61216")
    ig.village("Kobilu", "61205")

    ig.municipality("Rannu", "")
    ig.village("Tamme", "")
    ig.village("Koopsi", "61106")
    ig.smallborough("Kureküla", "")
    ig.village("Utukolga", "61115")
    ig.village("Järveküla", "61103")
    ig.village("Sangla", "61112")
    ig.village("Noorma", "61110")
    ig.village("Vallapalu", "61116")
    ig.village("Kaarlijärve", "61104")
    ig.village("Kulli", "61107")
    ig.village("Suure-Rakke", "61113")
    ig.village("Ervu", "61102")
    ig.village("Väike-Rakke", "61119")
    ig.village("Paju", "61111")
    ig.village("Verevi", "61118")
    ig.village("Kipastu", "61105")

    ig.municipality("Laeva", "")
    ig.village("Kärevere", "")
    ig.village("Siniküla", "")
    ig.village("Valmaotsa", "60605")
    ig.village("Kämara", "60602")
    ig.village("Väänikvere", "60606")

    ig.municipality("Võnnu", "")
    ig.village("Hammaste", "62404")
    ig.village("Imste", "62405")
    ig.village("Kannu", "62407")
    ig.village("Agali", "62402")
    ig.village("Ahunapalu", "62414")
    ig.village("Terikeste", "62413")
    ig.village("Kurista", "62408")
    ig.village("Rookse", "62412")
    ig.village("Lääniste", "62411")
    ig.village("Issaku", "62406")
    ig.village("Kõnnu", "62409")
    ig.village("Liispõllu", "62410")

    ig.municipality("Peipsiääre", "")
    ig.smallborough("Varnja", "")
    ig.smallborough("Kolkja", "")
    ig.village("Savka", "60303")
    ig.smallborough("Kasepää", "60302")
    ig.village("Sipelga", "60304")

    ig.municipality("Meeksi", "")
    ig.smallborough("Mehikoorma", "")
    ig.village("Haavametsa", "62504")
    ig.village("Rõka", "62509")
    ig.village("Järvselja", "62506")
    ig.village("Aravu", "62503")
    ig.village("Sikakurmu", "62510")
    ig.village("Meerapalu", "62502")
    ig.village("Jõepera", "62505")
    ig.village("Parapalu", "62508")

    ig.municipality("Vara", "")
    ig.village("Keressaare", "")
    ig.village("Koosa", "")
    ig.village("Põrgu", "60418")
    ig.village("Rehemetsa", "60419")
    ig.village("Kusma", "60408")
    ig.village("Põdra", "60416")
    ig.village("Sookalduse", "60421")
    ig.village("Matjama", "60431")
    ig.village("Koosalaane", "60407")
    ig.village("Vanaussaia", "60425")
    ig.village("Praaga", "60415")
    ig.village("Selgise", "60420")
    ig.village("Pilpaküla", "60414")
    ig.village("Tähemaa", "60423")
    ig.village("Meoma", "60410")
    ig.village("Särgla", "60422")
    ig.village("Mustametsa", "60412")
    ig.village("Undi", "60424")
    ig.village("Metsakivi", "60411")
    ig.village("Kuusiku", "60409")
    ig.village("Kargaja", "60404")
    ig.village("Alajõe", "60403")
    ig.village("Kauda", "60405")
    ig.village("Põldmaa", "60417")
    ig.village("Välgi", "60427")
    ig.village("Ätte", "60428")
    ig.village("Papiaru", "60413")

    ig.municipality("Piirissaare", "")
    ig.village("Piiri", "")
    ig.village("Tooni", "62603")

    ig.municipality("Vehendi", "")
    ig.municipality("Kriimani", "")
    ig.municipality("Illi", "")
    ig.municipality("Neemisküla", "")

    # Valga (county)
    ig.county("Valga", "")
    ig.town("Valga", "")
    ig.town("Tõrva", "")
    ig.town("Otepää", "")
    ig.village("Nüpli", "")
    ig.village("Sihva", "")
    ig.village("Pühajärve", "")
    ig.village("Vidrike", "67304")
    ig.village("Pedajamäe", "67417")
    ig.village("Tõutsi", "67303")
    ig.village("Kääriku", "67309")
    ig.village("Mägestiku", "67310")
    ig.village("Pilkuse", "67416")
    ig.village("Kastolatsi", "67410")
    ig.village("Truuta", "67302")
    ig.village("Kaurutootsi", "67307")
    ig.village("Raudsepa", "67415")
    ig.village("Arula", "67411")
    ig.village("Mäha", "67409")
    ig.village("Kassiratta", "67306")
    ig.village("Koigu", "67308")
    ig.village("Vana-Otepää", "67418")
    ig.village("Märdi", "67311")
    ig.village("Ilmjärve", "67305")

    ig.municipality("Puka", "")
    ig.village("Rebaste", "67216")
    ig.village("Aakre", "67212")
    ig.village("Palamuste", "67213")
    ig.village("Pühaste", "67215")
    ig.village("Pedaste", "67214")
    ig.village("Põru", "67210")
    ig.village("Prange", "67209")
    ig.village("Purtsi", "68709")
    ig.village("Meegaste", "67207")
    ig.village("Kolli", "67204")
    ig.village("Kibena", "67203")
    ig.village("Vaardi", "68229")
    ig.village("Kuigatsi", "68222")
    ig.village("Kähri", "67206")
    ig.village("Plika", "67208")
    ig.village("Soontaga", "68617")
    ig.village("Ruuna", "67211")
    ig.village("Komsi", "67205")

    ig.municipality("Õru", "")
    ig.village("Õlatu", "67108")
    ig.village("Õruste", "67111")
    ig.village("Priipalu", "67102")
    ig.village("Mustumetsa", "67106")
    ig.village("Killinge", "67103")
    ig.village("Lota", "67105")
    ig.village("Kiviküla", "67104")
    ig.village("Uniküla", "67107")

    ig.municipality("Tõlliste", "")
    ig.smallborough("Tsirguliina", "")
    ig.village("Sooru", "")
    ig.smallborough("Laatre", "")
    ig.village("Jaanikese", "")
    ig.village("Tagula", "")
    ig.village("Vilaski", "68311")
    ig.village("Rampe", "68310")
    ig.village("Muhkva", "68309")
    ig.village("Paju", "68217")
    ig.village("Korijärve", "68313")
    ig.village("Iigaste", "68308")
    ig.village("Tinu", "68306")
    ig.village("Supa", "68305")
    ig.village("Väljaküla", "68312")

    ig.municipality("Sangaste", "")
    ig.village("Keeni", "")
    ig.village("Lossiküla", "")
    ig.village("Sarapuu", "67009")
    ig.village("Vaalu", "68221")
    ig.village("Lauküla", "67011")
    ig.village("Tiidu", "67010")
    ig.village("Kurevere", "67004")
    ig.village("Mäeküla", "67003")
    ig.village("Risttee", "67007")
    ig.village("Mägiste", "68224")
    ig.village("Restu", "67006")
    ig.village("Ädu", "68219")
    ig.village("Pringi", "68223")

    ig.municipality("Karula", "")
    ig.village("Raavitsa", "")
    ig.village("Kaagjärve", "")
    ig.village("Valtina", "")
    ig.village("Lüllemäe", "")
    ig.village("Koobassaare", "68111")
    ig.village("Kirbu", "68107")
    ig.village("Väheru", "68105")
    ig.village("Pikkjärve", "68110")
    ig.village("Rebasemõisa", "68113")
    ig.village("Pugritsa", "68104")
    ig.village("Londi", "68103")
    ig.village("Käärikmäe", "68108")
    ig.village("Lusti", "68109")

    ig.municipality("Helme", "")
    ig.village("Taagepera", "")
    ig.village("Karjatnurme", "68511")
    ig.village("Koorküla", "68508")
    ig.village("Linna", "68619")
    ig.village("Kirikuküla", "68611")
    ig.village("Jõgeveste", "68616")
    ig.village("Möldre", "68612")
    ig.village("Holdre", "68505")
    ig.village("Pilpa", "68504")
    ig.village("Roobe", "68614")
    ig.village("Patküla", "68613")
    ig.village("Ala", "68507")
    ig.village("Kalme", "68618")
    ig.village("Kähu", "68506")

    ig.municipality("Taheva", "")
    ig.village("Koikküla", "")
    ig.village("Hargla", "")
    ig.village("Lutsu", "68005")
    ig.village("Lepa", "68004")
    ig.village("Sooblase", "68011")
    ig.village("Tõrvase", "68008")
    ig.village("Tsirgumäe", "68012")
    ig.village("Korkuna", "68009")
    ig.village("Koiva", "68006")
    ig.village("Kalliküla", "68007")
    ig.village("Laanemetsa", "68013")
    ig.village("Ringiste", "68010")

    ig.municipality("Põdrala", "")
    ig.village("Leebiku", "")
    ig.village("Riidaja", "")
    ig.village("Pikasilla", "68715")
    ig.village("Liva", "68706")
    ig.village("Rulli", "68615")
    ig.village("Uralaane", "68712")
    ig.village("Lõve", "68707")
    ig.village("Kungi", "68705")
    ig.village("Karu", "68703")
    ig.village("Vanamõisa", "68713")
    ig.village("Kaubi", "68704")
    ig.village("Pori", "68708")
    ig.village("Voorbahi", "68714")
    ig.village("Reti", "68710")

    ig.municipality("Palupera", "")
    ig.village("Hellenurme", "")
    ig.village("Nõuni", "")
    ig.village("Mäelooga", "67510")
    ig.village("Atra", "67508")
    ig.village("Räbi", "67503")
    ig.village("Urmi", "67513")
    ig.village("Päidla", "67506")
    ig.village("Miti", "67509")
    ig.village("Pastaku", "67512")
    ig.village("Makita", "67516")
    ig.village("Astuvere", "67507")
    ig.village("Neeruti", "67505")
    ig.village("Lutike", "67504")

    ig.municipality("Hummuli", "")
    ig.village("Piiri", "68405")
    ig.village("Ransi", "68407")
    ig.village("Kulli", "68404")
    ig.village("Aitsra", "68402")
    ig.village("Jeti", "68513")
    ig.village("Soe", "68408")
    ig.village("Puide", "68411")
    ig.village("Alamõisa", "68403")


    # Viljandi (county)
    ig.county("Viljandi", "")
    ig.municipality("Suure-Jaani", "")
    ig.village("Vastemõisa", "")
    ig.village("Ülde", "")
    ig.village("Võivaku", "")
    ig.village("Reegoldi", "")
    ig.village("Jälevere", "")
    ig.village("Nuutre", "")
    ig.smallborough("Olustvere", "")
    ig.village("Lõhavere", "")
    ig.village("Sürgavere", "")
    ig.village("Päraküla", "")
    ig.village("Tääksi", "")
    ig.village("Kõidama", "")
    ig.village("Kärevere", "70407")
    ig.village("Karjasoo", "71408")
    ig.village("Metsküla", "71302")
    ig.village("Tällevere", "71511")
    ig.village("Jaska", "70404")
    ig.village("Ivaski", "71305")
    ig.village("Kobruvere", "71306")
    ig.village("Vihi", "71402")
    ig.village("Mudiste", "70405")
    ig.village("Kootsi", "71411")
    ig.village("Mäeküla", "")
    ig.village("Aimla", "70403")
    ig.village("Navesti", "70406")
    ig.village("Kurnuvere", "70412")
    ig.village("Võhmassaare", "70606")
    ig.village("Epra", "71405")
    ig.village("Arjadi", "71505")
    ig.village("Munsi", "71403")
    ig.village("Ilbaku", "71307")
    ig.village("Lahmuse", "71412")
    ig.village("Ängi", "71507")
    ig.village("Rääka", "71409")
    ig.village("Taevere", "71510")
    ig.village("Kildu", "71303")
    ig.village("Sandra", "71309")
    ig.village("Kibaru", "71506")
    ig.village("Kuhjavere", "70414")
    ig.village("Kuiavere", "70408")
    ig.village("Paelama", "71308")
    ig.village("Põhjaka", "71410")
    ig.village("Kabila", "71404")
    ig.village("Riiassaare", "70415")
    ig.village("Kerita", "71406")
    ig.village("Võlli", "71512")
    ig.village("Lemmakõnnu", "71304")

    ig.municipality("Abja", "")
    ig.town("Abja-Paluoja", "")
    ig.village("Veskimäe", "")
    ig.village("Penuja", "")
    ig.village("Abja-Vanamõisa", "")
    ig.village("Põlde", "")
    ig.village("Raamatu", "69308")
    ig.village("Sarja", "69407")
    ig.village("Atika", "69411")
    ig.village("Saate", "69202")
    ig.village("Veelikse", "69307")
    ig.village("Umbsoo", "69309")
    ig.village("Kamara", "69304")
    ig.village("Räägu", "69310")
    ig.village("Lasari", "69306")
    ig.village("Laatre", "69305")
    ig.village("Abjaku", "69410")

    ig.town("Viljandi", "")
    ig.town("Võhma", "")
    ig.town("Mõisaküla", "")
    ig.municipality("Viiratsi", "")
    ig.village("Uusna", "")
    ig.village("Vana-Võidu", "")
    ig.village("Vardja", "")
    ig.village("Tänassilma", "")
    ig.village("Mähma", "")
    ig.village("Jõeküla", "")
    ig.village("Loime", "")
    ig.village("Tõnuküla", "")
    ig.village("Valma", "")
    ig.village("Kibeküla", "69619")
    ig.village("Saareküla", "70112")
    ig.village("Vanavälja", "70114")
    ig.village("Mäeltküla", "70105")
    ig.village("Kuudeküla", "70111")
    ig.village("Verilaske", "70110")
    ig.village("Surva", "70115")
    ig.village("Rebaste", "70117")
    ig.village("Ridaküla", "70122")
    ig.village("Vasara", "70107")
    ig.village("Tusti", "70113")
    ig.village("Ruudiküla", "70106")

    ig.municipality("Halliste", "")
    ig.village("Mõõnaste", "")
    ig.village("Päidre", "")
    ig.village("Kalvre", "")
    ig.village("Hõbemäe", "69507")
    ig.village("Ülemõisa", "69512")
    ig.village("Maru", "69522")
    ig.village("Naistevalla", "69519")
    ig.smallborough("Õisu", "69502")
    ig.village("Raja", "69503")
    ig.village("Uue-Kariste", "69504")
    ig.village("Vabamatsi", "69405")
    ig.village("Rimmu", "69505")
    ig.village("Mulgi", "69516")
    ig.village("Pornuse", "69508")
    ig.village("Kulla", "69509")
    ig.village("Ereste", "69511")
    ig.village("Saksaküla", "69520")
    ig.village("Toosi", "69514")
    ig.village("Päigiste", "69408")
    ig.village("Kaarli", "69510")
    ig.village("Tilla", "69517")
    ig.village("Sammaste", "69521")
    ig.village("Vana-Kariste", "69506")
    ig.village("Niguli", "69515")

    ig.municipality("Karksi", "")
    ig.town("Karksi-Nuia", "")
    ig.village("Kõvaküla", "")
    ig.village("Morna", "")
    ig.village("Univere", "")
    ig.village("Polli", "")
    ig.village("Lilli", "")
    ig.village("Metsaküla", "69109")
    ig.village("Hirmuküla", "69003")
    ig.village("Leeli", "69106")
    ig.village("Suuga", "71053")
    ig.village("Muri", "71054")
    ig.village("Sudiste", "69001")
    ig.village("Ainja", "69105")
    ig.village("Tuhalaane", "71056")
    ig.village("Pärsi", "69110")
    ig.village("Allaste", "69113")
    ig.village("Äriküla", "69115")
    ig.village("Pöögle", "69111")
    ig.village("Oti", "69114")

    ig.municipality("Kolga-Jaani", "")
    ig.village("Leie", "")
    ig.village("Parika", "70307")
    ig.village("Eesnurga", "70306")
    ig.village("Kaavere", "70318")
    ig.village("Järtsaare", "70302")
    ig.village("Oorgu", "70309")
    ig.village("Odiste", "70308")
    ig.village("Oiu", "70317")
    ig.village("Vissuvere", "70311")
    ig.village("Taganurga", "70310")
    ig.village("Otiküla", "70316")
    ig.village("Meleski", "70304")
    ig.village("Vaibla", "70314")
    ig.village("Lalsi", "70313")
    ig.village("Lätkalu", "70315")

    ig.municipality("Pärsti", "")
    ig.village("Päri", "")
    ig.village("Jämejala", "")
    ig.smallborough("Ramsi", "")
    ig.village("Kiisa", "")
    ig.village("Vardi", "")
    ig.village("Heimtali", "")
    ig.village("Raudna", "")
    ig.village("Rihkama", "")
    ig.village("Puiatu", "")
    ig.village("Mustivere", "")
    ig.village("Matapera", "")
    ig.village("Sinialliku", "")
    ig.village("Pinska", "")
    ig.village("Marna", "71108")
    ig.village("Vanamõisa", "71119")
    ig.village("Tõrreküla", "71111")
    ig.village("Kookla", "71120")
    ig.village("Savikoti", "71103")
    ig.village("Kiini", "71125")
    ig.village("Leemeti", "71122")
    ig.village("Turva", "71112")
    ig.village("Väike-Kõpu", "71124")
    ig.village("Alustre", "71057")
    ig.village("Laanekuru", "71107")
    ig.village("Tohvri", "71114")
    ig.village("Kingu", "71121")

    ig.municipality("Tarvastu", "")
    ig.village("Kärstna", "")
    ig.smallborough("Mustla", "")
    ig.village("Kivilõppe", "69706")
    ig.village("Jakobimõisa", "69705")
    ig.village("Porsa", "69710")
    ig.village("Riuma", "69736")
    ig.village("Pahuvere", "69725")
    ig.village("Kalbuse", "69737")
    ig.village("Vanausse", "69713")
    ig.village("Pikru", "69709")
    ig.village("Kuressaare", "69708")
    ig.village("Maltsa", "69731")
    ig.village("Muksi", "69724")
    ig.village("Ülensi", "69720")
    ig.village("Vilimeeste", "69718")
    ig.village("Koidu", "69707")
    ig.village("Raassilla", "69722")
    ig.village("Põrga", "69726")
    ig.village("Tinnikuru", "69716")
    ig.village("Unametsa", "69717")
    ig.village("Vooru", "69733")
    ig.village("Villa", "69719")
    ig.village("Järveküla", "69732")
    ig.village("Metsla", "69711")
    ig.village("Suislepa", "")
    ig.village("Veisjärve", "69729")
    ig.village("Väluste", "69704")
    ig.village("Tagamõisa", "69727")
    ig.village("Marjamäe", "69734")
    ig.village("Roosilla", "69730")
    ig.village("Mõnnaste", "69735")
    ig.village("Ämmuste", "69721")
    ig.village("Kannuküla", "69728")
    ig.village("Anikatsi", "69723")
    ig.village("Sooviku", "69714")

    ig.municipality("Saarepeedi", "")
    ig.village("Peetrimõisa", "")
    ig.village("Võistre", "")
    ig.village("Karula", "")
    ig.village("Moori", "70211")
    ig.village("Tõnissaare", "71069")
    ig.village("Auksi", "71064")
    ig.village("Välgita", "")
    ig.village("Taari", "71072")
    ig.village("Aindu", "71063")
    ig.village("Kokaviidika", "71071")
    ig.village("Tobraselja", "71068")

    ig.municipality("Paistu", "")
    ig.village("Sultsi", "")
    ig.village("Loodi", "")
    ig.village("Intsu", "")
    ig.village("Holstre", "")
    ig.village("Rebase", "69610")
    ig.village("Pulleritsu", "69609")
    ig.village("Luiga", "69606")
    ig.village("Aidu", "69604")
    ig.village("Tömbi", "69608")
    ig.village("Viisuküla", "69607")
    ig.village("Kassi", "71052")
    ig.village("Mustapali", "69618")
    ig.village("Pirmastu", "69620")
    ig.village("Lolu", "69617")
    ig.village("Hendrikumõisa", "69612")

    ig.municipality("Kõpu", "")
    ig.village("Tipu", "")
    ig.village("Uia", "71206")
    ig.village("Supsi", "71205")
    ig.village("Iia", "71210")
    ig.village("Vanaveski", "71207")
    ig.village("Laane", "71202")
    ig.village("Kuninga", "69518")
    ig.village("Punaküla", "71204")
    ig.village("Seruküla", "71203")

    ig.municipality("Kõo", "")
    ig.village("Soomevere", "")
    ig.village("Paaksima", "70607")
    ig.village("Koksvere", "70604")
    ig.village("Saviaugu", "70503")
    ig.village("Pilistvere", "70502")
    ig.village("Maalasti", "70608")
    ig.village("Kirivere", "70506")
    ig.village("Unakvere", "70508")
    ig.village("Arjassaare", "70507")
    ig.village("Arussaare", "70605")
    ig.village("Paenasti", "70509")
    ig.village("Kangrussaare", "70505")
    ig.village("Loopre", "70504")
    ig.village("Venevere", "70511")

    ig.municipality("Soe", "")

    # Võru (county)
    ig.county("Võru", "")
    ig.municipality("Vastseliina", "")
    ig.village("Pari", "65258")
    ig.village("Vana-Vastseliina", "65254")
    ig.village("Lindora", "65224")
    ig.village("Loosi", "65260")
    ig.village("Plessi", "65328")
    ig.village("Jeedasküla", "65212")
    ig.village("Perametsa", "65234")
    ig.village("Indra", "65259")
    ig.village("Tsolli", "")
    ig.village("Kerepäälse", "65217")
    ig.village("Halla", "65204")
    ig.village("Holsta", "65208")
    ig.village("Raadi", "65237")
    ig.village("Voki", "65257")
    ig.village("Ortuma", "65231")
    ig.village("Vatsa", "65255")
    ig.village("Luhte", "65171")
    ig.village("Kapera", "65216")
    ig.village("Külaoru", "65223")
    ig.village("Tellaste", "65247")
    ig.village("Kõrve", "65221")
    ig.village("Kündja", "65168")
    ig.village("Tabina", "65246")
    ig.village("Mutsu", "65226")
    ig.village("Puutli", "65235")
    ig.village("Kaagu", "65214")
    ig.village("Kornitsa", "65219")
    ig.village("Kirikumäe", "65218")
    ig.village("Juraski", "65213")
    ig.village("Heinasoo", "65205")
    ig.village("Illi", "65210")
    ig.village("Vana-Saaluse", "65253")
    ig.village("Tallikeste", "65337")
    ig.village("Viitka", "65256")
    ig.village("Sutte", "65245")
    ig.village("Kõo", "65165")
    ig.village("Hinniala", "65206")
    ig.village("Hinsa", "65207")
    ig.village("Käpa", "65222")
    ig.village("Saarde", "65239")
    ig.village("Mäe-Kõoküla", "65227")

    ig.municipality("Võru", "")
    ig.smallborough("Väimela", "")
    ig.smallborough("Parksepa", "")
    ig.village("Võlsi", "")
    ig.village("Roosisaare", "")
    ig.village("Võrumõisa", "")
    ig.village("Verijärve", "")
    ig.village("Puiga", "")
    ig.smallborough("Kose", "")
    ig.village("Lompka", "65525")
    ig.village("Sika", "")
    ig.village("Hannuste", "65515")
    ig.village("Käätso", "65524")
    ig.village("Kusma", "65523")
    ig.village("Nooska", "65531")
    ig.village("Võrusoo", "65565")
    ig.village("Kolepi", "65520")
    ig.village("Vagula", "65553")
    ig.village("Tagaküla", "65514")
    ig.village("Kasaritsa", "65519")
    ig.village("Väiso", "65503")
    ig.village("Räpo", "65535")
    ig.village("Umbsaare", "65538")
    ig.village("Loosu", "65548")
    ig.village("Juba", "65518")
    ig.village("Mõisamäe", "65529")
    ig.village("Palometsa", "65532")
    ig.village("Vana-Nursi", "65540")
    ig.village("Mõksi", "65530")
    ig.village("Raiste", "65513")
    ig.village("Tootsi", "65537")
    ig.village("Meeliku", "65527")
    ig.village("Kärnamäe", "65504")
    ig.village("Lapi", "65505")
    ig.village("Koloreino", "65521")

    ig.town("Antsla", "")
    ig.smallborough("Vana-Antsla", "")
    ig.village("Tsooru", "")
    ig.village("Säre", "")
    ig.smallborough("Kobela", "")
    ig.village("Kraavi", "66409")
    ig.village("Kaika", "66421")
    ig.village("Savilöövi", "66307")
    ig.village("Anne", "66423")
    ig.village("Antsu", "66424")
    ig.village("Soome", "66415")
    ig.village("Luhametsa", "66304")
    ig.village("Madise", "66411")
    ig.village("Oe", "66422")
    ig.village("Kikkaoja", "66302")
    ig.village("Taberlaane", "66417")
    ig.village("Lusti", "66410")
    ig.village("Litsmetsa", "66303")
    ig.village("Mähkli", "66412")
    ig.village("Jõepera", "66425")
    ig.village("Ähijärve", "66420")
    ig.village("Viirapalu", "66308")
    ig.village("Haabsaare", "66405")
    ig.village("Roosiku", "66306")
    ig.village("Piisi", "66305")
    ig.village("Kollino", "66408")
    ig.village("Rimmi", "66414")

    ig.municipality("Varstu", "")
    ig.village("Punsa", "66107")
    ig.village("Krabi", "66102")
    ig.village("Vana-Roosa", "66109")
    ig.village("Kangsti", "66103")
    ig.village("Metstaga", "66106")
    ig.village("Viru", "66309")
    ig.village("Mutemetsa", "66114")
    ig.village("Paganamaa", "66115")
    ig.village("Hintsiko", "66110")
    ig.village("Kõrgepalu", "66104")
    ig.village("Laurimäe", "66111")
    ig.village("Tagakolga", "66118")
    ig.village("Harjuküla", "66120")
    ig.village("Lüütsepa", "66113")
    ig.village("Liguri", "66112")
    ig.village("Soolätte", "66117")
    ig.village("Raudsepa", "")
    ig.village("Pähni", "66116")

    ig.municipality("Sõmerpalu", "")
    ig.village("Haava", "")
    ig.village("Mustja", "66614")
    ig.village("Leiso", "66634")
    ig.village("Rummi", "66640")
    ig.village("Udsali", "")
    ig.village("Heeska", "66625")
    ig.village("Kurenurme", "66631")
    ig.village("Hargi", "66624")
    ig.village("Mäekülä", "66615")
    ig.village("Järvere", "66629")
    ig.village("Linnamäe", "66635")
    ig.village("Mustassaare", "66637")
    ig.village("Horma", "66626")
    ig.village("Pritsi", "66638")
    ig.village("Haidaku", "66623")
    ig.village("Osula", "66602")
    ig.village("Majala", "66636")
    ig.village("Hutita", "66627")
    ig.village("Kärgula", "66632")
    ig.village("Liiva", "66514")
    ig.village("Kahro", "66617")
    ig.village("Rauskapalu", "66639")
    ig.village("Keema", "66511")
    ig.village("Haamaste", "66616")
    ig.village("Alakülä", "66620")
    ig.village("Varese", "66642")
    ig.village("Lakovitsa", "66633")
    ig.village("Alapõdra", "66621")
    ig.village("Punakülä", "66619")
    ig.village("Lilli-Anne", "66613")
    ig.village("Hänike", "66628")

    ig.municipality("Rõuge", "")
    ig.village("Hallimäe", "")
    ig.village("Horsa", "")
    ig.village("Kahru", "")
    ig.village("Tüütsi", "66703")
    ig.village("Rebäsemõisa", "66276")
    ig.village("Pulli", "")
    ig.village("Märdi", "66260")
    ig.village("Laossaarõ", "66246")
    ig.village("Savioru", "66285")
    ig.village("Suurõ-Ruuga", "66292")
    ig.village("Nilbõ", "66262")
    ig.village("Vanamõisa", "66707")
    ig.village("Tallima", "66293")
    ig.village("Simmuli", "66288")
    ig.village("Hapsu", "66214")
    ig.village("Lauri", "66247")
    ig.village("Sikalaanõ", "66287")
    ig.village("Haki", "66209")
    ig.village("Raudsepä", "66274")
    ig.village("Soemõisa", "66290")
    ig.village("Tiidu", "66296")
    ig.village("Muhkamõtsa", "66255")
    ig.village("Mõõlu", "66259")
    ig.village("Kokõjüri", "66237")
    ig.village("Kuuda", "66243")
    ig.village("Kiidi", "66234")
    ig.village("Möldri", "")
    ig.village("Püssä", "66272")
    ig.village("Kogrõ", "66235")
    ig.village("Mikita", "")
    ig.village("Vadsa", "66706")
    ig.village("Viitina", "66711")
    ig.village("Järvekülä", "66223")
    ig.village("Hinu", "66217")
    ig.village("Jugu", "66222")
    ig.village("Kaugu", "66231")
    ig.village("Soomõoru", "66291")
    ig.village("Sandisuu", "66284")
    ig.village("Matsi", "")
    ig.village("Viliksaarõ", "66708")
    ig.village("Nogu", "66263")
    ig.village("Järvepalu", "66224")
    ig.village("Rasva", "66273")
    ig.village("Ahitsa", "66206")
    ig.village("Väiku-Ruuga", "66709")
    ig.village("Sadramõtsa", "66282")
    ig.village("Handimiku", "66213")
    ig.village("Augli", "66207")
    ig.village("Aabra", "66205")
    ig.village("Saarlasõ", "66281")
    ig.village("Kurgjärve", "66241")
    ig.village("Tilgu", "66297")
    ig.village("Hansi", "65516")
    ig.village("Toodsi", "")
    ig.village("Rebäse", "")
    ig.village("Kurvitsa", "66242")
    ig.village("Hurda", "")
    ig.village("Murdõmäe", "66257")
    ig.village("Heedu", "66215")
    ig.village("Muna", "66256")
    ig.village("Tialasõ", "66295")
    ig.village("Petrakuudi", "66267")
    ig.village("Roobi", "66279")
    ig.village("Kähri", "66244")
    ig.village("Tsirgupalu", "66701")
    ig.village("Nursi", "66712")
    ig.village("Põru", "66271")
    ig.village("Paaburissa", "66265")
    ig.village("Utessuu", "66705")
    ig.village("Karaski", "66229")
    ig.village("Pugõstu", "66268")
    ig.village("Kaluka", "66228")
    ig.village("Sänna", "66710")
    ig.village("Kolga", "66239")
    ig.village("Tsutsu", "66702")
    ig.village("Lutika", "66250")
    ig.village("Paeboja", "66266")
    ig.village("Põdra", "66270")
    ig.village("Ruuksu", "66280")
    ig.village("Kokõ", "66236")
    ig.village("Kellämäe", "66233")
    ig.village("Kavõldi", "66232")
    ig.village("Saki", "66283")
    ig.village("Kokõmäe", "66238")
    ig.village("Heibri", "66216")
    ig.village("Taudsa", "66294")
    ig.village("Liivakupalu", "66248")
    ig.village("Haabsilla", "66208")
    ig.village("Kadõni", "66225")
    ig.village("Ortumäe", "66264")
    ig.village("Pärlijõe", "66211")
    ig.village("Soekõrdsi", "66289")
    ig.village("Tindi", "66298")
    ig.village("Hotõmäe", "66218")
    ig.village("Karba", "66230")
    ig.village("Muduri", "66254")
    ig.village("Kängsepä", "66245")
    ig.village("Jaanipeebu", "66221")
    ig.village("Lükkä", "66251")
    ig.village("Kuklasõ", "66240")
    ig.village("Härämäe", "66220")
    ig.village("Riitsilla", "66277")
    ig.village("Ristemäe", "66278")

    ig.municipality("Mõniste", "")
    ig.village("Hürova", "")
    ig.village("Karisöödi", "66005")
    ig.village("Koemetsa", "66006")
    ig.village("Peebu", "66007")
    ig.village("Parmupalu", "66015")
    ig.village("Kallaste", "")
    ig.village("Singa", "66010")
    ig.village("Saru", "66009")
    ig.village("Sakurgi", "66008")
    ig.village("Tiitsa", "66011")
    ig.village("Tursa", "66012")
    ig.village("Tundu", "66016")
    ig.village("Kuutsi", "66018")
    ig.village("Hüti", "66014")
    ig.village("Villike", "66017")
    ig.village("Vastse-Roosa", "66013")

    ig.municipality("Haanja", "")
    ig.village("Pausakunnu", "65131")
    ig.village("Andsumäe", "")
    ig.village("Mustahamba", "")
    ig.village("Mäe-Suhka", "65128")
    ig.village("Mäe-Tilga", "65129")
    ig.village("Tsiamäe", "65144")
    ig.village("Soodi", "65142")
    ig.village("Trolla", "65143")
    ig.village("Purka", "65137")
    ig.village("Posti", "65183")
    ig.village("Kirbu", "65118")
    ig.village("Vaarkali", "")
    ig.village("Kääraku", "65120")
    ig.village("Tsiiruli", "65196")
    ig.village("Haavistu", "65105")
    ig.village("Tsilgutaja", "65198")
    ig.village("Lillimõisa", "65169")
    ig.village("Saluora", "65190")
    ig.village("Märdimiku", "65177")
    ig.village("Rusa", "65189")
    ig.village("Vastsekivi", "65191")
    ig.village("Käänu", "65167")
    ig.village("Holdi", "")
    ig.village("Vaalimäe", "65148")
    ig.village("Tõnkova", "65166")
    ig.village("Mäe-Palo", "65176")
    ig.village("Pressi", "65136")
    ig.village("Kergatsi", "65117")
    ig.village("Kuiandi", "65162")
    ig.village("Ihatsi", "65109")
    ig.village("Kaldemäe", "65114")
    ig.village("Raagi", "65188")
    ig.village("Horoski", "65107")
    ig.village("Pillardi", "65182")
    ig.village("Külma", "65121")
    ig.village("Kaaratautsa", "65113")
    ig.village("Sarise", "65192")
    ig.village("Saika", "")
    ig.village("Hulaku", "65156")
    ig.village("Palanumäe", "65130")
    ig.village("Preeksa", "65184")
    ig.village("Naapka", "65178")
    ig.village("Kriguli", "65161")
    ig.village("Ala-Suhka", "65103")
    ig.village("Sormuli", "65194")
    ig.village("Vihkla", "65193")
    ig.village("Kuklase", "65163")
    ig.village("Palli", "65179")
    ig.village("Ruusmäe", "65102")
    ig.village("Loogamäe", "65170")
    ig.village("Meelaku", "65125")
    ig.village("Murati", "65174")
    ig.village("Uue-Saaluse", "65147")
    ig.village("Lüütsepä", "65172")
    ig.village("Ala-Palo", "65152")
    ig.village("Mallika", "65124")
    ig.village("Mahtja", "65123")
    ig.village("Kaloga", "65116")
    ig.village("Vungi", "65181")
    ig.village("Ala-Tilga", "65104")
    ig.village("Resto", "65138")
    ig.village("Leoski", "65122")
    ig.village("Palujüri", "65180")
    ig.village("Tummelka", "65146")
    ig.village("Vänni", "65151")
    ig.village("Hanija", "65155")
    ig.village("Plaksi", "65135")
    ig.village("Kilomani", "65159")
    ig.village("Piipsemäe", "65133")
    ig.village("Luutsniku", "65110")
    ig.village("Puspuri", "65186")
    ig.village("Hämkoti", "65108")
    ig.village("Simula", "65141")
    ig.village("Vorstimäe", "65197")
    ig.village("Miilimäe", "65126")
    ig.village("Kuura", "65164")
    ig.village("Kõomäe", "65119")
    ig.village("Söödi", "65195")
    ig.village("Plaani", "65134")
    ig.village("Vakari", "65149")
    ig.village("Peedo", "65132")
    ig.village("Tuuka", "65199")
    ig.village("Pundi", "65185")
    ig.village("Kotka", "65160")

    ig.municipality("Urvaste", "")
    ig.village("Kuldre", "")
    ig.village("Lümatu", "66515")
    ig.village("Uhtjärve", "66508")
    ig.village("Visela", "66510")
    ig.village("Kirikuküla", "66512")
    ig.village("Pihleni", "66506")
    ig.village("Vaabina", "66519")
    ig.village("Uue-Antsla", "66509")
    ig.village("Koigu", "66513")
    ig.village("Kassi", "66504")
    ig.village("Kõlbi", "66505")
    ig.village("Toku", "66507")
    ig.village("Ruhingu", "66516")

    ig.municipality("Lasva", "")
    ig.village("Nõnova", "65230")
    ig.village("Lauga", "65506")
    ig.village("Listaku", "")
    ig.village("Kõrgessaare", "65404")
    ig.village("Kaku", "")
    ig.village("Kääpa", "65545")
    ig.village("Puusepa", "65551")
    ig.village("Mõrgi", "65549")
    ig.village("Peraküla", "65510")
    ig.village("Noodasküla", "65229")
    ig.village("Kannu", "65544")
    ig.village("Saaremaa", "65240")
    ig.village("Kühmamäe", "65405")
    ig.village("Madala", "65406")
    ig.village("Tohkri", "65249")
    ig.village("Oleski", "65507")
    ig.village("Mäessaare", "65407")
    ig.village("Tammsaare", "65413")
    ig.village("Rusima", "65412")
    ig.village("Lehemetsa", "65546")
    ig.village("Sooküla", "65244")
    ig.village("Voki-Tamme", "65415")
    ig.village("Tüütsmäe", "65251")
    ig.village("Pindi", "65410")
    ig.village("Tiri", "65414")
    ig.village("Villa", "")
    ig.village("Pässä", "65411")
    ig.village("Hellekunnu", "65402")
    ig.village("Otsa", "65408")
    ig.village("Pikasilla", "65511")
    ig.village("Pikakannu", "65409")
    ig.village("Pille", "65512")
    ig.village("Tsolgo", "65552")
    ig.village("Husari", "65403")
    ig.village("Paidra", "65508")

    ig.municipality("Misso", "")
    ig.village("Häärmäni", "65209")
    ig.village("Põnni", "65042")
    ig.village("Mokra", "65020")
    ig.village("Kärinä", "65041")
    ig.village("Sapi", "65242")
    ig.village("Pupli", "65026")
    ig.village("Tserebi", "65039")
    ig.village("Tiastõ", "65036")
    ig.village("Tiilige", "65037")
    ig.village("Ritsiko", "65029")
    ig.village("Kriiva", "65013")
    ig.village("Põrstõ", "65027")
    ig.village("Suurõsuu", "65035")
    ig.village("Lütä", "65018")
    ig.village("Tika", "65248")
    ig.village("Määsi", "65045")
    ig.village("Kaubi", "65006")
    ig.village("Parmu", "65023")
    ig.village("Hürsi", "65158")
    ig.village("Savimäe", "65033")
    ig.village("Savioja", "")
    ig.village("Korgõssaarõ", "65010")
    ig.village("Mauri", "65225")
    ig.village("Horosuu", "65005")
    ig.village("Pruntova", "65024")
    ig.village("Tsiistre", "65002")
    ig.village("Laisi", "65016")
    ig.village("Kurõ", "65014")
    ig.village("Hino", "65004")
    ig.village("Pältre", "65236")
    ig.village("Koorla", "65009")
    ig.village("Muraski", "65021")
    ig.village("Siksälä", "65034")
    ig.village("Napi", "65022")
    ig.village("Kossa", "65012")
    ig.village("Kiviora", "65008")
    ig.village("Väiko-Tiilige", "65040")
    ig.village("Käbli", "65015")
    ig.village("Saagri", "")
    ig.village("Möldre", "65228")
    ig.village("Kundsa", "65220")
    ig.village("Hindsa", "65003")
    ig.village("Kimalasõ", "65007")
    ig.village("Rammuka", "65028")
    ig.village("Saagrimäe", "65031")
    ig.village("Sakudi", "65032")
    ig.village("Pedejä", "65233")
    ig.village("Leimani", "65017")
    ig.village("Missokülä", "65019")
    ig.village("Sandi", "65043")

    ig.municipality("Meremäe", "")
    ig.village("Obinitsa", "")
    ig.village("Kõõru", "65371")
    ig.village("Vinski", "65352")
    ig.village("Vaaksaarõ", "65350")
    ig.village("Ruutsi", "65333")
    ig.village("Teterüvä", "65339")
    ig.village("Tuulova", "65347")
    ig.village("Martsina", "65375")
    ig.village("Võmmorski", "65391")
    ig.village("Viro", "65353")
    ig.village("Antkruva", "65357")
    ig.village("Lutja", "65316")
    ig.village("Ostrova", "65322")
    ig.village("Raotu", "65332")
    ig.village("Tessova", "65385")
    ig.village("Härmä", "65361")
    ig.village("Veretinä", "65390")
    ig.village("Lindsi", "65373")
    ig.village("Karamsina", "65365")
    ig.village("Lepä", "65315")
    ig.village("Paklova", "65323")
    ig.village("Kiiova", "65366")
    ig.village("Miku", "65378")
    ig.village("Jaanimäe", "")
    ig.village("Väiko-Härmä", "65354")
    ig.village("Treiali", "65343")
    ig.village("Triginä", "65344")
    ig.village("Kuksina", "65314")
    ig.village("Pelsi", "65327")
    ig.village("Kasakova", "65308")
    ig.village("Tsumba", "65386")
    ig.village("Tedre", "65384")
    ig.village("Marinova", "65317")
    ig.village("Rokina", "65381")
    ig.village("Kiislova", "65311")
    ig.village("Kuigõ", "65313")
    ig.village("Tsergondõ", "65345")
    ig.village("Tääglova", "65388")
    ig.village("Korski", "65369")
    ig.village("Palandõ", "65324")
    ig.village("Juusa", "65364")
    ig.village("Miikse", "65319")
    ig.village("Serga", "65334")
    ig.village("Tsirgu", "65346")
    ig.village("Navikõ", "65379")
    ig.village("Küllätüvä", "65372")
    ig.village("Ala-Tsumba", "65356")
    ig.village("Ermakova", "65358")
    ig.village("Maaslova", "65374")
    ig.village("Kusnetsova", "65370")
    ig.village("Kiksova", "65367")
    ig.village("Ulaskova", "65348")
    ig.village("Sirgova", "65335")
    ig.village("Sulbi", "")
    ig.village("Paloveere", "")
    ig.village("Tiirhanna", "65340")
    ig.village("Tuplova", "65387")
    ig.village("Tobrova", "65342")
    ig.village("Väiko-Serga", "65355")
    ig.village("Talka", "65383")
    ig.village("Jõksi", "65305")
    ig.village("Hilläkeste", "65303")
    ig.village("Tiklasõ", "65341")
    ig.village("Masluva", "65376")
    ig.village("Pliia", "65329")
    ig.village("Kalatsova", "65306")
    ig.village("Klistina", "65368")
    ig.village("Vasla", "65389")
    ig.village("Helbi", "65359")
    ig.village("Hilana", "65360")
    ig.village("Melso", "65377")
    ig.village("Kangavitsa", "65307")
    ig.village("Keerba", "65310")
    ig.village("Merekülä", "65318")
    ig.village("Puista", "65331")
    ig.village("Kitsõ", "65312")
    ig.village("Olehkova", "65321")
    ig.village("Palo", "65325")
    ig.village("Ignasõ", "65362")
    ig.village("Poksa", "65330")
    ig.village("Seretsüvä", "65382")
    ig.village("Tepia", "65338")
    ig.village("Kastamara", "65309")
    ig.village("Polovina", "65380")
    ig.village("Uusvada", "65349")

    ig.municipality("Kirumpää", "")
    ig.municipality("Navi", "")
    ig.municipality("Meegomäe", "")

    yield ig.flush()

