# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs

__all__ = [
    'ProjectSharedWithGroup',
    'GetProjectsProjectResult',
    'GetProjectsProjectForkedFromProjectResult',
    'GetProjectsProjectNamespaceResult',
    'GetProjectsProjectOwnerResult',
    'GetProjectsProjectPermissionsResult',
    'GetProjectsProjectSharedWithGroupResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class ProjectSharedWithGroup(dict):
    def __init__(__self__, *,
                 group_access_level: str,
                 group_id: float,
                 group_name: Optional[str] = None):
        """
        :param str group_access_level: Group's sharing permissions. See [group members permission][group_members_permissions] for more info.
               Valid values are `guest`, `reporter`, `developer`, `master`.
        :param float group_id: Group id of the group you want to share the project with.
        :param str group_name: Group's name.
        """
        pulumi.set(__self__, "group_access_level", group_access_level)
        pulumi.set(__self__, "group_id", group_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupAccessLevel")
    def group_access_level(self) -> str:
        """
        Group's sharing permissions. See [group members permission][group_members_permissions] for more info.
        Valid values are `guest`, `reporter`, `developer`, `master`.
        """
        return pulumi.get(self, "group_access_level")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> float:
        """
        Group id of the group you want to share the project with.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[str]:
        """
        Group's name.
        """
        return pulumi.get(self, "group_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 _links: Mapping[str, str],
                 approvals_before_merge: float,
                 archived: bool,
                 avatar_url: str,
                 ci_config_path: str,
                 container_registry_enabled: bool,
                 created_at: str,
                 creator_id: float,
                 custom_attributes: List[Mapping[str, Any]],
                 default_branch: str,
                 description: str,
                 forked_from_project: 'outputs.GetProjectsProjectForkedFromProjectResult',
                 forks_count: float,
                 http_url_to_repo: str,
                 id: float,
                 import_error: str,
                 import_status: str,
                 issues_enabled: bool,
                 jobs_enabled: bool,
                 last_activity_at: str,
                 lfs_enabled: bool,
                 merge_method: str,
                 merge_requests_enabled: bool,
                 mirror: bool,
                 mirror_overwrites_diverged_branches: bool,
                 mirror_trigger_builds: bool,
                 mirror_user_id: float,
                 name: str,
                 name_with_namespace: str,
                 namespace: 'outputs.GetProjectsProjectNamespaceResult',
                 only_allow_merge_if_all_discussions_are_resolved: bool,
                 only_allow_merge_if_pipeline_succeeds: bool,
                 only_mirror_protected_branches: bool,
                 open_issues_count: float,
                 owner: 'outputs.GetProjectsProjectOwnerResult',
                 path: str,
                 path_with_namespace: str,
                 permissions: 'outputs.GetProjectsProjectPermissionsResult',
                 public: bool,
                 public_builds: bool,
                 readme_url: str,
                 request_access_enabled: bool,
                 resolve_outdated_diff_discussions: bool,
                 runners_token: str,
                 shared_runners_enabled: bool,
                 shared_with_groups: List['outputs.GetProjectsProjectSharedWithGroupResult'],
                 snippets_enabled: bool,
                 ssh_url_to_repo: str,
                 star_count: float,
                 statistics: Mapping[str, float],
                 tag_lists: List[str],
                 visibility: str,
                 web_url: str,
                 wiki_enabled: bool):
        """
        :param float approvals_before_merge: The numbers of approvals needed in a merge requests.
        :param bool archived: Limit by archived status.
        :param str http_url_to_repo: The HTTP clone URL of the project.
        :param float id: The ID of the project.
        :param bool jobs_enabled: Whether pipelines are enabled for the project.
        :param str name: The name of the project.
        :param str name_with_namespace: In `group / subgroup / project` or `user / project` format.
        :param str path_with_namespace: In `group/subgroup/project` or `user/project` format.
        :param bool public: Whether the project is public.
        :param str ssh_url_to_repo: The SSH clone URL of the project.
        :param Mapping[str, float] statistics: Include project statistics. Cannot be used with `group_id`.
        :param List[str] tag_lists: A set of the project topics (formerly called "project tags").
        :param str visibility: Limit by visibility `public`, `internal`, or `private`.
        """
        pulumi.set(__self__, "_links", _links)
        pulumi.set(__self__, "approvals_before_merge", approvals_before_merge)
        pulumi.set(__self__, "archived", archived)
        pulumi.set(__self__, "avatar_url", avatar_url)
        pulumi.set(__self__, "ci_config_path", ci_config_path)
        pulumi.set(__self__, "container_registry_enabled", container_registry_enabled)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "custom_attributes", custom_attributes)
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "forked_from_project", forked_from_project)
        pulumi.set(__self__, "forks_count", forks_count)
        pulumi.set(__self__, "http_url_to_repo", http_url_to_repo)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "import_error", import_error)
        pulumi.set(__self__, "import_status", import_status)
        pulumi.set(__self__, "issues_enabled", issues_enabled)
        pulumi.set(__self__, "jobs_enabled", jobs_enabled)
        pulumi.set(__self__, "last_activity_at", last_activity_at)
        pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        pulumi.set(__self__, "merge_method", merge_method)
        pulumi.set(__self__, "merge_requests_enabled", merge_requests_enabled)
        pulumi.set(__self__, "mirror", mirror)
        pulumi.set(__self__, "mirror_overwrites_diverged_branches", mirror_overwrites_diverged_branches)
        pulumi.set(__self__, "mirror_trigger_builds", mirror_trigger_builds)
        pulumi.set(__self__, "mirror_user_id", mirror_user_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_with_namespace", name_with_namespace)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "only_allow_merge_if_all_discussions_are_resolved", only_allow_merge_if_all_discussions_are_resolved)
        pulumi.set(__self__, "only_allow_merge_if_pipeline_succeeds", only_allow_merge_if_pipeline_succeeds)
        pulumi.set(__self__, "only_mirror_protected_branches", only_mirror_protected_branches)
        pulumi.set(__self__, "open_issues_count", open_issues_count)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "path_with_namespace", path_with_namespace)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "public", public)
        pulumi.set(__self__, "public_builds", public_builds)
        pulumi.set(__self__, "readme_url", readme_url)
        pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        pulumi.set(__self__, "resolve_outdated_diff_discussions", resolve_outdated_diff_discussions)
        pulumi.set(__self__, "runners_token", runners_token)
        pulumi.set(__self__, "shared_runners_enabled", shared_runners_enabled)
        pulumi.set(__self__, "shared_with_groups", shared_with_groups)
        pulumi.set(__self__, "snippets_enabled", snippets_enabled)
        pulumi.set(__self__, "ssh_url_to_repo", ssh_url_to_repo)
        pulumi.set(__self__, "star_count", star_count)
        pulumi.set(__self__, "statistics", statistics)
        pulumi.set(__self__, "tag_lists", tag_lists)
        pulumi.set(__self__, "visibility", visibility)
        pulumi.set(__self__, "web_url", web_url)
        pulumi.set(__self__, "wiki_enabled", wiki_enabled)

    @property
    @pulumi.getter
    def _links(self) -> Mapping[str, str]:
        return pulumi.get(self, "_links")

    @property
    @pulumi.getter(name="approvalsBeforeMerge")
    def approvals_before_merge(self) -> float:
        """
        The numbers of approvals needed in a merge requests.
        """
        return pulumi.get(self, "approvals_before_merge")

    @property
    @pulumi.getter
    def archived(self) -> bool:
        """
        Limit by archived status.
        """
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> str:
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> str:
        return pulumi.get(self, "ci_config_path")

    @property
    @pulumi.getter(name="containerRegistryEnabled")
    def container_registry_enabled(self) -> bool:
        return pulumi.get(self, "container_registry_enabled")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> float:
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> List[Mapping[str, Any]]:
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> str:
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forkedFromProject")
    def forked_from_project(self) -> 'outputs.GetProjectsProjectForkedFromProjectResult':
        return pulumi.get(self, "forked_from_project")

    @property
    @pulumi.getter(name="forksCount")
    def forks_count(self) -> float:
        return pulumi.get(self, "forks_count")

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> str:
        """
        The HTTP clone URL of the project.
        """
        return pulumi.get(self, "http_url_to_repo")

    @property
    @pulumi.getter
    def id(self) -> float:
        """
        The ID of the project.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="importError")
    def import_error(self) -> str:
        return pulumi.get(self, "import_error")

    @property
    @pulumi.getter(name="importStatus")
    def import_status(self) -> str:
        return pulumi.get(self, "import_status")

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> bool:
        return pulumi.get(self, "issues_enabled")

    @property
    @pulumi.getter(name="jobsEnabled")
    def jobs_enabled(self) -> bool:
        """
        Whether pipelines are enabled for the project.
        """
        return pulumi.get(self, "jobs_enabled")

    @property
    @pulumi.getter(name="lastActivityAt")
    def last_activity_at(self) -> str:
        return pulumi.get(self, "last_activity_at")

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> bool:
        return pulumi.get(self, "lfs_enabled")

    @property
    @pulumi.getter(name="mergeMethod")
    def merge_method(self) -> str:
        return pulumi.get(self, "merge_method")

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> bool:
        return pulumi.get(self, "merge_requests_enabled")

    @property
    @pulumi.getter
    def mirror(self) -> bool:
        return pulumi.get(self, "mirror")

    @property
    @pulumi.getter(name="mirrorOverwritesDivergedBranches")
    def mirror_overwrites_diverged_branches(self) -> bool:
        return pulumi.get(self, "mirror_overwrites_diverged_branches")

    @property
    @pulumi.getter(name="mirrorTriggerBuilds")
    def mirror_trigger_builds(self) -> bool:
        return pulumi.get(self, "mirror_trigger_builds")

    @property
    @pulumi.getter(name="mirrorUserId")
    def mirror_user_id(self) -> float:
        return pulumi.get(self, "mirror_user_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameWithNamespace")
    def name_with_namespace(self) -> str:
        """
        In `group / subgroup / project` or `user / project` format.
        """
        return pulumi.get(self, "name_with_namespace")

    @property
    @pulumi.getter
    def namespace(self) -> 'outputs.GetProjectsProjectNamespaceResult':
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="onlyAllowMergeIfAllDiscussionsAreResolved")
    def only_allow_merge_if_all_discussions_are_resolved(self) -> bool:
        return pulumi.get(self, "only_allow_merge_if_all_discussions_are_resolved")

    @property
    @pulumi.getter(name="onlyAllowMergeIfPipelineSucceeds")
    def only_allow_merge_if_pipeline_succeeds(self) -> bool:
        return pulumi.get(self, "only_allow_merge_if_pipeline_succeeds")

    @property
    @pulumi.getter(name="onlyMirrorProtectedBranches")
    def only_mirror_protected_branches(self) -> bool:
        return pulumi.get(self, "only_mirror_protected_branches")

    @property
    @pulumi.getter(name="openIssuesCount")
    def open_issues_count(self) -> float:
        return pulumi.get(self, "open_issues_count")

    @property
    @pulumi.getter
    def owner(self) -> 'outputs.GetProjectsProjectOwnerResult':
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> str:
        """
        In `group/subgroup/project` or `user/project` format.
        """
        return pulumi.get(self, "path_with_namespace")

    @property
    @pulumi.getter
    def permissions(self) -> 'outputs.GetProjectsProjectPermissionsResult':
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def public(self) -> bool:
        """
        Whether the project is public.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter(name="publicBuilds")
    def public_builds(self) -> bool:
        return pulumi.get(self, "public_builds")

    @property
    @pulumi.getter(name="readmeUrl")
    def readme_url(self) -> str:
        return pulumi.get(self, "readme_url")

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> bool:
        return pulumi.get(self, "request_access_enabled")

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> bool:
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> str:
        return pulumi.get(self, "runners_token")

    @property
    @pulumi.getter(name="sharedRunnersEnabled")
    def shared_runners_enabled(self) -> bool:
        return pulumi.get(self, "shared_runners_enabled")

    @property
    @pulumi.getter(name="sharedWithGroups")
    def shared_with_groups(self) -> List['outputs.GetProjectsProjectSharedWithGroupResult']:
        return pulumi.get(self, "shared_with_groups")

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> bool:
        return pulumi.get(self, "snippets_enabled")

    @property
    @pulumi.getter(name="sshUrlToRepo")
    def ssh_url_to_repo(self) -> str:
        """
        The SSH clone URL of the project.
        """
        return pulumi.get(self, "ssh_url_to_repo")

    @property
    @pulumi.getter(name="starCount")
    def star_count(self) -> float:
        return pulumi.get(self, "star_count")

    @property
    @pulumi.getter
    def statistics(self) -> Mapping[str, float]:
        """
        Include project statistics. Cannot be used with `group_id`.
        """
        return pulumi.get(self, "statistics")

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> List[str]:
        """
        A set of the project topics (formerly called "project tags").
        """
        return pulumi.get(self, "tag_lists")

    @property
    @pulumi.getter
    def visibility(self) -> str:
        """
        Limit by visibility `public`, `internal`, or `private`.
        """
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> str:
        return pulumi.get(self, "web_url")

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> bool:
        return pulumi.get(self, "wiki_enabled")


@pulumi.output_type
class GetProjectsProjectForkedFromProjectResult(dict):
    def __init__(__self__, *,
                 http_url_to_repo: str,
                 id: float,
                 name: str,
                 name_with_namespace: str,
                 path: str,
                 path_with_namespace: str,
                 web_url: str):
        """
        :param str http_url_to_repo: The HTTP clone URL of the project.
        :param float id: The ID of the project.
        :param str name: The name of the project.
        :param str name_with_namespace: In `group / subgroup / project` or `user / project` format.
        :param str path_with_namespace: In `group/subgroup/project` or `user/project` format.
        """
        pulumi.set(__self__, "http_url_to_repo", http_url_to_repo)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_with_namespace", name_with_namespace)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "path_with_namespace", path_with_namespace)
        pulumi.set(__self__, "web_url", web_url)

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> str:
        """
        The HTTP clone URL of the project.
        """
        return pulumi.get(self, "http_url_to_repo")

    @property
    @pulumi.getter
    def id(self) -> float:
        """
        The ID of the project.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameWithNamespace")
    def name_with_namespace(self) -> str:
        """
        In `group / subgroup / project` or `user / project` format.
        """
        return pulumi.get(self, "name_with_namespace")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> str:
        """
        In `group/subgroup/project` or `user/project` format.
        """
        return pulumi.get(self, "path_with_namespace")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> str:
        return pulumi.get(self, "web_url")


@pulumi.output_type
class GetProjectsProjectNamespaceResult(dict):
    def __init__(__self__, *,
                 full_path: str,
                 id: float,
                 kind: str,
                 name: str,
                 path: str):
        """
        :param float id: The ID of the project.
        :param str name: The name of the project.
        """
        pulumi.set(__self__, "full_path", full_path)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> str:
        return pulumi.get(self, "full_path")

    @property
    @pulumi.getter
    def id(self) -> float:
        """
        The ID of the project.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")


@pulumi.output_type
class GetProjectsProjectOwnerResult(dict):
    def __init__(__self__, *,
                 avatar_url: str,
                 id: float,
                 name: str,
                 state: str,
                 username: str,
                 website_url: str):
        """
        :param float id: The ID of the project.
        :param str name: The name of the project.
        """
        pulumi.set(__self__, "avatar_url", avatar_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "website_url", website_url)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> str:
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter
    def id(self) -> float:
        """
        The ID of the project.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="websiteUrl")
    def website_url(self) -> str:
        return pulumi.get(self, "website_url")


@pulumi.output_type
class GetProjectsProjectPermissionsResult(dict):
    def __init__(__self__, *,
                 group_access: Mapping[str, float],
                 project_access: Mapping[str, float]):
        pulumi.set(__self__, "group_access", group_access)
        pulumi.set(__self__, "project_access", project_access)

    @property
    @pulumi.getter(name="groupAccess")
    def group_access(self) -> Mapping[str, float]:
        return pulumi.get(self, "group_access")

    @property
    @pulumi.getter(name="projectAccess")
    def project_access(self) -> Mapping[str, float]:
        return pulumi.get(self, "project_access")


@pulumi.output_type
class GetProjectsProjectSharedWithGroupResult(dict):
    def __init__(__self__, *,
                 group_access_level: str,
                 group_id: float,
                 group_name: str):
        """
        :param float group_id: The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
        """
        pulumi.set(__self__, "group_access_level", group_access_level)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupAccessLevel")
    def group_access_level(self) -> str:
        return pulumi.get(self, "group_access_level")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> float:
        """
        The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        return pulumi.get(self, "group_name")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 avatar_url: str,
                 bio: str,
                 can_create_group: bool,
                 can_create_project: bool,
                 color_scheme_id: float,
                 created_at: str,
                 current_sign_in_at: str,
                 email: str,
                 extern_uid: str,
                 external: bool,
                 id: float,
                 is_admin: bool,
                 last_sign_in_at: str,
                 linkedin: str,
                 location: str,
                 name: str,
                 organization: str,
                 projects_limit: float,
                 provider: str,
                 skype: str,
                 state: str,
                 theme_id: float,
                 twitter: str,
                 two_factor_enabled: bool,
                 username: str,
                 website_url: str):
        """
        :param str avatar_url: The avatar URL of the user.
        :param str bio: The bio of the user.
        :param bool can_create_group: Whether the user can create groups.
        :param bool can_create_project: Whether the user can create projects.
        :param float color_scheme_id: User's color scheme ID.
        :param str created_at: Date the user was created at.
        :param str current_sign_in_at: Current user's sign-in date.
        :param str email: The e-mail address of the user.
        :param str extern_uid: Lookup users by external UID. (Requires administrator privileges)
        :param bool external: Whether the user is external.
        :param float id: The unique id assigned to the user by the gitlab server.
        :param bool is_admin: Whether the user is an admin.
        :param str last_sign_in_at: Last user's sign-in date.
        :param str linkedin: Linkedin profile of the user.
        :param str location: The location of the user.
        :param str name: The name of the user.
        :param str organization: The organization of the user.
        :param float projects_limit: Number of projects the user can create.
        :param str provider: The UID provider of the user.
        :param str skype: Skype username of the user.
        :param str state: Whether the user is active or blocked.
        :param float theme_id: User's theme ID.
        :param str twitter: Twitter username of the user.
        :param bool two_factor_enabled: Whether user's two factor auth is enabled.
        :param str username: The username of the user.
        :param str website_url: User's website URL.
        """
        pulumi.set(__self__, "avatar_url", avatar_url)
        pulumi.set(__self__, "bio", bio)
        pulumi.set(__self__, "can_create_group", can_create_group)
        pulumi.set(__self__, "can_create_project", can_create_project)
        pulumi.set(__self__, "color_scheme_id", color_scheme_id)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "current_sign_in_at", current_sign_in_at)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "extern_uid", extern_uid)
        pulumi.set(__self__, "external", external)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_admin", is_admin)
        pulumi.set(__self__, "last_sign_in_at", last_sign_in_at)
        pulumi.set(__self__, "linkedin", linkedin)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "projects_limit", projects_limit)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "skype", skype)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "theme_id", theme_id)
        pulumi.set(__self__, "twitter", twitter)
        pulumi.set(__self__, "two_factor_enabled", two_factor_enabled)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "website_url", website_url)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> str:
        """
        The avatar URL of the user.
        """
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter
    def bio(self) -> str:
        """
        The bio of the user.
        """
        return pulumi.get(self, "bio")

    @property
    @pulumi.getter(name="canCreateGroup")
    def can_create_group(self) -> bool:
        """
        Whether the user can create groups.
        """
        return pulumi.get(self, "can_create_group")

    @property
    @pulumi.getter(name="canCreateProject")
    def can_create_project(self) -> bool:
        """
        Whether the user can create projects.
        """
        return pulumi.get(self, "can_create_project")

    @property
    @pulumi.getter(name="colorSchemeId")
    def color_scheme_id(self) -> float:
        """
        User's color scheme ID.
        """
        return pulumi.get(self, "color_scheme_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Date the user was created at.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="currentSignInAt")
    def current_sign_in_at(self) -> str:
        """
        Current user's sign-in date.
        """
        return pulumi.get(self, "current_sign_in_at")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The e-mail address of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="externUid")
    def extern_uid(self) -> str:
        """
        Lookup users by external UID. (Requires administrator privileges)
        """
        return pulumi.get(self, "extern_uid")

    @property
    @pulumi.getter
    def external(self) -> bool:
        """
        Whether the user is external.
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def id(self) -> float:
        """
        The unique id assigned to the user by the gitlab server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Whether the user is an admin.
        """
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter(name="lastSignInAt")
    def last_sign_in_at(self) -> str:
        """
        Last user's sign-in date.
        """
        return pulumi.get(self, "last_sign_in_at")

    @property
    @pulumi.getter
    def linkedin(self) -> str:
        """
        Linkedin profile of the user.
        """
        return pulumi.get(self, "linkedin")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the user.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        The organization of the user.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="projectsLimit")
    def projects_limit(self) -> float:
        """
        Number of projects the user can create.
        """
        return pulumi.get(self, "projects_limit")

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        The UID provider of the user.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def skype(self) -> str:
        """
        Skype username of the user.
        """
        return pulumi.get(self, "skype")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Whether the user is active or blocked.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> float:
        """
        User's theme ID.
        """
        return pulumi.get(self, "theme_id")

    @property
    @pulumi.getter
    def twitter(self) -> str:
        """
        Twitter username of the user.
        """
        return pulumi.get(self, "twitter")

    @property
    @pulumi.getter(name="twoFactorEnabled")
    def two_factor_enabled(self) -> bool:
        """
        Whether user's two factor auth is enabled.
        """
        return pulumi.get(self, "two_factor_enabled")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username of the user.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="websiteUrl")
    def website_url(self) -> str:
        """
        User's website URL.
        """
        return pulumi.get(self, "website_url")


