# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['ProjectPushRules']


class ProjectPushRules(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author_email_regex: Optional[pulumi.Input[str]] = None,
                 branch_name_regex: Optional[pulumi.Input[str]] = None,
                 commit_message_regex: Optional[pulumi.Input[str]] = None,
                 deny_delete_tag: Optional[pulumi.Input[bool]] = None,
                 file_name_regex: Optional[pulumi.Input[str]] = None,
                 max_file_size: Optional[pulumi.Input[float]] = None,
                 member_check: Optional[pulumi.Input[bool]] = None,
                 prevent_secrets: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        This resource allows you to create and manage push rules for your GitLab projects.
        For further information on push rules, consult the [gitlab
        documentation](https://docs.gitlab.com/ce/push_rules/push_rules.html#push-rules).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author_email_regex: All commit author emails must match this regex, e.g. "@my-company.com$"
        :param pulumi.Input[str] branch_name_regex: All branch names must match this regex, e.g. "(feature|hotfix)\/*"
        :param pulumi.Input[str] commit_message_regex: All commit messages must match this regex, e.g. "Fixed \d+\..*"
        :param pulumi.Input[bool] deny_delete_tag: Deny deleting a tag
        :param pulumi.Input[str] file_name_regex: All commited filenames must not match this regex, e.g. "(jar|exe)$"
        :param pulumi.Input[float] max_file_size: Maximum file size (MB)
        :param pulumi.Input[bool] member_check: Restrict commits by author (email) to existing GitLab users
        :param pulumi.Input[bool] prevent_secrets: GitLab will reject any files that are likely to contain secrets
        :param pulumi.Input[str] project: The name or id of the project to add the push rules to.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['author_email_regex'] = author_email_regex
            __props__['branch_name_regex'] = branch_name_regex
            __props__['commit_message_regex'] = commit_message_regex
            __props__['deny_delete_tag'] = deny_delete_tag
            __props__['file_name_regex'] = file_name_regex
            __props__['max_file_size'] = max_file_size
            __props__['member_check'] = member_check
            __props__['prevent_secrets'] = prevent_secrets
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
        super(ProjectPushRules, __self__).__init__(
            'gitlab:index/projectPushRules:ProjectPushRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author_email_regex: Optional[pulumi.Input[str]] = None,
            branch_name_regex: Optional[pulumi.Input[str]] = None,
            commit_message_regex: Optional[pulumi.Input[str]] = None,
            deny_delete_tag: Optional[pulumi.Input[bool]] = None,
            file_name_regex: Optional[pulumi.Input[str]] = None,
            max_file_size: Optional[pulumi.Input[float]] = None,
            member_check: Optional[pulumi.Input[bool]] = None,
            prevent_secrets: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'ProjectPushRules':
        """
        Get an existing ProjectPushRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author_email_regex: All commit author emails must match this regex, e.g. "@my-company.com$"
        :param pulumi.Input[str] branch_name_regex: All branch names must match this regex, e.g. "(feature|hotfix)\/*"
        :param pulumi.Input[str] commit_message_regex: All commit messages must match this regex, e.g. "Fixed \d+\..*"
        :param pulumi.Input[bool] deny_delete_tag: Deny deleting a tag
        :param pulumi.Input[str] file_name_regex: All commited filenames must not match this regex, e.g. "(jar|exe)$"
        :param pulumi.Input[float] max_file_size: Maximum file size (MB)
        :param pulumi.Input[bool] member_check: Restrict commits by author (email) to existing GitLab users
        :param pulumi.Input[bool] prevent_secrets: GitLab will reject any files that are likely to contain secrets
        :param pulumi.Input[str] project: The name or id of the project to add the push rules to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["author_email_regex"] = author_email_regex
        __props__["branch_name_regex"] = branch_name_regex
        __props__["commit_message_regex"] = commit_message_regex
        __props__["deny_delete_tag"] = deny_delete_tag
        __props__["file_name_regex"] = file_name_regex
        __props__["max_file_size"] = max_file_size
        __props__["member_check"] = member_check
        __props__["prevent_secrets"] = prevent_secrets
        __props__["project"] = project
        return ProjectPushRules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorEmailRegex")
    def author_email_regex(self) -> pulumi.Output[Optional[str]]:
        """
        All commit author emails must match this regex, e.g. "@my-company.com$"
        """
        return pulumi.get(self, "author_email_regex")

    @property
    @pulumi.getter(name="branchNameRegex")
    def branch_name_regex(self) -> pulumi.Output[Optional[str]]:
        """
        All branch names must match this regex, e.g. "(feature|hotfix)\/*"
        """
        return pulumi.get(self, "branch_name_regex")

    @property
    @pulumi.getter(name="commitMessageRegex")
    def commit_message_regex(self) -> pulumi.Output[Optional[str]]:
        """
        All commit messages must match this regex, e.g. "Fixed \d+\..*"
        """
        return pulumi.get(self, "commit_message_regex")

    @property
    @pulumi.getter(name="denyDeleteTag")
    def deny_delete_tag(self) -> pulumi.Output[Optional[bool]]:
        """
        Deny deleting a tag
        """
        return pulumi.get(self, "deny_delete_tag")

    @property
    @pulumi.getter(name="fileNameRegex")
    def file_name_regex(self) -> pulumi.Output[Optional[str]]:
        """
        All commited filenames must not match this regex, e.g. "(jar|exe)$"
        """
        return pulumi.get(self, "file_name_regex")

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> pulumi.Output[Optional[float]]:
        """
        Maximum file size (MB)
        """
        return pulumi.get(self, "max_file_size")

    @property
    @pulumi.getter(name="memberCheck")
    def member_check(self) -> pulumi.Output[Optional[bool]]:
        """
        Restrict commits by author (email) to existing GitLab users
        """
        return pulumi.get(self, "member_check")

    @property
    @pulumi.getter(name="preventSecrets")
    def prevent_secrets(self) -> pulumi.Output[Optional[bool]]:
        """
        GitLab will reject any files that are likely to contain secrets
        """
        return pulumi.get(self, "prevent_secrets")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name or id of the project to add the push rules to.
        """
        return pulumi.get(self, "project")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

