# `auther`

Auther is a CLI tool which authenticates your AWS CLI using various identity providers - all in one tool!

Currently supported Identity Providers

- Azure Active Directory - `azuread`

---

## Installation

### Pip

```console
$ pip install auther
```

Further info on [PyPi](https://pypi.org/project/auther/).

### Docker

```console
$ docker run -it --rm -v ~/.aws:/root/.aws trewq34/auther
```

When looking at usage information, the above command is a direct replacement for `auther`. Although you may wish to create a command alias with your chosen shell for ease.

Further info on [Docker Hub](https://hub.docker.com/r/trewq34/auther).

## Usage

### Configure

Before using `auther` to authenticate your AWS CLI, you need to configure it. This can be done quite using `auther configure`

```console
# Uses the default options, most importantly: AWS config file path, AWS region, AWS profile and Auther provider
$ auther configure
Your Azure AD Tenant ID: 30e04ef1-fb0d-4844-87a5-8720745de01b
Your Azure AD Application ID: 94ab3a5d-1b99-416a-bcaf-669f7b6bcaba
The username you use to sign in: someone@company.com
```

If you need to use a different AWS CLI profile or AWS region, you can override these by passing in options to the `configure` command

```console
$ auther configure --profile saml --region us-east-1
```

This will create/update a CLI profile called `saml` for use in the `us-east-1` region.

For all available configuration options and their defaults, you can use the following command

```console
$ auther configure --help
```

### Login

Once you have configured your AWS CLI profile for use with `auther` for authentication, you can login simply using the following command

```console
# Uses the default options, most importantly: AWS config file path, AWS credential file path, AWS profile and Auther provider
$ auther login
```

If you wish to override override any of the defaults, you can do so by passing in options to the `login` command. A list of available options and their defailts is available using the following command

```console
$ auther login --help
```

## Troubleshooting

### Chromium failed to download

A common cause for this is a corporate proxy/firewall blocking such downloads. To work around this, you can set the `CHROME_BIN` environment variable pointing to your preinstalled Google Chrome, Chromium or Microsoft Edge installation (this will probably work with other Chromium based browsers too, although hasn't been tested).

Some examples per OS can be seen below

#### macOS

```console
# Google Chrome
$ export CHROME_BIN="/Applications/Google Chrome.app/Contents/MacOS/Google Chrome"

# Microsoft Edge
$ export CHROME_BIN="/Applications/Microsoft Edge.app/Contents/MacOS/Microsoft Edge"

# Chromium
$ export CHROME_BIN="/Applications/Chromium.app/Contents/MacOS/Chromium"
```

#### Windows

```powershell
# Google Chrome
PS C:\Users\username> $env:CHROME_BIN="C:\Program Files\Google\Chrome\Application\chrome.exe"

# Microsoft Edge
PS C:\Users\username> $env:CHROME_BIN="C:\Program Files (x86)\Microsoft\Edge\Application\msedge.exe"

# Chromium - this depends on how you installed it. Assuming you installed it the same way I did, the path will be
PS C:\Users\username> $env:CHROME_BIN="C:\Users\username\AppData\Local\Chromium\Application\chrome.exe"
```

#### Linux

This will vary vastly depending on which distro you use. I've tested on RHEL 7.9, so this may not be the same as your distro. In any case, you can verify the path using the `which` command.

```console
# Google Chrome
$ export CHROME_BIN="/usr/bin/google-chrome"

# Microsoft Edge
$ export CHROME_BIN="/usr/bin/microsoft-edge"

# Chromium
$ export CHROME_BIN="/usr/bin/chromium-browser"
```
