# coding: utf-8

"""
    Cognite API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: playground
    Contact: support@cognite.com
    Generated by: https://openapi-generator.tech
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six
from cognite.geospatial._client.api_client import ApiClient
from cognite.geospatial._client.exceptions import ApiTypeError  # noqa: F401
from cognite.geospatial._client.exceptions import ApiValueError


class SpatialApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_spatial_item_data(self, project, spatial_datas_dto, **kwargs):  # noqa: E501
        """Add/Update spatial data  # noqa: E501

        This will add or update spatial data to the specified resource type item. The data must be according to the format matching the type that was specified when creating the resource type item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_spatial_item_data(project, spatial_datas_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_datas_dto: (required)
        :type spatial_datas_dto: SpatialDatasDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.add_spatial_item_data_with_http_info(project, spatial_datas_dto, **kwargs)  # noqa: E501

    def add_spatial_item_data_with_http_info(self, project, spatial_datas_dto, **kwargs):  # noqa: E501
        """Add/Update spatial data  # noqa: E501

        This will add or update spatial data to the specified resource type item. The data must be according to the format matching the type that was specified when creating the resource type item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_spatial_item_data_with_http_info(project, spatial_datas_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_datas_dto: (required)
        :type spatial_datas_dto: SpatialDatasDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "spatial_datas_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method add_spatial_item_data" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `add_spatial_item_data`"
            )  # noqa: E501
        # verify the required parameter 'spatial_datas_dto' is set
        if self.api_client.client_side_validation and (
            "spatial_datas_dto" not in local_var_params or local_var_params["spatial_datas_dto"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `spatial_datas_dto` when calling `add_spatial_item_data`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "spatial_datas_dto" in local_var_params:
            body_params = local_var_params["spatial_datas_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/data",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def by_ids_spatial_items(self, project, spatial_ids_dto, **kwargs):  # noqa: E501
        """Retrieve spatial items  # noqa: E501

        Retrieves spatial items by internal ids or external ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.by_ids_spatial_items(project, spatial_ids_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_ids_dto: (required)
        :type spatial_ids_dto: SpatialIdsDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FullSpatialItemsDTO
        """
        kwargs["_return_http_data_only"] = True
        return self.by_ids_spatial_items_with_http_info(project, spatial_ids_dto, **kwargs)  # noqa: E501

    def by_ids_spatial_items_with_http_info(self, project, spatial_ids_dto, **kwargs):  # noqa: E501
        """Retrieve spatial items  # noqa: E501

        Retrieves spatial items by internal ids or external ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.by_ids_spatial_items_with_http_info(project, spatial_ids_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_ids_dto: (required)
        :type spatial_ids_dto: SpatialIdsDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FullSpatialItemsDTO, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "spatial_ids_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method by_ids_spatial_items" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `by_ids_spatial_items`"
            )  # noqa: E501
        # verify the required parameter 'spatial_ids_dto' is set
        if self.api_client.client_side_validation and (
            "spatial_ids_dto" not in local_var_params or local_var_params["spatial_ids_dto"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `spatial_ids_dto` when calling `by_ids_spatial_items`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "spatial_ids_dto" in local_var_params:
            body_params = local_var_params["spatial_ids_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/byids",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FullSpatialItemsDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def calculate_spatial_coverage(self, project, spatial_ids_dto, **kwargs):  # noqa: E501
        """Calculate coverage of spatial item  # noqa: E501

        Calculate coverage of spatial object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.calculate_spatial_coverage(project, spatial_ids_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_ids_dto: (required)
        :type spatial_ids_dto: SpatialIdsDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpatialItemsCoveragesDTO
        """
        kwargs["_return_http_data_only"] = True
        return self.calculate_spatial_coverage_with_http_info(project, spatial_ids_dto, **kwargs)  # noqa: E501

    def calculate_spatial_coverage_with_http_info(self, project, spatial_ids_dto, **kwargs):  # noqa: E501
        """Calculate coverage of spatial item  # noqa: E501

        Calculate coverage of spatial object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.calculate_spatial_coverage_with_http_info(project, spatial_ids_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_ids_dto: (required)
        :type spatial_ids_dto: SpatialIdsDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpatialItemsCoveragesDTO, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "spatial_ids_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method calculate_spatial_coverage" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `calculate_spatial_coverage`"
            )  # noqa: E501
        # verify the required parameter 'spatial_ids_dto' is set
        if self.api_client.client_side_validation and (
            "spatial_ids_dto" not in local_var_params or local_var_params["spatial_ids_dto"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `spatial_ids_dto` when calling `calculate_spatial_coverage`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "spatial_ids_dto" in local_var_params:
            body_params = local_var_params["spatial_ids_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/coverage/calculate",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SpatialItemsCoveragesDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def create_spatial(self, project, create_spatial_items_dto, **kwargs):  # noqa: E501
        """Create spatial items  # noqa: E501

        Creates spatial object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spatial(project, create_spatial_items_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param create_spatial_items_dto: List of spatial items to be created. It is possiible to post a maximum of 25 spatial items per request. (required)
        :type create_spatial_items_dto: CreateSpatialItemsDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FullSpatialItemsDTO
        """
        kwargs["_return_http_data_only"] = True
        return self.create_spatial_with_http_info(project, create_spatial_items_dto, **kwargs)  # noqa: E501

    def create_spatial_with_http_info(self, project, create_spatial_items_dto, **kwargs):  # noqa: E501
        """Create spatial items  # noqa: E501

        Creates spatial object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spatial_with_http_info(project, create_spatial_items_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param create_spatial_items_dto: List of spatial items to be created. It is possiible to post a maximum of 25 spatial items per request. (required)
        :type create_spatial_items_dto: CreateSpatialItemsDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FullSpatialItemsDTO, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "create_spatial_items_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method create_spatial" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_spatial`")  # noqa: E501
        # verify the required parameter 'create_spatial_items_dto' is set
        if self.api_client.client_side_validation and (
            "create_spatial_items_dto" not in local_var_params
            or local_var_params["create_spatial_items_dto"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `create_spatial_items_dto` when calling `create_spatial`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "create_spatial_items_dto" in local_var_params:
            body_params = local_var_params["create_spatial_items_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FullSpatialItemsDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def delete_spatial(self, project, spatial_ids_dto, **kwargs):  # noqa: E501
        """Delete spatial items  # noqa: E501

        Delete spatial object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_spatial(project, spatial_ids_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_ids_dto: List of spatial items to be deleted. It is possiible to post a maximum of 25 spatial items per request. (required)
        :type spatial_ids_dto: SpatialIdsDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FullSpatialItemsDTO
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_spatial_with_http_info(project, spatial_ids_dto, **kwargs)  # noqa: E501

    def delete_spatial_with_http_info(self, project, spatial_ids_dto, **kwargs):  # noqa: E501
        """Delete spatial items  # noqa: E501

        Delete spatial object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_spatial_with_http_info(project, spatial_ids_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_ids_dto: List of spatial items to be deleted. It is possiible to post a maximum of 25 spatial items per request. (required)
        :type spatial_ids_dto: SpatialIdsDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FullSpatialItemsDTO, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "spatial_ids_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method delete_spatial" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_spatial`")  # noqa: E501
        # verify the required parameter 'spatial_ids_dto' is set
        if self.api_client.client_side_validation and (
            "spatial_ids_dto" not in local_var_params or local_var_params["spatial_ids_dto"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `spatial_ids_dto` when calling `delete_spatial`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "spatial_ids_dto" in local_var_params:
            body_params = local_var_params["spatial_ids_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/delete",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FullSpatialItemsDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def file_save(self, project, file_type, file, **kwargs):  # noqa: E501
        """Save spatial file  # noqa: E501

        Save spatial file. Formats: shape file, parque.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.file_save(project, file_type, file, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param file_type: (required)
        :type file_type: str
        :param file: (required)
        :type file: file
        :param id:
        :type id: str
        :param external_id:
        :type external_id: str
        :param layer:
        :type layer: str
        :param attributes:
        :type attributes: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.file_save_with_http_info(project, file_type, file, **kwargs)  # noqa: E501

    def file_save_with_http_info(self, project, file_type, file, **kwargs):  # noqa: E501
        """Save spatial file  # noqa: E501

        Save spatial file. Formats: shape file, parque.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.file_save_with_http_info(project, file_type, file, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param file_type: (required)
        :type file_type: str
        :param file: (required)
        :type file: file
        :param id:
        :type id: str
        :param external_id:
        :type external_id: str
        :param layer:
        :type layer: str
        :param attributes:
        :type attributes: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "file_type", "file", "id", "external_id", "layer", "attributes"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method file_save" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `file_save`")  # noqa: E501
        # verify the required parameter 'file_type' is set
        if self.api_client.client_side_validation and (
            "file_type" not in local_var_params or local_var_params["file_type"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_type` when calling `file_save`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and (
            "file" not in local_var_params or local_var_params["file"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `file_save`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if "id" in local_var_params:
            form_params.append(("id", local_var_params["id"]))  # noqa: E501
        if "external_id" in local_var_params:
            form_params.append(("externalId", local_var_params["external_id"]))  # noqa: E501
        if "layer" in local_var_params:
            form_params.append(("layer", local_var_params["layer"]))  # noqa: E501
        if "attributes" in local_var_params:
            form_params.append(("attributes", local_var_params["attributes"]))  # noqa: E501
            collection_formats["attributes"] = "csv"  # noqa: E501
        if "file_type" in local_var_params:
            form_params.append(("fileType", local_var_params["file_type"]))  # noqa: E501
        if "file" in local_var_params:
            local_var_files["file"] = local_var_params["file"]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/file/save",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def find_feature_layer(self, project, feature_layers_filter_dto, **kwargs):  # noqa: E501
        """Find feature layers  # noqa: E501

        Find feature layers that represent a real-world geographic entity on earth. Feature layers are composed of both a geometry (point, linestring, polygon) and a set of attributes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_feature_layer(project, feature_layers_filter_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param feature_layers_filter_dto: (required)
        :type feature_layers_filter_dto: FeatureLayersFilterDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FeatureLayersDTO
        """
        kwargs["_return_http_data_only"] = True
        return self.find_feature_layer_with_http_info(project, feature_layers_filter_dto, **kwargs)  # noqa: E501

    def find_feature_layer_with_http_info(self, project, feature_layers_filter_dto, **kwargs):  # noqa: E501
        """Find feature layers  # noqa: E501

        Find feature layers that represent a real-world geographic entity on earth. Feature layers are composed of both a geometry (point, linestring, polygon) and a set of attributes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_feature_layer_with_http_info(project, feature_layers_filter_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param feature_layers_filter_dto: (required)
        :type feature_layers_filter_dto: FeatureLayersFilterDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FeatureLayersDTO, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "feature_layers_filter_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method find_feature_layer" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `find_feature_layer`"
            )  # noqa: E501
        # verify the required parameter 'feature_layers_filter_dto' is set
        if self.api_client.client_side_validation and (
            "feature_layers_filter_dto" not in local_var_params
            or local_var_params["feature_layers_filter_dto"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `feature_layers_filter_dto` when calling `find_feature_layer`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "feature_layers_filter_dto" in local_var_params:
            body_params = local_var_params["feature_layers_filter_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/featurelayer",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FeatureLayersDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def get_spatial_coverage(self, project, spatial_items_projection_dto, **kwargs):  # noqa: E501
        """Get spatial item coverage  # noqa: E501

        Get spatial item coverage in WKT representation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_spatial_coverage(project, spatial_items_projection_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_items_projection_dto: (required)
        :type spatial_items_projection_dto: SpatialItemsProjectionDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpatialItemsCoveragesDTO
        """
        kwargs["_return_http_data_only"] = True
        return self.get_spatial_coverage_with_http_info(project, spatial_items_projection_dto, **kwargs)  # noqa: E501

    def get_spatial_coverage_with_http_info(self, project, spatial_items_projection_dto, **kwargs):  # noqa: E501
        """Get spatial item coverage  # noqa: E501

        Get spatial item coverage in WKT representation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_spatial_coverage_with_http_info(project, spatial_items_projection_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_items_projection_dto: (required)
        :type spatial_items_projection_dto: SpatialItemsProjectionDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpatialItemsCoveragesDTO, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "spatial_items_projection_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_spatial_coverage" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_spatial_coverage`"
            )  # noqa: E501
        # verify the required parameter 'spatial_items_projection_dto' is set
        if self.api_client.client_side_validation and (
            "spatial_items_projection_dto" not in local_var_params
            or local_var_params["spatial_items_projection_dto"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `spatial_items_projection_dto` when calling `get_spatial_coverage`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "spatial_items_projection_dto" in local_var_params:
            body_params = local_var_params["spatial_items_projection_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/coverage",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SpatialItemsCoveragesDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def get_spatial_items_data(self, project, spatial_data_request_dto, **kwargs):  # noqa: E501
        """Retrieve spatial data  # noqa: E501

        Retrieves spatial data from a specified resource type item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_spatial_items_data(project, spatial_data_request_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_data_request_dto: (required)
        :type spatial_data_request_dto: SpatialDataRequestDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: dict(str, object)
        """
        kwargs["_return_http_data_only"] = True
        return self.get_spatial_items_data_with_http_info(project, spatial_data_request_dto, **kwargs)  # noqa: E501

    def get_spatial_items_data_with_http_info(self, project, spatial_data_request_dto, **kwargs):  # noqa: E501
        """Retrieve spatial data  # noqa: E501

        Retrieves spatial data from a specified resource type item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_spatial_items_data_with_http_info(project, spatial_data_request_dto, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_data_request_dto: (required)
        :type spatial_data_request_dto: SpatialDataRequestDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(dict(str, object), status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "spatial_data_request_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_spatial_items_data" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_spatial_items_data`"
            )  # noqa: E501
        # verify the required parameter 'spatial_data_request_dto' is set
        if self.api_client.client_side_validation and (
            "spatial_data_request_dto" not in local_var_params
            or local_var_params["spatial_data_request_dto"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `spatial_data_request_dto` when calling `get_spatial_items_data`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "spatial_data_request_dto" in local_var_params:
            body_params = local_var_params["spatial_data_request_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/data/list",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="dict(str, object)",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def search_spatial(self, project, **kwargs):  # noqa: E501
        """Search for spatial items  # noqa: E501

        Searches and returns the spatial items based on resource type content or coordinates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_spatial(project, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_search_request_dto:
        :type spatial_search_request_dto: SpatialSearchRequestDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SearchResponseItemsDTO
        """
        kwargs["_return_http_data_only"] = True
        return self.search_spatial_with_http_info(project, **kwargs)  # noqa: E501

    def search_spatial_with_http_info(self, project, **kwargs):  # noqa: E501
        """Search for spatial items  # noqa: E501

        Searches and returns the spatial items based on resource type content or coordinates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_spatial_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: The project name. (required)
        :type project: str
        :param spatial_search_request_dto:
        :type spatial_search_request_dto: SpatialSearchRequestDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SearchResponseItemsDTO, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["project", "spatial_search_request_dto"]
        all_params.extend(
            ["async_req", "_return_http_data_only", "_preload_content", "_request_timeout", "_request_auth"]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method search_spatial" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `search_spatial`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "spatial_search_request_dto" in local_var_params:
            body_params = local_var_params["spatial_search_request_dto"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api-key", "token"]  # noqa: E501

        return self.api_client.call_api(
            "/api/playground/projects/{project}/spatial/search",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SearchResponseItemsDTO",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )
