# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from cognite.seismic.protos import query_service_messages_pb2 as cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2
from cognite.seismic.protos import types_pb2 as cognite_dot_seismic_dot_protos_dot_types__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class QueryStub(object):
    """*
    Service for querying data and metadata from seismic files in Cognite Data Fusion (CDF) seismic datastore
    We use the word `File` to refer to a single seismic file/dataset/cube. Queries on a file require it to have been
    previously ingested into CDF using (ingest_service.proto)

    Queries are divided in:

    - Metadata:

    General information and headers for surveys and files

    - Geometry and grid:

    Information on a file's grid and positioning, such as coverage and range of inlines and crosslines

    - Trace:

    Find a single trace in the file. A trace will include header, position information and samples.
    More details about the trace format can be found on its definition in (types.proto)

    - Vertical slice:

    Get 2D vertical slices of samples (thus 1D arrays of traces). The slices can be based on a single defined line or
    in an arbitrarily defined line with interpolation.

    - Area:

    Get 3D volumes of samples (thus 2D arrays of traces) defined by a region in the horizontal plane

    - Horizontal slice:

    Get 2D horizontal slices of samples defined by a region in the horizontal plane and a specific index in depth/time

    - Artificial sampling:

    Get the (calculated/interpolated) values of properties in the file/cube given arbitrary positions

    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetSurvey = channel.unary_unary(
                '/com.cognite.seismic.Query/GetSurvey',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetSurveyResponse.FromString,
                )
        self.ListSurveys = channel.unary_unary(
                '/com.cognite.seismic.Query/ListSurveys',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.ListSurveysQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyWithFilesResponse.FromString,
                )
        self.ListFiles = channel.unary_unary(
                '/com.cognite.seismic.Query/ListFiles',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.ListFilesResponse.FromString,
                )
        self.SearchSurveys = channel.unary_unary(
                '/com.cognite.seismic.Query/SearchSurveys',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SearchSurveyRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyWithFilesResponse.FromString,
                )
        self.GetFile = channel.unary_unary(
                '/com.cognite.seismic.Query/GetFile',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetFileResponse.FromString,
                )
        self.GetBinaryHeader = channel.unary_unary(
                '/com.cognite.seismic.Query/GetBinaryHeader',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.HeaderFileQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetBinaryHeaderResponse.FromString,
                )
        self.GetTextHeader = channel.unary_unary(
                '/com.cognite.seismic.Query/GetTextHeader',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.HeaderFileQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetTextHeaderResponse.FromString,
                )
        self.GetFileDataCoverage = channel.unary_unary(
                '/com.cognite.seismic.Query/GetFileDataCoverage',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileCoverageRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.DataCoverageResponse.FromString,
                )
        self.GetFileLineRange = channel.unary_unary(
                '/com.cognite.seismic.Query/GetFileLineRange',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineRangeResponse.FromString,
                )
        self.GetCrosslinesByInline = channel.unary_unary(
                '/com.cognite.seismic.Query/GetCrosslinesByInline',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileLineQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.AvailableLines.FromString,
                )
        self.GetInlinesByCrossline = channel.unary_unary(
                '/com.cognite.seismic.Query/GetInlinesByCrossline',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileLineQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.AvailableLines.FromString,
                )
        self.GetTraceByCoordinates = channel.unary_unary(
                '/com.cognite.seismic.Query/GetTraceByCoordinates',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.CoordinateTraceQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
                )
        self.GetTracesByLine = channel.stream_stream(
                '/com.cognite.seismic.Query/GetTracesByLine',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineTraceQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
                )
        self.GetSliceByLine = channel.unary_stream(
                '/com.cognite.seismic.Query/GetSliceByLine',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineSliceQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
                )
        self.GetSliceByGeometry = channel.unary_stream(
                '/com.cognite.seismic.Query/GetSliceByGeometry',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometrySliceQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
                )
        self.GetCubeByLines = channel.unary_stream(
                '/com.cognite.seismic.Query/GetCubeByLines',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineCubeRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
                )
        self.GetCubeByGeometry = channel.unary_stream(
                '/com.cognite.seismic.Query/GetCubeByGeometry',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometryCubeRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
                )
        self.GetSegYFile = channel.unary_stream(
                '/com.cognite.seismic.Query/GetSegYFile',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SegYQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SegYQueryResponse.FromString,
                )
        self.GetTimeSliceByLines = channel.unary_stream(
                '/com.cognite.seismic.Query/GetTimeSliceByLines',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineTimeSliceQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.SurfacePoint.FromString,
                )
        self.GetTimeSliceByGeometry = channel.unary_stream(
                '/com.cognite.seismic.Query/GetTimeSliceByGeometry',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometryTimeSliceQueryRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.SurfacePoint.FromString,
                )
        self.GetVolume = channel.unary_stream(
                '/com.cognite.seismic.Query/GetVolume',
                request_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.VolumeRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
                )


class QueryServicer(object):
    """*
    Service for querying data and metadata from seismic files in Cognite Data Fusion (CDF) seismic datastore
    We use the word `File` to refer to a single seismic file/dataset/cube. Queries on a file require it to have been
    previously ingested into CDF using (ingest_service.proto)

    Queries are divided in:

    - Metadata:

    General information and headers for surveys and files

    - Geometry and grid:

    Information on a file's grid and positioning, such as coverage and range of inlines and crosslines

    - Trace:

    Find a single trace in the file. A trace will include header, position information and samples.
    More details about the trace format can be found on its definition in (types.proto)

    - Vertical slice:

    Get 2D vertical slices of samples (thus 1D arrays of traces). The slices can be based on a single defined line or
    in an arbitrarily defined line with interpolation.

    - Area:

    Get 3D volumes of samples (thus 2D arrays of traces) defined by a region in the horizontal plane

    - Horizontal slice:

    Get 2D horizontal slices of samples defined by a region in the horizontal plane and a specific index in depth/time

    - Artificial sampling:

    Get the (calculated/interpolated) values of properties in the file/cube given arbitrary positions

    """

    def GetSurvey(self, request, context):
        """Metadata queries

        *
        Finds one survey given its name or id. Optionally, lists its associated files.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListSurveys(self, request, context):
        """*
        Lists all surveys owned by this project. Optionally, includes their lists of files.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListFiles(self, request, context):
        """*
        Lists all files available, both owned by the authorized CDF project and shared with it
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchSurveys(self, request, context):
        """*
        Search surveys based on two criteria:
        Coverage polygon of files in the survey are within an area delimited by a specified polygon
        Filters on metadata of both the survey and the file
        Both criteria are optional and can be combined for a more detailed search.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFile(self, request, context):
        """*
        Returns file metadata given its name or id.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetBinaryHeader(self, request, context):
        """*
        Returns a binary header given its file name or id.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTextHeader(self, request, context):
        """*
        Returns a text header given its file name or id.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFileDataCoverage(self, request, context):
        """Geometry and grid queries

        *
        Returns the coverage for a given file identified by its id or name.
        The coverage is represented by a polygon either in WKT or geojson and represents the area covered by traces
        in the file.
        There can be holes in the polygon if traces do not exist in an area inside of it.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFileLineRange(self, request, context):
        """*
        Returns the full range of the inlines and crosslines in the file, i.e. the minimum and maximum inline and crossline
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetCrosslinesByInline(self, request, context):
        """*
        Returns the set of valid crossline indices for a specific inline, in a given file
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetInlinesByCrossline(self, request, context):
        """*
        Returns the set of valid inline indices for a specific crossline, in a given file
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTraceByCoordinates(self, request, context):
        """Trace queries

        *
        Returns the trace in a file that is closest to a point given its coordinates (x,y)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTracesByLine(self, request_iterator, context):
        """*
        Returns a trace for each coordinate (inline, xline) from the input stream
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetSliceByLine(self, request, context):
        """Slice queries

        *
        Returns all or a subset of traces in a slice (inline or crossline) given its index (and optionally from/to)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetSliceByGeometry(self, request, context):
        """*
        Returns a slice with traces following a path determined by an arbitrary line.
        Depending on interpolating method, these can be either real traces in the file that are closest to the path or
        synthetic traces generated by interpolation of the traces in the file.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetCubeByLines(self, request, context):
        """Area queries

        *
        Returns a volume with all traces inside a given range of inlines and a given range of crosslines
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetCubeByGeometry(self, request, context):
        """*
        Returns a volume with all traces with x, y coordinates inside an arbitrary 2D polygon
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetSegYFile(self, request, context):
        """*
        Returns a SEG-Y file.
        Can retrieve a full file or create a new cropped file filtering on areas of interest only.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTimeSliceByLines(self, request, context):
        """Depth-indexed area queries

        *
        Returns a horizontal slice for a given depth or time and area constrained by a range of inlines and crosslines
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTimeSliceByGeometry(self, request, context):
        """*
        Returns a horizontal slice for a given depth or time and area constrained by an arbitrary 2D polygon
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetVolume(self, request, context):
        """Volume queries
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_QueryServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetSurvey': grpc.unary_unary_rpc_method_handler(
                    servicer.GetSurvey,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetSurveyResponse.SerializeToString,
            ),
            'ListSurveys': grpc.unary_unary_rpc_method_handler(
                    servicer.ListSurveys,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.ListSurveysQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyWithFilesResponse.SerializeToString,
            ),
            'ListFiles': grpc.unary_unary_rpc_method_handler(
                    servicer.ListFiles,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.ListFilesResponse.SerializeToString,
            ),
            'SearchSurveys': grpc.unary_unary_rpc_method_handler(
                    servicer.SearchSurveys,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SearchSurveyRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyWithFilesResponse.SerializeToString,
            ),
            'GetFile': grpc.unary_unary_rpc_method_handler(
                    servicer.GetFile,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetFileResponse.SerializeToString,
            ),
            'GetBinaryHeader': grpc.unary_unary_rpc_method_handler(
                    servicer.GetBinaryHeader,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.HeaderFileQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetBinaryHeaderResponse.SerializeToString,
            ),
            'GetTextHeader': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTextHeader,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.HeaderFileQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetTextHeaderResponse.SerializeToString,
            ),
            'GetFileDataCoverage': grpc.unary_unary_rpc_method_handler(
                    servicer.GetFileDataCoverage,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileCoverageRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.DataCoverageResponse.SerializeToString,
            ),
            'GetFileLineRange': grpc.unary_unary_rpc_method_handler(
                    servicer.GetFileLineRange,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineRangeResponse.SerializeToString,
            ),
            'GetCrosslinesByInline': grpc.unary_unary_rpc_method_handler(
                    servicer.GetCrosslinesByInline,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileLineQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.AvailableLines.SerializeToString,
            ),
            'GetInlinesByCrossline': grpc.unary_unary_rpc_method_handler(
                    servicer.GetInlinesByCrossline,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileLineQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.AvailableLines.SerializeToString,
            ),
            'GetTraceByCoordinates': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTraceByCoordinates,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.CoordinateTraceQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.SerializeToString,
            ),
            'GetTracesByLine': grpc.stream_stream_rpc_method_handler(
                    servicer.GetTracesByLine,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineTraceQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.SerializeToString,
            ),
            'GetSliceByLine': grpc.unary_stream_rpc_method_handler(
                    servicer.GetSliceByLine,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineSliceQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.SerializeToString,
            ),
            'GetSliceByGeometry': grpc.unary_stream_rpc_method_handler(
                    servicer.GetSliceByGeometry,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometrySliceQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.SerializeToString,
            ),
            'GetCubeByLines': grpc.unary_stream_rpc_method_handler(
                    servicer.GetCubeByLines,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineCubeRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.SerializeToString,
            ),
            'GetCubeByGeometry': grpc.unary_stream_rpc_method_handler(
                    servicer.GetCubeByGeometry,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometryCubeRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.SerializeToString,
            ),
            'GetSegYFile': grpc.unary_stream_rpc_method_handler(
                    servicer.GetSegYFile,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SegYQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SegYQueryResponse.SerializeToString,
            ),
            'GetTimeSliceByLines': grpc.unary_stream_rpc_method_handler(
                    servicer.GetTimeSliceByLines,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineTimeSliceQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.SurfacePoint.SerializeToString,
            ),
            'GetTimeSliceByGeometry': grpc.unary_stream_rpc_method_handler(
                    servicer.GetTimeSliceByGeometry,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometryTimeSliceQueryRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.SurfacePoint.SerializeToString,
            ),
            'GetVolume': grpc.unary_stream_rpc_method_handler(
                    servicer.GetVolume,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.VolumeRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'com.cognite.seismic.Query', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Query(object):
    """*
    Service for querying data and metadata from seismic files in Cognite Data Fusion (CDF) seismic datastore
    We use the word `File` to refer to a single seismic file/dataset/cube. Queries on a file require it to have been
    previously ingested into CDF using (ingest_service.proto)

    Queries are divided in:

    - Metadata:

    General information and headers for surveys and files

    - Geometry and grid:

    Information on a file's grid and positioning, such as coverage and range of inlines and crosslines

    - Trace:

    Find a single trace in the file. A trace will include header, position information and samples.
    More details about the trace format can be found on its definition in (types.proto)

    - Vertical slice:

    Get 2D vertical slices of samples (thus 1D arrays of traces). The slices can be based on a single defined line or
    in an arbitrarily defined line with interpolation.

    - Area:

    Get 3D volumes of samples (thus 2D arrays of traces) defined by a region in the horizontal plane

    - Horizontal slice:

    Get 2D horizontal slices of samples defined by a region in the horizontal plane and a specific index in depth/time

    - Artificial sampling:

    Get the (calculated/interpolated) values of properties in the file/cube given arbitrary positions

    """

    @staticmethod
    def GetSurvey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetSurvey',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetSurveyResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListSurveys(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/ListSurveys',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.ListSurveysQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyWithFilesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListFiles(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/ListFiles',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.ListFilesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SearchSurveys(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/SearchSurveys',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SearchSurveyRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SurveyWithFilesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetFile',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetFileResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetBinaryHeader(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetBinaryHeader',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.HeaderFileQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetBinaryHeaderResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTextHeader(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetTextHeader',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.HeaderFileQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GetTextHeaderResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetFileDataCoverage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetFileDataCoverage',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileCoverageRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.DataCoverageResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetFileLineRange(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetFileLineRange',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineRangeResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetCrosslinesByInline(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetCrosslinesByInline',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileLineQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.AvailableLines.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetInlinesByCrossline(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetInlinesByCrossline',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.FileLineQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.AvailableLines.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTraceByCoordinates(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Query/GetTraceByCoordinates',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.CoordinateTraceQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTracesByLine(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(request_iterator, target, '/com.cognite.seismic.Query/GetTracesByLine',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineTraceQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetSliceByLine(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.Query/GetSliceByLine',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineSliceQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetSliceByGeometry(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.Query/GetSliceByGeometry',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometrySliceQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetCubeByLines(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.Query/GetCubeByLines',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineCubeRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetCubeByGeometry(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.Query/GetCubeByGeometry',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometryCubeRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetSegYFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.Query/GetSegYFile',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SegYQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.SegYQueryResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTimeSliceByLines(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.Query/GetTimeSliceByLines',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.LineTimeSliceQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.SurfacePoint.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTimeSliceByGeometry(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.Query/GetTimeSliceByGeometry',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.GeometryTimeSliceQueryRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.SurfacePoint.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetVolume(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.Query/GetVolume',
            cognite_dot_seismic_dot_protos_dot_query__service__messages__pb2.VolumeRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
