import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A descriptive comment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#description BinaryAuthorizationPolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Controls the evaluation of a Google-maintained global admission policy for common system-level images.
     *
     * Images not covered by the global
     * policy will be subject to the project admission policy. Possible values: ["ENABLE", "DISABLE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#global_policy_evaluation_mode BinaryAuthorizationPolicy#global_policy_evaluation_mode}
     *
     * @stability stable
     */
    readonly globalPolicyEvaluationMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#project BinaryAuthorizationPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * admission_whitelist_patterns block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#admission_whitelist_patterns BinaryAuthorizationPolicy#admission_whitelist_patterns}
     *
     * @stability stable
     */
    readonly admissionWhitelistPatterns?: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[];
    /**
     * cluster_admission_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#cluster_admission_rules BinaryAuthorizationPolicy#cluster_admission_rules}
     *
     * @stability stable
     */
    readonly clusterAdmissionRules?: BinaryAuthorizationPolicyClusterAdmissionRules[];
    /**
     * default_admission_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#default_admission_rule BinaryAuthorizationPolicy#default_admission_rule}
     *
     * @stability stable
     */
    readonly defaultAdmissionRule: BinaryAuthorizationPolicyDefaultAdmissionRule;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#timeouts BinaryAuthorizationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BinaryAuthorizationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyAdmissionWhitelistPatterns {
    /**
     * An image name pattern to whitelist, in the form 'registry/path/to/image'.
     *
     * This supports a trailing * as a
     * wildcard, but this is allowed only in text after the registry/
     * part.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#name_pattern BinaryAuthorizationPolicy#name_pattern}
     *
     * @stability stable
     */
    readonly namePattern: string;
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyClusterAdmissionRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#cluster BinaryAuthorizationPolicy#cluster}.
     *
     * @stability stable
     */
    readonly cluster: string;
    /**
     * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#enforcement_mode BinaryAuthorizationPolicy#enforcement_mode}
     *
     * @stability stable
     */
    readonly enforcementMode: string;
    /**
     * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#evaluation_mode BinaryAuthorizationPolicy#evaluation_mode}
     *
     * @stability stable
     */
    readonly evaluationMode: string;
    /**
     * The resource names of the attestors that must attest to a container image.
     *
     * If the attestor is in a different project from the
     * policy, it should be specified in the format 'projects/*\/attestors/*'.
     * Each attestor must exist before a policy can reference it. To add an
     * attestor to a policy the principal issuing the policy change
     * request must be able to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field
     * specifies REQUIRE_ATTESTATION, otherwise it must be empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#require_attestations_by BinaryAuthorizationPolicy#require_attestations_by}
     *
     * @stability stable
     */
    readonly requireAttestationsBy?: string[];
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyDefaultAdmissionRule {
    /**
     * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#enforcement_mode BinaryAuthorizationPolicy#enforcement_mode}
     *
     * @stability stable
     */
    readonly enforcementMode: string;
    /**
     * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#evaluation_mode BinaryAuthorizationPolicy#evaluation_mode}
     *
     * @stability stable
     */
    readonly evaluationMode: string;
    /**
     * The resource names of the attestors that must attest to a container image.
     *
     * If the attestor is in a different project from the
     * policy, it should be specified in the format 'projects/*\/attestors/*'.
     * Each attestor must exist before a policy can reference it. To add an
     * attestor to a policy the principal issuing the policy change
     * request must be able to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field
     * specifies REQUIRE_ATTESTATION, otherwise it must be empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#require_attestations_by BinaryAuthorizationPolicy#require_attestations_by}
     *
     * @stability stable
     */
    readonly requireAttestationsBy?: string[];
}
/**
 * @stability stable
 */
export declare class BinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enforcementMode?;
    /**
     * @stability stable
     */
    get enforcementMode(): string;
    /**
     * @stability stable
     */
    set enforcementMode(value: string);
    /**
     * @stability stable
     */
    get enforcementModeInput(): string | undefined;
    private _evaluationMode?;
    /**
     * @stability stable
     */
    get evaluationMode(): string;
    /**
     * @stability stable
     */
    set evaluationMode(value: string);
    /**
     * @stability stable
     */
    get evaluationModeInput(): string | undefined;
    private _requireAttestationsBy?;
    /**
     * @stability stable
     */
    get requireAttestationsBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set requireAttestationsBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRequireAttestationsBy(): void;
    /**
     * @stability stable
     */
    get requireAttestationsByInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#create BinaryAuthorizationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#delete BinaryAuthorizationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html#update BinaryAuthorizationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class BinaryAuthorizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html google_binary_authorization_policy}.
 *
 * @stability stable
 */
export declare class BinaryAuthorizationPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy.html google_binary_authorization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BinaryAuthorizationPolicyConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _globalPolicyEvaluationMode?;
    /**
     * @stability stable
     */
    get globalPolicyEvaluationMode(): string | undefined;
    /**
     * @stability stable
     */
    set globalPolicyEvaluationMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetGlobalPolicyEvaluationMode(): void;
    /**
     * @stability stable
     */
    get globalPolicyEvaluationModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _admissionWhitelistPatterns?;
    /**
     * @stability stable
     */
    get admissionWhitelistPatterns(): BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined;
    /**
     * @stability stable
     */
    set admissionWhitelistPatterns(value: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined);
    /**
     * @stability stable
     */
    resetAdmissionWhitelistPatterns(): void;
    /**
     * @stability stable
     */
    get admissionWhitelistPatternsInput(): BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined;
    private _clusterAdmissionRules?;
    /**
     * @stability stable
     */
    get clusterAdmissionRules(): BinaryAuthorizationPolicyClusterAdmissionRules[] | undefined;
    /**
     * @stability stable
     */
    set clusterAdmissionRules(value: BinaryAuthorizationPolicyClusterAdmissionRules[] | undefined);
    /**
     * @stability stable
     */
    resetClusterAdmissionRules(): void;
    /**
     * @stability stable
     */
    get clusterAdmissionRulesInput(): BinaryAuthorizationPolicyClusterAdmissionRules[] | undefined;
    private _defaultAdmissionRule?;
    private __defaultAdmissionRuleOutput;
    /**
     * @stability stable
     */
    get defaultAdmissionRule(): BinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference;
    /**
     * @stability stable
     */
    putDefaultAdmissionRule(value: BinaryAuthorizationPolicyDefaultAdmissionRule): void;
    /**
     * @stability stable
     */
    get defaultAdmissionRuleInput(): BinaryAuthorizationPolicyDefaultAdmissionRule | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): BinaryAuthorizationPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BinaryAuthorizationPolicyTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BinaryAuthorizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
