import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KmsSecretCiphertextConfig extends cdktf.TerraformMetaArguments {
    /**
     * The additional authenticated data used for integrity checks during encryption and decryption.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#additional_authenticated_data KmsSecretCiphertext#additional_authenticated_data}
     *
     * @stability stable
     */
    readonly additionalAuthenticatedData?: string;
    /**
     * The full name of the CryptoKey that will be used to encrypt the provided plaintext. Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}/cryptoKeys/{{cryptoKey}}''.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#crypto_key KmsSecretCiphertext#crypto_key}
     *
     * @stability stable
     */
    readonly cryptoKey: string;
    /**
     * The plaintext to be encrypted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#plaintext KmsSecretCiphertext#plaintext}
     *
     * @stability stable
     */
    readonly plaintext: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#timeouts KmsSecretCiphertext#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KmsSecretCiphertextTimeouts;
}
/**
 * @stability stable
 */
export interface KmsSecretCiphertextTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#create KmsSecretCiphertext#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#delete KmsSecretCiphertext#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class KmsSecretCiphertextTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html google_kms_secret_ciphertext}.
 *
 * @stability stable
 */
export declare class KmsSecretCiphertext extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html google_kms_secret_ciphertext} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KmsSecretCiphertextConfig);
    private _additionalAuthenticatedData?;
    /**
     * @stability stable
     */
    get additionalAuthenticatedData(): string | undefined;
    /**
     * @stability stable
     */
    set additionalAuthenticatedData(value: string | undefined);
    /**
     * @stability stable
     */
    resetAdditionalAuthenticatedData(): void;
    /**
     * @stability stable
     */
    get additionalAuthenticatedDataInput(): string | undefined;
    /**
     * @stability stable
     */
    get ciphertext(): string;
    private _cryptoKey?;
    /**
     * @stability stable
     */
    get cryptoKey(): string;
    /**
     * @stability stable
     */
    set cryptoKey(value: string);
    /**
     * @stability stable
     */
    get cryptoKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _plaintext?;
    /**
     * @stability stable
     */
    get plaintext(): string;
    /**
     * @stability stable
     */
    set plaintext(value: string);
    /**
     * @stability stable
     */
    get plaintextInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): KmsSecretCiphertextTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KmsSecretCiphertextTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KmsSecretCiphertextTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
