/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_lumino_messaging_dist_index_es6_js"],{

/***/ "../node_modules/@lumino/collections/dist/index.es6.js":
/*!*************************************************************!*\
  !*** ../node_modules/@lumino/collections/dist/index.es6.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BPlusTree\": () => (/* binding */ BPlusTree),\n/* harmony export */   \"LinkedList\": () => (/* binding */ LinkedList)\n/* harmony export */ });\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__);\n\n\n// Copyright (c) Jupyter Development Team.\n/**\n * A generic B+ tree.\n *\n * #### Notes\n * Most operations have `O(log32 n)` or better complexity.\n */\nvar BPlusTree = /** @class */ (function () {\n    /**\n     * Construct a new B+ tree.\n     *\n     * @param cmp - The item comparison function for the tree.\n     */\n    function BPlusTree(cmp) {\n        this._root = new Private.LeafNode();\n        this.cmp = cmp;\n    }\n    Object.defineProperty(BPlusTree.prototype, \"isEmpty\", {\n        /**\n         * Whether the tree is empty.\n         *\n         * #### Complexity\n         * `O(1)`\n         */\n        get: function () {\n            return this._root.size === 0;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(BPlusTree.prototype, \"size\", {\n        /**\n         * The size of the tree.\n         *\n         * #### Complexity\n         * `O(1)`\n         */\n        get: function () {\n            return this._root.size;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(BPlusTree.prototype, \"first\", {\n        /**\n         * The first item in the tree.\n         *\n         * This is `undefined` if the tree is empty.\n         *\n         * #### Complexity\n         * `O(log32 n)`\n         */\n        get: function () {\n            var node = Private.firstLeaf(this._root);\n            return node.size > 0 ? node.items[0] : undefined;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(BPlusTree.prototype, \"last\", {\n        /**\n         * The last item in the tree.\n         *\n         * This is `undefined` if the tree is empty.\n         *\n         * #### Complexity\n         * `O(log32 n)`\n         */\n        get: function () {\n            var node = Private.lastLeaf(this._root);\n            return node.size > 0 ? node.items[node.size - 1] : undefined;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    /**\n     * Create an iterator over the items in the tree.\n     *\n     * @returns A new iterator starting with the first item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.iter = function () {\n        return Private.iterItems(this._root);\n    };\n    /**\n     * Create a reverse iterator over the items in the tree.\n     *\n     * @returns A new iterator starting with the last item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.retro = function () {\n        return Private.retroItems(this._root);\n    };\n    /**\n     * Create an iterator for a slice of items in the tree.\n     *\n     * @param start - The index of the first item, inclusive. This\n     *   should be `< stop`. Negative values are taken as an offset\n     *   from the end of the tree. The default is `0`.\n     *\n     * @param stop - The index of the last item, exclusive. This\n     *   should be `> start`. Negative values are taken as an offset\n     *   from the end of the tree. The default is `size`.\n     *\n     * @returns A new iterator starting with the specified item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.slice = function (start, stop) {\n        return Private.sliceItems(this._root, start, stop);\n    };\n    /**\n     * Create a reverse iterator for a slice of items in the tree.\n     *\n     * @param start - The index of the first item, inclusive. This\n     *   should be `> stop`. Negative values are taken as an offset\n     *   from the end of the tree. The default is `size - 1`.\n     *\n     * @param stop - The index of the last item, exclusive. This\n     *   should be `< start`. Negative values are taken as an offset\n     *   from the end of the tree. The default is `-size - 1`.\n     *\n     * @returns A new reverse iterator starting with the specified item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.retroSlice = function (start, stop) {\n        return Private.retroSliceItems(this._root, start, stop);\n    };\n    /**\n     * Get the item at a particular index.\n     *\n     * @param index - The index of the item of interest. Negative\n     *   values are taken as an offset from the end of the tree.\n     *\n     * @returns The item at the specified index, or `undefined` if\n     *   the index is out of range.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.at = function (index) {\n        return Private.itemAt(this._root, index);\n    };\n    /**\n     * Test whether the tree has an item which matches a key.\n     *\n     * @param key - The key of interest.\n     *\n     * @param cmp - A function which compares an item against the key.\n     *\n     * @returns `true` if the tree has an item which matches the given\n     *   key, `false` otherwise.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.has = function (key, cmp) {\n        return Private.hasItem(this._root, key, cmp);\n    };\n    /**\n     * Get the index of an item which matches a key.\n     *\n     * @param key - The key of interest.\n     *\n     * @param cmp - A function which compares an item against the key.\n     *\n     * @returns The index of the item which matches the given key. A\n     *   negative value means that a matching item does not exist in\n     *   the tree, but if one did it would reside at `-index - 1`.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.indexOf = function (key, cmp) {\n        return Private.indexOf(this._root, key, cmp);\n    };\n    /**\n     * Get the item which matches a key.\n     *\n     * @param item - The key of interest.\n     *\n     * @param cmp - A function which compares an item against the key.\n     *\n     * @returns The item which matches the given key, or `undefined` if\n     *   the tree does not have a matching item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.get = function (key, cmp) {\n        return Private.getItem(this._root, key, cmp);\n    };\n    /**\n     * Assign new items to the tree, replacing all current items.\n     *\n     * @param items - The items to assign to the tree.\n     *\n     * #### Complexity\n     * `O(n log32 n)`\n     */\n    BPlusTree.prototype.assign = function (items) {\n        this.clear();\n        this.update(items);\n    };\n    /**\n     * Insert an item into the tree.\n     *\n     * @param item - The item of interest.\n     *\n     * @returns If the given item matches an existing item in the tree,\n     *   the given item will replace it, and the existing item will be\n     *   returned. Otherwise, this method returns `undefined`.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.insert = function (item) {\n        var existing = Private.insertItem(this._root, item, this.cmp);\n        this._root = Private.maybeSplitRoot(this._root);\n        return existing;\n    };\n    /**\n     * Update the tree with multiple items.\n     *\n     * @param items - The items to insert into the tree.\n     *\n     * #### Complexity\n     * `O(k log32 n)`\n     */\n    BPlusTree.prototype.update = function (items) {\n        var _this = this;\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.each)(items, function (item) { _this.insert(item); });\n    };\n    /**\n     * Delete an item which matches a particular key.\n     *\n     * @param key - The key of interest.\n     *\n     * @param cmp - A function which compares an item against the key.\n     *\n     * @returns The item removed from the tree, or `undefined` if no\n     *   item matched the given key.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.delete = function (key, cmp) {\n        var item = Private.deleteItem(this._root, key, cmp);\n        this._root = Private.maybeExtractRoot(this._root);\n        return item;\n    };\n    /**\n     * Remove an item at a particular index.\n     *\n     * @param index - The index of the item to remove. Negative\n     *   values are taken as an offset from the end of the tree.\n     *\n     * @returns The item removed from the tree, or `undefined` if\n     *   the given index is out of range.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    BPlusTree.prototype.remove = function (index) {\n        var item = Private.removeItem(this._root, index);\n        this._root = Private.maybeExtractRoot(this._root);\n        return item;\n    };\n    /**\n     * Clear the contents of the tree.\n     *\n     * #### Complexity\n     * `O(n)`\n     */\n    BPlusTree.prototype.clear = function () {\n        Private.clear(this._root);\n        this._root = new Private.LeafNode();\n    };\n    return BPlusTree;\n}());\n/**\n * The namespace for the `BPlusTree` class statics.\n */\n(function (BPlusTree) {\n    /**\n     * Create a new B+ tree populated with the given items.\n     *\n     * @param items - The items to add to the tree.\n     *\n     * @param cmp - The item comparison function for the tree.\n     *\n     * @returns A new B+ tree populated with the given items.\n     *\n     * #### Complexity\n     * `O(n log32 n)`\n     */\n    function from(items, cmp) {\n        var tree = new BPlusTree(cmp);\n        tree.assign(items);\n        return tree;\n    }\n    BPlusTree.from = from;\n})(BPlusTree || (BPlusTree = {}));\n/**\n * The namespace for the module implementation details.\n */\nvar Private;\n(function (Private) {\n    /**\n     * A branch node in a B+ tree.\n     */\n    var BranchNode = /** @class */ (function () {\n        function BranchNode() {\n            /**\n             * The left-most item of each child subtree.\n             */\n            this.items = [];\n            /**\n             * The cumulative sizes of each child subtree.\n             */\n            this.sizes = [];\n            /**\n             * The child nodes of this branch node.\n             */\n            this.children = [];\n        }\n        Object.defineProperty(BranchNode.prototype, \"type\", {\n            /**\n             * The discriminated type of the node.\n             */\n            get: function () {\n                return 0 /* Branch */;\n            },\n            enumerable: true,\n            configurable: true\n        });\n        Object.defineProperty(BranchNode.prototype, \"size\", {\n            /**\n             * The total number of items in the subtree.\n             */\n            get: function () {\n                return this.sizes[this.sizes.length - 1];\n            },\n            enumerable: true,\n            configurable: true\n        });\n        Object.defineProperty(BranchNode.prototype, \"width\", {\n            /**\n             * The tree width of the node.\n             */\n            get: function () {\n                return this.children.length;\n            },\n            enumerable: true,\n            configurable: true\n        });\n        return BranchNode;\n    }());\n    Private.BranchNode = BranchNode;\n    /**\n     * A leaf node in a B+ tree.\n     */\n    var LeafNode = /** @class */ (function () {\n        function LeafNode() {\n            /**\n             * The next sibling leaf node of this leaf node.\n             */\n            this.next = null;\n            /**\n             * The previous sibling leaf node of this leaf node.\n             */\n            this.prev = null;\n            /**\n             * The items of the leaf.\n             */\n            this.items = [];\n        }\n        Object.defineProperty(LeafNode.prototype, \"type\", {\n            /**\n             * The discriminated type of the node.\n             */\n            get: function () {\n                return 1 /* Leaf */;\n            },\n            enumerable: true,\n            configurable: true\n        });\n        Object.defineProperty(LeafNode.prototype, \"size\", {\n            /**\n             * The total number of items in the leaf.\n             */\n            get: function () {\n                return this.items.length;\n            },\n            enumerable: true,\n            configurable: true\n        });\n        Object.defineProperty(LeafNode.prototype, \"width\", {\n            /**\n             * The tree width of the node.\n             */\n            get: function () {\n                return this.items.length;\n            },\n            enumerable: true,\n            configurable: true\n        });\n        return LeafNode;\n    }());\n    Private.LeafNode = LeafNode;\n    /**\n     * Get the first leaf node in the tree.\n     *\n     * @param node - The root node of interest.\n     *\n     * @returns The first leaf node in the tree.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function firstLeaf(node) {\n        while (node.type === 0 /* Branch */) {\n            node = node.children[0];\n        }\n        return node;\n    }\n    Private.firstLeaf = firstLeaf;\n    /**\n     * Get the last leaf node in the tree.\n     *\n     * @param node - The root node of interest.\n     *\n     * @returns The last leaf node in the tree.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function lastLeaf(node) {\n        while (node.type === 0 /* Branch */) {\n            node = node.children[node.children.length - 1];\n        }\n        return node;\n    }\n    Private.lastLeaf = lastLeaf;\n    /**\n     * Create a forward iterator for the items in the tree.\n     *\n     * @param node - The root node of interest.\n     *\n     * @returns A new forward iterator starting with the first item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function iterItems(node) {\n        var leaf = firstLeaf(node);\n        return new ForwardIterator(leaf, 0, -1);\n    }\n    Private.iterItems = iterItems;\n    /**\n     * Create a reverse iterator for the items in the tree.\n     *\n     * @param node - The root node of interest.\n     *\n     * @returns A new reverse iterator starting with the last item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function retroItems(node) {\n        var leaf = lastLeaf(node);\n        return new RetroIterator(leaf, leaf.size - 1, -1);\n    }\n    Private.retroItems = retroItems;\n    /**\n     * Create an iterator for a slice of items in the tree.\n     *\n     * @param node - The root node of interest.\n     *\n     * @param start - The index of the first item, inclusive. This\n     *   should be `< stop`. Negative values are taken as an offset\n     *   from the end of the tree. The default is `0`.\n     *\n     * @param stop - The index of the last item, exclusive. This\n     *   should be `> start`. Negative values are taken as an offset\n     *   from the end of the tree. The default is `size`.\n     *\n     * @returns A new iterator starting with the specified item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function sliceItems(node, start, stop) {\n        // Normalize the start index.\n        if (start === undefined) {\n            start = 0;\n        }\n        else if (start < 0) {\n            start = Math.max(0, start + node.size);\n        }\n        else {\n            start = Math.min(start, node.size);\n        }\n        // Normalize the stop index.\n        if (stop === undefined) {\n            stop = node.size;\n        }\n        else if (stop < 0) {\n            stop = Math.max(0, stop + node.size);\n        }\n        else {\n            stop = Math.min(stop, node.size);\n        }\n        // Compute effective count.\n        var count = Math.max(0, stop - start);\n        // Bail early if there is nothing to iterate.\n        if (count === 0) {\n            return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.empty)();\n        }\n        // Find the starting leaf node and local index.\n        while (node.type === 0 /* Branch */) {\n            var i = findPivotIndexByIndex(node.sizes, start);\n            if (i > 0)\n                start -= node.sizes[i - 1];\n            node = node.children[i];\n        }\n        // Return the forward iterator for the range.\n        return new ForwardIterator(node, start, count);\n    }\n    Private.sliceItems = sliceItems;\n    /**\n     * Create a reverse iterator for a slice of items in the tree.\n     *\n     * @param node - The root node of interest.\n     *\n     * @param start - The index of the first item, inclusive. This\n     *   should be `> stop`. Negative values are taken as an offset\n     *   from the end of the tree. The default is `size - 1`.\n     *\n     * @param stop - The index of the last item, exclusive. This\n     *   should be `< start`. Negative values are taken as an offset\n     *   from the end of the tree. The default is `-size - 1`.\n     *\n     * @returns A new reverse iterator starting with the specified item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function retroSliceItems(node, start, stop) {\n        // Normalize the start index.\n        if (start === undefined) {\n            start = node.size - 1;\n        }\n        else if (start < 0) {\n            start = Math.max(-1, start + node.size);\n        }\n        else {\n            start = Math.min(start, node.size - 1);\n        }\n        // Normalize the stop index.\n        if (stop === undefined) {\n            stop = -1;\n        }\n        else if (stop < 0) {\n            stop = Math.max(-1, stop + node.size);\n        }\n        else {\n            stop = Math.min(stop, node.size - 1);\n        }\n        // Compute the effective count.\n        var count = Math.max(0, start - stop);\n        // Bail early if there is nothing to iterate.\n        if (count === 0) {\n            return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.empty)();\n        }\n        // Find the starting leaf node and local index.\n        while (node.type === 0 /* Branch */) {\n            var i = findPivotIndexByIndex(node.sizes, start);\n            if (i > 0)\n                start -= node.sizes[i - 1];\n            node = node.children[i];\n        }\n        // Return the retro iterator for the range.\n        return new RetroIterator(node, start, count);\n    }\n    Private.retroSliceItems = retroSliceItems;\n    /**\n     * Get the item at the specified index.\n     *\n     * @param node - The root node of interest.\n     *\n     * @param index - The index of the item of interest. Negative\n     *   values are taken as an offset from the end of the tree.\n     *\n     * @returns The item at the specified index, or `undefined` if\n     *   the index is out of range.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function itemAt(node, index) {\n        // Wrap negative indices.\n        if (index < 0) {\n            index += node.size;\n        }\n        // Bail early if the index is out of range.\n        if (index < 0 || index >= node.size) {\n            return undefined;\n        }\n        // Find the containing leaf node and local index.\n        while (node.type === 0 /* Branch */) {\n            var i = findPivotIndexByIndex(node.sizes, index);\n            if (i > 0)\n                index -= node.sizes[i - 1];\n            node = node.children[i];\n        }\n        // Return the item at the specified index.\n        return node.items[index];\n    }\n    Private.itemAt = itemAt;\n    /**\n     * Test whether the tree contains an item which matches a key.\n     *\n     * @param node - The root node of interest.\n     *\n     * @param key - The key of interest.\n     *\n     * @param cmp - The key comparison function.\n     *\n     * @returns Whether the tree contains a matching item.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function hasItem(node, key, cmp) {\n        // Find the containing leaf node.\n        while (node.type === 0 /* Branch */) {\n            var i_1 = findPivotIndexByKey(node.items, key, cmp);\n            node = node.children[i_1];\n        }\n        // Find the key index.\n        var i = findKeyIndex(node.items, key, cmp);\n        // Return whether or not the node contains a matching item.\n        return i >= 0;\n    }\n    Private.hasItem = hasItem;\n    /**\n     * Get the index of the item which matches a key.\n     *\n     * @param node - The node of interest.\n     *\n     * @param key - The key of interest.\n     *\n     * @param cmp - The key comparison function.\n     *\n     * @returns The index of the item which matches the given key. A\n     *   negative value means that a matching item does not exist in\n     *   the tree, but if one did it would reside at `-index - 1`.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function indexOf(node, key, cmp) {\n        // Set up the global index.\n        var index = 0;\n        // Find the containing leaf node and global index.\n        while (node.type === 0 /* Branch */) {\n            var i_2 = findPivotIndexByKey(node.items, key, cmp);\n            if (i_2 > 0)\n                index += node.sizes[i_2 - 1];\n            node = node.children[i_2];\n        }\n        // Find the key index.\n        var i = findKeyIndex(node.items, key, cmp);\n        // Return the final computed index.\n        return i >= 0 ? index + i : -index + i;\n    }\n    Private.indexOf = indexOf;\n    /**\n     * Get the item for a particular key.\n     *\n     * @param node - The node of interest.\n     *\n     * @param key - The key of interest.\n     *\n     * @param cmp - The key comparison function.\n     *\n     * @returns The item for the specified key, or `undefined` if\n     *   the tree does not have a matching item for the key.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     */\n    function getItem(node, key, cmp) {\n        // Find the containing leaf node.\n        while (node.type === 0 /* Branch */) {\n            var i_3 = findPivotIndexByKey(node.items, key, cmp);\n            node = node.children[i_3];\n        }\n        // Find the key index.\n        var i = findKeyIndex(node.items, key, cmp);\n        // Return the item for the given key.\n        return i >= 0 ? node.items[i] : undefined;\n    }\n    Private.getItem = getItem;\n    /**\n     * Insert an item into the tree.\n     *\n     * @param node - The root node of interest.\n     *\n     * @param item - The item of interest.\n     *\n     * @param cmp - The item comparison function.\n     *\n     * @returns If the given item matches an existing item in the tree,\n     *   the given item will replace it, and the existing item will be\n     *   returned. Otherwise, this function returns `undefined`.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     *\n     * #### Notes\n     * The root may be overfull after calling this function.\n     */\n    function insertItem(node, item, cmp) {\n        // Handle leaf nodes first.\n        if (node.type === 1 /* Leaf */) {\n            // Find the index for the given item.\n            var i_4 = findKeyIndex(node.items, item, cmp);\n            // Fetch the existing item and insert the new item.\n            var existing_1;\n            if (i_4 >= 0) {\n                existing_1 = node.items[i_4];\n                node.items[i_4] = item;\n            }\n            else {\n                existing_1 = undefined;\n                _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.insert(node.items, -i_4 - 1, item);\n            }\n            // Return the existing item.\n            return existing_1;\n        }\n        // Find the pivot index for the insert.\n        var i = findPivotIndexByKey(node.items, item, cmp);\n        // Fetch the pivot child.\n        var child = node.children[i];\n        // Fetch the current size of the child.\n        var prevSize = child.size;\n        // Recursively insert the item into the child.\n        var existing = insertItem(child, item, cmp);\n        // Fetch the updated size of the child.\n        var currSize = child.size;\n        // Update the item state of the branch.\n        node.items[i] = child.items[0];\n        // Bail early if the child size did not change.\n        if (prevSize === currSize) {\n            return existing;\n        }\n        // Split the child if it's overfull.\n        if (child.width > MAX_NODE_WIDTH) {\n            var next = splitNode(child);\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.insert(node.children, i + 1, next);\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.insert(node.items, i + 1, next.items[0]);\n        }\n        // Update the dirty sizes of the branch.\n        updateSizes(node, i);\n        // Return the existing item.\n        return existing;\n    }\n    Private.insertItem = insertItem;\n    /**\n     * Delete an item in the tree.\n     *\n     * @param node - The node of interest.\n     *\n     * @param key - The key of interest.\n     *\n     * @param cmp - The key comparison function.\n     *\n     * @returns The deleted item or `undefined`.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     *\n     * #### Notes\n     * The root may be underfull after calling this function.\n     */\n    function deleteItem(node, key, cmp) {\n        // Handle leaf nodes first.\n        if (node.type === 1 /* Leaf */) {\n            // Find the index for the given key.\n            var i_5 = findKeyIndex(node.items, key, cmp);\n            // Bail early if the item does not exist.\n            if (i_5 < 0) {\n                return undefined;\n            }\n            // Remove the item at the computed index.\n            return _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.items, i_5);\n        }\n        // Find the pivot index for the delete.\n        var i = findPivotIndexByKey(node.items, key, cmp);\n        // Fetch the pivot child.\n        var child = node.children[i];\n        // Fetch the current size of the child.\n        var prevSize = child.size;\n        // Recursively remove the item from the child.\n        var item = deleteItem(child, key, cmp);\n        // Fetch the updated size of the child.\n        var currSize = child.size;\n        // Bail early if the child size did not change.\n        if (prevSize === currSize) {\n            return item;\n        }\n        // Update the item state of the branch.\n        node.items[i] = child.items[0];\n        // Join the child if it's underfull.\n        if (child.width < MIN_NODE_WIDTH) {\n            i = joinChild(node, i);\n        }\n        // Update the dirty sizes of the branch.\n        updateSizes(node, i);\n        // Return the deleted item.\n        return item;\n    }\n    Private.deleteItem = deleteItem;\n    /**\n     * Remove an item from the tree.\n     *\n     * @param node - The node of interest.\n     *\n     * @param index - The index of interest.\n     *\n     * @returns The removed item or `undefined`.\n     *\n     * #### Complexity\n     * `O(log32 n)`\n     *\n     * #### Notes\n     * The root may be underfull after calling this function.\n     */\n    function removeItem(node, index) {\n        // Wrap negative indices.\n        if (index < 0) {\n            index += node.size;\n        }\n        // Bail early if the index is out of range.\n        if (index < 0 || index >= node.size) {\n            return undefined;\n        }\n        // Handle leaf nodes first.\n        if (node.type === 1 /* Leaf */) {\n            return _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.items, index);\n        }\n        // Find the pivot index for the remove.\n        var i = findPivotIndexByIndex(node.sizes, index);\n        if (i > 0)\n            index -= node.sizes[i];\n        // Fetch the pivot child.\n        var child = node.children[i];\n        // Recursively remove the item from the child.\n        var item = removeItem(child, index);\n        // Update the item state of the branch.\n        node.items[i] = child.items[0];\n        // Join the child if it's underfull.\n        if (child.width < MIN_NODE_WIDTH) {\n            i = joinChild(node, i);\n        }\n        // Update the dirty sizes of the branch.\n        updateSizes(node, i);\n        // Return the removed item.\n        return item;\n    }\n    Private.removeItem = removeItem;\n    /**\n     * Recursively clear the contents of a node.\n     *\n     * @param node - The node of interest.\n     *\n     * #### Complexity\n     * `O(n)`\n     */\n    function clear(node) {\n        if (node.type === 0 /* Branch */) {\n            (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.each)(node.children, clear);\n            node.children.length = 0;\n            node.sizes.length = 0;\n            node.items.length = 0;\n        }\n        else {\n            node.items.length = 0;\n            node.next = null;\n            node.prev = null;\n        }\n    }\n    Private.clear = clear;\n    /**\n     * Split a root node and create a new root, if needed.\n     *\n     * @param node - The root node of interest.\n     *\n     * @returns The new root node.\n     */\n    function maybeSplitRoot(node) {\n        // Bail early if the current root is not overfull.\n        if (node.width <= MAX_NODE_WIDTH) {\n            return node;\n        }\n        // Create a new root branch node.\n        var root = new BranchNode();\n        // Split the node to the right and create a new sibling.\n        var next = splitNode(node);\n        // Add the sizes to the root.\n        root.sizes[0] = node.size;\n        root.sizes[1] = node.size + next.size;\n        // Add the children to the root.\n        root.children[0] = node;\n        root.children[1] = next;\n        // Add the items to the root.\n        root.items[0] = node.items[0];\n        root.items[1] = next.items[0];\n        // Return the new root node.\n        return root;\n    }\n    Private.maybeSplitRoot = maybeSplitRoot;\n    /**\n     * Extract a single node child as a new root, if needed.\n     *\n     * @param node - The root node of interest.\n     *\n     * @returns The new root node.\n     */\n    function maybeExtractRoot(node) {\n        // Bail early if the node it already a leaf.\n        if (node.type === 1 /* Leaf */) {\n            return node;\n        }\n        // Bail early if the branch has more than one child.\n        if (node.children.length > 1) {\n            return node;\n        }\n        // Extract the sole remaining child as the new root.\n        var root = node.children.pop();\n        // Clear the rest of the node state.\n        clear(node);\n        // Return the new root.\n        return root;\n    }\n    Private.maybeExtractRoot = maybeExtractRoot;\n    /**\n     * The maximum width for a node in the tree.\n     */\n    var MAX_NODE_WIDTH = 32;\n    /**\n     * The minimum width for a node in the tree.\n     */\n    var MIN_NODE_WIDTH = MAX_NODE_WIDTH >> 1;\n    /**\n     * A forward iterator for a B+ tree.\n     */\n    var ForwardIterator = /** @class */ (function () {\n        /**\n         * Construct a new forward iterator.\n         *\n         * @param node - The first leaf node in the chain.\n         *\n         * @param index - The local index of the first item.\n         *\n         * @param count - The number of items to iterate. A value `< 0`\n         *   will iterate all available items.\n         */\n        function ForwardIterator(node, index, count) {\n            this._node = node;\n            this._index = index;\n            this._count = count;\n        }\n        /**\n         * Get an iterator over the object's values.\n         *\n         * @returns An iterator which yields the object's values.\n         */\n        ForwardIterator.prototype.iter = function () {\n            return this;\n        };\n        /**\n         * Create an independent clone of the iterator.\n         *\n         * @returns A new independent clone of the iterator.\n         */\n        ForwardIterator.prototype.clone = function () {\n            return new ForwardIterator(this._node, this._index, this._count);\n        };\n        /**\n         * Get the next value from the iterator.\n         *\n         * @returns The next value from the iterator, or `undefined`.\n         */\n        ForwardIterator.prototype.next = function () {\n            if (this._node === null || this._count === 0) {\n                return undefined;\n            }\n            if (this._index >= this._node.size) {\n                this._node = this._node.next;\n                this._index = 0;\n                return this.next();\n            }\n            if (this._count > 0) {\n                this._count--;\n            }\n            return this._node.items[this._index++];\n        };\n        return ForwardIterator;\n    }());\n    /**\n     * A reverse iterator for a B+ tree.\n     */\n    var RetroIterator = /** @class */ (function () {\n        /**\n         * Construct a new retro iterator.\n         *\n         * @param node - The last leaf node in the chain.\n         *\n         * @param index - The local index of the last item.\n         *\n         * @param count - The number of items to iterate. A value `< 0`\n         *   will iterate all available items.\n         */\n        function RetroIterator(node, index, count) {\n            this._node = node;\n            this._index = index;\n            this._count = count;\n        }\n        /**\n         * Get an iterator over the object's values.\n         *\n         * @returns An iterator which yields the object's values.\n         */\n        RetroIterator.prototype.iter = function () {\n            return this;\n        };\n        /**\n         * Create an independent clone of the iterator.\n         *\n         * @returns A new independent clone of the iterator.\n         */\n        RetroIterator.prototype.clone = function () {\n            return new RetroIterator(this._node, this._index, this._count);\n        };\n        /**\n         * Get the next value from the iterator.\n         *\n         * @returns The next value from the iterator, or `undefined`.\n         */\n        RetroIterator.prototype.next = function () {\n            if (this._node === null || this._count === 0) {\n                return undefined;\n            }\n            if (this._index >= this._node.size) {\n                this._index = this._node.size - 1;\n            }\n            if (this._index < 0) {\n                this._node = this._node.prev;\n                this._index = this._node ? this._node.size - 1 : -1;\n                return this.next();\n            }\n            if (this._count > 0) {\n                this._count--;\n            }\n            return this._node.items[this._index--];\n        };\n        return RetroIterator;\n    }());\n    /**\n     * Find the pivot index for a particular local index.\n     */\n    function findPivotIndexByIndex(sizes, index) {\n        var n = sizes.length;\n        for (var i = 0; i < n; ++i) {\n            if (sizes[i] > index) {\n                return i;\n            }\n        }\n        return n - 1;\n    }\n    /**\n     * Find the pivot index for a particular key.\n     */\n    function findPivotIndexByKey(items, key, cmp) {\n        var n = items.length;\n        for (var i = 1; i < n; ++i) {\n            if (cmp(items[i], key) > 0) {\n                return i - 1;\n            }\n        }\n        return n - 1;\n    }\n    /**\n     * Find the key index for a particular key.\n     */\n    function findKeyIndex(items, key, cmp) {\n        var n = items.length;\n        for (var i = 0; i < n; ++i) {\n            var c = cmp(items[i], key);\n            if (c === 0) {\n                return i;\n            }\n            if (c > 0) {\n                return -i - 1;\n            }\n        }\n        return -n - 1;\n    }\n    /**\n     * Update the sizes of a branch node starting at the given index.\n     */\n    function updateSizes(node, i) {\n        var sizes = node.sizes, children = node.children;\n        var last = i > 0 ? sizes[i - 1] : 0;\n        for (var n = children.length; i < n; ++i) {\n            last = sizes[i] = last + children[i].size;\n        }\n        sizes.length = children.length;\n    }\n    /**\n     * Split a node and return its new next sibling.\n     *\n     * @param node - The node of interest.\n     *\n     * @returns The new next sibling node.\n     */\n    function splitNode(node) {\n        // Handle leaf nodes first.\n        if (node.type === 1 /* Leaf */) {\n            // Create the new sibling leaf node.\n            var next_1 = new LeafNode();\n            // Move the items to the new sibling.\n            var v1_1 = node.items;\n            var v2_1 = next_1.items;\n            for (var i = MIN_NODE_WIDTH, n = v1_1.length; i < n; ++i) {\n                v2_1.push(v1_1[i]);\n            }\n            v1_1.length = MIN_NODE_WIDTH;\n            // Patch up the sibling links.\n            if (node.next)\n                node.next.prev = next_1;\n            next_1.next = node.next;\n            next_1.prev = node;\n            node.next = next_1;\n            // Return the new next sibling.\n            return next_1;\n        }\n        // Create the new sibling branch node.\n        var next = new BranchNode();\n        // Move the children to the new sibling.\n        var c1 = node.children;\n        var c2 = next.children;\n        for (var i = MIN_NODE_WIDTH, n = c1.length; i < n; ++i) {\n            c2.push(c1[i]);\n        }\n        c1.length = MIN_NODE_WIDTH;\n        // Move the items to the new sibling.\n        var v1 = node.items;\n        var v2 = next.items;\n        for (var i = MIN_NODE_WIDTH, n = v1.length; i < n; ++i) {\n            v2.push(v1[i]);\n        }\n        v1.length = MIN_NODE_WIDTH;\n        // Update the dirty sizes of the nodes.\n        updateSizes(node, MIN_NODE_WIDTH);\n        updateSizes(next, 0);\n        // Return the new next sibling.\n        return next;\n    }\n    /**\n     * Join a child node of a branch with one of its siblings.\n     *\n     * @param node - The branch node of interest.\n     *\n     * @param i - The index of the child node of interest.\n     *\n     * @returns The first modified index.\n     *\n     * #### Notes\n     * This may cause the branch to become underfull.\n     */\n    function joinChild(node, i) {\n        var _a, _b, _c, _d, _e, _f;\n        // Fetch the child to be joined.\n        var child = node.children[i];\n        // Fetch the relevant sibling.\n        var sibling = i === 0 ? node.children[i + 1] : node.children[i - 1];\n        // Compute the flags which control the join behavior.\n        var hasNext = i === 0;\n        var isLeaf = child.type === 1 /* Leaf */;\n        var hasExtra = sibling.width > MIN_NODE_WIDTH;\n        // Join case #1: steal from next sibling leaf\n        if (isLeaf && hasExtra && hasNext) {\n            // Cast the children as leaves.\n            var c = child;\n            var s = sibling;\n            // Steal an item.\n            c.items.push(s.items.shift());\n            // Update the branch items.\n            node.items[i + 1] = s.items[0];\n            // Return the first modified index.\n            return i;\n        }\n        // Join case #2: steal from previous sibling leaf\n        if (isLeaf && hasExtra && !hasNext) {\n            // Cast the children as leaves.\n            var c = child;\n            var s = sibling;\n            // Steal an item.\n            c.items.unshift(s.items.pop());\n            // Update the branch items.\n            node.items[i] = c.items[0];\n            // Return the first modified index.\n            return i - 1;\n        }\n        // Join case #3: merge with next sibling leaf\n        if (isLeaf && !hasExtra && hasNext) {\n            // Cast the children as leaves.\n            var c = child;\n            var s = sibling;\n            // Merge items.\n            (_a = s.items).unshift.apply(_a, c.items);\n            // Remove the old branch child.\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.children, i);\n            // Remove the stale branch item.\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.items, i + 1);\n            // Patch up the sibling links.\n            if (c.prev)\n                c.prev.next = s;\n            s.prev = c.prev;\n            // Clear the original child.\n            clear(c);\n            // Return the first modified index.\n            return i;\n        }\n        // Join case #4: merge with previous sibling leaf\n        if (isLeaf && !hasExtra && !hasNext) {\n            // Cast the children as leaves.\n            var c = child;\n            var s = sibling;\n            // Merge items.\n            (_b = s.items).push.apply(_b, c.items);\n            // Remove the old branch child.\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.children, i);\n            // Remove the stale branch item.\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.items, i);\n            // Patch up the sibling links.\n            if (c.next)\n                c.next.prev = s;\n            s.next = c.next;\n            // Clear the original child.\n            clear(c);\n            // Return the first modified index.\n            return i - 1;\n        }\n        // Join case #5: steal from next sibling branch\n        if (!isLeaf && hasExtra && hasNext) {\n            // Cast the children to branches.\n            var c = child;\n            var s = sibling;\n            // Steal a child from the next sibling.\n            c.children.push(s.children.shift());\n            // Steal an item from the next sibling.\n            c.items.push(s.items.shift());\n            // Update the branch items.\n            node.items[i + 1] = s.items[0];\n            // Update the sibling sizes.\n            updateSizes(c, c.width - 1);\n            updateSizes(s, 0);\n            // Return the first modified index.\n            return i;\n        }\n        // Join case #6: steal from previous sibling branch\n        if (!isLeaf && hasExtra && !hasNext) {\n            // Cast the children to branches.\n            var c = child;\n            var s = sibling;\n            // Steal a child from the previous sibling.\n            c.children.unshift(s.children.pop());\n            // Steal an item from the previous sibling.\n            c.items.unshift(s.items.pop());\n            // Update the branch items.\n            node.items[i] = c.items[0];\n            // Update the sibling sizes.\n            updateSizes(c, 0);\n            updateSizes(s, s.width - 1);\n            // Return the first modified index.\n            return i - 1;\n        }\n        // Join case #7: merge with next sibling branch\n        if (!isLeaf && !hasExtra && hasNext) {\n            // Cast the children to branches.\n            var c = child;\n            var s = sibling;\n            // Merge the children with the next sibling.\n            (_c = s.children).unshift.apply(_c, c.children);\n            // Merge the items with the next sibling.\n            (_d = s.items).unshift.apply(_d, c.items);\n            // Remove the old branch child.\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.children, i);\n            // Remove the stale branch item.\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.items, i + 1);\n            // Update the sibling sizes.\n            updateSizes(s, 0);\n            // Clear the original child but, not its children.\n            c.children.length = 0;\n            clear(c);\n            // Return the first modified index.\n            return i;\n        }\n        // Join case #8: merge with previous sibling branch\n        if (!isLeaf && !hasExtra && !hasNext) {\n            // Cast the children to branches.\n            var c = child;\n            var s = sibling;\n            // Merge the children with the previous sibling.\n            (_e = s.children).push.apply(_e, c.children);\n            // Merge the items with the previous sibling.\n            (_f = s.items).push.apply(_f, c.items);\n            // Remove the old branch child.\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.children, i);\n            // Remove the stale branch item.\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(node.items, i);\n            // Update the sibling sizes.\n            updateSizes(s, 0);\n            // Clear the original child, but not its children.\n            c.children.length = 0;\n            clear(c);\n            // Return the first modified index.\n            return i - 1;\n        }\n        // One of the above cases must match.\n        throw 'unreachable';\n    }\n})(Private || (Private = {}));\n\n// Copyright (c) Jupyter Development Team.\n/**\n * A generic doubly-linked list.\n */\nvar LinkedList = /** @class */ (function () {\n    /**\n     * Construct a new linked list.\n     */\n    function LinkedList() {\n        this._first = null;\n        this._last = null;\n        this._size = 0;\n    }\n    Object.defineProperty(LinkedList.prototype, \"isEmpty\", {\n        /**\n         * Whether the list is empty.\n         *\n         * #### Complexity\n         * Constant.\n         */\n        get: function () {\n            return this._size === 0;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(LinkedList.prototype, \"size\", {\n        /**\n         * The size of the list.\n         *\n         * #### Complexity\n         * `O(1)`\n         *\n         * #### Notes\n         * This is equivalent to `length`.\n         */\n        get: function () {\n            return this._size;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(LinkedList.prototype, \"length\", {\n        /**\n         * The length of the list.\n         *\n         * #### Complexity\n         * Constant.\n         *\n         * #### Notes\n         * This is equivalent to `size`.\n         *\n         * This property is deprecated.\n         */\n        get: function () {\n            return this._size;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(LinkedList.prototype, \"first\", {\n        /**\n         * The first value in the list.\n         *\n         * This is `undefined` if the list is empty.\n         *\n         * #### Complexity\n         * Constant.\n         */\n        get: function () {\n            return this._first ? this._first.value : undefined;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(LinkedList.prototype, \"last\", {\n        /**\n         * The last value in the list.\n         *\n         * This is `undefined` if the list is empty.\n         *\n         * #### Complexity\n         * Constant.\n         */\n        get: function () {\n            return this._last ? this._last.value : undefined;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(LinkedList.prototype, \"firstNode\", {\n        /**\n         * The first node in the list.\n         *\n         * This is `null` if the list is empty.\n         *\n         * #### Complexity\n         * Constant.\n         */\n        get: function () {\n            return this._first;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    Object.defineProperty(LinkedList.prototype, \"lastNode\", {\n        /**\n         * The last node in the list.\n         *\n         * This is `null` if the list is empty.\n         *\n         * #### Complexity\n         * Constant.\n         */\n        get: function () {\n            return this._last;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    /**\n     * Create an iterator over the values in the list.\n     *\n     * @returns A new iterator starting with the first value.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.iter = function () {\n        return new LinkedList.ForwardValueIterator(this._first);\n    };\n    /**\n     * Create a reverse iterator over the values in the list.\n     *\n     * @returns A new iterator starting with the last value.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.retro = function () {\n        return new LinkedList.RetroValueIterator(this._last);\n    };\n    /**\n     * Create an iterator over the nodes in the list.\n     *\n     * @returns A new iterator starting with the first node.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.nodes = function () {\n        return new LinkedList.ForwardNodeIterator(this._first);\n    };\n    /**\n     * Create a reverse iterator over the nodes in the list.\n     *\n     * @returns A new iterator starting with the last node.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.retroNodes = function () {\n        return new LinkedList.RetroNodeIterator(this._last);\n    };\n    /**\n     * Assign new values to the list, replacing all current values.\n     *\n     * @param values - The values to assign to the list.\n     *\n     * #### Complexity\n     * Linear.\n     */\n    LinkedList.prototype.assign = function (values) {\n        var _this = this;\n        this.clear();\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.each)(values, function (value) { _this.addLast(value); });\n    };\n    /**\n     * Add a value to the end of the list.\n     *\n     * @param value - The value to add to the end of the list.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Notes\n     * This is equivalent to `addLast`.\n     */\n    LinkedList.prototype.push = function (value) {\n        this.addLast(value);\n    };\n    /**\n     * Remove and return the value at the end of the list.\n     *\n     * @returns The removed value, or `undefined` if the list is empty.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Notes\n     * This is equivalent to `removeLast`.\n     */\n    LinkedList.prototype.pop = function () {\n        return this.removeLast();\n    };\n    /**\n     * Add a value to the beginning of the list.\n     *\n     * @param value - The value to add to the beginning of the list.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Notes\n     * This is equivalent to `addFirst`.\n     */\n    LinkedList.prototype.shift = function (value) {\n        this.addFirst(value);\n    };\n    /**\n     * Remove and return the value at the beginning of the list.\n     *\n     * @returns The removed value, or `undefined` if the list is empty.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Notes\n     * This is equivalent to `removeFirst`.\n     */\n    LinkedList.prototype.unshift = function () {\n        return this.removeFirst();\n    };\n    /**\n     * Add a value to the beginning of the list.\n     *\n     * @param value - The value to add to the beginning of the list.\n     *\n     * @returns The list node which holds the value.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.addFirst = function (value) {\n        var node = new Private$1.LinkedListNode(this, value);\n        if (!this._first) {\n            this._first = node;\n            this._last = node;\n        }\n        else {\n            node.next = this._first;\n            this._first.prev = node;\n            this._first = node;\n        }\n        this._size++;\n        return node;\n    };\n    /**\n     * Add a value to the end of the list.\n     *\n     * @param value - The value to add to the end of the list.\n     *\n     * @returns The list node which holds the value.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.addLast = function (value) {\n        var node = new Private$1.LinkedListNode(this, value);\n        if (!this._last) {\n            this._first = node;\n            this._last = node;\n        }\n        else {\n            node.prev = this._last;\n            this._last.next = node;\n            this._last = node;\n        }\n        this._size++;\n        return node;\n    };\n    /**\n     * Insert a value before a specific node in the list.\n     *\n     * @param value - The value to insert before the reference node.\n     *\n     * @param ref - The reference node of interest. If this is `null`,\n     *   the value will be added to the beginning of the list.\n     *\n     * @returns The list node which holds the value.\n     *\n     * #### Notes\n     * The reference node must be owned by the list.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.insertBefore = function (value, ref) {\n        if (!ref || ref === this._first) {\n            return this.addFirst(value);\n        }\n        if (!(ref instanceof Private$1.LinkedListNode) || ref.list !== this) {\n            throw new Error('Reference node is not owned by the list.');\n        }\n        var node = new Private$1.LinkedListNode(this, value);\n        var _ref = ref;\n        var prev = _ref.prev;\n        node.next = _ref;\n        node.prev = prev;\n        _ref.prev = node;\n        prev.next = node;\n        this._size++;\n        return node;\n    };\n    /**\n     * Insert a value after a specific node in the list.\n     *\n     * @param value - The value to insert after the reference node.\n     *\n     * @param ref - The reference node of interest. If this is `null`,\n     *   the value will be added to the end of the list.\n     *\n     * @returns The list node which holds the value.\n     *\n     * #### Notes\n     * The reference node must be owned by the list.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.insertAfter = function (value, ref) {\n        if (!ref || ref === this._last) {\n            return this.addLast(value);\n        }\n        if (!(ref instanceof Private$1.LinkedListNode) || ref.list !== this) {\n            throw new Error('Reference node is not owned by the list.');\n        }\n        var node = new Private$1.LinkedListNode(this, value);\n        var _ref = ref;\n        var next = _ref.next;\n        node.next = next;\n        node.prev = _ref;\n        _ref.next = node;\n        next.prev = node;\n        this._size++;\n        return node;\n    };\n    /**\n     * Remove and return the value at the beginning of the list.\n     *\n     * @returns The removed value, or `undefined` if the list is empty.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.removeFirst = function () {\n        var node = this._first;\n        if (!node) {\n            return undefined;\n        }\n        if (node === this._last) {\n            this._first = null;\n            this._last = null;\n        }\n        else {\n            this._first = node.next;\n            this._first.prev = null;\n        }\n        node.list = null;\n        node.next = null;\n        node.prev = null;\n        this._size--;\n        return node.value;\n    };\n    /**\n     * Remove and return the value at the end of the list.\n     *\n     * @returns The removed value, or `undefined` if the list is empty.\n     *\n     * #### Complexity\n     * Constant.\n     */\n    LinkedList.prototype.removeLast = function () {\n        var node = this._last;\n        if (!node) {\n            return undefined;\n        }\n        if (node === this._first) {\n            this._first = null;\n            this._last = null;\n        }\n        else {\n            this._last = node.prev;\n            this._last.next = null;\n        }\n        node.list = null;\n        node.next = null;\n        node.prev = null;\n        this._size--;\n        return node.value;\n    };\n    /**\n     * Remove a specific node from the list.\n     *\n     * @param node - The node to remove from the list.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Notes\n     * The node must be owned by the list.\n     */\n    LinkedList.prototype.removeNode = function (node) {\n        if (!(node instanceof Private$1.LinkedListNode) || node.list !== this) {\n            throw new Error('Node is not owned by the list.');\n        }\n        var _node = node;\n        if (_node === this._first && _node === this._last) {\n            this._first = null;\n            this._last = null;\n        }\n        else if (_node === this._first) {\n            this._first = _node.next;\n            this._first.prev = null;\n        }\n        else if (_node === this._last) {\n            this._last = _node.prev;\n            this._last.next = null;\n        }\n        else {\n            _node.next.prev = _node.prev;\n            _node.prev.next = _node.next;\n        }\n        _node.list = null;\n        _node.next = null;\n        _node.prev = null;\n        this._size--;\n    };\n    /**\n     * Remove all values from the list.\n     *\n     * #### Complexity\n     * Linear.\n     */\n    LinkedList.prototype.clear = function () {\n        var node = this._first;\n        while (node) {\n            var next = node.next;\n            node.list = null;\n            node.prev = null;\n            node.next = null;\n            node = next;\n        }\n        this._first = null;\n        this._last = null;\n        this._size = 0;\n    };\n    return LinkedList;\n}());\n/**\n * The namespace for the `LinkedList` class statics.\n */\n(function (LinkedList) {\n    /**\n     * Create a linked list from an iterable of values.\n     *\n     * @param values - The iterable or array-like object of interest.\n     *\n     * @returns A new linked list initialized with the given values.\n     *\n     * #### Complexity\n     * Linear.\n     */\n    function from(values) {\n        var list = new LinkedList();\n        list.assign(values);\n        return list;\n    }\n    LinkedList.from = from;\n    /**\n     * A forward iterator for values in a linked list.\n     */\n    var ForwardValueIterator = /** @class */ (function () {\n        /**\n         * Construct a forward value iterator.\n         *\n         * @param node - The first node in the list.\n         */\n        function ForwardValueIterator(node) {\n            this._node = node;\n        }\n        /**\n         * Get an iterator over the object's values.\n         *\n         * @returns An iterator which yields the object's values.\n         */\n        ForwardValueIterator.prototype.iter = function () {\n            return this;\n        };\n        /**\n         * Create an independent clone of the iterator.\n         *\n         * @returns A new independent clone of the iterator.\n         */\n        ForwardValueIterator.prototype.clone = function () {\n            return new ForwardValueIterator(this._node);\n        };\n        /**\n         * Get the next value from the iterator.\n         *\n         * @returns The next value from the iterator, or `undefined`.\n         */\n        ForwardValueIterator.prototype.next = function () {\n            if (!this._node) {\n                return undefined;\n            }\n            var node = this._node;\n            this._node = node.next;\n            return node.value;\n        };\n        return ForwardValueIterator;\n    }());\n    LinkedList.ForwardValueIterator = ForwardValueIterator;\n    /**\n     * A reverse iterator for values in a linked list.\n     */\n    var RetroValueIterator = /** @class */ (function () {\n        /**\n         * Construct a retro value iterator.\n         *\n         * @param node - The last node in the list.\n         */\n        function RetroValueIterator(node) {\n            this._node = node;\n        }\n        /**\n         * Get an iterator over the object's values.\n         *\n         * @returns An iterator which yields the object's values.\n         */\n        RetroValueIterator.prototype.iter = function () {\n            return this;\n        };\n        /**\n         * Create an independent clone of the iterator.\n         *\n         * @returns A new independent clone of the iterator.\n         */\n        RetroValueIterator.prototype.clone = function () {\n            return new RetroValueIterator(this._node);\n        };\n        /**\n         * Get the next value from the iterator.\n         *\n         * @returns The next value from the iterator, or `undefined`.\n         */\n        RetroValueIterator.prototype.next = function () {\n            if (!this._node) {\n                return undefined;\n            }\n            var node = this._node;\n            this._node = node.prev;\n            return node.value;\n        };\n        return RetroValueIterator;\n    }());\n    LinkedList.RetroValueIterator = RetroValueIterator;\n    /**\n     * A forward iterator for nodes in a linked list.\n     */\n    var ForwardNodeIterator = /** @class */ (function () {\n        /**\n         * Construct a forward node iterator.\n         *\n         * @param node - The first node in the list.\n         */\n        function ForwardNodeIterator(node) {\n            this._node = node;\n        }\n        /**\n         * Get an iterator over the object's values.\n         *\n         * @returns An iterator which yields the object's values.\n         */\n        ForwardNodeIterator.prototype.iter = function () {\n            return this;\n        };\n        /**\n         * Create an independent clone of the iterator.\n         *\n         * @returns A new independent clone of the iterator.\n         */\n        ForwardNodeIterator.prototype.clone = function () {\n            return new ForwardNodeIterator(this._node);\n        };\n        /**\n         * Get the next value from the iterator.\n         *\n         * @returns The next value from the iterator, or `undefined`.\n         */\n        ForwardNodeIterator.prototype.next = function () {\n            if (!this._node) {\n                return undefined;\n            }\n            var node = this._node;\n            this._node = node.next;\n            return node;\n        };\n        return ForwardNodeIterator;\n    }());\n    LinkedList.ForwardNodeIterator = ForwardNodeIterator;\n    /**\n     * A reverse iterator for nodes in a linked list.\n     */\n    var RetroNodeIterator = /** @class */ (function () {\n        /**\n         * Construct a retro node iterator.\n         *\n         * @param node - The last node in the list.\n         */\n        function RetroNodeIterator(node) {\n            this._node = node;\n        }\n        /**\n         * Get an iterator over the object's values.\n         *\n         * @returns An iterator which yields the object's values.\n         */\n        RetroNodeIterator.prototype.iter = function () {\n            return this;\n        };\n        /**\n         * Create an independent clone of the iterator.\n         *\n         * @returns A new independent clone of the iterator.\n         */\n        RetroNodeIterator.prototype.clone = function () {\n            return new RetroNodeIterator(this._node);\n        };\n        /**\n         * Get the next value from the iterator.\n         *\n         * @returns The next value from the iterator, or `undefined`.\n         */\n        RetroNodeIterator.prototype.next = function () {\n            if (!this._node) {\n                return undefined;\n            }\n            var node = this._node;\n            this._node = node.prev;\n            return node;\n        };\n        return RetroNodeIterator;\n    }());\n    LinkedList.RetroNodeIterator = RetroNodeIterator;\n})(LinkedList || (LinkedList = {}));\n/**\n * The namespace for the module implementation details.\n */\nvar Private$1;\n(function (Private) {\n    /**\n     * The internal linked list node implementation.\n     */\n    var LinkedListNode = /** @class */ (function () {\n        /**\n         * Construct a new linked list node.\n         *\n         * @param list - The list which owns the node.\n         *\n         * @param value - The value for the link.\n         */\n        function LinkedListNode(list, value) {\n            /**\n             * The linked list which created and owns the node.\n             */\n            this.list = null;\n            /**\n             * The next node in the list.\n             */\n            this.next = null;\n            /**\n             * The previous node in the list.\n             */\n            this.prev = null;\n            this.list = list;\n            this.value = value;\n        }\n        return LinkedListNode;\n    }());\n    Private.LinkedListNode = LinkedListNode;\n})(Private$1 || (Private$1 = {}));\n\n\n//# sourceMappingURL=index.es6.js.map\n\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@lumino/collections/dist/index.es6.js?");

/***/ }),

/***/ "../node_modules/@lumino/messaging/dist/index.es6.js":
/*!***********************************************************!*\
  !*** ../node_modules/@lumino/messaging/dist/index.es6.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ConflatableMessage\": () => (/* binding */ ConflatableMessage),\n/* harmony export */   \"Message\": () => (/* binding */ Message),\n/* harmony export */   \"MessageLoop\": () => (/* binding */ MessageLoop)\n/* harmony export */ });\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_collections__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/collections */ \"../node_modules/@lumino/collections/dist/index.es6.js\");\n\n\n\n/*! *****************************************************************************\r\nCopyright (c) Microsoft Corporation. All rights reserved.\r\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\nthis file except in compliance with the License. You may obtain a copy of the\r\nLicense at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\nMERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\nSee the Apache Version 2.0 License for specific language governing permissions\r\nand limitations under the License.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\n\n/**\n * A message which can be delivered to a message handler.\n *\n * #### Notes\n * This class may be subclassed to create complex message types.\n */\nvar Message = /** @class */ (function () {\n    /**\n     * Construct a new message.\n     *\n     * @param type - The type of the message.\n     */\n    function Message(type) {\n        this.type = type;\n    }\n    Object.defineProperty(Message.prototype, \"isConflatable\", {\n        /**\n         * Test whether the message is conflatable.\n         *\n         * #### Notes\n         * Message conflation is an advanced topic. Most message types will\n         * not make use of this feature.\n         *\n         * If a conflatable message is posted to a handler while another\n         * conflatable message of the same `type` has already been posted\n         * to the handler, the `conflate()` method of the existing message\n         * will be invoked. If that method returns `true`, the new message\n         * will not be enqueued. This allows messages to be compressed, so\n         * that only a single instance of the message type is processed per\n         * cycle, no matter how many times messages of that type are posted.\n         *\n         * Custom message types may reimplement this property.\n         *\n         * The default implementation is always `false`.\n         */\n        get: function () {\n            return false;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    /**\n     * Conflate this message with another message of the same `type`.\n     *\n     * @param other - A conflatable message of the same `type`.\n     *\n     * @returns `true` if the message was successfully conflated, or\n     *   `false` otherwise.\n     *\n     * #### Notes\n     * Message conflation is an advanced topic. Most message types will\n     * not make use of this feature.\n     *\n     * This method is called automatically by the message loop when the\n     * given message is posted to the handler paired with this message.\n     * This message will already be enqueued and conflatable, and the\n     * given message will have the same `type` and also be conflatable.\n     *\n     * This method should merge the state of the other message into this\n     * message as needed so that when this message is finally delivered\n     * to the handler, it receives the most up-to-date information.\n     *\n     * If this method returns `true`, it signals that the other message\n     * was successfully conflated and that message will not be enqueued.\n     *\n     * If this method returns `false`, the other message will be enqueued\n     * for normal delivery.\n     *\n     * Custom message types may reimplement this method.\n     *\n     * The default implementation always returns `false`.\n     */\n    Message.prototype.conflate = function (other) {\n        return false;\n    };\n    return Message;\n}());\n/**\n * A convenience message class which conflates automatically.\n *\n * #### Notes\n * Message conflation is an advanced topic. Most user code will not\n * make use of this class.\n *\n * This message class is useful for creating message instances which\n * should be conflated, but which have no state other than `type`.\n *\n * If conflation of stateful messages is required, a custom `Message`\n * subclass should be created.\n */\nvar ConflatableMessage = /** @class */ (function (_super) {\n    __extends(ConflatableMessage, _super);\n    function ConflatableMessage() {\n        return _super !== null && _super.apply(this, arguments) || this;\n    }\n    Object.defineProperty(ConflatableMessage.prototype, \"isConflatable\", {\n        /**\n         * Test whether the message is conflatable.\n         *\n         * #### Notes\n         * This property is always `true`.\n         */\n        get: function () {\n            return true;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    /**\n     * Conflate this message with another message of the same `type`.\n     *\n     * #### Notes\n     * This method always returns `true`.\n     */\n    ConflatableMessage.prototype.conflate = function (other) {\n        return true;\n    };\n    return ConflatableMessage;\n}(Message));\n/**\n * The namespace for the global singleton message loop.\n */\nvar MessageLoop;\n(function (MessageLoop) {\n    /**\n     * Send a message to a message handler to process immediately.\n     *\n     * @param handler - The handler which should process the message.\n     *\n     * @param msg - The message to deliver to the handler.\n     *\n     * #### Notes\n     * The message will first be sent through any installed message hooks\n     * for the handler. If the message passes all hooks, it will then be\n     * delivered to the `processMessage` method of the handler.\n     *\n     * The message will not be conflated with pending posted messages.\n     *\n     * Exceptions in hooks and handlers will be caught and logged.\n     */\n    function sendMessage(handler, msg) {\n        // Lookup the message hooks for the handler.\n        var hooks = messageHooks.get(handler);\n        // Handle the common case of no installed hooks.\n        if (!hooks || hooks.length === 0) {\n            invokeHandler(handler, msg);\n            return;\n        }\n        // Invoke the message hooks starting with the newest first.\n        var passed = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.every)((0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.retro)(hooks), function (hook) {\n            return hook ? invokeHook(hook, handler, msg) : true;\n        });\n        // Invoke the handler if the message passes all hooks.\n        if (passed) {\n            invokeHandler(handler, msg);\n        }\n    }\n    MessageLoop.sendMessage = sendMessage;\n    /**\n     * Post a message to a message handler to process in the future.\n     *\n     * @param handler - The handler which should process the message.\n     *\n     * @param msg - The message to post to the handler.\n     *\n     * #### Notes\n     * The message will be conflated with the pending posted messages for\n     * the handler, if possible. If the message is not conflated, it will\n     * be queued for normal delivery on the next cycle of the event loop.\n     *\n     * Exceptions in hooks and handlers will be caught and logged.\n     */\n    function postMessage(handler, msg) {\n        // Handle the common case of a non-conflatable message.\n        if (!msg.isConflatable) {\n            enqueueMessage(handler, msg);\n            return;\n        }\n        // Conflate the message with an existing message if possible.\n        var conflated = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.some)(messageQueue, function (posted) {\n            if (posted.handler !== handler) {\n                return false;\n            }\n            if (!posted.msg) {\n                return false;\n            }\n            if (posted.msg.type !== msg.type) {\n                return false;\n            }\n            if (!posted.msg.isConflatable) {\n                return false;\n            }\n            return posted.msg.conflate(msg);\n        });\n        // Enqueue the message if it was not conflated.\n        if (!conflated) {\n            enqueueMessage(handler, msg);\n        }\n    }\n    MessageLoop.postMessage = postMessage;\n    /**\n     * Install a message hook for a message handler.\n     *\n     * @param handler - The message handler of interest.\n     *\n     * @param hook - The message hook to install.\n     *\n     * #### Notes\n     * A message hook is invoked before a message is delivered to the\n     * handler. If the hook returns `false`, no other hooks will be\n     * invoked and the message will not be delivered to the handler.\n     *\n     * The most recently installed message hook is executed first.\n     *\n     * If the hook is already installed, this is a no-op.\n     */\n    function installMessageHook(handler, hook) {\n        // Lookup the hooks for the handler.\n        var hooks = messageHooks.get(handler);\n        // Bail early if the hook is already installed.\n        if (hooks && hooks.indexOf(hook) !== -1) {\n            return;\n        }\n        // Add the hook to the end, so it will be the first to execute.\n        if (!hooks) {\n            messageHooks.set(handler, [hook]);\n        }\n        else {\n            hooks.push(hook);\n        }\n    }\n    MessageLoop.installMessageHook = installMessageHook;\n    /**\n     * Remove an installed message hook for a message handler.\n     *\n     * @param handler - The message handler of interest.\n     *\n     * @param hook - The message hook to remove.\n     *\n     * #### Notes\n     * It is safe to call this function while the hook is executing.\n     *\n     * If the hook is not installed, this is a no-op.\n     */\n    function removeMessageHook(handler, hook) {\n        // Lookup the hooks for the handler.\n        var hooks = messageHooks.get(handler);\n        // Bail early if the hooks do not exist.\n        if (!hooks) {\n            return;\n        }\n        // Lookup the index of the hook and bail if not found.\n        var i = hooks.indexOf(hook);\n        if (i === -1) {\n            return;\n        }\n        // Clear the hook and schedule a cleanup of the array.\n        hooks[i] = null;\n        scheduleCleanup(hooks);\n    }\n    MessageLoop.removeMessageHook = removeMessageHook;\n    /**\n     * Clear all message data associated with a message handler.\n     *\n     * @param handler - The message handler of interest.\n     *\n     * #### Notes\n     * This will clear all posted messages and hooks for the handler.\n     */\n    function clearData(handler) {\n        // Lookup the hooks for the handler.\n        var hooks = messageHooks.get(handler);\n        // Clear all messsage hooks for the handler.\n        if (hooks && hooks.length > 0) {\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.fill(hooks, null);\n            scheduleCleanup(hooks);\n        }\n        // Clear all posted messages for the handler.\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.each)(messageQueue, function (posted) {\n            if (posted.handler === handler) {\n                posted.handler = null;\n                posted.msg = null;\n            }\n        });\n    }\n    MessageLoop.clearData = clearData;\n    /**\n     * Process the pending posted messages in the queue immediately.\n     *\n     * #### Notes\n     * This function is useful when posted messages must be processed\n     * immediately, instead of on the next animation frame.\n     *\n     * This function should normally not be needed, but it may be\n     * required to work around certain browser idiosyncrasies.\n     *\n     * Recursing into this function is a no-op.\n     */\n    function flush() {\n        // Bail if recursion is detected or if there is no pending task.\n        if (flushGuard || loopTaskID === 0) {\n            return;\n        }\n        // Unschedule the pending loop task.\n        unschedule(loopTaskID);\n        // Run the message loop within the recursion guard.\n        flushGuard = true;\n        runMessageLoop();\n        flushGuard = false;\n    }\n    MessageLoop.flush = flush;\n    /**\n     * Get the message loop exception handler.\n     *\n     * @returns The current exception handler.\n     *\n     * #### Notes\n     * The default exception handler is `console.error`.\n     */\n    function getExceptionHandler() {\n        return exceptionHandler;\n    }\n    MessageLoop.getExceptionHandler = getExceptionHandler;\n    /**\n     * Set the message loop exception handler.\n     *\n     * @param handler - The function to use as the exception handler.\n     *\n     * @returns The old exception handler.\n     *\n     * #### Notes\n     * The exception handler is invoked when a message handler or a\n     * message hook throws an exception.\n     */\n    function setExceptionHandler(handler) {\n        var old = exceptionHandler;\n        exceptionHandler = handler;\n        return old;\n    }\n    MessageLoop.setExceptionHandler = setExceptionHandler;\n    /**\n     * The queue of posted message pairs.\n     */\n    var messageQueue = new _lumino_collections__WEBPACK_IMPORTED_MODULE_1__.LinkedList();\n    /**\n     * A mapping of handler to array of installed message hooks.\n     */\n    var messageHooks = new WeakMap();\n    /**\n     * A set of message hook arrays which are pending cleanup.\n     */\n    var dirtySet = new Set();\n    /**\n     * The message loop exception handler.\n     */\n    var exceptionHandler = function (err) {\n        console.error(err);\n    };\n    /**\n     * The id of the pending loop task animation frame.\n     */\n    var loopTaskID = 0;\n    /**\n     * A guard flag to prevent flush recursion.\n     */\n    var flushGuard = false;\n    /**\n     * A function to schedule an event loop callback.\n     */\n    var schedule = (function () {\n        var ok = typeof requestAnimationFrame === 'function';\n        return ok ? requestAnimationFrame : setImmediate;\n    })();\n    /**\n     * A function to unschedule an event loop callback.\n     */\n    var unschedule = (function () {\n        var ok = typeof cancelAnimationFrame === 'function';\n        return ok ? cancelAnimationFrame : clearImmediate;\n    })();\n    /**\n     * Invoke a message hook with the specified handler and message.\n     *\n     * Returns the result of the hook, or `true` if the hook throws.\n     *\n     * Exceptions in the hook will be caught and logged.\n     */\n    function invokeHook(hook, handler, msg) {\n        var result = true;\n        try {\n            if (typeof hook === 'function') {\n                result = hook(handler, msg);\n            }\n            else {\n                result = hook.messageHook(handler, msg);\n            }\n        }\n        catch (err) {\n            exceptionHandler(err);\n        }\n        return result;\n    }\n    /**\n     * Invoke a message handler with the specified message.\n     *\n     * Exceptions in the handler will be caught and logged.\n     */\n    function invokeHandler(handler, msg) {\n        try {\n            handler.processMessage(msg);\n        }\n        catch (err) {\n            exceptionHandler(err);\n        }\n    }\n    /**\n     * Add a message to the end of the message queue.\n     *\n     * This will automatically schedule a run of the message loop.\n     */\n    function enqueueMessage(handler, msg) {\n        // Add the posted message to the queue.\n        messageQueue.addLast({ handler: handler, msg: msg });\n        // Bail if a loop task is already pending.\n        if (loopTaskID !== 0) {\n            return;\n        }\n        // Schedule a run of the message loop.\n        loopTaskID = schedule(runMessageLoop);\n    }\n    /**\n     * Run an iteration of the message loop.\n     *\n     * This will process all pending messages in the queue. If a message\n     * is added to the queue while the message loop is running, it will\n     * be processed on the next cycle of the loop.\n     */\n    function runMessageLoop() {\n        // Clear the task ID so the next loop can be scheduled.\n        loopTaskID = 0;\n        // If the message queue is empty, there is nothing else to do.\n        if (messageQueue.isEmpty) {\n            return;\n        }\n        // Add a sentinel value to the end of the queue. The queue will\n        // only be processed up to the sentinel. Messages posted during\n        // this cycle will execute on the next cycle.\n        var sentinel = { handler: null, msg: null };\n        messageQueue.addLast(sentinel);\n        // Enter the message loop.\n        while (true) {\n            // Remove the first posted message in the queue.\n            var posted = messageQueue.removeFirst();\n            // If the value is the sentinel, exit the loop.\n            if (posted === sentinel) {\n                return;\n            }\n            // Dispatch the message if it has not been cleared.\n            if (posted.handler && posted.msg) {\n                sendMessage(posted.handler, posted.msg);\n            }\n        }\n    }\n    /**\n     * Schedule a cleanup of a message hooks array.\n     *\n     * This will add the array to the dirty set and schedule a deferred\n     * cleanup of the array contents. On cleanup, any `null` hook will\n     * be removed from the array.\n     */\n    function scheduleCleanup(hooks) {\n        if (dirtySet.size === 0) {\n            schedule(cleanupDirtySet);\n        }\n        dirtySet.add(hooks);\n    }\n    /**\n     * Cleanup the message hook arrays in the dirty set.\n     *\n     * This function should only be invoked asynchronously, when the\n     * stack frame is guaranteed to not be on the path of user code.\n     */\n    function cleanupDirtySet() {\n        dirtySet.forEach(cleanupHooks);\n        dirtySet.clear();\n    }\n    /**\n     * Cleanup the dirty hooks in a message hooks array.\n     *\n     * This will remove any `null` hook from the array.\n     *\n     * This function should only be invoked asynchronously, when the\n     * stack frame is guaranteed to not be on the path of user code.\n     */\n    function cleanupHooks(hooks) {\n        _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAllWhere(hooks, isNull);\n    }\n    /**\n     * Test whether a value is `null`.\n     */\n    function isNull(value) {\n        return value === null;\n    }\n})(MessageLoop || (MessageLoop = {}));\n\n\n//# sourceMappingURL=index.es6.js.map\n\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@lumino/messaging/dist/index.es6.js?");

/***/ })

}]);