# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['datagen',
 'datagen.api',
 'datagen.api.catalog',
 'datagen.api.catalog.hooks',
 'datagen.api.client',
 'datagen.api.datapoint',
 'datagen.api.requests',
 'datagen.api.requests.datapoint',
 'datagen.components',
 'datagen.components.datapoint',
 'datagen.components.datapoint.entity',
 'datagen.config',
 'datagen.core',
 'datagen.core.tasks',
 'datagen.dev',
 'datagen.imaging',
 'datagen.modalities',
 'datagen.modalities.textual',
 'datagen.modalities.textual.base',
 'datagen.modalities.textual.common',
 'datagen.modalities.textual.hic',
 'datagen.modalities.textual.identities',
 'datagen.modalities.textual.identities.keypoints',
 'datagen.utilities']

package_data = \
{'': ['*'],
 'datagen.api.catalog': ['cache/backgrounds.json',
                         'cache/backgrounds.json',
                         'cache/backgrounds.json',
                         'cache/backgrounds.json',
                         'cache/backgrounds.json',
                         'cache/backgrounds.json',
                         'cache/backgrounds.json',
                         'cache/beards.json',
                         'cache/beards.json',
                         'cache/beards.json',
                         'cache/beards.json',
                         'cache/beards.json',
                         'cache/beards.json',
                         'cache/beards.json',
                         'cache/eyebrows.json',
                         'cache/eyebrows.json',
                         'cache/eyebrows.json',
                         'cache/eyebrows.json',
                         'cache/eyebrows.json',
                         'cache/eyebrows.json',
                         'cache/eyebrows.json',
                         'cache/eyes.json',
                         'cache/eyes.json',
                         'cache/eyes.json',
                         'cache/eyes.json',
                         'cache/eyes.json',
                         'cache/eyes.json',
                         'cache/eyes.json',
                         'cache/glasses.json',
                         'cache/glasses.json',
                         'cache/glasses.json',
                         'cache/glasses.json',
                         'cache/glasses.json',
                         'cache/glasses.json',
                         'cache/glasses.json',
                         'cache/hair.json',
                         'cache/hair.json',
                         'cache/hair.json',
                         'cache/hair.json',
                         'cache/hair.json',
                         'cache/hair.json',
                         'cache/hair.json',
                         'cache/hic/*',
                         'cache/humans/*',
                         'cache/masks.json',
                         'cache/masks.json',
                         'cache/masks.json',
                         'cache/masks.json',
                         'cache/masks.json',
                         'cache/masks.json',
                         'cache/masks.json']}

install_requires = \
['aiofiles>=23.1.0,<24.0.0',
 'aiohttp>=3.8,<4.0',
 'appdirs>=1.4,<2.0',
 'asyncio-channel>=0.9.1,<0.10.0',
 'datagen-protocol-functional==0.22.0',
 'dependency-injector>4.6',
 'dynaconf>=2.2.3,<3.0.0',
 'importlib-metadata<5.0.0',
 'marshmallow-dataclass>=6',
 'marshmallow-enum>=1.5',
 'nest-asyncio>=1.5.6,<2.0.0',
 'opencv-python>=4.4,<5.0',
 'pandas>=1.1,<2.0',
 'pydantic>=1.9,<2.0',
 'requests>=2.28.1,<3.0.0',
 'rich>=12.5,<13.0']

extras_require = \
{':python_full_version >= "3.6.7" and python_version < "3.7"': ['numpy>=1.15,<2.0'],
 ':python_version >= "3.7" and python_version < "3.8"': ['numpy>=1.19,<2.0'],
 ':python_version >= "3.8" and python_version < "3.9"': ['numpy>=1.20,<2.0'],
 ':python_version >= "3.9"': ['numpy>=1.20,<2.0'],
 'camera-utils:python_version < "3.9"': ['scipy>=1.5,<2.0', 'scipy>=1.5,<2.0'],
 'camera-utils:python_version >= "3.9" and python_version < "4.0"': ['scipy>=1.9,<2.0',
                                                                     'scipy>=1.9,<2.0']}

setup_kwargs = {
    'name': 'datagen-tech',
    'version': '1.10.0rc1',
    'description': 'Datagen SDK',
    'long_description': '# The Datagen SDK Python Package\n\n## About Datagen\n\nDatagen is powering the AI revolution by providing high-performance synthetic data, with a focus on data for human-centric computer vision applications. \n\nDatagen provides a powerful platform that allows you to generate high-quality and high variance, domain-specific, simulated synthetic data, granting you the ability to simulate dynamic humans and objects in their context. With Datagen, CV engineers have unparalleled flexibility to control visual outcomes across a broad spectrum of 3D environments.\n\n## About this package\n\nDatagen has developed a set of Python-based user tools for accessing and loading the rendered images and metadata that you generate on our platform. This package is designed to load our synthetic data into your Python environment, whether as part of your training set or as part of your testing set. \n\nThe abstraction layer we designed gives you access to all of the modalities we offer: facial landmarks, eye gaze vectors, depth and normal maps, and more. \n\n## Installation\n\nBefore installing this package, we recommend that you create a new Conda environment using the following command:\n\n> conda create --name datagen-env\n\nNext, activate the environment using this command:\n\n> conda activate datagen-env\n\nFinally, use this command to install the Datagen package itself:\n\n> pip install datagen-tech\n\n# Using This Package\n\nThis package contains Python objects and functions that are designed to process datasets generated with the Datagen Platform. If you are a Datagen customer, you have already been given access to sample datasets and jupyter notebook tutorials. If you are not a Datagen customer, contact our support team at support@datagen.tech.\n\n## Importing the SDK\n\nTo import the sdk, use the command `import datagen` or, if you prefer, `import datagen as dg`. For the rest of this tutorial we will use the latter.\n\n## Datasets\n\nA "dataset" is any collection of datapoints that were generated on the Datgen platform. Each datapoint is a single visual spectrum image accompanied by visual and textual metadata.\n\n### Loading a dataset\n\nThe `dg.load()` command stores one or more datasets into a `Dataset` object. It can accept any number of target folders at once, merging them into one large dataset so you can conduct operations on all of them together. \n\nThis command is fully backwards-compatible. If you use the platform\'s newest features in your dataset, you can still load that dataset together with older datasets that predate those features.\n\nWhen using this command, you should target the top-level folder of each dataset (the folder that contains one or more subfolders named "scene").  For example:\n\n```\ndataset = dg.load("/path/to/datagen/datasets/eye-gaze-forward", "/path/to/datagen/datasets/expression-smiles")\n```\n\nThe above line of sample code loads a dataset found in a folder named "eye-gaze-forward" as well as a dataset found in a folder named "expression-smiles", merging their datapoints into a single dataset.\n\n### Working with your dataset\n\nYou can iterate over your dataset in three different ways: by scene, by camera, or by datapoint.\n\n### Scenes\n\n#### What is a scene?\n\nA "scene" refers to a 3D environment that contains one or more 3D objects. For example, each scene that is created in our Faces generator consists of a single human face, wearing a specific expression, and located in a static position.\n\nWhen generating a dataset on our Faces platform, you have the option of rendering each scene in multiple ways: through more than one camera, each with different settings; and under more than one lighting scenario, each with different backgrounds. Therefore, depending on the settings you used when you generated this dataset, each scene can be depicted in anywhere between one and over 30 rendered images.\n\n#### The `Scene` object\n\nEach dataset contains an iterable set of `Scene` objects. To retrieve this set, use `dataset.scenes`. To refer to an individual scene in a dataset, use `dataset.scenes[0]`.\n\nThe `Scene` object contains a set of rendered images that all depict the same subject, but from different angles and under different lighting scenarios. Each of these images, along with its metadata, is called a "datapoint". You can access a scene\'s datapoints by subscription:\n\n```\nscene = dataset.scenes[0]\ndatapoint = scene[0]\n```\n\nOr by iterating over the scene:\n\n```\nfor datapoint in scene:\n    ...\n```\n\n**Note:** In older datasets generated by our platform, scenes were previously named "environments". The package supports both formats.\n\n### Cameras\n\n#### What is a camera?\n\nA "camera" refers to a set of rendered images that were taken of a specific scene, from a specific angle, under specific camera settings - but each one shows the scene under a different lighting scenario. When you generated this dataset, you selected one or more lighting scenarios; that selection determines the number of rendered images per camera.\n\n#### The `Camera` object\n\nEach scene contains an iterable list of `Camera` objects. To retrieve this set, use scene`scene.cameras`. To refer to an individual camera in a scene, use `scene.cameras[0]`.\n\nThe `Camera` object contains a set of rendered images that all depict the same subject from the same angle, but under different lighting scenarios. Each of these images, along with its metadata, is called a "datapoint". You can access a camera\'s datapoints by subscription:\n\n```\nscene = dataset.scenes[0]\ncamera = scene.cameras[0]\ndatapoint = camera[0]\n```\n\nOr by iterating over the camera:\n\n```\nfor datapoint in camera:\n    ...\n```\n\n### Datapoints\n\n#### What is a datapoint?\n\nA "datapoint" refers to a single rendered image of a synthetic human subject, along with all of its metadata. That metadata includes all of Datagen\'s modalities: normal and depth maps, facial landmark coordinates, camera and actor metadata, and more.\n\n#### The `Datapoint` object\n\nA `Datapoint` object consists of a visual spectrum image annotated by additional visual and textual data files:\n\n* The visual spectrum image depicts the scene from the point of view of a specific camera under a specific lighting scenario.\n\n* The annotations contain metadata that is specific to that image.\n\nFor example, each `Datapoint` object contains 2D coordinates for facial landmarks, identifying where those landmark can be found in the visual spectrum image.\n\nYou can use tab autocompletion to view the full list of available objects in the `Datapoint` object. For example, you can use the following command to access the visual spectrum image of the subject:\n\n```\nimshow(datapoint.visible_spectrum)\n```\n\nAnd this one to access a normal map of the subject:\n\n```\nimshow(datapoint.normals_map)\n```\n\nTextual annotations are organized in a hierarchy. `datapoint.actor_metadata.face_expression` gives you the description of the subject\'s facial expression, while `datapoint.semantic_segmentation_metadata.nose` gives you the RGB value that represents the nose in the accompanying semantic segmentation map.\n',
    'author': 'Datagen Technologies Ltd.',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://gitlab.com/datagen1/core/sdk',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
