/// Files: drivers/accessibility/speakup/spk_ttyio.c drivers/staging/speakup/spk_ttyio.c
/// Fix: f0992098cadb4c9c6a00703b66cafe604e178fea
/// Detect-To: 6b9ad1c742bf227b1005a41d8baa315b747e3e8d

virtual detect

@receive_buf2 exists@
identifier read_buff_add;
@@

spk_ttyio_receive_buf2(...)
{
	... when any
	spk_ttyio_synth->read_buff_add
	... when any
}

@err_spk_ttyio_ldisc_open depends on receive_buf2 exists@
identifier tty;
position p;
@@

* spk_ttyio_ldisc_open@p(struct tty_struct *tty)
{
	... when != if (tty != speakup_tty) return -ENODEV;
	return 0;
}

@err_spk_ttyio_initialise_ldisc exists@
identifier tty;
position p;
@@

* spk_ttyio_initialise_ldisc@p(...)
{
	...
	struct tty_struct *tty;
	... when != speakup_tty = tty;
}

@script:python depends on detect@
p << err_spk_ttyio_ldisc_open.p;
p << err_spk_ttyio_initialise_ldisc.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-27830')
coccilib.report.print_report(p[0], 'ERROR: CVE-2020-27830')
