/// Files: arch/x86/kernel/kprobes/opt.c arch/x86/kernel/vmlinux.lds.S
/// Fix: 0d07c0ec4381f630c801539c79ad8dcc627f6e4a
/// Fixes: 7705dc8557973d8ad8f10840f61d8ec805695e9e

virtual detect

@initialize:python@
@@
import re

int3 = False
vmlinux_lds = None
with open('/proc/self/cmdline', 'rt') as f:
	for arg in f.read().split('\0'):
		if 'vmlinux.lds.S' in arg:
			vmlinux_lds = arg
if vmlinux_lds:
	with open(vmlinux_lds, 'rt') as f:
		if re.search(':text\s*=\s*0xcccc', f.read()):
			int3 = True

@err exists@
expression E;
position p;
@@

can_optimize(...)
{
	...
	if (E.opcode.bytes[0] == \(INT3_INSN_OPCODE\|BREAKPOINT_INSTRUCTION\))
*		return 0;@p
	...
}

@script:python depends on detect@
p << err.p;
@@

if int3:
	coccilib.report.print_report(p[0], 'ERROR: CVE-2021-3411')
