# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from arthur_client.api_bindings.models.aggregation_metric_type import AggregationMetricType
from arthur_client.api_bindings.models.aggregation_spec_schema_init_args_inner import AggregationSpecSchemaInitArgsInner
from arthur_client.api_bindings.models.base_reported_aggregation import BaseReportedAggregation
from typing import Optional, Set
from typing_extensions import Self

class AggregationSpecSchema(BaseModel):
    """
    AggregationSpecSchema
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the aggregation function.")
    id: StrictStr = Field(description="Unique identifier of the aggregation function.")
    description: StrictStr = Field(description="Description of the aggregation function and what it aggregates.")
    metric_type: AggregationMetricType = Field(description="Return type of the aggregations aggregate function.")
    init_args: List[AggregationSpecSchemaInitArgsInner] = Field(description="List of parameters to the aggregation's init function.")
    aggregate_args: List[AggregationSpecSchemaInitArgsInner] = Field(description="List of parameters to the aggregation's aggregate function.")
    reported_aggregations: List[BaseReportedAggregation] = Field(description="List of aggregations reported by the metric.")
    __properties: ClassVar[List[str]] = ["name", "id", "description", "metric_type", "init_args", "aggregate_args", "reported_aggregations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AggregationSpecSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in init_args (list)
        _items = []
        if self.init_args:
            for _item_init_args in self.init_args:
                if _item_init_args:
                    _items.append(_item_init_args.to_dict())
            _dict['init_args'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aggregate_args (list)
        _items = []
        if self.aggregate_args:
            for _item_aggregate_args in self.aggregate_args:
                if _item_aggregate_args:
                    _items.append(_item_aggregate_args.to_dict())
            _dict['aggregate_args'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in reported_aggregations (list)
        _items = []
        if self.reported_aggregations:
            for _item_reported_aggregations in self.reported_aggregations:
                if _item_reported_aggregations:
                    _items.append(_item_reported_aggregations.to_dict())
            _dict['reported_aggregations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AggregationSpecSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "id": obj.get("id"),
            "description": obj.get("description"),
            "metric_type": obj.get("metric_type"),
            "init_args": [AggregationSpecSchemaInitArgsInner.from_dict(_item) for _item in obj["init_args"]] if obj.get("init_args") is not None else None,
            "aggregate_args": [AggregationSpecSchemaInitArgsInner.from_dict(_item) for _item in obj["aggregate_args"]] if obj.get("aggregate_args") is not None else None,
            "reported_aggregations": [BaseReportedAggregation.from_dict(_item) for _item in obj["reported_aggregations"]] if obj.get("reported_aggregations") is not None else None
        })
        return _obj


