# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.new_metric_request import NewMetricRequest
from arthur_client.api_bindings.models.new_rule_request import NewRuleRequest
from arthur_client.api_bindings.models.task_type import TaskType
from typing import Optional, Set
from typing_extensions import Self

class CreateModelTaskJobSpec(BaseModel):
    """
    CreateModelTaskJobSpec
    """ # noqa: E501
    job_type: Optional[StrictStr] = 'create_model_task'
    connector_id: StrictStr = Field(description="The id of the engine internal connector to use to create the task.")
    task_name: StrictStr = Field(description="The name of the task.")
    onboarding_identifier: Optional[StrictStr] = None
    initial_rules: List[NewRuleRequest] = Field(description="The initial rules to apply to the created model.")
    task_type: Optional[TaskType] = Field(default=None, description="The type of task to create.")
    initial_metrics: List[NewMetricRequest] = Field(description="The initial metrics to apply to agentic tasks.")
    __properties: ClassVar[List[str]] = ["job_type", "connector_id", "task_name", "onboarding_identifier", "initial_rules", "task_type", "initial_metrics"]

    @field_validator('job_type')
    def job_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['create_model_task']):
            raise ValueError("must be one of enum values ('create_model_task')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateModelTaskJobSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in initial_rules (list)
        _items = []
        if self.initial_rules:
            for _item_initial_rules in self.initial_rules:
                if _item_initial_rules:
                    _items.append(_item_initial_rules.to_dict())
            _dict['initial_rules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in initial_metrics (list)
        _items = []
        if self.initial_metrics:
            for _item_initial_metrics in self.initial_metrics:
                if _item_initial_metrics:
                    _items.append(_item_initial_metrics.to_dict())
            _dict['initial_metrics'] = _items
        # set to None if onboarding_identifier (nullable) is None
        # and model_fields_set contains the field
        if self.onboarding_identifier is None and "onboarding_identifier" in self.model_fields_set:
            _dict['onboarding_identifier'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateModelTaskJobSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "job_type": obj.get("job_type") if obj.get("job_type") is not None else 'create_model_task',
            "connector_id": obj.get("connector_id"),
            "task_name": obj.get("task_name"),
            "onboarding_identifier": obj.get("onboarding_identifier"),
            "initial_rules": [NewRuleRequest.from_dict(_item) for _item in obj["initial_rules"]] if obj.get("initial_rules") is not None else None,
            "task_type": obj.get("task_type"),
            "initial_metrics": [NewMetricRequest.from_dict(_item) for _item in obj["initial_metrics"]] if obj.get("initial_metrics") is not None else None
        })
        return _obj


