import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
 *
 * @experimental
 */
export declare class Deepracer extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add access for a private leaderboard.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     *
     * @experimental
     */
    toAddLeaderboardAccessPermission(): this;
    /**
     * (experimental) Grants permission to get current admin multiuser configuration for this account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     *
     * @experimental
     */
    toAdminGetAccountConfig(): this;
    /**
     * (experimental) Grants permission to list all deepracer users with their associated resources created under this account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-list-associated-resources.html
     *
     * @experimental
     */
    toAdminListAssociatedResources(): this;
    /**
     * (experimental) Grants permission to list user data for all users associated with this account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-list-associated-users.html
     *
     * @experimental
     */
    toAdminListAssociatedUsers(): this;
    /**
     * (experimental) Grants permission to manage a user associated with this account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-manage-user.html
     *
     * @experimental
     */
    toAdminManageUser(): this;
    /**
     * (experimental) Grants permission to set configuration options for this account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     *
     * @experimental
     */
    toAdminSetAccountConfig(): this;
    /**
     * (experimental) Grants permission to clone an existing DeepRacer model.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-clone-trained-model
     *
     * @experimental
     */
    toCloneReinforcementLearningModel(): this;
    /**
     * (experimental) Grants permission to create a DeepRacer car in your garage.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     *
     * @experimental
     */
    toCreateCar(): this;
    /**
     * (experimental) Grants permission to create a leaderboard.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-create-community-race.html
     *
     * @experimental
     */
    toCreateLeaderboard(): this;
    /**
     * (experimental) Grants permission to create an access token for a private leaderboard.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     *
     * @experimental
     */
    toCreateLeaderboardAccessToken(): this;
    /**
     * (experimental) Grants permission to submit a DeepRacer model to be evaluated for leaderboards.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toCreateLeaderboardSubmission(): this;
    /**
     * (experimental) Grants permission to create ra einforcement learning model for DeepRacer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toCreateReinforcementLearningModel(): this;
    /**
     * (experimental) Grants permission to delete a leaderboard.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     *
     * @experimental
     */
    toDeleteLeaderboard(): this;
    /**
     * (experimental) Grants permission to delete a DeepRacer model.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toDeleteModel(): this;
    /**
     * (experimental) Grants permission to edit a leaderboard.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     *
     * @experimental
     */
    toEditLeaderboard(): this;
    /**
     * (experimental) Grants permission to get current multiuser configuration for this account.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     *
     * @experimental
     */
    toGetAccountConfig(): this;
    /**
     * (experimental) Grants permission to retrieve the user's alias for submitting a DeepRacer model to leaderboards.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toGetAlias(): this;
    /**
     * (experimental) Grants permission to download artifacts for an existing DeepRacer model.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @experimental
     */
    toGetAssetUrl(): this;
    /**
     * (experimental) Grants permission to retrieve a specific DeepRacer car from your garage.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     *
     * @experimental
     */
    toGetCar(): this;
    /**
     * (experimental) Grants permission to view all the DeepRacer cars in your garage.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     *
     * @experimental
     */
    toGetCars(): this;
    /**
     * (experimental) Grants permission to retrieve information about an existing DeepRacer model's evaluation jobs.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @experimental
     */
    toGetEvaluation(): this;
    /**
     * (experimental) Grants permission to retrieve information about how the latest submitted DeepRacer model for a user performed on a leaderboard.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toGetLatestUserSubmission(): this;
    /**
     * (experimental) Grants permission to retrieve information about leaderboards.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toGetLeaderboard(): this;
    /**
     * (experimental) Grants permission to retrieve information about an existing DeepRacer model.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toGetModel(): this;
    /**
     * (experimental) Grants permission to retrieve information about private leaderboards.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     *
     * @experimental
     */
    toGetPrivateLeaderboard(): this;
    /**
     * (experimental) Grants permission to retrieve information about the performance of a user's DeepRacer model that got placed on a leaderboard.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toGetRankedUserSubmission(): this;
    /**
     * (experimental) Grants permission to retrieve information about DeepRacer tracks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @experimental
     */
    toGetTrack(): this;
    /**
     * (experimental) Grants permission to retrieve information about an existing DeepRacer model's training job.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toGetTrainingJob(): this;
    /**
     * (experimental) Grants permission to import a reinforcement learning model for DeepRacer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-troubleshooting-service-migration-errors.html
     *
     * @experimental
     */
    toImportModel(): this;
    /**
     * (experimental) Grants permission to list a DeepRacer model's evaluation jobs.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @experimental
     */
    toListEvaluations(): this;
    /**
     * (experimental) Grants permission to list all the DeepRacer model submissions of a user on a leaderboard.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toListLeaderboardSubmissions(): this;
    /**
     * (experimental) Grants permission to list all the available leaderboards.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toListLeaderboards(): this;
    /**
     * (experimental) Grants permission to list all existing DeepRacer models.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toListModels(): this;
    /**
     * (experimental) Grants permission to retrieve participant information about private leaderboards.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     *
     * @experimental
     */
    toListPrivateLeaderboardParticipants(): this;
    /**
     * (experimental) Grants permission to list all the available private leaderboards.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     *
     * @experimental
     */
    toListPrivateLeaderboards(): this;
    /**
     * (experimental) Grants permission to list all the subscribed private leaderboards.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     *
     * @experimental
     */
    toListSubscribedPrivateLeaderboards(): this;
    /**
     * (experimental) Grants permission to lists tag for a resource.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list all DeepRacer tracks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @experimental
     */
    toListTracks(): this;
    /**
     * (experimental) Grants permission to list a DeepRacer model's training jobs.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toListTrainingJobs(): this;
    /**
     * (experimental) Grants permission to migrate previous reinforcement learning models for DeepRacer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-troubleshooting-service-migration-errors.html
     *
     * @experimental
     */
    toMigrateModels(): this;
    /**
     * (experimental) Grants permission to performs the leaderboard operation mentioned in the operation attribute.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-perform-leaderboard-operation.html
     *
     * @experimental
     */
    toPerformLeaderboardOperation(): this;
    /**
     * (experimental) Grants permission to remove access for a private leaderboard.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     *
     * @experimental
     */
    toRemoveLeaderboardAccessPermission(): this;
    /**
     * (experimental) Grants permission to set the user's alias for submitting a DeepRacer model to leaderboards.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toSetAlias(): this;
    /**
     * (experimental) Grants permission to evaluate a DeepRacer model in a simulated environment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @experimental
     */
    toStartEvaluation(): this;
    /**
     * (experimental) Grants permission to stop DeepRacer model evaluations.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @experimental
     */
    toStopEvaluation(): this;
    /**
     * (experimental) Grants permission to stop training a DeepRacer model.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toStopTrainingReinforcementLearningModel(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to test reward functions for correctness.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-train-models-define-reward-function
     *
     * @experimental
     */
    toTestRewardFunction(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a DeepRacer car in your garage.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     *
     * @experimental
     */
    toUpdateCar(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type car to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCar(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type evaluation_job to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEvaluationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type leaderboard to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLeaderboard(resourceId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type leaderboard_evaluation_job to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLeaderboardEvaluationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type reinforcement_learning_model to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onReinforcementLearningModel(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type track to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTrack(resourceId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type training_job to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTrainingJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by multiuser flag.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/reference_policies_iam-condition-keys.html#condition-keys-multiuser
     *
     * Applies to actions:
     * - .toAddLeaderboardAccessPermission()
     * - .toCloneReinforcementLearningModel()
     * - .toCreateCar()
     * - .toCreateLeaderboard()
     * - .toCreateLeaderboardAccessToken()
     * - .toCreateLeaderboardSubmission()
     * - .toCreateReinforcementLearningModel()
     * - .toDeleteLeaderboard()
     * - .toDeleteModel()
     * - .toEditLeaderboard()
     * - .toGetAccountConfig()
     * - .toGetAlias()
     * - .toGetAssetUrl()
     * - .toGetCar()
     * - .toGetCars()
     * - .toGetEvaluation()
     * - .toGetLatestUserSubmission()
     * - .toGetLeaderboard()
     * - .toGetModel()
     * - .toGetPrivateLeaderboard()
     * - .toGetRankedUserSubmission()
     * - .toGetTrainingJob()
     * - .toImportModel()
     * - .toListEvaluations()
     * - .toListLeaderboardSubmissions()
     * - .toListLeaderboards()
     * - .toListModels()
     * - .toListPrivateLeaderboardParticipants()
     * - .toListPrivateLeaderboards()
     * - .toListSubscribedPrivateLeaderboards()
     * - .toListTagsForResource()
     * - .toListTrainingJobs()
     * - .toPerformLeaderboardOperation()
     * - .toRemoveLeaderboardAccessPermission()
     * - .toSetAlias()
     * - .toStartEvaluation()
     * - .toStopEvaluation()
     * - .toStopTrainingReinforcementLearningModel()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCar()
     *
     * @param value `true` or `false`.
     * @experimental
     */
    ifMultiUser(value?: boolean): this;
    /**
     * (experimental) Filters access by user token in the request.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/reference_policies_iam-condition-keys.html#condition-keys-usertoken
     *
     * Applies to actions:
     * - .toAddLeaderboardAccessPermission()
     * - .toCloneReinforcementLearningModel()
     * - .toCreateCar()
     * - .toCreateLeaderboard()
     * - .toCreateLeaderboardAccessToken()
     * - .toCreateLeaderboardSubmission()
     * - .toCreateReinforcementLearningModel()
     * - .toDeleteLeaderboard()
     * - .toDeleteModel()
     * - .toEditLeaderboard()
     * - .toGetAccountConfig()
     * - .toGetAlias()
     * - .toGetAssetUrl()
     * - .toGetCar()
     * - .toGetCars()
     * - .toGetEvaluation()
     * - .toGetLatestUserSubmission()
     * - .toGetLeaderboard()
     * - .toGetModel()
     * - .toGetPrivateLeaderboard()
     * - .toGetRankedUserSubmission()
     * - .toGetTrainingJob()
     * - .toImportModel()
     * - .toListEvaluations()
     * - .toListLeaderboardSubmissions()
     * - .toListLeaderboards()
     * - .toListModels()
     * - .toListPrivateLeaderboardParticipants()
     * - .toListPrivateLeaderboards()
     * - .toListSubscribedPrivateLeaderboards()
     * - .toListTagsForResource()
     * - .toListTrainingJobs()
     * - .toPerformLeaderboardOperation()
     * - .toRemoveLeaderboardAccessPermission()
     * - .toSetAlias()
     * - .toStartEvaluation()
     * - .toStopEvaluation()
     * - .toStopTrainingReinforcementLearningModel()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCar()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifUserToken(value: string | string[], operator?: Operator | string): this;
}
