import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [opsworks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworks.html).
 *
 * @experimental
 */
export declare class Opsworks extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [opsworks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworks.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Assign a registered instance to a layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssignInstance.html
     *
     * @experimental
     */
    toAssignInstance(): this;
    /**
     * (experimental) Assigns one of the stack's registered Amazon EBS volumes to a specified instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssignVolume.html
     *
     * @experimental
     */
    toAssignVolume(): this;
    /**
     * (experimental) Associates one of the stack's registered Elastic IP addresses with a specified instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssociateElasticIp.html
     *
     * @experimental
     */
    toAssociateElasticIp(): this;
    /**
     * (experimental) Attaches an Elastic Load Balancing load balancer to a specified layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AttachElasticLoadBalancer.html
     *
     * @experimental
     */
    toAttachElasticLoadBalancer(): this;
    /**
     * (experimental) Creates a clone of a specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CloneStack.html
     *
     * @experimental
     */
    toCloneStack(): this;
    /**
     * (experimental) Creates an app for a specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateApp.html
     *
     * @experimental
     */
    toCreateApp(): this;
    /**
     * (experimental) Runs deployment or stack commands.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateDeployment.html
     *
     * @experimental
     */
    toCreateDeployment(): this;
    /**
     * (experimental) Creates an instance in a specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateInstance.html
     *
     * @experimental
     */
    toCreateInstance(): this;
    /**
     * (experimental) Creates a layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateLayer.html
     *
     * @experimental
     */
    toCreateLayer(): this;
    /**
     * (experimental) Creates a new stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateStack.html
     *
     * @experimental
     */
    toCreateStack(): this;
    /**
     * (experimental) Creates a new user profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateUserProfile.html
     *
     * @experimental
     */
    toCreateUserProfile(): this;
    /**
     * (experimental) Deletes a specified app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteApp.html
     *
     * @experimental
     */
    toDeleteApp(): this;
    /**
     * (experimental) Deletes a specified instance, which terminates the associated Amazon EC2 instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteInstance.html
     *
     * @experimental
     */
    toDeleteInstance(): this;
    /**
     * (experimental) Deletes a specified layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteLayer.html
     *
     * @experimental
     */
    toDeleteLayer(): this;
    /**
     * (experimental) Deletes a specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteStack.html
     *
     * @experimental
     */
    toDeleteStack(): this;
    /**
     * (experimental) Deletes a user profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteUserProfile.html
     *
     * @experimental
     */
    toDeleteUserProfile(): this;
    /**
     * (experimental) Deletes a user profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterEcsCluster.html
     *
     * @experimental
     */
    toDeregisterEcsCluster(): this;
    /**
     * (experimental) Deregisters a specified Elastic IP address.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterElasticIp.html
     *
     * @experimental
     */
    toDeregisterElasticIp(): this;
    /**
     * (experimental) Deregister a registered Amazon EC2 or on-premises instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterInstance.html
     *
     * @experimental
     */
    toDeregisterInstance(): this;
    /**
     * (experimental) Deregisters an Amazon RDS instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterRdsDbInstance.html
     *
     * @experimental
     */
    toDeregisterRdsDbInstance(): this;
    /**
     * (experimental) Deregisters an Amazon EBS volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterVolume.html
     *
     * @experimental
     */
    toDeregisterVolume(): this;
    /**
     * (experimental) Describes the available AWS OpsWorks agent versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeAgentVersions.html
     *
     * @experimental
     */
    toDescribeAgentVersions(): this;
    /**
     * (experimental) Requests a description of a specified set of apps.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeApps.html
     *
     * @experimental
     */
    toDescribeApps(): this;
    /**
     * (experimental) Describes the results of specified commands.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeCommands.html
     *
     * @experimental
     */
    toDescribeCommands(): this;
    /**
     * (experimental) Requests a description of a specified set of deployments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeDeployments.html
     *
     * @experimental
     */
    toDescribeDeployments(): this;
    /**
     * (experimental) Describes Amazon ECS clusters that are registered with a stack.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeEcsClusters.html
     *
     * @experimental
     */
    toDescribeEcsClusters(): this;
    /**
     * (experimental) Describes Elastic IP addresses.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeElasticIps.html
     *
     * @experimental
     */
    toDescribeElasticIps(): this;
    /**
     * (experimental) Describes a stack's Elastic Load Balancing instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeElasticLoadBalancers.html
     *
     * @experimental
     */
    toDescribeElasticLoadBalancers(): this;
    /**
     * (experimental) Requests a description of a set of instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeInstances.html
     *
     * @experimental
     */
    toDescribeInstances(): this;
    /**
     * (experimental) Requests a description of one or more layers in a specified stack.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeLayers.html
     *
     * @experimental
     */
    toDescribeLayers(): this;
    /**
     * (experimental) Describes load-based auto scaling configurations for specified layers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeLoadBasedAutoScaling.html
     *
     * @experimental
     */
    toDescribeLoadBasedAutoScaling(): this;
    /**
     * (experimental) Describes a user's SSH information.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeMyUserProfile.html
     *
     * @experimental
     */
    toDescribeMyUserProfile(): this;
    /**
     * (experimental) Describes the operating systems that are supported by AWS OpsWorks Stacks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeOperatingSystems.html
     *
     * @experimental
     */
    toDescribeOperatingSystems(): this;
    /**
     * (experimental) Describes the permissions for a specified stack.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribePermissions.html
     *
     * @experimental
     */
    toDescribePermissions(): this;
    /**
     * (experimental) Describe an instance's RAID arrays.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeRaidArrays.html
     *
     * @experimental
     */
    toDescribeRaidArrays(): this;
    /**
     * (experimental) Describes Amazon RDS instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeRdsDbInstances.html
     *
     * @experimental
     */
    toDescribeRdsDbInstances(): this;
    /**
     * (experimental) Describes AWS OpsWorks service errors.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeServiceErrors.html
     *
     * @experimental
     */
    toDescribeServiceErrors(): this;
    /**
     * (experimental) Requests a description of a stack's provisioning parameters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStackProvisioningParameters.html
     *
     * @experimental
     */
    toDescribeStackProvisioningParameters(): this;
    /**
     * (experimental) Describes the number of layers and apps in a specified stack, and the number of instances in each state, such as running_setup or online.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStackSummary.html
     *
     * @experimental
     */
    toDescribeStackSummary(): this;
    /**
     * (experimental) Requests a description of one or more stacks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStacks.html
     *
     * @experimental
     */
    toDescribeStacks(): this;
    /**
     * (experimental) Describes time-based auto scaling configurations for specified instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeTimeBasedAutoScaling.html
     *
     * @experimental
     */
    toDescribeTimeBasedAutoScaling(): this;
    /**
     * (experimental) Describe specified users.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeUserProfiles.html
     *
     * @experimental
     */
    toDescribeUserProfiles(): this;
    /**
     * (experimental) Describes an instance's Amazon EBS volumes.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeVolumes.html
     *
     * @experimental
     */
    toDescribeVolumes(): this;
    /**
     * (experimental) Detaches a specified Elastic Load Balancing instance from its layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DetachElasticLoadBalancer.html
     *
     * @experimental
     */
    toDetachElasticLoadBalancer(): this;
    /**
     * (experimental) Disassociates an Elastic IP address from its instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DisassociateElasticIp.html
     *
     * @experimental
     */
    toDisassociateElasticIp(): this;
    /**
     * (experimental) Gets a generated host name for the specified layer, based on the current host name theme.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_GetHostnameSuggestion.html
     *
     * @experimental
     */
    toGetHostnameSuggestion(): this;
    /**
     * (experimental) Grants RDP access to a Windows instance for a specified time period.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RebootInstance.html
     *
     * @experimental
     */
    toGrantAccess(): this;
    /**
     * (experimental) Returns a list of tags that are applied to the specified stack or layer.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_ListTags.html
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Reboots a specified instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RebootInstance.html
     *
     * @experimental
     */
    toRebootInstance(): this;
    /**
     * (experimental) Registers a specified Amazon ECS cluster with a stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterEcsCluster.html
     *
     * @experimental
     */
    toRegisterEcsCluster(): this;
    /**
     * (experimental) Registers an Elastic IP address with a specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterElasticIp.html
     *
     * @experimental
     */
    toRegisterElasticIp(): this;
    /**
     * (experimental) Registers instances with a specified stack that were created outside of AWS OpsWorks.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterInstance.html
     *
     * @experimental
     */
    toRegisterInstance(): this;
    /**
     * (experimental) Registers an Amazon RDS instance with a stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterRdsDbInstance.html
     *
     * @experimental
     */
    toRegisterRdsDbInstance(): this;
    /**
     * (experimental) Registers an Amazon EBS volume with a specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterVolume.html
     *
     * @experimental
     */
    toRegisterVolume(): this;
    /**
     * (experimental) Specify the load-based auto scaling configuration for a specified layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetLoadBasedAutoScaling.html
     *
     * @experimental
     */
    toSetLoadBasedAutoScaling(): this;
    /**
     * (experimental) Specifies a user's permissions.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetPermission.html
     *
     * @experimental
     */
    toSetPermission(): this;
    /**
     * (experimental) Specify the time-based auto scaling configuration for a specified instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetTimeBasedAutoScaling.html
     *
     * @experimental
     */
    toSetTimeBasedAutoScaling(): this;
    /**
     * (experimental) Starts a specified instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StartInstance.html
     *
     * @experimental
     */
    toStartInstance(): this;
    /**
     * (experimental) Starts a stack's instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StartStack.html
     *
     * @experimental
     */
    toStartStack(): this;
    /**
     * (experimental) Stops a specified instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StopInstance.html
     *
     * @experimental
     */
    toStopInstance(): this;
    /**
     * (experimental) Stops a specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StopStack.html
     *
     * @experimental
     */
    toStopStack(): this;
    /**
     * (experimental) Apply tags to a specified stack or layer.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Unassigns a registered instance from all of it's layers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UnassignInstance.html
     *
     * @experimental
     */
    toUnassignInstance(): this;
    /**
     * (experimental) Unassigns an assigned Amazon EBS volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UnassignVolume.html
     *
     * @experimental
     */
    toUnassignVolume(): this;
    /**
     * (experimental) Removes tags from a specified stack or layer.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Updates a specified app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateApp.html
     *
     * @experimental
     */
    toUpdateApp(): this;
    /**
     * (experimental) Updates a registered Elastic IP address's name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateElasticIp.html
     *
     * @experimental
     */
    toUpdateElasticIp(): this;
    /**
     * (experimental) Updates a specified instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateInstance.html
     *
     * @experimental
     */
    toUpdateInstance(): this;
    /**
     * (experimental) Updates a specified layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateLayer.html
     *
     * @experimental
     */
    toUpdateLayer(): this;
    /**
     * (experimental) Updates a user's SSH public key.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateMyUserProfile.html
     *
     * @experimental
     */
    toUpdateMyUserProfile(): this;
    /**
     * (experimental) Updates an Amazon RDS instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateRdsDbInstance.html
     *
     * @experimental
     */
    toUpdateRdsDbInstance(): this;
    /**
     * (experimental) Updates a specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateStack.html
     *
     * @experimental
     */
    toUpdateStack(): this;
    /**
     * (experimental) Updates a specified user profile.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateUserProfile.html
     *
     * @experimental
     */
    toUpdateUserProfile(): this;
    /**
     * (experimental) Updates an Amazon EBS volume's name or mount point.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateVolume.html
     *
     * @experimental
     */
    toUpdateVolume(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type stack to the statement.
     *
     * https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks.html
     *
     * @param stackId - Identifier for the stackId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onStack(stackId: string, account?: string, region?: string, partition?: string): this;
}
