# generated by datamodel-codegen:
#   filename:  cpu.json

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field


class LastUpdated(BaseModel):
    """
    Last updated
    """

    class Config:
        extra = Extra.allow

    count: float
    frequency_current: float
    frequency_min: float
    frequency_max: float
    load_average: float
    stats_ctx_switches: float
    stats_interrupts: float
    stats_soft_interrupts: float
    stats_syscalls: float
    temperature: float
    times_user: float
    times_system: float
    times_idle: float
    times_interrupt: Optional[float] = None
    times_dpc: Optional[float] = None
    times_percent_user: float
    times_percent_system: float
    times_percent_idle: float
    times_percent_interrupt: Optional[float] = None
    times_percent_dpc: Optional[float] = None
    usage: float
    voltage: Optional[float] = None


class Cpu(BaseModel):
    """
    CPU
    """

    class Config:
        extra = Extra.allow

    count: int
    frequency_current: float
    frequency_min: float
    frequency_max: float
    load_average: float
    stats_ctx_switches: int
    stats_interrupts: int
    stats_soft_interrupts: int
    stats_syscalls: int
    temperature: float
    times_user: float
    times_system: float
    times_idle: float
    times_interrupt: Optional[float] = None
    times_dpc: Optional[float] = None
    times_percent_user: float
    times_percent_system: float
    times_percent_idle: float
    times_percent_interrupt: Optional[float] = None
    times_percent_dpc: Optional[float] = None
    usage: float
    voltage: Optional[float] = None
    last_updated: LastUpdated = Field(..., description="Last updated")
