from enum import Enum


class ErrorCode(Enum):
    """
    String code representing an internal error externally.
    """
    NOT_FOUND = "ERROR.NOT_FOUND"
    UNAUTHORIZED = "ERROR.UNAUTHORIZED"
    FORBIDDEN = "ERROR.FORBIDDEN"
    EXPIRED_TOKEN = "ERROR.EXPIRED_TOKEN"
    DISABLED_TOKEN = "ERROR.DISABLED_TOKEN"
    WRONG_USERNAME = "ERROR.WRONG_USERNAME"
    WRONG_PASSWORD = "ERROR.WRONG_PASSWORD"
    STATUS_CHANGE = "ERROR.STATUS_CHANGE"
    DUPLICATE_NAME = "ERROR.DUPLICATE_NAME"
