import sys
import os

file_path = os.path.abspath(__file__)
end = file_path.index('mns') + 14
project_path = file_path[0:end]
sys.path.append(project_path)

from mns_common.db.MongodbUtil import MongodbUtil
import pandas as pd

mongodb_util = MongodbUtil('27017')

# 亿元
HUNDRED_MILLION = 100000000

# 万元
TEN_THOUSAND = 10000


def total_mv_classification(real_time_quotes_now):
    real_time_quotes_now['flow_mv_sp'] = round((real_time_quotes_now['flow_mv'] / HUNDRED_MILLION), 2)
    real_time_quotes_now['total_mv_sp'] = round((real_time_quotes_now['total_mv'] / HUNDRED_MILLION), 2)
    real_time_quotes_now['flow_mv_level'] = 0

    real_time_quotes_now.reset_index(drop=True, inplace=True)
    real_time_quotes_now.loc[(real_time_quotes_now["flow_mv_sp"] >= 0), ['flow_mv_level']] \
        = (real_time_quotes_now["flow_mv_sp"] // 10) + 1
    return real_time_quotes_now


# 股票分类
def classify_symbol(real_time_quotes_now_df):
    real_time_quotes_now_df['classification'] = real_time_quotes_now_df['symbol'].apply(
        lambda symbol: 'C' if symbol.startswith('3')
        else ('K' if symbol.startswith('68')
              else ('S' if symbol.startswith('0')
                    else ('X' if symbol.startswith('8') else ('X' if symbol.startswith('4') else "H")))))
    return real_time_quotes_now_df


# 单个股票分类
def classify_symbol_one(symbol):
    if symbol.startswith('3'):
        return 'C'
    elif symbol.startswith('68'):
        return 'K'
    elif symbol.startswith('0'):
        return 'S'
    elif symbol.startswith('4'):
        return 'X'
    elif symbol.startswith('8'):
        return 'X'
    else:
        return 'H'


def symbol_amount_simple(real_time_quotes_now_df):
    real_time_quotes_now_df['amount_level'] = round(real_time_quotes_now_df['amount'] / HUNDRED_MILLION, 2)
    return real_time_quotes_now_df


# 排除 新股
def exclude_new_stock(real_time_quotes_now_df):
    return real_time_quotes_now_df.loc[~(real_time_quotes_now_df['name'].str.contains('N'))]


# 排除st
def exclude_st_symbol(real_time_quotes_now_df):
    exclude_st_symbol_list = list(
        real_time_quotes_now_df.loc[(real_time_quotes_now_df['name'].str.contains('ST'))
                                    | (real_time_quotes_now_df['name'].str.contains('退'))]['symbol'])
    return real_time_quotes_now_df.loc[
        ~(real_time_quotes_now_df['symbol'].isin(
            exclude_st_symbol_list))]


# 排除b股数据
def exclude_b_symbol(real_time_quotes_now_df):
    return real_time_quotes_now_df.loc[(real_time_quotes_now_df.symbol.str.startswith('3'))
                                       | (real_time_quotes_now_df.symbol.str.startswith('0'))
                                       | (real_time_quotes_now_df.symbol.str.startswith('6'))
                                       | (real_time_quotes_now_df.symbol.str.startswith('4'))
                                       | (real_time_quotes_now_df.symbol.str.startswith('8'))]


def exclude_ts_symbol(real_time_quotes_now_df):
    return real_time_quotes_now_df.loc[~(real_time_quotes_now_df['name'].str.contains('退'))]


# 排除成交量为0 停牌的股票
def exclude_amount_zero_stock(real_time_quotes_now_df):
    return real_time_quotes_now_df.loc[~(real_time_quotes_now_df['amount'] == 0)]


# 获取最大number
def realtime_quotes_now_max_number(db_name, field):
    query = {'symbol': '000001'}
    df = mongodb_util.descend_query(query, db_name, field, 1)
    if df is None or df.shape[0] == 0:
        return 1
    else:
        return list(df[field])[0]


# 获取集合最新实时数据
def get_last_new_real_time_data(db_name, number):
    query = {'number': number}
    return mongodb_util.find_query_data(db_name, query)


# 获取当天 new stock
def get_new_stock(real_time_quotes_now_df):
    return real_time_quotes_now_df.loc[(real_time_quotes_now_df['name'].str.contains('N'))]


# 计算指数
def calculate_index(real_time_quotes_now_df):
    concept_flow_mv = sum(real_time_quotes_now_df['flow_mv'])
    real_time_quotes_now_df.loc[:, 'flow_mv_ratio'] = round(
        (real_time_quotes_now_df['flow_mv'] / concept_flow_mv), 4)
    real_time_quotes_now_df.loc[:, "chg_ratio"] = real_time_quotes_now_df["flow_mv_ratio"] * \
                                                  real_time_quotes_now_df["chg"]
    return round(sum(real_time_quotes_now_df["chg_ratio"]), 2)


# 按照字段field1分组  对field2 求和
def group_by_industry_sum(real_time_quotes_now, field1, field2):
    df_series = real_time_quotes_now.groupby(by=[field1])[field2].sum()
    return pd.DataFrame({field1: df_series.index, field2: df_series.values})
