import sys
import os

file_path = os.path.abspath(__file__)
end = file_path.index('mns') + 14
project_path = file_path[0:end]
sys.path.append(project_path)

import pandas as pd


# 简单排除概念
def get_simple_exclude_ths_concept():
    return pd.DataFrame([
        # 地域概念
        [885939, '海峡两岸', '地域概念'],
        [885894, '海南自贸区', '地域概念'],
        [885827, '横琴新区', '地域概念'],
        [885894, '海南自贸区', '地域概念'],
        [885345, '新疆振兴', '弱势概念'],

        # 财务概念
        [885929, '专精特新', '财务概念'],
        [885907, '科创次新股', '财务概念'],
        [885906, '核准制次新股', '财务概念'],
        [885905, '注册制次新股', '财务概念'],
        [885873, '分拆上市意愿', '财务概念'],
        [885873, '分拆上市意愿', '财务概念'],
        [885699, 'ST板块', '弱势概念'],
        [885835, '参股银行', '财务概念'],
        [885787, '独角兽概念', '财务概念'],
        [885740, '债转股', '财务概念'],
        [885639, '高送转', '财务概念'],
        # 宏观概念
        [885924, '共同富裕示范区', '宏观概念'],
        [885893, '国家大基金持股', '宏观概念'],
        [885791, '知识产权保护', '宏观概念'],
        [885764, '自由贸易港', '宏观概念'],
        [885761, '超级品牌', '宏观概念'],
        [885705, '乡村振兴', '宏观概念'],
        [885703, '健康中国', '宏观概念'],
        # 交易指数概念

        [885932, '北交所概念', '指数概念'],
        [885916, '同花顺漂亮100', '指数概念'],
        [885745, 'MSCI概念', '指数概念'],
        [886045, '同花顺中特估100', '指数概念'],
        # 过期项目概念
        [886014, '世界杯', '过期项目概念'],
        # [885993, '方舱医院', '过期项目概念'], 有回测数据
        [885984, '恒大概念', '过期项目概念'],
        [885983, '疫情监测', '过期项目概念'],
        [885964, '俄乌冲突概念', '过期项目概念'],
        # 无效概念
        [885992, '噪声防治', '概念太小'],
        [885985, '毛发医疗', '概念太小'],
        [885892, 'REITs概念', '概念太小'],
        [885974, '两轮车', '概念太小'],
        [885889, '富媒体', '概念太小'],
        [885841, '草地贪夜蛾防治', '概念太小'],
        [885831, '超级真菌', '概念太小'],
        [885829, '丙烯酸', '概念太小'],
        [885798, '燃料乙醇', '概念太小'],
        [885792, '赛马概念', '概念太小'],
        [885754, '微信小程序', '概念太小'],
        # 行业概念
        [885284, '稀缺资源', '矿产细分不够'],
        [885986, '碳交易', '行业概念'],
        [885973, '金属铜', '行业概念'],
        [885972, '金属回收', '行业概念'],
        [885971, '金属铅', '行业概念'],
        [885970, '金属锌', '行业概念'],
        [885969, '金属镍', '行业概念'],
        # 弱势概念 组成数量少
        [885931, 'PVDF概念', '弱势概念'],
        [885652, '钛白粉概念', '弱势概念'],
        [885427, '高端装备', '弱势概念'],
        [885633, '染料', '弱势概念'],
        [885852, '青蒿素', '弱势概念'],
        [885747, '共享单车', '弱势概念'],
        [885753, '网约车', '弱势概念'],
        [885900, 'NMN概念', '弱势概念'],
    ],
        columns=['symbol',
                 'name',
                 'exclude_reason'
                 ])


def get_exclude_ths_concept():
    return pd.DataFrame([
        [300061, '京津冀一体化', '地域概念'],

        [301128, '上海自贸区', '地域概念'],

        [301229, '天津自贸区', '地域概念'],

        [301236, '福建自贸区', '地域概念'],

        [301491, '粤港澳大湾区', '地域概念'],

        [301541, '中韩自贸区', '地域概念'],

        [301630, '广东自贸区', '地域概念'],

        [302182, '雄安新区', '地域概念'],

        [308547, '黑龙江自贸区', '地域概念'],

        [301455, '摘帽', '财务概念'],
        [301610, '壳资源', '财务概念'],
        [302046, '债转股(AMC概念)', '财务概念'],
        [308296, '送转填权', '财务概念'],
        [300265, '金改', '财务概念'],
        [300168, '创投', '财务概念'],

        [300100, '参股券商', '财务概念'],

        [300389, '参股新三板', '财务概念'],

        [300900, '融资融券', '财务概念'],

        [300018, '参股保险', '财务概念'],

        [300269, '举牌', '财务概念'],

        [300870, '新股与次新股', '财务概念'],

        [302154, '股权转让', '财务概念'],

        [301531, '首发新股', '财务概念'],

        [308458, '三季报预增', '财务概念'],

        [307816, '国家大基金持股', '宏观概念'],
        [308432, '长三角一体化', '宏观概念'],

        [309034, '国企改革', '宏观概念'],

        [300704, '中字头股票', '宏观概念'],

        [301546, '央企国企改革', '宏观概念'],
        [301402, '上海国企改革', '宏观概念'],
        [301171, '深圳国企改革', '宏观概念'],

        [301715, '证金持股', '宏观概念'],
        [301636, '深股通', '指数概念'],
        [308594, '标普道琼斯A股', '指数概念'],
        [301490, '沪股通', '指数概念'],
        [301783, '杭州亚运会', '过期项目概念'],
        [309004, '先进封装', '重复概念'],

        # 地域概念
        [885939, '海峡两岸', '地域概念'],
        [885894, '海南自贸区', '地域概念'],
        [885827, '横琴新区', '地域概念'],
        [885894, '海南自贸区', '地域概念'],
        # 财务概念
        [885929, '专精特新', '财务概念'],

        [885907, '科创次新股', '财务概念'],

        [885906, '核准制次新股', '财务概念'],

        [885905, '注册制次新股', '财务概念'],

        [885873, '分拆上市意愿', '财务概念'],

        [885873, '分拆上市意愿', '财务概念'],

        [885869, '一季报预增', '财务概念'],
        [885835, '参股银行', '财务概念'],

        [885814, '信托概念', '财务概念'],

        [885787, '独角兽概念', '财务概念'],

        [885767, '互联网保险', '财务概念'],

        [885740, '债转股', '财务概念'],

        [885647, '互联网彩票', '财务概念'],

        [885639, '高送转', '财务概念'],

        [885570, '期货概念', '财务概念'],
        [885456, '互联网金融', '财务概念'],

        # 宏观概念

        [885977, '国资云', '宏观概念'],
        [885924, '共同富裕示范区', '宏观概念'],
        [885893, '国家大基金持股', '宏观概念'],
        [885791, '知识产权保护', '宏观概念'],
        [885764, '自由贸易港', '宏观概念'],
        [885761, '超级品牌', '宏观概念'],
        [885705, '乡村振兴', '宏观概念'],
        [885703, '健康中国', '宏观概念'],

        # 交易指数概念

        [885932, '北交所概念', '指数概念'],
        [885916, '同花顺漂亮100', '指数概念'],
        [885745, 'MSCI概念', '指数概念'],
        [886045, '同花顺中特估100', '指数概念'],
        # 过期项目概念
        [886014, '世界杯', '过期项目概念'],
        # [885993, '方舱医院', '过期项目概念'], 有回测数据
        [885984, '恒大概念', '过期项目概念'],
        [885983, '疫情监测', '过期项目概念'],
        [885964, '俄乌冲突概念', '过期项目概念'],

        # 无效概念
        [885992, '噪声防治', '概念太小'],
        [885985, '毛发医疗', '概念太小'],
        [885892, 'REITs概念', '概念太小'],
        [885974, '两轮车', '概念太小'],
        [885889, '富媒体', '概念太小'],
        [885841, '草地贪夜蛾防治', '概念太小'],
        [885831, '超级真菌', '概念太小'],
        [885829, '丙烯酸', '概念太小'],
        [885798, '燃料乙醇', '概念太小'],
        [885792, '赛马概念', '概念太小'],
        [885754, '微信小程序', '概念太小'],

        # 行业概念

        [885284, '稀缺资源', '矿产细分不够'],
        [885986, '碳交易', '行业概念'],
        [885973, '金属铜', '行业概念'],
        [885972, '金属回收', '行业概念'],
        [885971, '金属铅', '行业概念'],
        [885970, '金属锌', '行业概念'],
        [885969, '金属镍', '行业概念'],
        [885914, '煤炭概念', '行业概念'],
        [885913, '医美概念', '行业概念'],
        [885865, '钴', '行业概念'],
        [885913, '医美概念', '行业概念'],
        [885700, '军工', '行业概念'],
        [885525, '白酒概念', '行业概念'],
        [885530, '黄金概念', '行业概念'],
        [885505, '生态农业', '行业概念'],
        [885995, '粮食概念', '行业概念'],
        [885967, '化肥', '行业概念'],
        [885936, '绿色电力', '行业概念'],
        [885572, '水利', '行业概念'],
        [885936, '绿色电力', '行业概念'],
        [885851, '烟草', '行业概念'],
        [885812, '农业种植', '行业概念'],
        [885406, '食品安全', '行业概念'],
        [885544, '新材料概念', '行业概念'],
        [885428, '特钢概念', '行业概念'],
        [885921, '储能', '行业概念'],
        [885919, '碳中和', '行业概念'],
        [885398, '煤化工', '行业概念'],
        [885808, '养鸡', '行业概念'],
        [885839, '人造肉', '行业概念'],
        [885784, '新零售', '行业概念'],
        [885782, '水泥概念', '行业概念'],
        [885562, '高铁', '行业概念'],

        # 弱势概念
        [885987, 'MicroLED概念', '弱势概念'],
        [885968, '托育服务', '弱势概念'],
        [885941, '智能制造', '弱势概念'],
        [885640, '草甘膦', '弱势概念'],
        [885743, '军民融合', '弱势概念'],
        [885877, '转基因', '弱势概念'],
        [885563, '节能环保', '弱势概念'],
        [885915, '物业管理', '弱势概念'],
        [885911, '社区团购', '弱势概念'],
        [885902, '汽车拆解概念', '弱势概念'],
        [885738, 'OLED', '弱势概念'],
        [885875, 'MiniLED', '弱势概念'],
        [885888, 'C2M概念', '弱势概念'],
        [885805, '芬太尼', '弱势概念'],
        [885768, '无人零售', '弱势概念'],
        [885750, '特色小镇', '弱势概念'],
        [885840, '人民币贬值受益', '弱势概念'],
        [885728, '人工智能', '弱势概念'],
        [885770, '智能物流', '弱势概念'],
        [885629, '农村电商', '弱势概念'],
        # 地下管网
        [885692, 'PPP概念', '弱势概念'],
        [885811, '玉米', '弱势概念'],
        [885539, '医疗器械概念', '弱势概念'],
        [885780, '啤酒概念', '弱势概念'],
        [885522, '养老概念', '弱势概念'],
        [885880, '口罩', '弱势概念'],
        [885494, '一带一路', '弱势概念'],
        [885580, '足球概念', '弱势概念'],
        [885531, '光伏概念', '弱势概念'],
        [885552, '小金属概念', '弱势概念'],
        [885543, '家用电器', '弱势概念'],
        [885531, '光伏概念', '弱势概念'],
        [885418, '文化传媒', '弱势概念'],
        [885710, '锂电池', '弱势概念'],
        [885378, '智慧城市', '弱势概念'],
        [885402, '智能医疗', '弱势概念'],
        [885641, '风电', '弱势概念'],
        [885861, 'ETC', '弱势概念'],

    ],
        columns=['symbol',
                 'name',
                 'exclude_reason'
                 ])
