"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneAssociation = exports.PSTNResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const cr = require("aws-cdk-lib/custom-resources");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class PSTNResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const PSTNResourceProvider = new cr.Provider(this, 'PSTNResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.pstnCustomResource = new aws_cdk_lib_1.CustomResource(this, 'pstnCustomResource', {
            serviceToken: PSTNResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = cdk.Stack.of(this);
        const constructName = 'PSTNResources';
        const existing = stack.node.tryFindChild(constructName);
        if (existing) {
            return existing;
        }
        const pstnCustomResourceRole = new iam.Role(this, 'pstnCustomResourceRole', {
            description: 'Amazon Chime PSTN Resources',
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:CreateSipRule',
                                'chime:DeleteSipRule',
                                'chime:UpdateSipRule',
                                'chime:GetSipRule',
                                'chime:CreateSipMediaApplication',
                                'chime:DeleteSipMediaApplication',
                                'chime:GetPhoneNumberOrder',
                                'chime:SearchAvailablePhoneNumbers',
                                'chime:CreatePhoneNumberOrder',
                                'chime:DeletePhoneNumber',
                                'chime:GetPhoneNumber',
                                'chime:CreateVoiceConnector',
                                'chime:PutVoiceConnectorStreamingConfiguration',
                                'chime:PutVoiceConnectorTermination',
                                'chime:PutVoiceConnectorOrigination',
                                'chime:ListPhoneNumbers',
                                'chime:AssociatePhoneNumbersWithVoiceConnector',
                                'chime:DisassociatePhoneNumbersFromVoiceConnector',
                                'chime:DeleteVoiceConnector',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                        new iam.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new lambda.Function(stack, constructName, {
            runtime: lambda.Runtime.PYTHON_3_9,
            code: lambda.Code.fromAsset(path.join(__dirname, '../../resources/pstn')),
            handler: 'index.handler',
            architecture: lambda.Architecture.ARM_64,
            role: pstnCustomResourceRole,
            timeout: cdk.Duration.minutes(1),
        });
        return fn;
    }
}
exports.PSTNResources = PSTNResources;
_a = JSII_RTTI_SYMBOL_1;
PSTNResources[_a] = { fqn: "cdk-amazon-chime-resources.PSTNResources", version: "0.1.200" };
class PhoneAssociation extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.phoneAssociationResource = new custom_resources_1.AwsCustomResource(this, 'phoneAssociation', {
            onCreate: {
                service: 'Chime',
                action: 'associatePhoneNumbersWithVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                    ForceAssociate: true,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(cdk.Names.uniqueId(this)),
            },
            onDelete: {
                service: 'Chime',
                action: 'disassociatePhoneNumbersFromVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(cdk.Names.uniqueId(this)),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.PhoneAssociation = PhoneAssociation;
_b = JSII_RTTI_SYMBOL_1;
PhoneAssociation[_b] = { fqn: "cdk-amazon-chime-resources.PhoneAssociation", version: "0.1.200" };
//# sourceMappingURL=data:application/json;base64,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