"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Import necessary packages
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
class SecureBucket extends constructs_1.Construct {
    constructor(parent, name, props) {
        super(parent, name);
        /*     if (!props?.bucketName) {
          throw new Error('parameterName cannot be an empty string');
        }
     */
        if (props?.bucketName && props.bucketName.length > 2048) {
            throw new Error('Name cannot be longer than 2048 characters.');
        }
        this.encryption = props && props.encryption ? props.encryption : aws_s3_1.BucketEncryption.KMS;
        this.bucketKMSKey = new aws_kms_1.Key(this, 'Key', {
            alias: `${parent}-key`,
            enableKeyRotation: true,
            enabled: true,
            policy: new aws_cdk_lib_1.aws_iam.PolicyDocument({
                assignSids: true,
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                        principals: [
                            new aws_cdk_lib_1.aws_iam.AccountRootPrincipal(),
                        ],
                        actions: ['kms:*'],
                        resources: ['*'],
                    }),
                ],
            }),
        });
        // Overrule Bucket Props with secure defaults and make them mandatory
        let newProps = {
            ...props,
            bucketName: props && props.bucketName ? props.bucketName : undefined,
            // Force encryption to use a Custom Managed Key; if encryption is not set to unencrypted use encryption specified in props otherwise set to KMS encryption
            //encryption: BucketEncryption.KMS,
            //encryption: props && props.encryption === undefined || props && props.encryption != BucketEncryption.UNENCRYPTED ? BucketEncryption.KMS : BucketEncryption.UNENCRYPTED,
            // encryption: props && props.encryption === undefined || props && props.encryption != BucketEncryption.UNENCRYPTED ? BucketEncryption.KMS : props?.encryption,
            encryption: this.encryption,
            // Create the Encryption Key, with Rotation enabled
            //encryptionKey: props && props.encryption === undefined || props && props.encryption != BucketEncryption.UNENCRYPTED ? this.bucketKMSKey : undefined,
            encryptionKey: this.encryption != aws_s3_1.BucketEncryption.UNENCRYPTED ? this.bucketKMSKey : undefined,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            versioned: true,
            autoDeleteObjects: props && props.autoDeleteObjects && props.autoDeleteObjects == !false ? props.autoDeleteObjects : false,
            removalPolicy: props && props.autoDeleteObjects && props.autoDeleteObjects == true ? aws_cdk_lib_1.RemovalPolicy.DESTROY : aws_cdk_lib_1.RemovalPolicy.RETAIN,
            enforceSSL: true,
            accessControl: aws_s3_1.BucketAccessControl.LOG_DELIVERY_WRITE,
            serverAccessLogsPrefix: 'access-logs',
            lifecycleRules: [
                {
                    // 👇 optionally apply object name filtering
                    // prefix: 'data/',
                    abortIncompleteMultipartUploadAfter: aws_cdk_lib_1.Duration.days(30),
                    expiration: aws_cdk_lib_1.Duration.days(365),
                    transitions: [
                        {
                            storageClass: aws_s3_1.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: aws_cdk_lib_1.Duration.days(30),
                        },
                        {
                            storageClass: aws_s3_1.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: aws_cdk_lib_1.Duration.days(60),
                        },
                        {
                            storageClass: aws_s3_1.StorageClass.GLACIER,
                            transitionAfter: aws_cdk_lib_1.Duration.days(90),
                        },
                        {
                            storageClass: aws_s3_1.StorageClass.DEEP_ARCHIVE,
                            transitionAfter: aws_cdk_lib_1.Duration.days(180),
                        },
                    ],
                },
            ],
        };
        // Create actual bucket
        this.bucket = new aws_s3_1.Bucket(this, `${parent}-bucket`, newProps);
        new aws_cdk_lib_1.CfnOutput(this, 'BucketName', {
            value: this.bucket.bucketName,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'KMSKeyArn', {
            value: this.bucketKMSKey.keyArn,
        });
    }
}
exports.SecureBucket = SecureBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureBucket[_a] = { fqn: "vaughntech-secure-s3-bucket.SecureBucket", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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