# Contributing to ProbNum

Contributions to ProbNum are very welcome! Before getting started make sure to read the following guidelines.

Some suggestions for contributions:

- adding documentation
- adding tutorials
- requesting a feature
- implementing a new feature
- reporting a bug
- fixing a bug
- adding missing tests

If you would like to contribute but are unsure how, then writing tutorials, documentation or working on
[open issues](https://github.com/probabilistic-numerics/probnum/issues) are a good way to start. 

## Reporting a Bug
If you find a bug, please report it by opening an issue on the GitHub page, and tag it as a bug.
Reproducibility is key, so if possible provide a working code snippet that reproduces the bug and mention the 
Python and ProbNum version you are using.

Please also detail how you found the bug, what you expected to happen, and what happened instead. Have you made any 
code changes after which the bug occurred?

Of course, bug fixes via pull request are very welcome as well.

## Requesting a Feature
If you are working with ProbNum, and you are missing a feature, please open an issue and detail what feature you 
would like to see. Please also check existing issues in case someone else requested the same or a similar feature. 
Detail the intended functionality and use case of the feature. 
You can also lay out how you would implement the feature. 
If you have a working version, please consider creating a pull request!

## Contributing via Pull Request

You implemented an additional feature, a tutorial, tests, or some other enhancement to ProbNum? That's great! 
Please consider creating a pull request (PR) with the changes. 

If you do so, please check out the 
[developer guide](https://probnum.readthedocs.io/en/latest/development/contributing_code.html) first.

Before working on a pull request, please check existing open, and recently merged, pull requests to make sure 
someone else hasn't addressed the problem already.
If your PR is larger please open an issue first to discuss any significant work - we would hate 
for your time to be wasted. 

That's it! Thanks for contributing to ProbNum!

(Contribution guide, inspired by [Emukit's](https://github.com/EmuKit/emukit/blob/master/CONTRIBUTING.md) contribution guide.)