from requests import get
from os.path import exists
from os import mkdir
from modules.color import print_colored, colors, bcolors
from modules.outfile import WriteToFile
from dataclasses import dataclass

printed_software = []

@dataclass
class ExploitInfo:
    Platform : str
    PublishDate : str
    Type : str
    ExploitDBID : int
    Author : str
    Metasploit : bool
    Verified : bool
    Link : str

def GetExploitInfo(CVEID):
    apiresponse = get(
        "https://www.exploit-db.com/search?cve=" + CVEID, 
        headers={
            "X-Requested-With": "XMLHttpRequest",
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.5005.63 Safari/537.36"
        }
    )
    if apiresponse.status_code == 200:
        apidata = apiresponse.json()
        ExploitInfos = []
        for exploit in apidata['data']:
            Exploit = ExploitInfo(
                Platform=exploit['platform_id'],
                PublishDate = exploit['date_published'],
                Type = exploit['type_id'],
                ExploitDBID = int(exploit['id']),
                Author = exploit['author']['name'],
                Metasploit = exploit['author']['name'] == "Metasploit",
                Verified = exploit['verified'] == "1",
                Link = "https://www.exploit-db.com/download/" + exploit['id']
            )
            ExploitInfos.append(Exploit)
        return ExploitInfos
    else:
        return []

def GetExploitContents(ExploitLink):
    apiresponse = get(
        ExploitLink, 
        headers={
            "X-Requested-With": "XMLHttpRequest",
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.5005.63 Safari/537.36"
        }
    )
    if apiresponse.status_code == 200:
        content = apiresponse.content
        filename = apiresponse.headers['Content-Disposition'].lstrip("attachment; filename=\"")
        
        return content, filename
    else:
        return None, None


def GetExploitAsFile(vulnerability):
    SoftwareName = vulnerability.Software
    CVEs = vulnerability.CVEs

    for CVE in CVEs:
        Exploits = GetExploitInfo(CVE)
        if not len(Exploits) > 0:
            continue

        if not SoftwareName in printed_software:
            print("\n\n┌─" + bcolors.yellow + "[ " + SoftwareName + " ]" + bcolors.endc + "\n│")
            printed_software.append(SoftwareName)
            WriteToFile("\n\n┌─[ %s ]" % SoftwareName)

        print("│\n├─────┤ " + bcolors.red + str(CVE) + bcolors.endc + "\n│")
        WriteToFile("\n├─────┤ " + CVE + "\n│")

        for exploit in Exploits:

            print(" " * 100, end="\r") #clear the line
            print("Downloading exploit for %s (%s)..." % (SoftwareName, CVE), end="\r")
            content, filename = GetExploitContents(exploit.Link)
            if content is None:
                continue
            if not exists("exploits"):
                mkdir("exploits")
            if not exists("exploits/" + SoftwareName):
                mkdir("exploits/" + SoftwareName)
            if not exists("exploits/" + SoftwareName + "/" + CVE):
                mkdir("exploits/" + SoftwareName + "/" + CVE)

            with open("exploits/" + SoftwareName + "/" + CVE + "/" + filename, "wb") as exploitfile:
                print(" " * 100, end="\r") #clear the line
                print("├──────────# exploits/" + SoftwareName + "/" + CVE + "/" + filename + "\n│")
                print("│\t\t" + bcolors.cyan + "Platform: " + bcolors.endc + exploit.Platform)
                print("│\t\t" + bcolors.cyan + "Type: " + bcolors.endc + exploit.Type)
                print("│\t\t" + bcolors.cyan + "Author: " + bcolors.endc + exploit.Author)
                print("│\t\t" + bcolors.cyan + "Date: " + bcolors.endc + exploit.PublishDate)
                print("│\t\t" + bcolors.cyan + "Metasploit: " + bcolors.endc + str(exploit.Metasploit))
                print("│\t\t" + bcolors.cyan + "Verified: " + bcolors.endc + str(exploit.Verified))
                print("│\t\t" + bcolors.cyan + "Link: " + bcolors.endc + exploit.Link + "\n│")
                WriteToFile("├──────────# exploits/" + SoftwareName + "/" + CVE + "/" + filename + "\n│")
                exploitfile.write(content)
                exploitfile.close()
    if SoftwareName in printed_software:
        print(" " * 100, end="\r")
        print("└" + "─" * 59 + "\n")

def GetExploitsFromArray(VulnsArray, target=None):
    print_colored("\n" + "─" * 60, colors.blue)
    if target:
        print_colored(("Downloading exploits for %s..." % (target)).center(60), colors.blue)
    else:
        print_colored("Downloading exploits...".center(60), colors.blue)
    print_colored("─" * 60, colors.blue)
    WriteToFile("\nDownloading exploits...")

    for vulnerability in VulnsArray:
        GetExploitAsFile(vulnerability)
        