import * as sfn from '@aws-cdk/aws-stepfunctions';
/**
 * Http Methods that API Gateway supports.
 *
 * @stability stable
 */
export declare enum HttpMethod {
    /**
     * Retreive data from a server at the specified resource.
     *
     * @stability stable
     */
    GET = "GET",
    /**
     * Send data to the API endpoint to create or udpate a resource.
     *
     * @stability stable
     */
    POST = "POST",
    /**
     * Send data to the API endpoint to update or create a resource.
     *
     * @stability stable
     */
    PUT = "PUT",
    /**
     * Delete the resource at the specified endpoint.
     *
     * @stability stable
     */
    DELETE = "DELETE",
    /**
     * Apply partial modifications to the resource.
     *
     * @stability stable
     */
    PATCH = "PATCH",
    /**
     * Retreive data from a server at the specified resource without the response body.
     *
     * @stability stable
     */
    HEAD = "HEAD",
    /**
     * Return data describing what other methods and operations the server supports.
     *
     * @stability stable
     */
    OPTIONS = "OPTIONS"
}
/**
 * The authentication method used to call the endpoint.
 *
 * @stability stable
 */
export declare enum AuthType {
    /**
     * Call the API direclty with no authorization method.
     *
     * @stability stable
     */
    NO_AUTH = "NO_AUTH",
    /**
     * Use the IAM role associated with the current state machine for authorization.
     *
     * @stability stable
     */
    IAM_ROLE = "IAM_ROLE",
    /**
     * Use the resource policy of the API for authorization.
     *
     * @stability stable
     */
    RESOURCE_POLICY = "RESOURCE_POLICY"
}
/**
 * Base CallApiGatewayEdnpoint Task Props.
 *
 * @stability stable
 */
export interface CallApiGatewayEndpointBaseProps extends sfn.TaskStateBaseProps {
    /**
     * Http method for the API.
     *
     * @stability stable
     */
    readonly method: HttpMethod;
    /**
     * HTTP request information that does not relate to contents of the request.
     *
     * @default - No headers
     * @stability stable
     */
    readonly headers?: sfn.TaskInput;
    /**
     * Path parameters appended after API endpoint.
     *
     * @default - No path
     * @stability stable
     */
    readonly apiPath?: string;
    /**
     * Query strings attatched to end of request.
     *
     * @default - No query parameters
     * @stability stable
     */
    readonly queryParameters?: sfn.TaskInput;
    /**
     * HTTP Request body.
     *
     * @default - No request body
     * @stability stable
     */
    readonly requestBody?: sfn.TaskInput;
    /**
     * Authentication methods.
     *
     * @default AuthType.NO_AUTH
     * @stability stable
     */
    readonly authType?: AuthType;
}
