#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['NuRadioReco',
 'NuRadioReco.detector',
 'NuRadioReco.detector.ARA',
 'NuRadioReco.detector.ARIANNA',
 'NuRadioReco.detector.RNO_G',
 'NuRadioReco.eventbrowser',
 'NuRadioReco.eventbrowser.apps',
 'NuRadioReco.eventbrowser.apps.trace_plots',
 'NuRadioReco.framework',
 'NuRadioReco.modules',
 'NuRadioReco.modules.ARA',
 'NuRadioReco.modules.ARIANNA',
 'NuRadioReco.modules.RNO_G',
 'NuRadioReco.modules.base',
 'NuRadioReco.modules.custom',
 'NuRadioReco.modules.custom.deltaT',
 'NuRadioReco.modules.io',
 'NuRadioReco.modules.io.araroot',
 'NuRadioReco.modules.io.coreas',
 'NuRadioReco.modules.io.noise',
 'NuRadioReco.modules.io.snowshovel',
 'NuRadioReco.modules.neutrino2DVertexReconstructor',
 'NuRadioReco.modules.phasedarray',
 'NuRadioReco.modules.trigger',
 'NuRadioReco.utilities']

package_data = \
{'': ['*'],
 'NuRadioReco': ['autodoc/*',
                 'autodoc/custom_scripts/*',
                 'autodoc/pages/*',
                 'examples/*',
                 'examples/AliasPhasedArray/*',
                 'examples/AliasPhasedArray/Noise_trigger_rate/*',
                 'examples/AliasPhasedArray/SNR_study/*',
                 'examples/AraData/*',
                 'examples/EnvelopePhasedArray/*',
                 'examples/EnvelopePhasedArray/Effective_volume/*',
                 'examples/EnvelopePhasedArray/Noise_trigger_rate/*',
                 'examples/PhasedArray/*',
                 'examples/PhasedArray/Effective_volume/*',
                 'examples/PhasedArray/Noise_trigger_rate/*',
                 'examples/PhasedArray/SNR_curves/*',
                 'examples/PhasedArray/SNR_curves/results/*',
                 'examples/StandAloneScripts/*',
                 'examples/example_data/*',
                 'test/*',
                 'test/tiny_reconstruction/*',
                 'test/trigger_tests/*'],
 'NuRadioReco.detector': ['amps/*',
                          'amps/NTU01/*',
                          'detector_browser/*',
                          'detector_browser/assets/*',
                          'filter/*',
                          'filter/SBLP-467+_S2P/*',
                          'filter/SHP-20+_S2P/*',
                          'filter/SHP-25+_S2P/*',
                          'filter/SHP-48+_S2P/*',
                          'filter/SXHP-48+_S2P/*',
                          'filter/ZFHP-1R2-S+_S2P/*',
                          'filter/ZFLP-450+_S2P/*',
                          'filter/ZX75HP-44+_S2P/*',
                          'filter/ZX75LP-470+_S2P/*',
                          'test/*',
                          'visualization/*',
                          'visualization/assets/*'],
 'NuRadioReco.detector.ARA': ['HardwareResponses/*'],
 'NuRadioReco.detector.ARIANNA': ['HardwareResponses/*'],
 'NuRadioReco.detector.RNO_G': ['HardwareResponses/*'],
 'NuRadioReco.eventbrowser': ['assets/*',
                              'assets/fontawesome/*',
                              'assets/fontawesome/css/*',
                              'assets/fontawesome/font/*'],
 'NuRadioReco.eventbrowser.apps': ['cosmic_ray_plots/*',
                                   'overview_plots/*',
                                   'simulation_plots/*'],
 'NuRadioReco.modules': ['envelope_phasedarray/*']}

install_requires = \
['tinydb>=4.1.1',
 'tinydb-serialization',
 'aenum',
 'astropy',
 'radiotools >=0.2.0',
 'h5py',
 'peakutils',
 'requests']

extras_require = \
{'doc': ['sphinx']}

setup(name='NuRadioReco',
      version='1.2',
      description='NuRadioReco: A reconstruction framework for radio neutrino detectors',
      author='Christian Glaser',
      author_email='work@c-glaser.de',
      url='https://github.com/nu-radio/NuRadioReco',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>3.6',
     )
