from dataclasses import dataclass
from abc import abstractmethod
from Utils.Subprocess import check_call
from Tc.TcCollection import TcCollection


class NetemCmd(object):
    @abstractmethod
    def make_cmd(self):
        pass

    @staticmethod
    def format(value, to_append):
        if value:
            return f"{value}{to_append}"
        else:
            return ""


# needed for set eq and hash to decide uniqueness of object,
# hash is generated by default if eq and frozen
@dataclass(eq=True, frozen=True)
class Loss(NetemCmd):
    _ratio: float = 0.0
    _correlation: float = 0.0

    def make_cmd(self):
        _ratio = self.format(self._ratio, "%")
        _correlation = self.format(self._correlation, "%")
        return f"loss {_ratio} {_correlation}"


@dataclass(eq=True, frozen=True)
class Duplicate(NetemCmd):
    _ratio: float = 0.0
    _correlation: float = 0.0

    def make_cmd(self):
        _ratio = self.format(self._ratio, "%")
        _correlation = self.format(self._correlation, "%")
        return f"duplicate {_ratio} {_correlation}"


@dataclass(eq=True, frozen=True)
class Delay(NetemCmd):
    _time: int = 0
    _jitter: int = 0
    _correlation: float = 0.0

    def make_cmd(self):
        _time = self.format(self._time, "ms")
        _jitter = self.format(self._jitter, "ms")
        _correlation = self.format(self._correlation, "%")

        return f"delay {_time} {_jitter} {_correlation}"


@dataclass(eq=True, frozen=True)
class Reorder(NetemCmd):
    _ratio: float = 0.0
    _correlation: float = 0.0

    def make_cmd(self):
        _ratio = self.format(self._ratio, "%")
        _correlation = self.format(self._correlation, "%")

        return f"reorder {_ratio} {_correlation}"


@dataclass(eq=True, frozen=True)
class Corrupt(NetemCmd):
    _ratio: float = 0.0
    _correlation: float = 0.0

    def make_cmd(self):
        _ratio = self.format(self._ratio, "%")
        _correlation = self.format(self._correlation, "%")

        return f"corrupt {_ratio} {_correlation}"


class NetemCollection(TcCollection):
    def __init__(self, nic):
        super().__init__()
        self._nic = nic

    def apply_cmd(self, operation):
        _used_dtcls = set()

        self._operation_check(operation)

        for dtcls in self:
            for param_val in dtcls.__dict__.values():
                if param_val:
                    _used_dtcls.add(dtcls)

        # generate empty cmd to reset the tc qdisc device
        if operation == "reset":
            _used_dtcls = set()
            operation = "change"

        check_call(f"tc qdisc {operation} dev {self._nic} parent 1:2 handle 20: netem "
                   + " ".join([x.make_cmd() for x in _used_dtcls]))
