"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleProvider = exports.GoogleProviderBatchingOutputReference = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googleProviderBatchingToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable_batching: cdktf.booleanToTerraform(struct.enableBatching),
        send_after: cdktf.stringToTerraform(struct.sendAfter),
    };
}
/**
 * @stability stable
 */
class GoogleProviderBatchingOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get enableBatching() {
        return this._enableBatching;
    }
    /**
     * @stability stable
     */
    set enableBatching(value) {
        this._enableBatching = value;
    }
    /**
     * @stability stable
     */
    resetEnableBatching() {
        this._enableBatching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get enableBatchingInput() {
        return this._enableBatching;
    }
    /**
     * @stability stable
     */
    get sendAfter() {
        return this._sendAfter;
    }
    /**
     * @stability stable
     */
    set sendAfter(value) {
        this._sendAfter = value;
    }
    /**
     * @stability stable
     */
    resetSendAfter() {
        this._sendAfter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sendAfterInput() {
        return this._sendAfter;
    }
}
exports.GoogleProviderBatchingOutputReference = GoogleProviderBatchingOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GoogleProviderBatchingOutputReference[_a] = { fqn: "@cdktf/provider-google.GoogleProviderBatchingOutputReference", version: "0.3.90" };
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google google}.
 *
 * @stability stable
 */
class GoogleProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google google} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'google',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersionConstraint: '~> 3.0'
            },
            terraformProviderSource: 'google'
        });
        this._accessApprovalCustomEndpoint = config.accessApprovalCustomEndpoint;
        this._accessContextManagerCustomEndpoint = config.accessContextManagerCustomEndpoint;
        this._accessToken = config.accessToken;
        this._activeDirectoryCustomEndpoint = config.activeDirectoryCustomEndpoint;
        this._apigeeCustomEndpoint = config.apigeeCustomEndpoint;
        this._appEngineCustomEndpoint = config.appEngineCustomEndpoint;
        this._assuredWorkloadsCustomEndpoint = config.assuredWorkloadsCustomEndpoint;
        this._bigQueryCustomEndpoint = config.bigQueryCustomEndpoint;
        this._bigqueryDataTransferCustomEndpoint = config.bigqueryDataTransferCustomEndpoint;
        this._bigqueryReservationCustomEndpoint = config.bigqueryReservationCustomEndpoint;
        this._bigtableCustomEndpoint = config.bigtableCustomEndpoint;
        this._billingCustomEndpoint = config.billingCustomEndpoint;
        this._billingProject = config.billingProject;
        this._binaryAuthorizationCustomEndpoint = config.binaryAuthorizationCustomEndpoint;
        this._cloudAssetCustomEndpoint = config.cloudAssetCustomEndpoint;
        this._cloudBillingCustomEndpoint = config.cloudBillingCustomEndpoint;
        this._cloudBuildCustomEndpoint = config.cloudBuildCustomEndpoint;
        this._cloudFunctionsCustomEndpoint = config.cloudFunctionsCustomEndpoint;
        this._cloudIdentityCustomEndpoint = config.cloudIdentityCustomEndpoint;
        this._cloudIotCustomEndpoint = config.cloudIotCustomEndpoint;
        this._cloudResourceManagerCustomEndpoint = config.cloudResourceManagerCustomEndpoint;
        this._cloudRunCustomEndpoint = config.cloudRunCustomEndpoint;
        this._cloudSchedulerCustomEndpoint = config.cloudSchedulerCustomEndpoint;
        this._cloudTasksCustomEndpoint = config.cloudTasksCustomEndpoint;
        this._composerCustomEndpoint = config.composerCustomEndpoint;
        this._computeBetaCustomEndpoint = config.computeBetaCustomEndpoint;
        this._computeCustomEndpoint = config.computeCustomEndpoint;
        this._containerAnalysisCustomEndpoint = config.containerAnalysisCustomEndpoint;
        this._containerBetaCustomEndpoint = config.containerBetaCustomEndpoint;
        this._containerCustomEndpoint = config.containerCustomEndpoint;
        this._credentials = config.credentials;
        this._dataCatalogCustomEndpoint = config.dataCatalogCustomEndpoint;
        this._dataLossPreventionCustomEndpoint = config.dataLossPreventionCustomEndpoint;
        this._dataflowCustomEndpoint = config.dataflowCustomEndpoint;
        this._dataprocBetaCustomEndpoint = config.dataprocBetaCustomEndpoint;
        this._dataprocCustomEndpoint = config.dataprocCustomEndpoint;
        this._datastoreCustomEndpoint = config.datastoreCustomEndpoint;
        this._deploymentManagerCustomEndpoint = config.deploymentManagerCustomEndpoint;
        this._dialogflowCustomEndpoint = config.dialogflowCustomEndpoint;
        this._dialogflowCxCustomEndpoint = config.dialogflowCxCustomEndpoint;
        this._dnsCustomEndpoint = config.dnsCustomEndpoint;
        this._essentialContactsCustomEndpoint = config.essentialContactsCustomEndpoint;
        this._eventarcCustomEndpoint = config.eventarcCustomEndpoint;
        this._filestoreCustomEndpoint = config.filestoreCustomEndpoint;
        this._firestoreCustomEndpoint = config.firestoreCustomEndpoint;
        this._gameServicesCustomEndpoint = config.gameServicesCustomEndpoint;
        this._gkeHubCustomEndpoint = config.gkeHubCustomEndpoint;
        this._gkehubFeatureCustomEndpoint = config.gkehubFeatureCustomEndpoint;
        this._healthcareCustomEndpoint = config.healthcareCustomEndpoint;
        this._iamCredentialsCustomEndpoint = config.iamCredentialsCustomEndpoint;
        this._iamCustomEndpoint = config.iamCustomEndpoint;
        this._iapCustomEndpoint = config.iapCustomEndpoint;
        this._identityPlatformCustomEndpoint = config.identityPlatformCustomEndpoint;
        this._impersonateServiceAccount = config.impersonateServiceAccount;
        this._impersonateServiceAccountDelegates = config.impersonateServiceAccountDelegates;
        this._kmsCustomEndpoint = config.kmsCustomEndpoint;
        this._loggingCustomEndpoint = config.loggingCustomEndpoint;
        this._memcacheCustomEndpoint = config.memcacheCustomEndpoint;
        this._mlEngineCustomEndpoint = config.mlEngineCustomEndpoint;
        this._monitoringCustomEndpoint = config.monitoringCustomEndpoint;
        this._networkManagementCustomEndpoint = config.networkManagementCustomEndpoint;
        this._networkServicesCustomEndpoint = config.networkServicesCustomEndpoint;
        this._notebooksCustomEndpoint = config.notebooksCustomEndpoint;
        this._orgPolicyCustomEndpoint = config.orgPolicyCustomEndpoint;
        this._osConfigCustomEndpoint = config.osConfigCustomEndpoint;
        this._osLoginCustomEndpoint = config.osLoginCustomEndpoint;
        this._privatecaCustomEndpoint = config.privatecaCustomEndpoint;
        this._project = config.project;
        this._pubsubCustomEndpoint = config.pubsubCustomEndpoint;
        this._pubsubLiteCustomEndpoint = config.pubsubLiteCustomEndpoint;
        this._redisCustomEndpoint = config.redisCustomEndpoint;
        this._region = config.region;
        this._requestReason = config.requestReason;
        this._requestTimeout = config.requestTimeout;
        this._resourceManagerCustomEndpoint = config.resourceManagerCustomEndpoint;
        this._resourceManagerV2CustomEndpoint = config.resourceManagerV2CustomEndpoint;
        this._runtimeConfigCustomEndpoint = config.runtimeConfigCustomEndpoint;
        this._runtimeconfigCustomEndpoint = config.runtimeconfigCustomEndpoint;
        this._scopes = config.scopes;
        this._secretManagerCustomEndpoint = config.secretManagerCustomEndpoint;
        this._securityCenterCustomEndpoint = config.securityCenterCustomEndpoint;
        this._serviceManagementCustomEndpoint = config.serviceManagementCustomEndpoint;
        this._serviceNetworkingCustomEndpoint = config.serviceNetworkingCustomEndpoint;
        this._serviceUsageCustomEndpoint = config.serviceUsageCustomEndpoint;
        this._sourceRepoCustomEndpoint = config.sourceRepoCustomEndpoint;
        this._spannerCustomEndpoint = config.spannerCustomEndpoint;
        this._sqlCustomEndpoint = config.sqlCustomEndpoint;
        this._storageCustomEndpoint = config.storageCustomEndpoint;
        this._storageTransferCustomEndpoint = config.storageTransferCustomEndpoint;
        this._tagsCustomEndpoint = config.tagsCustomEndpoint;
        this._tpuCustomEndpoint = config.tpuCustomEndpoint;
        this._userProjectOverride = config.userProjectOverride;
        this._vertexAiCustomEndpoint = config.vertexAiCustomEndpoint;
        this._vpcAccessCustomEndpoint = config.vpcAccessCustomEndpoint;
        this._workflowsCustomEndpoint = config.workflowsCustomEndpoint;
        this._zone = config.zone;
        this._alias = config.alias;
        this._batching = config.batching;
    }
    /**
     * @stability stable
     */
    get accessApprovalCustomEndpoint() {
        return this._accessApprovalCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set accessApprovalCustomEndpoint(value) {
        this._accessApprovalCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetAccessApprovalCustomEndpoint() {
        this._accessApprovalCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get accessApprovalCustomEndpointInput() {
        return this._accessApprovalCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get accessContextManagerCustomEndpoint() {
        return this._accessContextManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set accessContextManagerCustomEndpoint(value) {
        this._accessContextManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetAccessContextManagerCustomEndpoint() {
        this._accessContextManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get accessContextManagerCustomEndpointInput() {
        return this._accessContextManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get accessToken() {
        return this._accessToken;
    }
    /**
     * @stability stable
     */
    set accessToken(value) {
        this._accessToken = value;
    }
    /**
     * @stability stable
     */
    resetAccessToken() {
        this._accessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get accessTokenInput() {
        return this._accessToken;
    }
    /**
     * @stability stable
     */
    get activeDirectoryCustomEndpoint() {
        return this._activeDirectoryCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set activeDirectoryCustomEndpoint(value) {
        this._activeDirectoryCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetActiveDirectoryCustomEndpoint() {
        this._activeDirectoryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get activeDirectoryCustomEndpointInput() {
        return this._activeDirectoryCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get apigeeCustomEndpoint() {
        return this._apigeeCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set apigeeCustomEndpoint(value) {
        this._apigeeCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetApigeeCustomEndpoint() {
        this._apigeeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get apigeeCustomEndpointInput() {
        return this._apigeeCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get appEngineCustomEndpoint() {
        return this._appEngineCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set appEngineCustomEndpoint(value) {
        this._appEngineCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetAppEngineCustomEndpoint() {
        this._appEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get appEngineCustomEndpointInput() {
        return this._appEngineCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get assuredWorkloadsCustomEndpoint() {
        return this._assuredWorkloadsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set assuredWorkloadsCustomEndpoint(value) {
        this._assuredWorkloadsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetAssuredWorkloadsCustomEndpoint() {
        this._assuredWorkloadsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get assuredWorkloadsCustomEndpointInput() {
        return this._assuredWorkloadsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get bigQueryCustomEndpoint() {
        return this._bigQueryCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set bigQueryCustomEndpoint(value) {
        this._bigQueryCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBigQueryCustomEndpoint() {
        this._bigQueryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get bigQueryCustomEndpointInput() {
        return this._bigQueryCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get bigqueryDataTransferCustomEndpoint() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set bigqueryDataTransferCustomEndpoint(value) {
        this._bigqueryDataTransferCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBigqueryDataTransferCustomEndpoint() {
        this._bigqueryDataTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get bigqueryDataTransferCustomEndpointInput() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get bigqueryReservationCustomEndpoint() {
        return this._bigqueryReservationCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set bigqueryReservationCustomEndpoint(value) {
        this._bigqueryReservationCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBigqueryReservationCustomEndpoint() {
        this._bigqueryReservationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get bigqueryReservationCustomEndpointInput() {
        return this._bigqueryReservationCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get bigtableCustomEndpoint() {
        return this._bigtableCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set bigtableCustomEndpoint(value) {
        this._bigtableCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBigtableCustomEndpoint() {
        this._bigtableCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get bigtableCustomEndpointInput() {
        return this._bigtableCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get billingCustomEndpoint() {
        return this._billingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set billingCustomEndpoint(value) {
        this._billingCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBillingCustomEndpoint() {
        this._billingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get billingCustomEndpointInput() {
        return this._billingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get billingProject() {
        return this._billingProject;
    }
    /**
     * @stability stable
     */
    set billingProject(value) {
        this._billingProject = value;
    }
    /**
     * @stability stable
     */
    resetBillingProject() {
        this._billingProject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get billingProjectInput() {
        return this._billingProject;
    }
    /**
     * @stability stable
     */
    get binaryAuthorizationCustomEndpoint() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set binaryAuthorizationCustomEndpoint(value) {
        this._binaryAuthorizationCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetBinaryAuthorizationCustomEndpoint() {
        this._binaryAuthorizationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get binaryAuthorizationCustomEndpointInput() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudAssetCustomEndpoint() {
        return this._cloudAssetCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudAssetCustomEndpoint(value) {
        this._cloudAssetCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudAssetCustomEndpoint() {
        this._cloudAssetCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudAssetCustomEndpointInput() {
        return this._cloudAssetCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudBillingCustomEndpoint() {
        return this._cloudBillingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudBillingCustomEndpoint(value) {
        this._cloudBillingCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudBillingCustomEndpoint() {
        this._cloudBillingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudBillingCustomEndpointInput() {
        return this._cloudBillingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudBuildCustomEndpoint() {
        return this._cloudBuildCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudBuildCustomEndpoint(value) {
        this._cloudBuildCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudBuildCustomEndpoint() {
        this._cloudBuildCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudBuildCustomEndpointInput() {
        return this._cloudBuildCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudFunctionsCustomEndpoint() {
        return this._cloudFunctionsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudFunctionsCustomEndpoint(value) {
        this._cloudFunctionsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudFunctionsCustomEndpoint() {
        this._cloudFunctionsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudFunctionsCustomEndpointInput() {
        return this._cloudFunctionsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudIdentityCustomEndpoint() {
        return this._cloudIdentityCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudIdentityCustomEndpoint(value) {
        this._cloudIdentityCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudIdentityCustomEndpoint() {
        this._cloudIdentityCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudIdentityCustomEndpointInput() {
        return this._cloudIdentityCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudIotCustomEndpoint() {
        return this._cloudIotCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudIotCustomEndpoint(value) {
        this._cloudIotCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudIotCustomEndpoint() {
        this._cloudIotCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudIotCustomEndpointInput() {
        return this._cloudIotCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudResourceManagerCustomEndpoint() {
        return this._cloudResourceManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudResourceManagerCustomEndpoint(value) {
        this._cloudResourceManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudResourceManagerCustomEndpoint() {
        this._cloudResourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudResourceManagerCustomEndpointInput() {
        return this._cloudResourceManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudRunCustomEndpoint() {
        return this._cloudRunCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudRunCustomEndpoint(value) {
        this._cloudRunCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudRunCustomEndpoint() {
        this._cloudRunCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudRunCustomEndpointInput() {
        return this._cloudRunCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudSchedulerCustomEndpoint() {
        return this._cloudSchedulerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudSchedulerCustomEndpoint(value) {
        this._cloudSchedulerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudSchedulerCustomEndpoint() {
        this._cloudSchedulerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudSchedulerCustomEndpointInput() {
        return this._cloudSchedulerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get cloudTasksCustomEndpoint() {
        return this._cloudTasksCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set cloudTasksCustomEndpoint(value) {
        this._cloudTasksCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetCloudTasksCustomEndpoint() {
        this._cloudTasksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cloudTasksCustomEndpointInput() {
        return this._cloudTasksCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get composerCustomEndpoint() {
        return this._composerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set composerCustomEndpoint(value) {
        this._composerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetComposerCustomEndpoint() {
        this._composerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get composerCustomEndpointInput() {
        return this._composerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get computeBetaCustomEndpoint() {
        return this._computeBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set computeBetaCustomEndpoint(value) {
        this._computeBetaCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetComputeBetaCustomEndpoint() {
        this._computeBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get computeBetaCustomEndpointInput() {
        return this._computeBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get computeCustomEndpoint() {
        return this._computeCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set computeCustomEndpoint(value) {
        this._computeCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetComputeCustomEndpoint() {
        this._computeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get computeCustomEndpointInput() {
        return this._computeCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get containerAnalysisCustomEndpoint() {
        return this._containerAnalysisCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set containerAnalysisCustomEndpoint(value) {
        this._containerAnalysisCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetContainerAnalysisCustomEndpoint() {
        this._containerAnalysisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get containerAnalysisCustomEndpointInput() {
        return this._containerAnalysisCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get containerBetaCustomEndpoint() {
        return this._containerBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set containerBetaCustomEndpoint(value) {
        this._containerBetaCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetContainerBetaCustomEndpoint() {
        this._containerBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get containerBetaCustomEndpointInput() {
        return this._containerBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get containerCustomEndpoint() {
        return this._containerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set containerCustomEndpoint(value) {
        this._containerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetContainerCustomEndpoint() {
        this._containerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get containerCustomEndpointInput() {
        return this._containerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get credentials() {
        return this._credentials;
    }
    /**
     * @stability stable
     */
    set credentials(value) {
        this._credentials = value;
    }
    /**
     * @stability stable
     */
    resetCredentials() {
        this._credentials = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get credentialsInput() {
        return this._credentials;
    }
    /**
     * @stability stable
     */
    get dataCatalogCustomEndpoint() {
        return this._dataCatalogCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataCatalogCustomEndpoint(value) {
        this._dataCatalogCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataCatalogCustomEndpoint() {
        this._dataCatalogCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataCatalogCustomEndpointInput() {
        return this._dataCatalogCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dataLossPreventionCustomEndpoint() {
        return this._dataLossPreventionCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataLossPreventionCustomEndpoint(value) {
        this._dataLossPreventionCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataLossPreventionCustomEndpoint() {
        this._dataLossPreventionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataLossPreventionCustomEndpointInput() {
        return this._dataLossPreventionCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dataflowCustomEndpoint() {
        return this._dataflowCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataflowCustomEndpoint(value) {
        this._dataflowCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataflowCustomEndpoint() {
        this._dataflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataflowCustomEndpointInput() {
        return this._dataflowCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dataprocBetaCustomEndpoint() {
        return this._dataprocBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataprocBetaCustomEndpoint(value) {
        this._dataprocBetaCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataprocBetaCustomEndpoint() {
        this._dataprocBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataprocBetaCustomEndpointInput() {
        return this._dataprocBetaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dataprocCustomEndpoint() {
        return this._dataprocCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dataprocCustomEndpoint(value) {
        this._dataprocCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDataprocCustomEndpoint() {
        this._dataprocCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dataprocCustomEndpointInput() {
        return this._dataprocCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get datastoreCustomEndpoint() {
        return this._datastoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set datastoreCustomEndpoint(value) {
        this._datastoreCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDatastoreCustomEndpoint() {
        this._datastoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get datastoreCustomEndpointInput() {
        return this._datastoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get deploymentManagerCustomEndpoint() {
        return this._deploymentManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set deploymentManagerCustomEndpoint(value) {
        this._deploymentManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDeploymentManagerCustomEndpoint() {
        this._deploymentManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deploymentManagerCustomEndpointInput() {
        return this._deploymentManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dialogflowCustomEndpoint() {
        return this._dialogflowCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dialogflowCustomEndpoint(value) {
        this._dialogflowCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDialogflowCustomEndpoint() {
        this._dialogflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dialogflowCustomEndpointInput() {
        return this._dialogflowCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dialogflowCxCustomEndpoint() {
        return this._dialogflowCxCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dialogflowCxCustomEndpoint(value) {
        this._dialogflowCxCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDialogflowCxCustomEndpoint() {
        this._dialogflowCxCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dialogflowCxCustomEndpointInput() {
        return this._dialogflowCxCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get dnsCustomEndpoint() {
        return this._dnsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set dnsCustomEndpoint(value) {
        this._dnsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetDnsCustomEndpoint() {
        this._dnsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dnsCustomEndpointInput() {
        return this._dnsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get essentialContactsCustomEndpoint() {
        return this._essentialContactsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set essentialContactsCustomEndpoint(value) {
        this._essentialContactsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetEssentialContactsCustomEndpoint() {
        this._essentialContactsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get essentialContactsCustomEndpointInput() {
        return this._essentialContactsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get eventarcCustomEndpoint() {
        return this._eventarcCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set eventarcCustomEndpoint(value) {
        this._eventarcCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetEventarcCustomEndpoint() {
        this._eventarcCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get eventarcCustomEndpointInput() {
        return this._eventarcCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get filestoreCustomEndpoint() {
        return this._filestoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set filestoreCustomEndpoint(value) {
        this._filestoreCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetFilestoreCustomEndpoint() {
        this._filestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get filestoreCustomEndpointInput() {
        return this._filestoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get firestoreCustomEndpoint() {
        return this._firestoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set firestoreCustomEndpoint(value) {
        this._firestoreCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetFirestoreCustomEndpoint() {
        this._firestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get firestoreCustomEndpointInput() {
        return this._firestoreCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get gameServicesCustomEndpoint() {
        return this._gameServicesCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set gameServicesCustomEndpoint(value) {
        this._gameServicesCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetGameServicesCustomEndpoint() {
        this._gameServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get gameServicesCustomEndpointInput() {
        return this._gameServicesCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get gkeHubCustomEndpoint() {
        return this._gkeHubCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set gkeHubCustomEndpoint(value) {
        this._gkeHubCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetGkeHubCustomEndpoint() {
        this._gkeHubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get gkeHubCustomEndpointInput() {
        return this._gkeHubCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get gkehubFeatureCustomEndpoint() {
        return this._gkehubFeatureCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set gkehubFeatureCustomEndpoint(value) {
        this._gkehubFeatureCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetGkehubFeatureCustomEndpoint() {
        this._gkehubFeatureCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get gkehubFeatureCustomEndpointInput() {
        return this._gkehubFeatureCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get healthcareCustomEndpoint() {
        return this._healthcareCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set healthcareCustomEndpoint(value) {
        this._healthcareCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetHealthcareCustomEndpoint() {
        this._healthcareCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get healthcareCustomEndpointInput() {
        return this._healthcareCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get iamCredentialsCustomEndpoint() {
        return this._iamCredentialsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set iamCredentialsCustomEndpoint(value) {
        this._iamCredentialsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetIamCredentialsCustomEndpoint() {
        this._iamCredentialsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get iamCredentialsCustomEndpointInput() {
        return this._iamCredentialsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get iamCustomEndpoint() {
        return this._iamCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set iamCustomEndpoint(value) {
        this._iamCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetIamCustomEndpoint() {
        this._iamCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get iamCustomEndpointInput() {
        return this._iamCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get iapCustomEndpoint() {
        return this._iapCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set iapCustomEndpoint(value) {
        this._iapCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetIapCustomEndpoint() {
        this._iapCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get iapCustomEndpointInput() {
        return this._iapCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get identityPlatformCustomEndpoint() {
        return this._identityPlatformCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set identityPlatformCustomEndpoint(value) {
        this._identityPlatformCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetIdentityPlatformCustomEndpoint() {
        this._identityPlatformCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get identityPlatformCustomEndpointInput() {
        return this._identityPlatformCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get impersonateServiceAccount() {
        return this._impersonateServiceAccount;
    }
    /**
     * @stability stable
     */
    set impersonateServiceAccount(value) {
        this._impersonateServiceAccount = value;
    }
    /**
     * @stability stable
     */
    resetImpersonateServiceAccount() {
        this._impersonateServiceAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get impersonateServiceAccountInput() {
        return this._impersonateServiceAccount;
    }
    /**
     * @stability stable
     */
    get impersonateServiceAccountDelegates() {
        return this._impersonateServiceAccountDelegates;
    }
    /**
     * @stability stable
     */
    set impersonateServiceAccountDelegates(value) {
        this._impersonateServiceAccountDelegates = value;
    }
    /**
     * @stability stable
     */
    resetImpersonateServiceAccountDelegates() {
        this._impersonateServiceAccountDelegates = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get impersonateServiceAccountDelegatesInput() {
        return this._impersonateServiceAccountDelegates;
    }
    /**
     * @stability stable
     */
    get kmsCustomEndpoint() {
        return this._kmsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set kmsCustomEndpoint(value) {
        this._kmsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetKmsCustomEndpoint() {
        this._kmsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get kmsCustomEndpointInput() {
        return this._kmsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get loggingCustomEndpoint() {
        return this._loggingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set loggingCustomEndpoint(value) {
        this._loggingCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetLoggingCustomEndpoint() {
        this._loggingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get loggingCustomEndpointInput() {
        return this._loggingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get memcacheCustomEndpoint() {
        return this._memcacheCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set memcacheCustomEndpoint(value) {
        this._memcacheCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetMemcacheCustomEndpoint() {
        this._memcacheCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get memcacheCustomEndpointInput() {
        return this._memcacheCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get mlEngineCustomEndpoint() {
        return this._mlEngineCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set mlEngineCustomEndpoint(value) {
        this._mlEngineCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetMlEngineCustomEndpoint() {
        this._mlEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get mlEngineCustomEndpointInput() {
        return this._mlEngineCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get monitoringCustomEndpoint() {
        return this._monitoringCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set monitoringCustomEndpoint(value) {
        this._monitoringCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetMonitoringCustomEndpoint() {
        this._monitoringCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get monitoringCustomEndpointInput() {
        return this._monitoringCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get networkManagementCustomEndpoint() {
        return this._networkManagementCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set networkManagementCustomEndpoint(value) {
        this._networkManagementCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetNetworkManagementCustomEndpoint() {
        this._networkManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get networkManagementCustomEndpointInput() {
        return this._networkManagementCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get networkServicesCustomEndpoint() {
        return this._networkServicesCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set networkServicesCustomEndpoint(value) {
        this._networkServicesCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetNetworkServicesCustomEndpoint() {
        this._networkServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get networkServicesCustomEndpointInput() {
        return this._networkServicesCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get notebooksCustomEndpoint() {
        return this._notebooksCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set notebooksCustomEndpoint(value) {
        this._notebooksCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetNotebooksCustomEndpoint() {
        this._notebooksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get notebooksCustomEndpointInput() {
        return this._notebooksCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get orgPolicyCustomEndpoint() {
        return this._orgPolicyCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set orgPolicyCustomEndpoint(value) {
        this._orgPolicyCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetOrgPolicyCustomEndpoint() {
        this._orgPolicyCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get orgPolicyCustomEndpointInput() {
        return this._orgPolicyCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get osConfigCustomEndpoint() {
        return this._osConfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set osConfigCustomEndpoint(value) {
        this._osConfigCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetOsConfigCustomEndpoint() {
        this._osConfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get osConfigCustomEndpointInput() {
        return this._osConfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get osLoginCustomEndpoint() {
        return this._osLoginCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set osLoginCustomEndpoint(value) {
        this._osLoginCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetOsLoginCustomEndpoint() {
        this._osLoginCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get osLoginCustomEndpointInput() {
        return this._osLoginCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get privatecaCustomEndpoint() {
        return this._privatecaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set privatecaCustomEndpoint(value) {
        this._privatecaCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetPrivatecaCustomEndpoint() {
        this._privatecaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get privatecaCustomEndpointInput() {
        return this._privatecaCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get project() {
        return this._project;
    }
    /**
     * @stability stable
     */
    set project(value) {
        this._project = value;
    }
    /**
     * @stability stable
     */
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get projectInput() {
        return this._project;
    }
    /**
     * @stability stable
     */
    get pubsubCustomEndpoint() {
        return this._pubsubCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set pubsubCustomEndpoint(value) {
        this._pubsubCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetPubsubCustomEndpoint() {
        this._pubsubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pubsubCustomEndpointInput() {
        return this._pubsubCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get pubsubLiteCustomEndpoint() {
        return this._pubsubLiteCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set pubsubLiteCustomEndpoint(value) {
        this._pubsubLiteCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetPubsubLiteCustomEndpoint() {
        this._pubsubLiteCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pubsubLiteCustomEndpointInput() {
        return this._pubsubLiteCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get redisCustomEndpoint() {
        return this._redisCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set redisCustomEndpoint(value) {
        this._redisCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetRedisCustomEndpoint() {
        this._redisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get redisCustomEndpointInput() {
        return this._redisCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get region() {
        return this._region;
    }
    /**
     * @stability stable
     */
    set region(value) {
        this._region = value;
    }
    /**
     * @stability stable
     */
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get regionInput() {
        return this._region;
    }
    /**
     * @stability stable
     */
    get requestReason() {
        return this._requestReason;
    }
    /**
     * @stability stable
     */
    set requestReason(value) {
        this._requestReason = value;
    }
    /**
     * @stability stable
     */
    resetRequestReason() {
        this._requestReason = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get requestReasonInput() {
        return this._requestReason;
    }
    /**
     * @stability stable
     */
    get requestTimeout() {
        return this._requestTimeout;
    }
    /**
     * @stability stable
     */
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    /**
     * @stability stable
     */
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    /**
     * @stability stable
     */
    get resourceManagerCustomEndpoint() {
        return this._resourceManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set resourceManagerCustomEndpoint(value) {
        this._resourceManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetResourceManagerCustomEndpoint() {
        this._resourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get resourceManagerCustomEndpointInput() {
        return this._resourceManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get resourceManagerV2CustomEndpoint() {
        return this._resourceManagerV2CustomEndpoint;
    }
    /**
     * @stability stable
     */
    set resourceManagerV2CustomEndpoint(value) {
        this._resourceManagerV2CustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetResourceManagerV2CustomEndpoint() {
        this._resourceManagerV2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get resourceManagerV2CustomEndpointInput() {
        return this._resourceManagerV2CustomEndpoint;
    }
    /**
     * @stability stable
     */
    get runtimeConfigCustomEndpoint() {
        return this._runtimeConfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set runtimeConfigCustomEndpoint(value) {
        this._runtimeConfigCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetRuntimeConfigCustomEndpoint() {
        this._runtimeConfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get runtimeConfigCustomEndpointInput() {
        return this._runtimeConfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get runtimeconfigCustomEndpoint() {
        return this._runtimeconfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set runtimeconfigCustomEndpoint(value) {
        this._runtimeconfigCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetRuntimeconfigCustomEndpoint() {
        this._runtimeconfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get runtimeconfigCustomEndpointInput() {
        return this._runtimeconfigCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get scopes() {
        return this._scopes;
    }
    /**
     * @stability stable
     */
    set scopes(value) {
        this._scopes = value;
    }
    /**
     * @stability stable
     */
    resetScopes() {
        this._scopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get scopesInput() {
        return this._scopes;
    }
    /**
     * @stability stable
     */
    get secretManagerCustomEndpoint() {
        return this._secretManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set secretManagerCustomEndpoint(value) {
        this._secretManagerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSecretManagerCustomEndpoint() {
        this._secretManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get secretManagerCustomEndpointInput() {
        return this._secretManagerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get securityCenterCustomEndpoint() {
        return this._securityCenterCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set securityCenterCustomEndpoint(value) {
        this._securityCenterCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSecurityCenterCustomEndpoint() {
        this._securityCenterCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get securityCenterCustomEndpointInput() {
        return this._securityCenterCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get serviceManagementCustomEndpoint() {
        return this._serviceManagementCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set serviceManagementCustomEndpoint(value) {
        this._serviceManagementCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetServiceManagementCustomEndpoint() {
        this._serviceManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get serviceManagementCustomEndpointInput() {
        return this._serviceManagementCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get serviceNetworkingCustomEndpoint() {
        return this._serviceNetworkingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set serviceNetworkingCustomEndpoint(value) {
        this._serviceNetworkingCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetServiceNetworkingCustomEndpoint() {
        this._serviceNetworkingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get serviceNetworkingCustomEndpointInput() {
        return this._serviceNetworkingCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get serviceUsageCustomEndpoint() {
        return this._serviceUsageCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set serviceUsageCustomEndpoint(value) {
        this._serviceUsageCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetServiceUsageCustomEndpoint() {
        this._serviceUsageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get serviceUsageCustomEndpointInput() {
        return this._serviceUsageCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get sourceRepoCustomEndpoint() {
        return this._sourceRepoCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set sourceRepoCustomEndpoint(value) {
        this._sourceRepoCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSourceRepoCustomEndpoint() {
        this._sourceRepoCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sourceRepoCustomEndpointInput() {
        return this._sourceRepoCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get spannerCustomEndpoint() {
        return this._spannerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set spannerCustomEndpoint(value) {
        this._spannerCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSpannerCustomEndpoint() {
        this._spannerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get spannerCustomEndpointInput() {
        return this._spannerCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get sqlCustomEndpoint() {
        return this._sqlCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set sqlCustomEndpoint(value) {
        this._sqlCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetSqlCustomEndpoint() {
        this._sqlCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sqlCustomEndpointInput() {
        return this._sqlCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get storageCustomEndpoint() {
        return this._storageCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set storageCustomEndpoint(value) {
        this._storageCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetStorageCustomEndpoint() {
        this._storageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get storageCustomEndpointInput() {
        return this._storageCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get storageTransferCustomEndpoint() {
        return this._storageTransferCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set storageTransferCustomEndpoint(value) {
        this._storageTransferCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetStorageTransferCustomEndpoint() {
        this._storageTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get storageTransferCustomEndpointInput() {
        return this._storageTransferCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get tagsCustomEndpoint() {
        return this._tagsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set tagsCustomEndpoint(value) {
        this._tagsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetTagsCustomEndpoint() {
        this._tagsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tagsCustomEndpointInput() {
        return this._tagsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get tpuCustomEndpoint() {
        return this._tpuCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set tpuCustomEndpoint(value) {
        this._tpuCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetTpuCustomEndpoint() {
        this._tpuCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tpuCustomEndpointInput() {
        return this._tpuCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get userProjectOverride() {
        return this._userProjectOverride;
    }
    /**
     * @stability stable
     */
    set userProjectOverride(value) {
        this._userProjectOverride = value;
    }
    /**
     * @stability stable
     */
    resetUserProjectOverride() {
        this._userProjectOverride = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get userProjectOverrideInput() {
        return this._userProjectOverride;
    }
    /**
     * @stability stable
     */
    get vertexAiCustomEndpoint() {
        return this._vertexAiCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set vertexAiCustomEndpoint(value) {
        this._vertexAiCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetVertexAiCustomEndpoint() {
        this._vertexAiCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get vertexAiCustomEndpointInput() {
        return this._vertexAiCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get vpcAccessCustomEndpoint() {
        return this._vpcAccessCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set vpcAccessCustomEndpoint(value) {
        this._vpcAccessCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetVpcAccessCustomEndpoint() {
        this._vpcAccessCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get vpcAccessCustomEndpointInput() {
        return this._vpcAccessCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get workflowsCustomEndpoint() {
        return this._workflowsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    set workflowsCustomEndpoint(value) {
        this._workflowsCustomEndpoint = value;
    }
    /**
     * @stability stable
     */
    resetWorkflowsCustomEndpoint() {
        this._workflowsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get workflowsCustomEndpointInput() {
        return this._workflowsCustomEndpoint;
    }
    /**
     * @stability stable
     */
    get zone() {
        return this._zone;
    }
    /**
     * @stability stable
     */
    set zone(value) {
        this._zone = value;
    }
    /**
     * @stability stable
     */
    resetZone() {
        this._zone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get zoneInput() {
        return this._zone;
    }
    /**
     * @stability stable
     */
    get alias() {
        return this._alias;
    }
    /**
     * @stability stable
     */
    set alias(value) {
        this._alias = value;
    }
    /**
     * @stability stable
     */
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get aliasInput() {
        return this._alias;
    }
    /**
     * @stability stable
     */
    get batching() {
        return this._batching;
    }
    /**
     * @stability stable
     */
    set batching(value) {
        this._batching = value;
    }
    /**
     * @stability stable
     */
    resetBatching() {
        this._batching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get batchingInput() {
        return this._batching;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            access_approval_custom_endpoint: cdktf.stringToTerraform(this._accessApprovalCustomEndpoint),
            access_context_manager_custom_endpoint: cdktf.stringToTerraform(this._accessContextManagerCustomEndpoint),
            access_token: cdktf.stringToTerraform(this._accessToken),
            active_directory_custom_endpoint: cdktf.stringToTerraform(this._activeDirectoryCustomEndpoint),
            apigee_custom_endpoint: cdktf.stringToTerraform(this._apigeeCustomEndpoint),
            app_engine_custom_endpoint: cdktf.stringToTerraform(this._appEngineCustomEndpoint),
            assured_workloads_custom_endpoint: cdktf.stringToTerraform(this._assuredWorkloadsCustomEndpoint),
            big_query_custom_endpoint: cdktf.stringToTerraform(this._bigQueryCustomEndpoint),
            bigquery_data_transfer_custom_endpoint: cdktf.stringToTerraform(this._bigqueryDataTransferCustomEndpoint),
            bigquery_reservation_custom_endpoint: cdktf.stringToTerraform(this._bigqueryReservationCustomEndpoint),
            bigtable_custom_endpoint: cdktf.stringToTerraform(this._bigtableCustomEndpoint),
            billing_custom_endpoint: cdktf.stringToTerraform(this._billingCustomEndpoint),
            billing_project: cdktf.stringToTerraform(this._billingProject),
            binary_authorization_custom_endpoint: cdktf.stringToTerraform(this._binaryAuthorizationCustomEndpoint),
            cloud_asset_custom_endpoint: cdktf.stringToTerraform(this._cloudAssetCustomEndpoint),
            cloud_billing_custom_endpoint: cdktf.stringToTerraform(this._cloudBillingCustomEndpoint),
            cloud_build_custom_endpoint: cdktf.stringToTerraform(this._cloudBuildCustomEndpoint),
            cloud_functions_custom_endpoint: cdktf.stringToTerraform(this._cloudFunctionsCustomEndpoint),
            cloud_identity_custom_endpoint: cdktf.stringToTerraform(this._cloudIdentityCustomEndpoint),
            cloud_iot_custom_endpoint: cdktf.stringToTerraform(this._cloudIotCustomEndpoint),
            cloud_resource_manager_custom_endpoint: cdktf.stringToTerraform(this._cloudResourceManagerCustomEndpoint),
            cloud_run_custom_endpoint: cdktf.stringToTerraform(this._cloudRunCustomEndpoint),
            cloud_scheduler_custom_endpoint: cdktf.stringToTerraform(this._cloudSchedulerCustomEndpoint),
            cloud_tasks_custom_endpoint: cdktf.stringToTerraform(this._cloudTasksCustomEndpoint),
            composer_custom_endpoint: cdktf.stringToTerraform(this._composerCustomEndpoint),
            compute_beta_custom_endpoint: cdktf.stringToTerraform(this._computeBetaCustomEndpoint),
            compute_custom_endpoint: cdktf.stringToTerraform(this._computeCustomEndpoint),
            container_analysis_custom_endpoint: cdktf.stringToTerraform(this._containerAnalysisCustomEndpoint),
            container_beta_custom_endpoint: cdktf.stringToTerraform(this._containerBetaCustomEndpoint),
            container_custom_endpoint: cdktf.stringToTerraform(this._containerCustomEndpoint),
            credentials: cdktf.stringToTerraform(this._credentials),
            data_catalog_custom_endpoint: cdktf.stringToTerraform(this._dataCatalogCustomEndpoint),
            data_loss_prevention_custom_endpoint: cdktf.stringToTerraform(this._dataLossPreventionCustomEndpoint),
            dataflow_custom_endpoint: cdktf.stringToTerraform(this._dataflowCustomEndpoint),
            dataproc_beta_custom_endpoint: cdktf.stringToTerraform(this._dataprocBetaCustomEndpoint),
            dataproc_custom_endpoint: cdktf.stringToTerraform(this._dataprocCustomEndpoint),
            datastore_custom_endpoint: cdktf.stringToTerraform(this._datastoreCustomEndpoint),
            deployment_manager_custom_endpoint: cdktf.stringToTerraform(this._deploymentManagerCustomEndpoint),
            dialogflow_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCustomEndpoint),
            dialogflow_cx_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCxCustomEndpoint),
            dns_custom_endpoint: cdktf.stringToTerraform(this._dnsCustomEndpoint),
            essential_contacts_custom_endpoint: cdktf.stringToTerraform(this._essentialContactsCustomEndpoint),
            eventarc_custom_endpoint: cdktf.stringToTerraform(this._eventarcCustomEndpoint),
            filestore_custom_endpoint: cdktf.stringToTerraform(this._filestoreCustomEndpoint),
            firestore_custom_endpoint: cdktf.stringToTerraform(this._firestoreCustomEndpoint),
            game_services_custom_endpoint: cdktf.stringToTerraform(this._gameServicesCustomEndpoint),
            gke_hub_custom_endpoint: cdktf.stringToTerraform(this._gkeHubCustomEndpoint),
            gkehub_feature_custom_endpoint: cdktf.stringToTerraform(this._gkehubFeatureCustomEndpoint),
            healthcare_custom_endpoint: cdktf.stringToTerraform(this._healthcareCustomEndpoint),
            iam_credentials_custom_endpoint: cdktf.stringToTerraform(this._iamCredentialsCustomEndpoint),
            iam_custom_endpoint: cdktf.stringToTerraform(this._iamCustomEndpoint),
            iap_custom_endpoint: cdktf.stringToTerraform(this._iapCustomEndpoint),
            identity_platform_custom_endpoint: cdktf.stringToTerraform(this._identityPlatformCustomEndpoint),
            impersonate_service_account: cdktf.stringToTerraform(this._impersonateServiceAccount),
            impersonate_service_account_delegates: cdktf.listMapper(cdktf.stringToTerraform)(this._impersonateServiceAccountDelegates),
            kms_custom_endpoint: cdktf.stringToTerraform(this._kmsCustomEndpoint),
            logging_custom_endpoint: cdktf.stringToTerraform(this._loggingCustomEndpoint),
            memcache_custom_endpoint: cdktf.stringToTerraform(this._memcacheCustomEndpoint),
            ml_engine_custom_endpoint: cdktf.stringToTerraform(this._mlEngineCustomEndpoint),
            monitoring_custom_endpoint: cdktf.stringToTerraform(this._monitoringCustomEndpoint),
            network_management_custom_endpoint: cdktf.stringToTerraform(this._networkManagementCustomEndpoint),
            network_services_custom_endpoint: cdktf.stringToTerraform(this._networkServicesCustomEndpoint),
            notebooks_custom_endpoint: cdktf.stringToTerraform(this._notebooksCustomEndpoint),
            org_policy_custom_endpoint: cdktf.stringToTerraform(this._orgPolicyCustomEndpoint),
            os_config_custom_endpoint: cdktf.stringToTerraform(this._osConfigCustomEndpoint),
            os_login_custom_endpoint: cdktf.stringToTerraform(this._osLoginCustomEndpoint),
            privateca_custom_endpoint: cdktf.stringToTerraform(this._privatecaCustomEndpoint),
            project: cdktf.stringToTerraform(this._project),
            pubsub_custom_endpoint: cdktf.stringToTerraform(this._pubsubCustomEndpoint),
            pubsub_lite_custom_endpoint: cdktf.stringToTerraform(this._pubsubLiteCustomEndpoint),
            redis_custom_endpoint: cdktf.stringToTerraform(this._redisCustomEndpoint),
            region: cdktf.stringToTerraform(this._region),
            request_reason: cdktf.stringToTerraform(this._requestReason),
            request_timeout: cdktf.stringToTerraform(this._requestTimeout),
            resource_manager_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerCustomEndpoint),
            resource_manager_v2_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerV2CustomEndpoint),
            runtime_config_custom_endpoint: cdktf.stringToTerraform(this._runtimeConfigCustomEndpoint),
            runtimeconfig_custom_endpoint: cdktf.stringToTerraform(this._runtimeconfigCustomEndpoint),
            scopes: cdktf.listMapper(cdktf.stringToTerraform)(this._scopes),
            secret_manager_custom_endpoint: cdktf.stringToTerraform(this._secretManagerCustomEndpoint),
            security_center_custom_endpoint: cdktf.stringToTerraform(this._securityCenterCustomEndpoint),
            service_management_custom_endpoint: cdktf.stringToTerraform(this._serviceManagementCustomEndpoint),
            service_networking_custom_endpoint: cdktf.stringToTerraform(this._serviceNetworkingCustomEndpoint),
            service_usage_custom_endpoint: cdktf.stringToTerraform(this._serviceUsageCustomEndpoint),
            source_repo_custom_endpoint: cdktf.stringToTerraform(this._sourceRepoCustomEndpoint),
            spanner_custom_endpoint: cdktf.stringToTerraform(this._spannerCustomEndpoint),
            sql_custom_endpoint: cdktf.stringToTerraform(this._sqlCustomEndpoint),
            storage_custom_endpoint: cdktf.stringToTerraform(this._storageCustomEndpoint),
            storage_transfer_custom_endpoint: cdktf.stringToTerraform(this._storageTransferCustomEndpoint),
            tags_custom_endpoint: cdktf.stringToTerraform(this._tagsCustomEndpoint),
            tpu_custom_endpoint: cdktf.stringToTerraform(this._tpuCustomEndpoint),
            user_project_override: cdktf.booleanToTerraform(this._userProjectOverride),
            vertex_ai_custom_endpoint: cdktf.stringToTerraform(this._vertexAiCustomEndpoint),
            vpc_access_custom_endpoint: cdktf.stringToTerraform(this._vpcAccessCustomEndpoint),
            workflows_custom_endpoint: cdktf.stringToTerraform(this._workflowsCustomEndpoint),
            zone: cdktf.stringToTerraform(this._zone),
            alias: cdktf.stringToTerraform(this._alias),
            batching: googleProviderBatchingToTerraform(this._batching),
        };
    }
}
exports.GoogleProvider = GoogleProvider;
_b = JSII_RTTI_SYMBOL_1;
GoogleProvider[_b] = { fqn: "@cdktf/provider-google.GoogleProvider", version: "0.3.90" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
GoogleProvider.tfResourceType = "google";
//# sourceMappingURL=data:application/json;base64,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