"""
automua™ is a trademark of "Gaspard d'Hautefeuille" and may not be used 
by third parties without the prior written permission of the author.

Copyright © 2022 Gaspard d'Hautefeuille: fix Autodiscover requests
Copyright © 2019-2022 Ralph Seichter

This file is part of automua.

automua is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

automua is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with automua. If not, see <https://www.gnu.org/licenses/>.
"""
import re

from flask import Response
from flask import make_response
from flask import request

from automua.util import parse_email_address

# Keys are case-sensitive when used in XML
EMAIL_MOZILLA = 'emailaddress'
EMAIL_OUTLOOK = 'EMailAddress'

CONTENT_TYPE = 'Content-Type'
CONTENT_TYPE_XML = 'application/xml'


class MailConfig:
    CONTENT_TYPE_RE = re.compile(r'\b(?:application|text)/xml\b', re.IGNORECASE)

    def config_from_address(self, address: str, ns_response: str, realname: str = '', password: str = '') -> Response:
        local_part, domain_part = parse_email_address(address)
        data = self.config_response(local_part, domain_part, ns_response, realname, password)
        return self.response_with_type(data)

    def config_response(self, local_part, domain_part: str, ns_response: str, realname: str, password: str) -> str:
        raise NotImplementedError

    @staticmethod
    def response_type() -> str:
        return CONTENT_TYPE_XML

    def response_with_type(self, data: object) -> Response:
        response: Response = make_response(data)
        response.headers[CONTENT_TYPE] = self.response_type()
        return response

    def is_expected_content_type(self) -> bool:
        if CONTENT_TYPE in request.headers and self.CONTENT_TYPE_RE.search(request.headers[CONTENT_TYPE]):
            return True
        return False
