/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers;

import java.util.regex.Pattern;

public class TextUtilsForMorph {
    private static final Pattern removePunctationFromBeginning = Pattern.compile("^(\\p{Punct}|\u00ab)+");
    private static final Pattern removePunctationFromEnding = Pattern.compile("(\\p{Punct}|\u00bb)+$");
    public static final Pattern beginningOfQuote = Pattern.compile("^(\u00ab|\")+");
    public static final Pattern endOfQuote = Pattern.compile("(\u00bb|\")+$");

    public static String trim(String sone) {
        return TextUtilsForMorph.ltrim(sone).replaceAll("\\s+$", "");
    }

    public static String ltrim(String source) {
        return source.replaceAll("^\\s+", "");
    }

    public static String trimSurroundingPunctation(String source) {
        return removePunctationFromEnding.matcher(removePunctationFromBeginning.matcher(source).replaceAll("")).replaceAll("");
    }

    public static String normalizeSpecialSymbols(String input) {
        input = input.replaceAll("-{2,}", "-");
        input = input.replaceAll("(\u2212|\uff0d|\u02d7|\ufe63|-)", "-");
        input = input.replaceAll("(\u2010|\u2011|\u2012|\u2013|\u2014|\u2015)", "-");
        input = input.replaceAll("&(quot|#34);", "\"");
        input = input.replaceAll("&(apos|#39);", "'");
        input = input.replaceAll("&(amp|#38);", "&");
        input = input.replaceAll("&(lt|#60);", "<");
        input = input.replaceAll("&(gt|#62);", ">");
        return input;
    }
}

