/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2;

import ee.ut.soras.ajavtV2.NumberTokenizer;
import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.util.ArvSonaFraasideTuvastaja;
import ee.ut.soras.ajavtV2.util.LogiPidaja;
import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.EstyhmmWrapper;
import ee.ut.soras.wrappers.impl.T3MestaReader;
import ee.ut.soras.wrappers.impl.T3OLPReader;
import ee.ut.soras.wrappers.impl.VabaMorfJSONReader;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EelTootlus {
    public static LogiPidaja logi = null;
    private static Pattern musterLauseLoppLauseAlgus = Pattern.compile("[?!.](\\s+)\\p{Lu}");
    private static Pattern musterKomaSonadeVahel = Pattern.compile("(\\p{Alpha}|[0-9])([,]\\s+)(\\p{Alpha}|[0-9])");
    private static Pattern musterArvudeKriipslopp = Pattern.compile("^(\\d|[.,!?])+-$");
    private static Pattern musterSTlopp = Pattern.compile("^.+(-)?st$");
    private static Pattern musterPoleSTlopp = Pattern.compile("^(august|p\u00e4rast)$", 64);
    private static Pattern musterNIlopp = Pattern.compile("^.+(-)?ni$");
    private static Pattern musterPoleNIlopp = Pattern.compile("^(juuni|kuni)$");
    private static final Pattern verbOlevik = Pattern.compile("^(b|d|vad|te|me|n|neg o|t(a|akse)||k(s|sid|sime|sin|site)|neg ks|o|ge|gem|gu|neg g(e|em|u)|tagu|taks|neg vat|vat|tavat|tav|v),");
    private static final Pattern verbLihtminevik = Pattern.compile("^(s|sid|sime|sin|site|ti|neg (nud|tud)),");
    private static final Pattern verbTingivKaudneMinevik = Pattern.compile("^(k(s|sid|sime|sin|site)|neg ks|vat|tavat|neg vat),");
    private static final Pattern verbYldMinevik = Pattern.compile("^(nu(ks|ksid|ksime|ksin|ksite|vat)|tu(ks|vat)|neg nuks),");
    private static final Pattern verbKeskSonaMinevikuVorm = Pattern.compile("^(nud|tud),");
    private static final Pattern ksTyveMinevikuLopp = Pattern.compile("^(.+)(dud|tud|nud)$");
    private static final Pattern ksTyveOlevikuLopp = Pattern.compile("^(.+)(v)$");

    public static String prepareTextForMorphAnalysis(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        Matcher matcher = musterLauseLoppLauseAlgus.matcher(stringBuffer);
        while (matcher.find()) {
            if (matcher.groupCount() <= 0 || (n = matcher.start(1)) == -1) continue;
            stringBuffer.replace(n, n + 1, System.getProperty("line.separator"));
        }
        matcher = musterKomaSonadeVahel.matcher(stringBuffer);
        while (matcher.find()) {
            if (matcher.groupCount() <= 0 || (n = matcher.start(2)) == -1) continue;
            stringBuffer.replace(n, n + 1, " , ");
        }
        return stringBuffer.toString();
    }

    public static List<AjavtSona> eeltootlusValiseMorfAnalyysiga(EstyhmmWrapper estyhmmWrapper, String string) throws Exception {
        string = EelTootlus.prepareTextForMorphAnalysis(string);
        String string2 = estyhmmWrapper.process(string);
        return EelTootlus.eeltootlus(string2);
    }

    public static List<AjavtSona> eeltootlus(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        List<MorfAnSona> list = T3MestaReader.parseT3mestatext(bufferedReader);
        bufferedReader.close();
        ArrayList<AjavtSona> arrayList = new ArrayList<AjavtSona>(list.size());
        ArvSonaFraasideTuvastaja arvSonaFraasideTuvastaja = new ArvSonaFraasideTuvastaja(arrayList);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        AjavtSona ajavtSona = null;
        for (int i = 0; i < list.size(); ++i) {
            MorfAnSona morfAnSona = list.get(i);
            EelTootlus.lisaUusAjavtSona(arrayList, morfAnSona, arvSonaFraasideTuvastaja);
            ajavtSona = (AjavtSona)arrayList.get(arrayList.size() - 1);
            if (ajavtSona.onVerb()) {
                EelTootlus.maaraGrammatilineAeg(ajavtSona, false, arrayList2);
            } else if (ajavtSona.onAdjektiivPos()) {
                EelTootlus.maaraGrammatilineAeg(ajavtSona, true, arrayList2);
            }
            if (ajavtSona == null || !ajavtSona.onOlpKindelPiir() && !ajavtSona.onLauseLopp()) continue;
            arrayList2.clear();
        }
        return arrayList;
    }

    public static List<AjavtSona> eeltootlusT3OLP(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        List<MorfAnSona> list = T3OLPReader.parseT3OLPtext(bufferedReader);
        bufferedReader.close();
        ArrayList<AjavtSona> arrayList = new ArrayList<AjavtSona>(list.size());
        ArvSonaFraasideTuvastaja arvSonaFraasideTuvastaja = new ArvSonaFraasideTuvastaja(arrayList);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        AjavtSona ajavtSona = null;
        for (int i = 0; i < list.size(); ++i) {
            MorfAnSona morfAnSona = list.get(i);
            EelTootlus.lisaUusAjavtSona(arrayList, morfAnSona, arvSonaFraasideTuvastaja);
            ajavtSona = (AjavtSona)arrayList.get(arrayList.size() - 1);
            if (ajavtSona.onVerb()) {
                EelTootlus.maaraGrammatilineAeg(ajavtSona, false, arrayList2);
            } else if (ajavtSona.onAdjektiivPos()) {
                EelTootlus.maaraGrammatilineAeg(ajavtSona, true, arrayList2);
            }
            if (ajavtSona == null || !ajavtSona.onOlpKindelPiir() && !ajavtSona.onLauseLopp()) continue;
            arrayList2.clear();
        }
        return arrayList;
    }

    public static List<AjavtSona> eeltootlusJSON(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        List<MorfAnSona> list = VabaMorfJSONReader.parseJSONtext(bufferedReader);
        bufferedReader.close();
        ArrayList<AjavtSona> arrayList = new ArrayList<AjavtSona>(list.size());
        ArvSonaFraasideTuvastaja arvSonaFraasideTuvastaja = new ArvSonaFraasideTuvastaja(arrayList);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        AjavtSona ajavtSona = null;
        for (int i = 0; i < list.size(); ++i) {
            MorfAnSona morfAnSona = list.get(i);
            EelTootlus.lisaUusAjavtSona(arrayList, morfAnSona, arvSonaFraasideTuvastaja);
            ajavtSona = (AjavtSona)arrayList.get(arrayList.size() - 1);
            if (ajavtSona.onVerb()) {
                EelTootlus.maaraGrammatilineAeg(ajavtSona, false, arrayList2);
            } else if (ajavtSona.onAdjektiivPos()) {
                EelTootlus.maaraGrammatilineAeg(ajavtSona, true, arrayList2);
            }
            if (ajavtSona == null || !ajavtSona.onOlpKindelPiir() && !ajavtSona.onLauseLopp()) continue;
            arrayList2.clear();
        }
        return arrayList;
    }

    private static int findNextInnerTokenPosition(List<AjavtSona> list, MorfAnSona morfAnSona) {
        if (!list.isEmpty()) {
            int n = list.get(list.size() - 1).getTokenPosition();
            int n2 = list.get(list.size() - 1).getInnerTokenPosition();
            int n3 = n2 - n;
            int n4 = morfAnSona.getTokenPosition();
            return n4 + n3;
        }
        return morfAnSona.getTokenPosition();
    }

    private static void lisaUusAjavtSona(List<AjavtSona> list, MorfAnSona morfAnSona, ArvSonaFraasideTuvastaja arvSonaFraasideTuvastaja) {
        int n;
        Object object;
        String string = morfAnSona.getAlgSona();
        if (morfAnSona.getAlgSona().length() > 50) {
            string = morfAnSona.getAlgSona().substring(0, 50);
        }
        boolean bl = false;
        if (NumberTokenizer.isNumberTokenizationNeeded(string)) {
            object = NumberTokenizer.extractNumbersWithTrailingPunctation(string, true);
            n = EelTootlus.findNextInnerTokenPosition(list, morfAnSona);
            for (int i = 0; i < object.size(); ++i) {
                String string2 = (String)object.get(i);
                AjavtSona ajavtSona = new AjavtSona(morfAnSona, string2);
                EelTootlus.leiaKasOnTeguPotentsiaalseAjavahemikuOsaga(ajavtSona, string2);
                ajavtSona.setInnerTokenPosition(n);
                if (object.size() > 1) {
                    ajavtSona.setAtTokenBreakPosition(true);
                }
                list.add(ajavtSona);
                ++n;
                if (i < object.size() - 1) {
                    ajavtSona.setOnLauseLopp(false);
                    ajavtSona.setOlpOnKindelPiir(false);
                    continue;
                }
                ajavtSona.setOnLauseLopp(morfAnSona.onLauseLopp());
                ajavtSona.setOlpOnKindelPiir(morfAnSona.onOlpKindelPiir());
            }
            bl = true;
        }
        if (!bl) {
            object = new AjavtSona(morfAnSona, null);
            ((MorfAnSona)object).setOnLauseLopp(morfAnSona.onLauseLopp());
            ((MorfAnSona)object).setOlpOnKindelPiir(morfAnSona.onOlpKindelPiir());
            EelTootlus.leiaKasOnTeguPotentsiaalseAjavahemikuOsaga((AjavtSona)object, string);
            n = EelTootlus.findNextInnerTokenPosition(list, morfAnSona);
            list.add((AjavtSona)object);
            ((AjavtSona)object).setInnerTokenPosition(n);
            arvSonaFraasideTuvastaja.tuvastaArvSonaFraas((AjavtSona)object);
        }
    }

    private static void leiaKasOnTeguPotentsiaalseAjavahemikuOsaga(AjavtSona ajavtSona, String string) {
        List<MorfAnRida> list;
        String string2 = string.toLowerCase();
        String string3 = TextUtils.trimSurroundingPunctation(string2);
        if (musterSTlopp.matcher(string3).matches() && ajavtSona.getAnalyysiTulemused() != null) {
            list = ajavtSona.getAnalyysiTulemused();
            for (MorfAnRida morfAnRida : list) {
                if (!morfAnRida.leiaKasMorfTunnusEsineb("el") || musterPoleSTlopp.matcher(string3).matches()) continue;
                ajavtSona.setOnPotentsiaalneVahemikuAlgus(true);
            }
        }
        if (musterArvudeKriipslopp.matcher(string2).matches()) {
            ajavtSona.setOnPotentsiaalneVahemikuAlgus(true);
        }
        if (musterNIlopp.matcher(string3).matches() && ajavtSona.getAnalyysiTulemused() != null) {
            list = ajavtSona.getAnalyysiTulemused();
            for (MorfAnRida morfAnRida : list) {
                if (!morfAnRida.leiaKasMorfTunnusEsineb("ter") || musterPoleNIlopp.matcher(string3).matches()) continue;
                ajavtSona.setOnPotentsiaalneVahemikuLopp(true);
            }
        }
    }

    private static void maaraGrammatilineAeg(AjavtSona ajavtSona, boolean bl, List<Object> list) {
        if (!bl) {
            Object object = null;
            AjavtSona ajavtSona2 = null;
            if (list != null && list.size() == 2) {
                object = (String)list.get(0);
                ajavtSona2 = (AjavtSona)list.get(1);
            }
            List<MorfAnRida> list2 = ajavtSona.getAnalyysiTulemused();
            for (MorfAnRida morfAnRida : list2) {
                if (morfAnRida.getVormiNimetused() == null) continue;
                if (verbOlevik.matcher(morfAnRida.getVormiNimetused()).matches()) {
                    ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.OLEVIK);
                    if (morfAnRida.getLemmaIlmaVahemarkideta().equals("ole")) {
                        object = verbTingivKaudneMinevik.matcher(morfAnRida.getVormiNimetused()).matches() ? morfAnRida.getLemmaIlmaVahemarkideta() + "_ot" : morfAnRida.getLemmaIlmaVahemarkideta() + "_o";
                    }
                }
                if (verbLihtminevik.matcher(morfAnRida.getVormiNimetused()).matches()) {
                    ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.LIHTMINEVIK);
                    if (morfAnRida.getLemmaIlmaVahemarkideta().equals("ole")) {
                        object = morfAnRida.getLemmaIlmaVahemarkideta() + "_m";
                    }
                }
                if (verbYldMinevik.matcher(morfAnRida.getVormiNimetused()).matches()) {
                    ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.YLDMINEVIK);
                }
                if (!verbKeskSonaMinevikuVorm.matcher(morfAnRida.getVormiNimetused()).matches()) continue;
                boolean bl2 = false;
                if (ajavtSona2 != null && object != null) {
                    if (((String)object).equals("pole") || ((String)object).equals("ei")) {
                        ajavtSona2.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.LIHTMINEVIK);
                        ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.LIHTMINEVIK);
                    }
                    if (((String)object).equals("ole_o")) {
                        ajavtSona2.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.TAISMINEVIK);
                        ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.TAISMINEVIK);
                        bl2 = true;
                    } else if (((String)object).equals("ole_ot")) {
                        ajavtSona2.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.YLDMINEVIK);
                        ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.YLDMINEVIK);
                        bl2 = true;
                    } else if (((String)object).equals("ole_m")) {
                        ajavtSona2.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.ENNEMINEVIK);
                        ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.ENNEMINEVIK);
                        bl2 = true;
                    }
                }
                if (bl2) continue;
                ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.KS_MINEVIK);
            }
            String string = ajavtSona.getAlgSona();
            if (string.equals("pole") || string.equals("ei")) {
                object = string;
            }
            list.clear();
            list.add(object);
            list.add(ajavtSona);
        } else {
            List<MorfAnRida> list3 = ajavtSona.getAnalyysiTulemused();
            for (MorfAnRida morfAnRida : list3) {
                if (morfAnRida.getSonaliik() == null || !morfAnRida.getSonaliik().equals("_A_") || morfAnRida.getLemmaIlmaVahemarkideta() == null) continue;
                String string = morfAnRida.getLemmaIlmaVahemarkideta();
                if (ksTyveMinevikuLopp.matcher(string).matches()) {
                    ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.KS_MINEVIK);
                    break;
                }
                if (!ksTyveOlevikuLopp.matcher(string).matches()) continue;
                ajavtSona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.KS_OLEVIK);
                break;
            }
        }
    }
}

