/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogiPidaja {
    private boolean kirjutaLogiFaili = false;
    private boolean kirjutaLogiValjundisse = false;
    private PrintStream raportivoog = null;
    private String failinimePrefiks = "logi";
    private String raportiFailiNimi = "";
    private String kodeering = "UTF-8";

    public LogiPidaja(boolean bl) {
        this.setKirjutaLogiFaili(bl);
    }

    public LogiPidaja(boolean bl, String string) {
        this.failinimePrefiks = string;
        this.setKirjutaLogiFaili(bl);
    }

    private void initsialiseeriFailiVoog() {
        String string;
        Date date = new Date();
        this.raportiFailiNimi = string = this.konstrueeriRaportiFailiNimi(date);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            this.raportivoog = new PrintStream((OutputStream)fileOutputStream, true, this.kodeering);
            this.println("---------------------------------------------------------");
            this.println(date.toString());
            this.println();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Ilmnes t6rge ning faili " + string + " ei 6nnestunud andmeid lisada.");
            this.raportivoog = null;
        }
    }

    private String konstrueeriRaportiFailiNimi(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
        return this.failinimePrefiks + "_" + simpleDateFormat.format(date) + ".txt";
    }

    public void println() {
        this.print("\n");
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void print(String string) {
        if (this.raportivoog != null) {
            this.raportivoog.print(string);
            this.raportivoog.flush();
        }
        if (this.kirjutaLogiValjundisse) {
            System.out.print(string);
        }
    }

    public void printErrStackTraces(Exception exception) {
        if (this.raportivoog != null) {
            exception.printStackTrace(this.raportivoog);
        }
        exception.printStackTrace();
    }

    private void sulgeRaportiVoog() {
        if (this.raportivoog != null) {
            Date date = new Date();
            this.println("---------------------------------------------------------");
            this.println();
            this.println(String.valueOf("T88 l6pp: " + date.toString()));
            this.println();
            this.raportivoog.close();
        }
    }

    public boolean isKirjutaLogiFaili() {
        return this.kirjutaLogiFaili;
    }

    public void setKirjutaLogiFaili(boolean bl) {
        if (!this.kirjutaLogiFaili && bl) {
            this.initsialiseeriFailiVoog();
        } else if (this.kirjutaLogiFaili && !bl) {
            this.sulgeRaportiVoog();
        }
        this.kirjutaLogiFaili = bl;
    }

    public boolean isKirjutaLogiValjundisse() {
        return this.kirjutaLogiValjundisse;
    }

    public void setKirjutaLogiValjundisse(boolean bl) {
        this.kirjutaLogiValjundisse = bl;
    }

    public String getRaportiFailiNimi() {
        if (this.raportiFailiNimi != null && this.raportiFailiNimi.lastIndexOf(File.separator) > -1) {
            int n = this.raportiFailiNimi.lastIndexOf(File.separator);
            return this.raportiFailiNimi.substring(n + File.separator.length());
        }
        return this.raportiFailiNimi;
    }

    public PrintStream getRaportiVoog() {
        return this.raportivoog;
    }
}

