/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import ee.ut.soras.ajavtV2.AjaTuvastaja;
import ee.ut.soras.ajavtV2.mudel.FraasiMustriFilter;
import ee.ut.soras.ajavtV2.mudel.MustriTahis;
import ee.ut.soras.ajavtV2.mudel.TuvastamisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.LiitumisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.MustristSoltuv;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.AlgVormSonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.ArvuEriKujudSonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.FraasiMuster;
import ee.ut.soras.ajavtV2.mudel.sonamallid.FraasiMusterFSM;
import ee.ut.soras.ajavtV2.mudel.sonamallid.NegatiivneMuster;
import ee.ut.soras.ajavtV2.mudel.sonamallid.RegExpSonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaKlass;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMalliSemOsa;
import ee.ut.soras.ajavtV2.mudel.sonamallid.TavaTekstSonaMall;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MustridXMLFailist {
    public static final String TAG_SONAKLASS = "SonaKlass";
    public static final String TAG_SONAKLASS_NIMI = "nimi";
    public static final String TAG_ELEMENT = "Element";
    public static final String TAG_ELEMENT_TYYP = "tyyp";
    public static final String TAG_ELEMENT_TYYP_ALGVORM = "algv";
    public static final String TAG_ELEMENT_TYYP_REGEXP = "reg";
    public static final String TAG_ELEMENT_TYYP_ARVSONA = "arvSona";
    public static final String TAG_ELEMENT_TYYP_ERI_ARV = "eriArv";
    public static final String TAG_ELEMENT_TYYP_TEKST = "tekst";
    public static final String TAG_ELEMENT_VAARTUS = "vaartus";
    public static final String TAG_ELEMENT_NUMPIIRANG = "arvuPiirang";
    public static final String TAG_ELEMENT_ARVULIIK = "arvuLiik";
    public static final String TAG_REEGEL = "Reegel";
    public static final String TAG_MUSTER = "Muster";
    public static final String TAG_MUSTER_VBSNJRG = "vabaSonajarg";
    public static final String TAG_FILTER = "Filter";
    public static final String TAG_MORF_TUNNUSED = "morfTunnused";
    public static final String TAG_SEOTUD_MUSTRIOSA = "seotudMustriosa";
    public static final String TAG_SEMDEF = "SemReegel";
    public static final String TAG_PRIORITEET = "priority";
    public static final String TAG_SEOTUD_KONTEKST = "seotudKontekst";
    public static final String TAG_ATTRIB = "attrib";
    public static final String TAG_SEMFIELD = "semField";
    public static final String TAG_OP = "op";
    public static final String TAG_SEMLABEL = "semLabel";
    public static final String TAG_SEMVALUE = "semValue";
    public static final String TAG_SEMVAL_EBATAPNE = "semValOnEbatapne";
    public static final String TAG_EXPLICIT_POINT = "explicitPoint";
    public static final String TAG_DIRECTION = "direction";
    public static final String TAG_MUDEL = "mudel";
    public static final String TAG_MUSTRITAHIS = "MustriTahis";
    public static final String TAG_MUSTRITAHISED = "tahised";
    public static final String TAG_MUSTRITAHIS_PESA = "poleEraldiSeisevAjav";
    public static final String TAG_NEGMUSTER = "NegMuster";
    public static final String TAG_NEGMUSTER_STARTPOS = "startPos";
    public static final String TAG_NEGMUSTER_PRESPUNCT = "preservePunct";
    public static final String TAG_LIITUMISREEGEL = "LiitumisReegel";
    public static final String TAG_LIITUMISREEGEL_ASTE = "tase";
    public static final String TAG_LIITUMISREEGEL_FJRK = "fikseeritudJarjekord";
    public static final String TAG_LIITUMISREEGEL_K6RVUTI = "tapseltKorvuti";
    private Document dom;
    private HashMap<String, SonaKlass> sonaKlassid;
    private Pattern musterSonaKlass = Pattern.compile("^!?([A-Z0-9_]+)\\??$");
    private Pattern musterRegexp = Pattern.compile("^!?/([^/]+)/\\??$");
    private Pattern musterAlgvorm = Pattern.compile("^!?\\|(.+)\\|\\??$");
    private Pattern musterValikuline = Pattern.compile("^(.+)\\?$");
    private Pattern musterArajaetav = Pattern.compile("^!(.+)$");

    public void votaMustridXMLFailist(String string, AjaTuvastaja ajaTuvastaja) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.dom = documentBuilder.parse(string);
        this.sonaKlassid = this.parsiDokumendistSonaKlassid();
        ajaTuvastaja.setSonaKlassid(this.sonaKlassid);
        ajaTuvastaja.setReeglid(this.parsiDokumendistTuvastamisReeglid());
        ajaTuvastaja.setLiitumisReeglid(this.parsiDokumendistLiitumisReeglid());
    }

    public void votaMustridXMLSisendvoost(InputStream inputStream, AjaTuvastaja ajaTuvastaja) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.dom = documentBuilder.parse(inputStream);
        this.sonaKlassid = this.parsiDokumendistSonaKlassid();
        ajaTuvastaja.setSonaKlassid(this.sonaKlassid);
        ajaTuvastaja.setReeglid(this.parsiDokumendistTuvastamisReeglid());
        ajaTuvastaja.setLiitumisReeglid(this.parsiDokumendistLiitumisReeglid());
    }

    private List<TuvastamisReegel> parsiDokumendistTuvastamisReeglid() {
        ArrayList<TuvastamisReegel> arrayList = new ArrayList<TuvastamisReegel>();
        int n = 1;
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(TAG_REEGEL);
        if (nodeList != null && nodeList.getLength() > 0) {
            arrayList = new ArrayList(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                MustriTahis mustriTahis;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String string;
                FraasiMuster fraasiMuster;
                Element element2 = (Element)nodeList.item(i);
                Element element3 = MustridXMLFailist.getElementByTagName(element2, TAG_MUSTER);
                if (element3 == null || (fraasiMuster = this.parsiFraasiMuster(string = element3.getTextContent(), n++)) == null) continue;
                TuvastamisReegel tuvastamisReegel = new TuvastamisReegel();
                tuvastamisReegel.setFraasiMuster(fraasiMuster);
                arrayList.add(tuvastamisReegel);
                NodeList nodeList2 = element2.getElementsByTagName(TAG_FILTER);
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        object5 = (Element)nodeList2.item(j);
                        object4 = this.parsiFraasiMustriFilter((Element)object5);
                        if (object4 == null) continue;
                        tuvastamisReegel.lisaFraasiMustriFilter((FraasiMustriFilter)object4);
                    }
                }
                NodeList nodeList3 = element2.getElementsByTagName(TAG_SEMDEF);
                object5 = new LinkedList();
                if (nodeList3 != null && nodeList3.getLength() > 0) {
                    for (int j = 0; j < nodeList3.getLength(); ++j) {
                        object3 = (Element)nodeList3.item(j);
                        if (!object3.getParentNode().equals(element2) || (object2 = this.looUusSemDefElemendiPohjal((Element)object3)) == null) continue;
                        object5.add(object2);
                    }
                }
                object4 = element2.getElementsByTagName(TAG_MUSTRITAHIS);
                object3 = new LinkedList();
                if (object4 != null && object4.getLength() > 0) {
                    for (int j = 0; j < object4.getLength(); ++j) {
                        object = (Element)object4.item(j);
                        if (!object.getParentNode().equals(element2)) continue;
                        mustriTahis = this.looUusMustriTahisDefElemendiPohjal((Element)object);
                        if (object == null) continue;
                        object3.add(mustriTahis);
                    }
                }
                if (!object5.isEmpty() || !object3.isEmpty()) {
                    FraasiMustriFilter fraasiMustriFilter = new FraasiMustriFilter(null, null);
                    if (!object5.isEmpty()) {
                        fraasiMustriFilter.setSemDefinitsioonid((List<SemantikaDefinitsioon>)object5);
                    }
                    if (!object3.isEmpty()) {
                        object = object3.iterator();
                        while (object.hasNext()) {
                            mustriTahis = (MustriTahis)object.next();
                            fraasiMustriFilter.addMustriTahis(mustriTahis);
                        }
                    }
                    tuvastamisReegel.lisaFraasiMustriFilter(fraasiMustriFilter);
                }
                if ((object2 = element2.getElementsByTagName(TAG_NEGMUSTER)) == null || object2.getLength() <= 0) continue;
                object = new LinkedList<NegatiivneMuster>();
                for (int j = 0; j < object2.getLength(); ++j) {
                    Element element4 = (Element)object2.item(j);
                    NegatiivneMuster negatiivneMuster = this.looUusNegMusterElemendiPohjal(element4);
                    if (negatiivneMuster == null) continue;
                    object.add((NegatiivneMuster)negatiivneMuster);
                }
                if (object.isEmpty()) continue;
                tuvastamisReegel.setNegMustrid((List<NegatiivneMuster>)object);
            }
        }
        return arrayList;
    }

    private HashMap<String, SonaKlass> parsiDokumendistSonaKlassid() {
        HashMap<String, SonaKlass> hashMap = new HashMap<String, SonaKlass>();
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(TAG_SONAKLASS);
        if (nodeList != null && nodeList.getLength() > 0) {
            hashMap = new HashMap(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                SonaKlass sonaKlass = null;
                Element element2 = (Element)nodeList.item(i);
                String string = MustridXMLFailist.getElementsAttributeByName(element2, TAG_SONAKLASS_NIMI);
                if (string == null) continue;
                sonaKlass = new SonaKlass(string);
                NodeList nodeList2 = element2.getElementsByTagName(TAG_ELEMENT);
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Element element3 = (Element)nodeList2.item(j);
                        SonaMall sonaMall = this.parsiDokumendiElemendistSonaMall(element3);
                        if (sonaMall == null) continue;
                        sonaKlass.lisaElement(sonaMall);
                    }
                }
                if (sonaKlass.getElemendid().isEmpty()) continue;
                hashMap.put(string, sonaKlass);
            }
        }
        return hashMap;
    }

    private SonaMall parsiDokumendiElemendistSonaMall(Element element) {
        SonaMalliSemOsa sonaMalliSemOsa = null;
        String string = MustridXMLFailist.getElementsAttributeByName(element, TAG_ELEMENT_TYYP);
        if (string != null) {
            String string2;
            if (string.compareTo(TAG_ELEMENT_TYYP_ALGVORM) == 0 && (string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_ELEMENT_VAARTUS)) != null) {
                sonaMalliSemOsa = new AlgVormSonaMall(string2);
            }
            if (string.compareTo(TAG_ELEMENT_TYYP_ARVSONA) == 0 || string.compareTo(TAG_ELEMENT_TYYP_ERI_ARV) == 0) {
                Object object;
                sonaMalliSemOsa = new ArvuEriKujudSonaMall();
                string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_ELEMENT_NUMPIIRANG);
                if (string2 != null) {
                    object = string2.split("-");
                    int n = -1;
                    int n2 = -1;
                    if (((String[])object).length == 2) {
                        try {
                            n = Integer.parseInt(object[0]);
                            n2 = Integer.parseInt(object[1]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (string2.startsWith("-")) {
                        try {
                            n2 = Integer.parseInt(object[0]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        try {
                            n = Integer.parseInt(object[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ((ArvuEriKujudSonaMall)sonaMalliSemOsa).setArvuVaartusePiirid(n, n2);
                }
                if ((object = MustridXMLFailist.getElementsAttributeByName(element, TAG_ELEMENT_ARVULIIK)) != null) {
                    ((ArvuEriKujudSonaMall)sonaMalliSemOsa).setArvuTyyp((String)object);
                }
            }
            if (string.compareTo(TAG_ELEMENT_TYYP_REGEXP) == 0 && (string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_ELEMENT_VAARTUS)) != null) {
                sonaMalliSemOsa = new RegExpSonaMall(string2);
            }
            if (string.compareTo(TAG_ELEMENT_TYYP_TEKST) == 0 && (string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_ELEMENT_VAARTUS)) != null) {
                sonaMalliSemOsa = new TavaTekstSonaMall(string2);
            }
            if (sonaMalliSemOsa != null) {
                this.lisaSonaMallileSemOsa((SonaMall)((Object)sonaMalliSemOsa), element);
            }
        }
        return sonaMalliSemOsa;
    }

    private void lisaSonaMallileSemOsa(SonaMall sonaMall, Element element) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEMFIELD);
        if (string6 != null) {
            sonaMall.lisaSemField(string6);
        }
        if ((string5 = MustridXMLFailist.getElementsAttributeByName(element, TAG_OP)) != null) {
            sonaMall.lisaOp(string5);
        }
        if ((string4 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEMVALUE)) != null) {
            sonaMall.lisaSemValue(string4);
        }
        if ((string3 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEMLABEL)) != null) {
            sonaMall.lisaSemLabel(string3);
        }
        if ((string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEMVAL_EBATAPNE)) != null && string2.equals("1")) {
            sonaMall.setSemValueOnEbatapne(true);
        }
        if ((string = MustridXMLFailist.getElementsAttributeByName(element, TAG_DIRECTION)) != null) {
            sonaMall.setSeekDirection(string);
        }
    }

    private SemantikaDefinitsioon looUusSemDefElemendiPohjal(Element element) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        SemantikaDefinitsioon semantikaDefinitsioon = new SemantikaDefinitsioon();
        String string11 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEOTUD_MUSTRIOSA);
        if (string11 != null) {
            semantikaDefinitsioon.setSeotudMustriOsa(string11);
        }
        if ((string10 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEOTUD_KONTEKST)) != null) {
            semantikaDefinitsioon.setSeotudKontekst(string10);
        } else {
            semantikaDefinitsioon.setSeotudKontekst("");
        }
        String string12 = MustridXMLFailist.getElementsAttributeByName(element, TAG_PRIORITEET);
        if (string12 != null) {
            semantikaDefinitsioon.setPriority(string12);
        }
        if ((string9 = MustridXMLFailist.getElementsAttributeByName(element, TAG_OP)) != null) {
            semantikaDefinitsioon.setOp(string9);
        }
        if ((string8 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEMFIELD)) != null) {
            if (Granulaarsus.getGranulaarsus(string8) != null) {
                semantikaDefinitsioon.setGranulaarsus(Granulaarsus.getGranulaarsus(string8));
            }
            if (string9 != null && (string9.equals(SemantikaDefinitsioon.OP.ANCHOR_TIMEX.toString()) || string9.equals(SemantikaDefinitsioon.OP.ANCHOR_TIMEX_IN_SENTENCE.toString()) || string9.equals(SemantikaDefinitsioon.OP.FIND_NTH_SUBGRAN.toString()))) {
                semantikaDefinitsioon.setGranulaarsusStr(string8);
            }
        }
        if ((string7 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEMVALUE)) != null) {
            semantikaDefinitsioon.setSemValue(string7);
        }
        if ((string6 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEMLABEL)) != null) {
            semantikaDefinitsioon.setSemLabel(string6);
        }
        if ((string5 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEMVAL_EBATAPNE)) != null && string5.equals("1")) {
            semantikaDefinitsioon.setSemValueOnEbatapne(true);
        }
        if ((string4 = MustridXMLFailist.getElementsAttributeByName(element, TAG_DIRECTION)) != null) {
            semantikaDefinitsioon.setDirection(string4);
        }
        if ((string3 = MustridXMLFailist.getElementsAttributeByName(element, TAG_MUDEL)) != null) {
            semantikaDefinitsioon.setMudel(string3);
        }
        if ((string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_EXPLICIT_POINT)) != null) {
            semantikaDefinitsioon.setIsExplicitPoint(string2);
        }
        if ((string = MustridXMLFailist.getElementsAttributeByName(element, TAG_ATTRIB)) != null) {
            semantikaDefinitsioon.setAttribute(string);
        }
        return semantikaDefinitsioon;
    }

    private MustriTahis looUusMustriTahisDefElemendiPohjal(Element element) {
        String string;
        String string2;
        MustriTahis mustriTahis = new MustriTahis();
        String string3 = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEOTUD_MUSTRIOSA);
        if (string3 != null) {
            mustriTahis.setSeotudMustriOsa(string3);
        }
        if ((string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_MUSTRITAHISED)) != null) {
            mustriTahis.setMustriTahised(string2);
        }
        if ((string = MustridXMLFailist.getElementsAttributeByName(element, TAG_MUSTRITAHIS_PESA)) != null) {
            mustriTahis.setAjavPoleEraldiSeisev(string.matches("(1|true)"));
        }
        return mustriTahis;
    }

    private NegatiivneMuster looUusNegMusterElemendiPohjal(Element element) {
        NegatiivneMuster negatiivneMuster = null;
        String string = element.getTextContent();
        if (string != null) {
            String string2;
            negatiivneMuster = new NegatiivneMuster();
            negatiivneMuster.setMusterSonena(string);
            String string3 = MustridXMLFailist.getElementsAttributeByName(element, TAG_NEGMUSTER_STARTPOS);
            if (string3 != null) {
                try {
                    int n = Integer.parseInt(string3);
                    negatiivneMuster.setAlgusPositsioon(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_NEGMUSTER_PRESPUNCT)) != null && string2.matches("(?i)true")) {
                negatiivneMuster.setSailitaYmbritsevadMargid(true);
            }
        }
        return negatiivneMuster;
    }

    private FraasiMuster parsiFraasiMuster(String string, int n) {
        ArrayList<SonaMall> arrayList = new ArrayList<SonaMall>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            SonaMall sonaMall = null;
            Matcher matcher = this.musterRegexp.matcher(string3);
            Matcher matcher2 = this.musterAlgvorm.matcher(string3);
            Matcher matcher3 = this.musterSonaKlass.matcher(string3);
            if (matcher.matches()) {
                sonaMall = new RegExpSonaMall(matcher.group(1));
            } else if (matcher2.matches()) {
                sonaMall = new AlgVormSonaMall(matcher2.group(1));
            } else if (matcher3.matches() && this.sonaKlassid.containsKey(string2 = matcher3.group(1))) {
                sonaMall = this.sonaKlassid.get(string2);
            }
            if (sonaMall == null) continue;
            if (this.musterValikuline.matcher(string3).matches()) {
                arrayList2.add(new Boolean(true));
                ++n2;
            } else {
                arrayList2.add(new Boolean(false));
            }
            if (this.musterArajaetav.matcher(string3).matches()) {
                arrayList3.add(new Boolean(true));
                ++n3;
            } else {
                arrayList3.add(new Boolean(false));
            }
            arrayList.add(sonaMall);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (n2 == arrayList.size() || n3 == arrayList.size()) {
            return null;
        }
        return new FraasiMusterFSM(arrayList, arrayList2, arrayList3, "m" + String.valueOf(n));
    }

    private FraasiMustriFilter parsiFraasiMustriFilter(Element element) {
        MustristSoltuv mustristSoltuv;
        Element element2;
        int n;
        Object object;
        String string = MustridXMLFailist.getElementsAttributeByName(element, TAG_SEOTUD_MUSTRIOSA);
        String string2 = MustridXMLFailist.getElementsAttributeByName(element, TAG_MORF_TUNNUSED);
        FraasiMustriFilter fraasiMustriFilter = new FraasiMustriFilter(string2, string);
        NodeList nodeList = element.getElementsByTagName(TAG_SEMDEF);
        if (nodeList != null && nodeList.getLength() > 0) {
            object = new LinkedList();
            for (n = 0; n < nodeList.getLength(); ++n) {
                element2 = (Element)nodeList.item(n);
                mustristSoltuv = this.looUusSemDefElemendiPohjal(element2);
                if (mustristSoltuv == null) continue;
                object.add(mustristSoltuv);
            }
            if (!object.isEmpty()) {
                fraasiMustriFilter.setSemDefinitsioonid((List<SemantikaDefinitsioon>)object);
            } else {
                return null;
            }
        }
        if ((object = element.getElementsByTagName(TAG_MUSTRITAHIS)) != null && object.getLength() > 0) {
            for (n = 0; n < object.getLength(); ++n) {
                element2 = (Element)object.item(n);
                mustristSoltuv = this.looUusMustriTahisDefElemendiPohjal(element2);
                if (mustristSoltuv == null) continue;
                fraasiMustriFilter.addMustriTahis((MustriTahis)mustristSoltuv);
            }
        }
        return fraasiMustriFilter;
    }

    private List<LiitumisReegel> parsiDokumendistLiitumisReeglid() {
        ArrayList<LiitumisReegel> arrayList = new ArrayList<LiitumisReegel>();
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(TAG_LIITUMISREEGEL);
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                String string2;
                String string3;
                StringTokenizer stringTokenizer;
                Element element2 = (Element)nodeList.item(i);
                String string4 = element2.getTextContent();
                if (string4 == null || (stringTokenizer = new StringTokenizer(string4)).countTokens() <= 0) continue;
                LiitumisReegel liitumisReegel = new LiitumisReegel();
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    string3 = (String)stringTokenizer.nextElement();
                    stringArray[n++] = string3;
                }
                liitumisReegel.setMustriTahised(stringArray);
                string3 = MustridXMLFailist.getElementsAttributeByName(element2, TAG_LIITUMISREEGEL_ASTE);
                if (string3 != null) {
                    if (string3.equals("FRAAS")) {
                        liitumisReegel.setYhendamiseAste(AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA);
                    }
                    if (string3.equals("VAHEMIK")) {
                        liitumisReegel.setYhendamiseAste(AjavaljendiKandidaat.ASTE.YHENDATUD_VAHEMIKUNA);
                    }
                }
                if ((string2 = MustridXMLFailist.getElementsAttributeByName(element2, TAG_LIITUMISREEGEL_FJRK)) != null) {
                    liitumisReegel.setFikseeritudJarjekord(string2.matches("(1|true)"));
                }
                if ((string = MustridXMLFailist.getElementsAttributeByName(element2, TAG_LIITUMISREEGEL_K6RVUTI)) != null) {
                    liitumisReegel.setTapseltKorvuti(string.matches("(1|true)"));
                }
                arrayList.add(liitumisReegel);
            }
        }
        return arrayList;
    }

    private static Element getElementByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private static String getElementsAttributeByName(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }
}

