/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers.impl;

import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class T3MestaReader {
    private static Pattern musterLauseAlgus = Pattern.compile("^\\p{Lu}");
    private static Pattern musterLauseLopp = Pattern.compile("[?!.]$");

    private static boolean kasSonaOnSuurt2heliseAlgusega(String string) {
        return musterLauseAlgus.matcher(TextUtils.trimSurroundingPunctation(string)).find();
    }

    private static boolean kasSonaLopebLauselopuMargiga(MorfAnSona morfAnSona) {
        return musterLauseLopp.matcher(morfAnSona.getAlgSona()).find();
    }

    public static List<MorfAnSona> parseT3mestatext(BufferedReader bufferedReader) throws Exception {
        String string;
        ArrayList<MorfAnSona> arrayList = new ArrayList<MorfAnSona>();
        String string2 = null;
        MorfAnSona morfAnSona = null;
        int n = 1;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() > 0) {
                String[] stringArray = string.split("\\s{4}");
                if (stringArray.length < 2) {
                    throw new IOException("Unable to parse the output of morphological analyzer - unexpected format: " + string);
                }
                string2 = stringArray[0];
                MorfAnSona morfAnSona2 = new MorfAnSona(string2);
                morfAnSona2.setTokenPosition(n);
                for (int i = 1; i < stringArray.length; ++i) {
                    morfAnSona2.lisaAnalyysiRida(TextUtils.ltrim(stringArray[i]));
                }
                if (morfAnSona != null) {
                    if (T3MestaReader.kasSonaOnSuurt2heliseAlgusega(string2) && T3MestaReader.kasSonaLopebLauselopuMargiga(morfAnSona)) {
                        morfAnSona.setOnLauseLopp(true);
                    }
                    if (morfAnSona.getAlgSona().endsWith(",")) {
                        morfAnSona.setOlpOnKindelPiir(true);
                    }
                }
                arrayList.add(morfAnSona2);
                morfAnSona = (MorfAnSona)arrayList.get(arrayList.size() - 1);
                string2 = null;
            }
            ++n;
        }
        return arrayList;
    }
}

