import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IRestApi } from './restapi';
/**
 * @stability stable
 */
export interface IRequestValidator extends IResource {
    /**
     * ID of the request validator, such as abc123.
     *
     * @stability stable
     * @attribute true
     */
    readonly requestValidatorId: string;
}
/**
 * @stability stable
 */
export interface RequestValidatorOptions {
    /**
     * The name of this request validator.
     *
     * @default None
     * @stability stable
     */
    readonly requestValidatorName?: string;
    /**
     * Indicates whether to validate the request body according to the configured schema for the targeted API and method.
     *
     * @default false
     * @stability stable
     */
    readonly validateRequestBody?: boolean;
    /**
     * Indicates whether to validate request parameters.
     *
     * @default false
     * @stability stable
     */
    readonly validateRequestParameters?: boolean;
}
/**
 * @stability stable
 */
export interface RequestValidatorProps extends RequestValidatorOptions {
    /**
     * The rest API that this model is part of.
     *
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     *
     * @stability stable
     */
    readonly restApi: IRestApi;
}
/**
 * @stability stable
 */
export declare class RequestValidator extends Resource implements IRequestValidator {
    /**
     * @stability stable
     */
    static fromRequestValidatorId(scope: Construct, id: string, requestValidatorId: string): IRequestValidator;
    /**
     * ID of the request validator, such as abc123.
     *
     * @stability stable
     * @attribute true
     */
    readonly requestValidatorId: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: RequestValidatorProps);
}
