from typing import List, Union

from statham.dsl.constants import Maybe
from statham.dsl.elements import (
    AnyOf,
    Array,
    Boolean,
    Integer,
    Null,
    Number,
    OneOf,
    Object,
    ObjectOptions,
    String,
)
from statham.dsl.property import Property


class ListOfStringsItem(Object):

    options = ObjectOptions(additionalProperties=False)

    string_property: Maybe[str] = Property(String())


class ListOfIntegersItem(Object):

    options = ObjectOptions(additionalProperties=False)

    integer_property: Maybe[int] = Property(Integer())


class ListAnyOfItem0(Object):

    options = ObjectOptions(additionalProperties=False)

    string_prop: Maybe[str] = Property(String())


class ListAnyOfItem1(Object):

    options = ObjectOptions(additionalProperties=False)

    integer_prop: Maybe[int] = Property(Integer())


class Autoname(Object):

    list_of_strings: Maybe[List[ListOfStringsItem]] = Property(
        Array(ListOfStringsItem)
    )

    list_of_integers: Maybe[List[ListOfIntegersItem]] = Property(
        Array(ListOfIntegersItem)
    )

    list_any_of: Maybe[
        List[Union[ListAnyOfItem0, ListAnyOfItem1, str]]
    ] = Property(Array(AnyOf(ListAnyOfItem0, ListAnyOfItem1, String())))
