from invenio_search.engine import dsl

class NestedLabeledFacet(dsl.Facet):
    agg_type = "nested"

    def __init__(self, path, nested_facet, label = ''):
        self._path = path
        self._inner = nested_facet
        self._label = label
        super(NestedLabeledFacet, self).__init__(
            path=path,  aggs={"inner": nested_facet.get_aggregation(),}
        )

    def get_values(self, data, filter_values):
        return self._inner.get_values(data.inner, filter_values)

    def add_filter(self, filter_values):
        inner_q = self._inner.add_filter(filter_values)
        if inner_q:
            return dsl.Nested(path=self._path, query=inner_q)

    def get_labelled_values(self, data, filter_values):
        """Get a labelled version of a bucket."""
        try:
            out = data['buckets']
        except:
            out = []
        return {'buckets': out, 'label': str(self._label)}