export declare const AWS_OLDER_REGIONS: Set<string>;
export declare const AWS_CDK_METADATA: Set<string>;
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints
 */
export declare const ROUTE_53_BUCKET_WEBSITE_ZONE_IDS: {
    [region: string]: string;
};
interface Region {
    partition: string;
    domainSuffix: string;
}
export declare const PARTITION_MAP: {
    [region: string]: Region;
};
export declare const ELBV2_ACCOUNTS: {
    [region: string]: string;
};
export declare const DLC_REPOSITORY_ACCOUNTS: {
    [region: string]: string;
};
export declare const APPMESH_ECR_ACCOUNTS: {
    [region: string]: string;
};
export declare const CLOUDWATCH_LAMBDA_INSIGHTS_ARNS: {
    [key: string]: any;
};
export declare const FIREHOSE_CIDR_BLOCKS: {
    [region: string]: string;
};
export {};
