"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AZContextProviderPlugin = void 0;
const cxapi = require("@aws-cdk/cx-api");
const api_1 = require("../api");
const logging_1 = require("../logging");
/**
 * Plugin to retrieve the Availability Zones for the current account
 */
class AZContextProviderPlugin {
    constructor(aws) {
        this.aws = aws;
    }
    async getValue(args) {
        const region = args.region;
        const account = args.account;
        logging_1.debug(`Reading AZs for ${account}:${region}`);
        const options = { assumeRoleArn: args.lookupRoleArn };
        const ec2 = (await this.aws.forEnvironment(cxapi.EnvironmentUtils.make(account, region), api_1.Mode.ForReading, options)).ec2();
        const response = await ec2.describeAvailabilityZones().promise();
        if (!response.AvailabilityZones) {
            return [];
        }
        const azs = response.AvailabilityZones.filter(zone => zone.State === 'available').map(zone => zone.ZoneName);
        return azs;
    }
}
exports.AZContextProviderPlugin = AZContextProviderPlugin;
//# sourceMappingURL=data:application/json;base64,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