"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasAllTrafficEgress = exports.SecurityGroupContextProviderPlugin = void 0;
const cxapi = require("@aws-cdk/cx-api");
const api_1 = require("../api");
class SecurityGroupContextProviderPlugin {
    constructor(aws) {
        this.aws = aws;
    }
    async getValue(args) {
        var _a;
        const account = args.account;
        const region = args.region;
        const options = { assumeRoleArn: args.lookupRoleArn };
        const ec2 = (await this.aws.forEnvironment(cxapi.EnvironmentUtils.make(account, region), api_1.Mode.ForReading, options)).ec2();
        const response = await ec2.describeSecurityGroups({
            GroupIds: [args.securityGroupId],
        }).promise();
        const securityGroups = (_a = response.SecurityGroups) !== null && _a !== void 0 ? _a : [];
        if (securityGroups.length === 0) {
            throw new Error(`No security groups found matching ${JSON.stringify(args)}`);
        }
        const [securityGroup] = securityGroups;
        return {
            securityGroupId: securityGroup.GroupId,
            allowAllOutbound: hasAllTrafficEgress(securityGroup),
        };
    }
}
exports.SecurityGroupContextProviderPlugin = SecurityGroupContextProviderPlugin;
/**
 * @internal
 */
function hasAllTrafficEgress(securityGroup) {
    var _a, _b, _c;
    let hasAllTrafficCidrV4 = false;
    let hasAllTrafficCidrV6 = false;
    for (const ipPermission of (_a = securityGroup.IpPermissionsEgress) !== null && _a !== void 0 ? _a : []) {
        const isAllProtocols = ipPermission.IpProtocol === '-1';
        if (isAllProtocols && ((_b = ipPermission.IpRanges) === null || _b === void 0 ? void 0 : _b.some(m => m.CidrIp === '0.0.0.0/0'))) {
            hasAllTrafficCidrV4 = true;
        }
        if (isAllProtocols && ((_c = ipPermission.Ipv6Ranges) === null || _c === void 0 ? void 0 : _c.some(m => m.CidrIpv6 === '::/0'))) {
            hasAllTrafficCidrV6 = true;
        }
    }
    return hasAllTrafficCidrV4 && hasAllTrafficCidrV6;
}
exports.hasAllTrafficEgress = hasAllTrafficEgress;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VjdXJpdHktZ3JvdXBzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic2VjdXJpdHktZ3JvdXBzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHlDQUF5QztBQUV6QyxnQ0FBMkM7QUFHM0MsTUFBYSxrQ0FBa0M7SUFDN0MsWUFBNkIsR0FBZ0I7UUFBaEIsUUFBRyxHQUFILEdBQUcsQ0FBYTtJQUM3QyxDQUFDO0lBRUQsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUF3Qzs7UUFDckQsTUFBTSxPQUFPLEdBQVcsSUFBSSxDQUFDLE9BQVEsQ0FBQztRQUN0QyxNQUFNLE1BQU0sR0FBVyxJQUFJLENBQUMsTUFBTyxDQUFDO1FBRXBDLE1BQU0sT0FBTyxHQUFHLEVBQUUsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztRQUN0RCxNQUFNLEdBQUcsR0FBRyxDQUFDLE1BQU0sSUFBSSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsTUFBTSxDQUFDLEVBQUUsVUFBSSxDQUFDLFVBQVUsRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBRTFILE1BQU0sUUFBUSxHQUFHLE1BQU0sR0FBRyxDQUFDLHNCQUFzQixDQUFDO1lBQ2hELFFBQVEsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDakMsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDO1FBRWIsTUFBTSxjQUFjLFNBQUcsUUFBUSxDQUFDLGNBQWMsbUNBQUksRUFBRSxDQUFDO1FBQ3JELElBQUksY0FBYyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDL0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxxQ0FBcUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUM7U0FDOUU7UUFFRCxNQUFNLENBQUMsYUFBYSxDQUFDLEdBQUcsY0FBYyxDQUFDO1FBRXZDLE9BQU87WUFDTCxlQUFlLEVBQUUsYUFBYSxDQUFDLE9BQVE7WUFDdkMsZ0JBQWdCLEVBQUUsbUJBQW1CLENBQUMsYUFBYSxDQUFDO1NBQ3JELENBQUM7SUFDSixDQUFDO0NBQ0Y7QUEzQkQsZ0ZBMkJDO0FBRUQ7O0dBRUc7QUFDSCxTQUFnQixtQkFBbUIsQ0FBQyxhQUFvQzs7SUFDdEUsSUFBSSxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDaEMsSUFBSSxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFFaEMsS0FBSyxNQUFNLFlBQVksVUFBSSxhQUFhLENBQUMsbUJBQW1CLG1DQUFJLEVBQUUsRUFBRTtRQUNsRSxNQUFNLGNBQWMsR0FBRyxZQUFZLENBQUMsVUFBVSxLQUFLLElBQUksQ0FBQztRQUV4RCxJQUFJLGNBQWMsV0FBSSxZQUFZLENBQUMsUUFBUSwwQ0FBRSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsTUFBTSxLQUFLLFdBQVcsRUFBQyxFQUFFO1lBQ2hGLG1CQUFtQixHQUFHLElBQUksQ0FBQztTQUM1QjtRQUVELElBQUksY0FBYyxXQUFJLFlBQVksQ0FBQyxVQUFVLDBDQUFFLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxRQUFRLEtBQUssTUFBTSxFQUFDLEVBQUU7WUFDL0UsbUJBQW1CLEdBQUcsSUFBSSxDQUFDO1NBQzVCO0tBQ0Y7SUFFRCxPQUFPLG1CQUFtQixJQUFJLG1CQUFtQixDQUFDO0FBQ3BELENBQUM7QUFqQkQsa0RBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY3hzY2hlbWEgZnJvbSAnQGF3cy1jZGsvY2xvdWQtYXNzZW1ibHktc2NoZW1hJztcbmltcG9ydCAqIGFzIGN4YXBpIGZyb20gJ0Bhd3MtY2RrL2N4LWFwaSc7XG5pbXBvcnQgKiBhcyBBV1MgZnJvbSAnYXdzLXNkayc7XG5pbXBvcnQgeyBNb2RlLCBTZGtQcm92aWRlciB9IGZyb20gJy4uL2FwaSc7XG5pbXBvcnQgeyBDb250ZXh0UHJvdmlkZXJQbHVnaW4gfSBmcm9tICcuL3Byb3ZpZGVyJztcblxuZXhwb3J0IGNsYXNzIFNlY3VyaXR5R3JvdXBDb250ZXh0UHJvdmlkZXJQbHVnaW4gaW1wbGVtZW50cyBDb250ZXh0UHJvdmlkZXJQbHVnaW4ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGF3czogU2RrUHJvdmlkZXIpIHtcbiAgfVxuXG4gIGFzeW5jIGdldFZhbHVlKGFyZ3M6IGN4c2NoZW1hLlNlY3VyaXR5R3JvdXBDb250ZXh0UXVlcnkpOiBQcm9taXNlPGN4YXBpLlNlY3VyaXR5R3JvdXBDb250ZXh0UmVzcG9uc2U+IHtcbiAgICBjb25zdCBhY2NvdW50OiBzdHJpbmcgPSBhcmdzLmFjY291bnQhO1xuICAgIGNvbnN0IHJlZ2lvbjogc3RyaW5nID0gYXJncy5yZWdpb24hO1xuXG4gICAgY29uc3Qgb3B0aW9ucyA9IHsgYXNzdW1lUm9sZUFybjogYXJncy5sb29rdXBSb2xlQXJuIH07XG4gICAgY29uc3QgZWMyID0gKGF3YWl0IHRoaXMuYXdzLmZvckVudmlyb25tZW50KGN4YXBpLkVudmlyb25tZW50VXRpbHMubWFrZShhY2NvdW50LCByZWdpb24pLCBNb2RlLkZvclJlYWRpbmcsIG9wdGlvbnMpKS5lYzIoKTtcblxuICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgZWMyLmRlc2NyaWJlU2VjdXJpdHlHcm91cHMoe1xuICAgICAgR3JvdXBJZHM6IFthcmdzLnNlY3VyaXR5R3JvdXBJZF0sXG4gICAgfSkucHJvbWlzZSgpO1xuXG4gICAgY29uc3Qgc2VjdXJpdHlHcm91cHMgPSByZXNwb25zZS5TZWN1cml0eUdyb3VwcyA/PyBbXTtcbiAgICBpZiAoc2VjdXJpdHlHcm91cHMubGVuZ3RoID09PSAwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYE5vIHNlY3VyaXR5IGdyb3VwcyBmb3VuZCBtYXRjaGluZyAke0pTT04uc3RyaW5naWZ5KGFyZ3MpfWApO1xuICAgIH1cblxuICAgIGNvbnN0IFtzZWN1cml0eUdyb3VwXSA9IHNlY3VyaXR5R3JvdXBzO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIHNlY3VyaXR5R3JvdXBJZDogc2VjdXJpdHlHcm91cC5Hcm91cElkISxcbiAgICAgIGFsbG93QWxsT3V0Ym91bmQ6IGhhc0FsbFRyYWZmaWNFZ3Jlc3Moc2VjdXJpdHlHcm91cCksXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgZnVuY3Rpb24gaGFzQWxsVHJhZmZpY0VncmVzcyhzZWN1cml0eUdyb3VwOiBBV1MuRUMyLlNlY3VyaXR5R3JvdXApIHtcbiAgbGV0IGhhc0FsbFRyYWZmaWNDaWRyVjQgPSBmYWxzZTtcbiAgbGV0IGhhc0FsbFRyYWZmaWNDaWRyVjYgPSBmYWxzZTtcblxuICBmb3IgKGNvbnN0IGlwUGVybWlzc2lvbiBvZiBzZWN1cml0eUdyb3VwLklwUGVybWlzc2lvbnNFZ3Jlc3MgPz8gW10pIHtcbiAgICBjb25zdCBpc0FsbFByb3RvY29scyA9IGlwUGVybWlzc2lvbi5JcFByb3RvY29sID09PSAnLTEnO1xuXG4gICAgaWYgKGlzQWxsUHJvdG9jb2xzICYmIGlwUGVybWlzc2lvbi5JcFJhbmdlcz8uc29tZShtID0+IG0uQ2lkcklwID09PSAnMC4wLjAuMC8wJykpIHtcbiAgICAgIGhhc0FsbFRyYWZmaWNDaWRyVjQgPSB0cnVlO1xuICAgIH1cblxuICAgIGlmIChpc0FsbFByb3RvY29scyAmJiBpcFBlcm1pc3Npb24uSXB2NlJhbmdlcz8uc29tZShtID0+IG0uQ2lkcklwdjYgPT09ICc6Oi8wJykpIHtcbiAgICAgIGhhc0FsbFRyYWZmaWNDaWRyVjYgPSB0cnVlO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBoYXNBbGxUcmFmZmljQ2lkclY0ICYmIGhhc0FsbFRyYWZmaWNDaWRyVjY7XG59XG4iXX0=