"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadStructuredFile = exports.serializeStructure = exports.deserializeStructure = exports.toYAML = void 0;
const fs = require("fs-extra");
const yaml_cfn = require("./util/yaml-cfn");
/**
 * Stringify to YAML
 */
function toYAML(obj) {
    return yaml_cfn.serialize(obj);
}
exports.toYAML = toYAML;
/**
 * Parse either YAML or JSON
 */
function deserializeStructure(str) {
    try {
        return yaml_cfn.deserialize(str);
    }
    catch (e) {
        // This shouldn't really ever happen I think, but it's the code we had so I'm leaving it.
        return JSON.parse(str);
    }
}
exports.deserializeStructure = deserializeStructure;
/**
 * Serialize to either YAML or JSON
 */
function serializeStructure(object, json) {
    if (json) {
        return JSON.stringify(object, undefined, 2);
    }
    else {
        return toYAML(object);
    }
}
exports.serializeStructure = serializeStructure;
/**
 * Load a YAML or JSON file from disk
 */
async function loadStructuredFile(fileName) {
    const contents = await fs.readFile(fileName, { encoding: 'utf-8' });
    return deserializeStructure(contents);
}
exports.loadStructuredFile = loadStructuredFile;
//# sourceMappingURL=data:application/json;base64,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