"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const api_1 = require("../../lib/api");
const mock_sdk_1 = require("../util/mock-sdk");
let mockSdk;
beforeEach(() => {
    mockSdk = new mock_sdk_1.MockSdk();
});
test('failure to read SSM parameter results in upgrade message for existing bootstrap stack under v5', async () => {
    // GIVEN
    const toolkitInfo = api_1.ToolkitInfo.fromStack(mock_sdk_1.mockBootstrapStack(mockSdk, {
        Outputs: [{ OutputKey: 'BootstrapVersion', OutputValue: '4' }],
    }), mockSdk);
    mockSdk.stubSsm({
        getParameter() {
            throw mock_sdk_1.errorWithCode('AccessDeniedException', 'Computer says no');
        },
    });
    // THEN
    await expect(toolkitInfo.validateVersion(99, '/abc')).rejects.toThrow(/This CDK deployment requires bootstrap stack version/);
});
test('failure to read SSM parameter results in exception passthrough for existing bootstrap stack v5 or higher', async () => {
    // GIVEN
    const toolkitInfo = api_1.ToolkitInfo.fromStack(mock_sdk_1.mockBootstrapStack(mockSdk, {
        Outputs: [{ OutputKey: 'BootstrapVersion', OutputValue: '5' }],
    }), mockSdk);
    mockSdk.stubSsm({
        getParameter() {
            throw mock_sdk_1.errorWithCode('AccessDeniedException', 'Computer says no');
        },
    });
    // THEN
    await expect(toolkitInfo.validateVersion(99, '/abc')).rejects.toThrow(/Computer says no/);
});
describe('validateversion without bootstrap stack', () => {
    let toolkitInfo;
    beforeEach(() => {
        toolkitInfo = api_1.ToolkitInfo.bootstrapStackNotFoundInfo(mockSdk);
    });
    test('validating version with explicit SSM parameter succeeds', async () => {
        // GIVEN
        mockSdk.stubSsm({
            getParameter() {
                return { Parameter: { Value: '10' } };
            },
        });
        // THEN
        await expect(toolkitInfo.validateVersion(8, '/abc')).resolves.toBeUndefined();
    });
    test('validating version without explicit SSM parameter fails', async () => {
        // WHEN
        await expect(toolkitInfo.validateVersion(8, undefined)).rejects.toThrow(/This deployment requires a bootstrap stack with a known name/);
    });
    test('validating version with access denied error gives upgrade hint', async () => {
        // GIVEN
        mockSdk.stubSsm({
            getParameter() {
                throw mock_sdk_1.errorWithCode('AccessDeniedException', 'Computer says no');
            },
        });
        // WHEN
        await expect(toolkitInfo.validateVersion(8, '/abc')).rejects.toThrow(/This CDK deployment requires bootstrap stack version/);
    });
    test('validating version with missing parameter gives bootstrap hint', async () => {
        // GIVEN
        mockSdk.stubSsm({
            getParameter() {
                throw mock_sdk_1.errorWithCode('ParameterNotFound', 'Wut?');
            },
        });
        // WHEN
        await expect(toolkitInfo.validateVersion(8, '/abc')).rejects.toThrow(/Has the environment been bootstrapped?/);
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9vbGtpdC1pbmZvLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0b29sa2l0LWluZm8udGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHVDQUE0QztBQUM1QywrQ0FBOEU7QUFHOUUsSUFBSSxPQUFnQixDQUFDO0FBQ3JCLFVBQVUsQ0FBQyxHQUFHLEVBQUU7SUFDZCxPQUFPLEdBQUcsSUFBSSxrQkFBTyxFQUFFLENBQUM7QUFDMUIsQ0FBQyxDQUFDLENBQUM7QUFFSCxJQUFJLENBQUMsZ0dBQWdHLEVBQUUsS0FBSyxJQUFJLEVBQUU7SUFDaEgsUUFBUTtJQUNSLE1BQU0sV0FBVyxHQUFHLGlCQUFXLENBQUMsU0FBUyxDQUFDLDZCQUFrQixDQUFDLE9BQU8sRUFBRTtRQUNwRSxPQUFPLEVBQUUsQ0FBQyxFQUFFLFNBQVMsRUFBRSxrQkFBa0IsRUFBRSxXQUFXLEVBQUUsR0FBRyxFQUFFLENBQUM7S0FDL0QsQ0FBQyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBRWIsT0FBTyxDQUFDLE9BQU8sQ0FBQztRQUNkLFlBQVk7WUFDVixNQUFNLHdCQUFhLENBQUMsdUJBQXVCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUNuRSxDQUFDO0tBQ0YsQ0FBQyxDQUFDO0lBRUgsT0FBTztJQUNQLE1BQU0sTUFBTSxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRSxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO0FBQ2hJLENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLDBHQUEwRyxFQUFFLEtBQUssSUFBSSxFQUFFO0lBQzFILFFBQVE7SUFDUixNQUFNLFdBQVcsR0FBRyxpQkFBVyxDQUFDLFNBQVMsQ0FBQyw2QkFBa0IsQ0FBQyxPQUFPLEVBQUU7UUFDcEUsT0FBTyxFQUFFLENBQUMsRUFBRSxTQUFTLEVBQUUsa0JBQWtCLEVBQUUsV0FBVyxFQUFFLEdBQUcsRUFBRSxDQUFDO0tBQy9ELENBQUMsRUFBRSxPQUFPLENBQUMsQ0FBQztJQUViLE9BQU8sQ0FBQyxPQUFPLENBQUM7UUFDZCxZQUFZO1lBQ1YsTUFBTSx3QkFBYSxDQUFDLHVCQUF1QixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFDbkUsQ0FBQztLQUNGLENBQUMsQ0FBQztJQUVILE9BQU87SUFDUCxNQUFNLE1BQU0sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUUsRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsa0JBQWtCLENBQUMsQ0FBQztBQUM1RixDQUFDLENBQUMsQ0FBQztBQUVILFFBQVEsQ0FBQyx5Q0FBeUMsRUFBRSxHQUFHLEVBQUU7SUFDdkQsSUFBSSxXQUF3QixDQUFDO0lBQzdCLFVBQVUsQ0FBQyxHQUFHLEVBQUU7UUFDZCxXQUFXLEdBQUcsaUJBQVcsQ0FBQywwQkFBMEIsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNoRSxDQUFDLENBQUMsQ0FBQztJQUVILElBQUksQ0FBQyx5REFBeUQsRUFBRSxLQUFLLElBQUksRUFBRTtRQUN6RSxRQUFRO1FBQ1IsT0FBTyxDQUFDLE9BQU8sQ0FBQztZQUNkLFlBQVk7Z0JBQ1YsT0FBTyxFQUFFLFNBQVMsRUFBRSxFQUFFLEtBQUssRUFBRSxJQUFJLEVBQUUsRUFBRSxDQUFDO1lBQ3hDLENBQUM7U0FDRixDQUFDLENBQUM7UUFFSCxPQUFPO1FBQ1AsTUFBTSxNQUFNLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDaEYsQ0FBQyxDQUFDLENBQUM7SUFFSCxJQUFJLENBQUMseURBQXlELEVBQUUsS0FBSyxJQUFJLEVBQUU7UUFDekUsT0FBTztRQUNQLE1BQU0sTUFBTSxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxFQUFFLFNBQVMsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyw4REFBOEQsQ0FBQyxDQUFDO0lBQzFJLENBQUMsQ0FBQyxDQUFDO0lBRUgsSUFBSSxDQUFDLGdFQUFnRSxFQUFFLEtBQUssSUFBSSxFQUFFO1FBQ2hGLFFBQVE7UUFDUixPQUFPLENBQUMsT0FBTyxDQUFDO1lBQ2QsWUFBWTtnQkFDVixNQUFNLHdCQUFhLENBQUMsdUJBQXVCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztZQUNuRSxDQUFDO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsT0FBTztRQUNQLE1BQU0sTUFBTSxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO0lBQy9ILENBQUMsQ0FBQyxDQUFDO0lBRUgsSUFBSSxDQUFDLGdFQUFnRSxFQUFFLEtBQUssSUFBSSxFQUFFO1FBQ2hGLFFBQVE7UUFDUixPQUFPLENBQUMsT0FBTyxDQUFDO1lBQ2QsWUFBWTtnQkFDVixNQUFNLHdCQUFhLENBQUMsbUJBQW1CLEVBQUUsTUFBTSxDQUFDLENBQUM7WUFDbkQsQ0FBQztTQUNGLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxNQUFNLE1BQU0sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLENBQUMsRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsd0NBQXdDLENBQUMsQ0FBQztJQUNqSCxDQUFDLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9vbGtpdEluZm8gfSBmcm9tICcuLi8uLi9saWIvYXBpJztcbmltcG9ydCB7IGVycm9yV2l0aENvZGUsIG1vY2tCb290c3RyYXBTdGFjaywgTW9ja1NkayB9IGZyb20gJy4uL3V0aWwvbW9jay1zZGsnO1xuXG5cbmxldCBtb2NrU2RrOiBNb2NrU2RrO1xuYmVmb3JlRWFjaCgoKSA9PiB7XG4gIG1vY2tTZGsgPSBuZXcgTW9ja1NkaygpO1xufSk7XG5cbnRlc3QoJ2ZhaWx1cmUgdG8gcmVhZCBTU00gcGFyYW1ldGVyIHJlc3VsdHMgaW4gdXBncmFkZSBtZXNzYWdlIGZvciBleGlzdGluZyBib290c3RyYXAgc3RhY2sgdW5kZXIgdjUnLCBhc3luYyAoKSA9PiB7XG4gIC8vIEdJVkVOXG4gIGNvbnN0IHRvb2xraXRJbmZvID0gVG9vbGtpdEluZm8uZnJvbVN0YWNrKG1vY2tCb290c3RyYXBTdGFjayhtb2NrU2RrLCB7XG4gICAgT3V0cHV0czogW3sgT3V0cHV0S2V5OiAnQm9vdHN0cmFwVmVyc2lvbicsIE91dHB1dFZhbHVlOiAnNCcgfV0sXG4gIH0pLCBtb2NrU2RrKTtcblxuICBtb2NrU2RrLnN0dWJTc20oe1xuICAgIGdldFBhcmFtZXRlcigpIHtcbiAgICAgIHRocm93IGVycm9yV2l0aENvZGUoJ0FjY2Vzc0RlbmllZEV4Y2VwdGlvbicsICdDb21wdXRlciBzYXlzIG5vJyk7XG4gICAgfSxcbiAgfSk7XG5cbiAgLy8gVEhFTlxuICBhd2FpdCBleHBlY3QodG9vbGtpdEluZm8udmFsaWRhdGVWZXJzaW9uKDk5LCAnL2FiYycpKS5yZWplY3RzLnRvVGhyb3coL1RoaXMgQ0RLIGRlcGxveW1lbnQgcmVxdWlyZXMgYm9vdHN0cmFwIHN0YWNrIHZlcnNpb24vKTtcbn0pO1xuXG50ZXN0KCdmYWlsdXJlIHRvIHJlYWQgU1NNIHBhcmFtZXRlciByZXN1bHRzIGluIGV4Y2VwdGlvbiBwYXNzdGhyb3VnaCBmb3IgZXhpc3RpbmcgYm9vdHN0cmFwIHN0YWNrIHY1IG9yIGhpZ2hlcicsIGFzeW5jICgpID0+IHtcbiAgLy8gR0lWRU5cbiAgY29uc3QgdG9vbGtpdEluZm8gPSBUb29sa2l0SW5mby5mcm9tU3RhY2sobW9ja0Jvb3RzdHJhcFN0YWNrKG1vY2tTZGssIHtcbiAgICBPdXRwdXRzOiBbeyBPdXRwdXRLZXk6ICdCb290c3RyYXBWZXJzaW9uJywgT3V0cHV0VmFsdWU6ICc1JyB9XSxcbiAgfSksIG1vY2tTZGspO1xuXG4gIG1vY2tTZGsuc3R1YlNzbSh7XG4gICAgZ2V0UGFyYW1ldGVyKCkge1xuICAgICAgdGhyb3cgZXJyb3JXaXRoQ29kZSgnQWNjZXNzRGVuaWVkRXhjZXB0aW9uJywgJ0NvbXB1dGVyIHNheXMgbm8nKTtcbiAgICB9LFxuICB9KTtcblxuICAvLyBUSEVOXG4gIGF3YWl0IGV4cGVjdCh0b29sa2l0SW5mby52YWxpZGF0ZVZlcnNpb24oOTksICcvYWJjJykpLnJlamVjdHMudG9UaHJvdygvQ29tcHV0ZXIgc2F5cyBuby8pO1xufSk7XG5cbmRlc2NyaWJlKCd2YWxpZGF0ZXZlcnNpb24gd2l0aG91dCBib290c3RyYXAgc3RhY2snLCAoKSA9PiB7XG4gIGxldCB0b29sa2l0SW5mbzogVG9vbGtpdEluZm87XG4gIGJlZm9yZUVhY2goKCkgPT4ge1xuICAgIHRvb2xraXRJbmZvID0gVG9vbGtpdEluZm8uYm9vdHN0cmFwU3RhY2tOb3RGb3VuZEluZm8obW9ja1Nkayk7XG4gIH0pO1xuXG4gIHRlc3QoJ3ZhbGlkYXRpbmcgdmVyc2lvbiB3aXRoIGV4cGxpY2l0IFNTTSBwYXJhbWV0ZXIgc3VjY2VlZHMnLCBhc3luYyAoKSA9PiB7XG4gICAgLy8gR0lWRU5cbiAgICBtb2NrU2RrLnN0dWJTc20oe1xuICAgICAgZ2V0UGFyYW1ldGVyKCkge1xuICAgICAgICByZXR1cm4geyBQYXJhbWV0ZXI6IHsgVmFsdWU6ICcxMCcgfSB9O1xuICAgICAgfSxcbiAgICB9KTtcblxuICAgIC8vIFRIRU5cbiAgICBhd2FpdCBleHBlY3QodG9vbGtpdEluZm8udmFsaWRhdGVWZXJzaW9uKDgsICcvYWJjJykpLnJlc29sdmVzLnRvQmVVbmRlZmluZWQoKTtcbiAgfSk7XG5cbiAgdGVzdCgndmFsaWRhdGluZyB2ZXJzaW9uIHdpdGhvdXQgZXhwbGljaXQgU1NNIHBhcmFtZXRlciBmYWlscycsIGFzeW5jICgpID0+IHtcbiAgICAvLyBXSEVOXG4gICAgYXdhaXQgZXhwZWN0KHRvb2xraXRJbmZvLnZhbGlkYXRlVmVyc2lvbig4LCB1bmRlZmluZWQpKS5yZWplY3RzLnRvVGhyb3coL1RoaXMgZGVwbG95bWVudCByZXF1aXJlcyBhIGJvb3RzdHJhcCBzdGFjayB3aXRoIGEga25vd24gbmFtZS8pO1xuICB9KTtcblxuICB0ZXN0KCd2YWxpZGF0aW5nIHZlcnNpb24gd2l0aCBhY2Nlc3MgZGVuaWVkIGVycm9yIGdpdmVzIHVwZ3JhZGUgaGludCcsIGFzeW5jICgpID0+IHtcbiAgICAvLyBHSVZFTlxuICAgIG1vY2tTZGsuc3R1YlNzbSh7XG4gICAgICBnZXRQYXJhbWV0ZXIoKSB7XG4gICAgICAgIHRocm93IGVycm9yV2l0aENvZGUoJ0FjY2Vzc0RlbmllZEV4Y2VwdGlvbicsICdDb21wdXRlciBzYXlzIG5vJyk7XG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgLy8gV0hFTlxuICAgIGF3YWl0IGV4cGVjdCh0b29sa2l0SW5mby52YWxpZGF0ZVZlcnNpb24oOCwgJy9hYmMnKSkucmVqZWN0cy50b1Rocm93KC9UaGlzIENESyBkZXBsb3ltZW50IHJlcXVpcmVzIGJvb3RzdHJhcCBzdGFjayB2ZXJzaW9uLyk7XG4gIH0pO1xuXG4gIHRlc3QoJ3ZhbGlkYXRpbmcgdmVyc2lvbiB3aXRoIG1pc3NpbmcgcGFyYW1ldGVyIGdpdmVzIGJvb3RzdHJhcCBoaW50JywgYXN5bmMgKCkgPT4ge1xuICAgIC8vIEdJVkVOXG4gICAgbW9ja1Nkay5zdHViU3NtKHtcbiAgICAgIGdldFBhcmFtZXRlcigpIHtcbiAgICAgICAgdGhyb3cgZXJyb3JXaXRoQ29kZSgnUGFyYW1ldGVyTm90Rm91bmQnLCAnV3V0PycpO1xuICAgICAgfSxcbiAgICB9KTtcblxuICAgIC8vIFdIRU5cbiAgICBhd2FpdCBleHBlY3QodG9vbGtpdEluZm8udmFsaWRhdGVWZXJzaW9uKDgsICcvYWJjJykpLnJlamVjdHMudG9UaHJvdygvSGFzIHRoZSBlbnZpcm9ubWVudCBiZWVuIGJvb3RzdHJhcHBlZD8vKTtcbiAgfSk7XG59KTsiXX0=