"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const os = require("os");
const fs_path = require("path");
const fs = require("fs-extra");
const utils_1 = require("ts-jest/utils");
const settings_1 = require("../lib/settings");
// mock fs deeply
jest.mock('fs-extra');
const mockedFs = utils_1.mocked(fs, true);
const USER_CONFIG = fs_path.join(os.homedir(), '.cdk.json');
test('load settings from both files if available', async () => {
    // GIVEN
    const GIVEN_CONFIG = new Map([
        [settings_1.PROJECT_CONFIG, {
                project: 'foobar',
            }],
        [USER_CONFIG, {
                project: 'foo',
                test: 'bar',
            }],
    ]);
    // WHEN
    mockedFs.pathExists.mockImplementation(path => {
        return GIVEN_CONFIG.has(path);
    });
    mockedFs.readJSON.mockImplementation(path => {
        return GIVEN_CONFIG.get(path);
    });
    const config = await new settings_1.Configuration().load();
    // THEN
    expect(config.settings.get(['project'])).toBe('foobar');
    expect(config.settings.get(['test'])).toBe('bar');
});
test('load context from all 3 files if available', async () => {
    // GIVEN
    const GIVEN_CONFIG = new Map([
        [settings_1.PROJECT_CONFIG, {
                context: {
                    project: 'foobar',
                },
            }],
        [settings_1.PROJECT_CONTEXT, {
                foo: 'bar',
            }],
        [USER_CONFIG, {
                context: {
                    test: 'bar',
                },
            }],
    ]);
    // WHEN
    mockedFs.pathExists.mockImplementation(path => {
        return GIVEN_CONFIG.has(path);
    });
    mockedFs.readJSON.mockImplementation(path => {
        return GIVEN_CONFIG.get(path);
    });
    const config = await new settings_1.Configuration().load();
    // THEN
    expect(config.context.get('project')).toBe('foobar');
    expect(config.context.get('foo')).toBe('bar');
    expect(config.context.get('test')).toBe('bar');
});
//# sourceMappingURL=data:application/json;base64,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